/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.rss;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.wiki.api.core.Attachment;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.attachment.AttachmentManager;
import org.apache.wiki.rss.Entry;
import org.apache.wiki.rss.Feed;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class AtomFeed
extends Feed {
    private final Namespace m_atomNameSpace = Namespace.getNamespace((String)"http://www.w3.org/2005/Atom");
    public static final String RFC3339FORMAT = "yyyy-MM-dd'T'HH:mm:ssZZ";

    public AtomFeed(Context c) {
        super(c);
    }

    private String getFeedID() {
        return this.m_wikiContext.getEngine().getBaseURL();
    }

    private String getEntryID(Entry e) {
        return e.getURL();
    }

    private Collection<Element> getItems() {
        ArrayList<Element> list = new ArrayList<Element>();
        Engine engine = this.m_wikiContext.getEngine();
        ServletContext servletContext = null;
        if (this.m_wikiContext.getHttpRequest() != null) {
            servletContext = this.m_wikiContext.getHttpRequest().getSession().getServletContext();
        }
        for (Entry e : this.m_entries) {
            Page p = e.getPage();
            Element entryEl = this.getElement("entry");
            entryEl.addContent((Content)this.getElement("id").setText(this.getEntryID(e)));
            entryEl.addContent((Content)this.getElement("title").setAttribute("type", "html").setText(e.getTitle()));
            entryEl.addContent((Content)this.getElement("updated").setText(DateFormatUtils.formatUTC((Date)p.getLastModified(), (String)RFC3339FORMAT)));
            entryEl.addContent((Content)this.getElement("author").addContent((Content)this.getElement("name").setText(e.getAuthor())));
            entryEl.addContent((Content)this.getElement("link").setAttribute("rel", "alternate").setAttribute("href", e.getURL()));
            entryEl.addContent((Content)this.getElement("content").setAttribute("type", "html").setText(e.getContent()));
            if (((AttachmentManager)engine.getManager(AttachmentManager.class)).hasAttachments(p) && servletContext != null) {
                try {
                    List<Attachment> c = ((AttachmentManager)engine.getManager(AttachmentManager.class)).listAttachments(p);
                    for (Attachment att : c) {
                        Element attEl = this.getElement("link");
                        attEl.setAttribute("rel", "enclosure");
                        attEl.setAttribute("href", engine.getURL(ContextEnum.PAGE_ATTACH.getRequestContext(), att.getName(), null));
                        attEl.setAttribute("length", Long.toString(att.getSize()));
                        attEl.setAttribute("type", this.getMimeType(servletContext, att.getFileName()));
                        entryEl.addContent((Content)attEl);
                    }
                }
                catch (ProviderException providerException) {
                    // empty catch block
                }
            }
            list.add(entryEl);
        }
        return list;
    }

    @Override
    public String getString() {
        Element root = this.getElement("feed");
        Engine engine = this.m_wikiContext.getEngine();
        Date lastModified = new Date(0L);
        for (Entry e : this.m_entries) {
            if (!e.getPage().getLastModified().after(lastModified)) continue;
            lastModified = e.getPage().getLastModified();
        }
        root.addContent((Content)this.getElement("title").setText(this.getChannelTitle()));
        root.addContent((Content)this.getElement("id").setText(this.getFeedID()));
        root.addContent((Content)this.getElement("updated").setText(DateFormatUtils.formatUTC((Date)lastModified, (String)RFC3339FORMAT)));
        root.addContent((Content)this.getElement("link").setAttribute("href", engine.getBaseURL()));
        root.addContent((Content)this.getElement("generator").setText("JSPWiki 2.12.0"));
        String rssFeedURL = engine.getURL(ContextEnum.PAGE_NONE.getRequestContext(), "rss.jsp", "page=" + engine.encodeName(this.m_wikiContext.getPage().getName()) + "&mode=" + this.m_mode + "&type=atom");
        Element self = this.getElement("link").setAttribute("rel", "self");
        self.setAttribute("href", rssFeedURL);
        root.addContent((Content)self);
        root.addContent(this.getItems());
        XMLOutputter output = new XMLOutputter();
        output.setFormat(Format.getPrettyFormat());
        try {
            StringWriter res = new StringWriter();
            output.output(root, (Writer)res);
            return res.toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    private Element getElement(String name) {
        return new Element(name, this.m_atomNameSpace);
    }
}

