/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.rss;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.wiki.api.core.Attachment;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.attachment.AttachmentManager;
import org.apache.wiki.rss.Entry;
import org.apache.wiki.rss.Feed;
import org.apache.wiki.variables.VariableManager;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class RSS20Feed
extends Feed {
    public RSS20Feed(Context context) {
        super(context);
    }

    private List<Element> getItems() {
        ArrayList<Element> list = new ArrayList<Element>();
        SimpleDateFormat fmt = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'");
        Engine engine = this.m_wikiContext.getEngine();
        ServletContext servletContext = null;
        if (this.m_wikiContext.getHttpRequest() != null) {
            servletContext = this.m_wikiContext.getHttpRequest().getSession().getServletContext();
        }
        for (Entry e : this.m_entries) {
            Page p = e.getPage();
            String url = e.getURL();
            Element item = new Element("item");
            item.addContent((Content)new Element("link").setText(url));
            item.addContent((Content)new Element("title").setText(e.getTitle()));
            item.addContent((Content)new Element("description").setText(e.getContent()));
            if (((AttachmentManager)engine.getManager(AttachmentManager.class)).hasAttachments(p) && servletContext != null) {
                try {
                    List<Attachment> c = ((AttachmentManager)engine.getManager(AttachmentManager.class)).listAttachments(p);
                    for (Attachment att : c) {
                        Element attEl = new Element("enclosure");
                        attEl.setAttribute("url", engine.getURL(ContextEnum.PAGE_ATTACH.getRequestContext(), att.getName(), null));
                        attEl.setAttribute("length", Long.toString(att.getSize()));
                        attEl.setAttribute("type", this.getMimeType(servletContext, att.getFileName()));
                        item.addContent((Content)attEl);
                    }
                }
                catch (ProviderException c) {
                    // empty catch block
                }
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(p.getLastModified());
            cal.add(14, -(cal.get(15) + (cal.getTimeZone().inDaylightTime(p.getLastModified()) ? cal.get(16) : 0)));
            item.addContent((Content)new Element("pubDate").setText(fmt.format(cal.getTime())));
            list.add(item);
        }
        return list;
    }

    @Override
    public String getString() {
        Engine engine = this.m_wikiContext.getEngine();
        Element root = new Element("rss");
        root.setAttribute("version", "2.0");
        Element channel = new Element("channel");
        root.addContent((Content)channel);
        channel.addContent((Content)new Element("title").setText(this.getChannelTitle()));
        channel.addContent((Content)new Element("link").setText(engine.getBaseURL()));
        channel.addContent((Content)new Element("description").setText(this.getChannelDescription()));
        channel.addContent((Content)new Element("language").setText(this.getChannelLanguage()));
        channel.addContent((Content)new Element("generator").setText("JSPWiki 2.12.0"));
        Object mail = ((VariableManager)engine.getManager(VariableManager.class)).getVariable(this.m_wikiContext, "jspwiki.rss.author.email");
        if (mail != null) {
            String editor = ((VariableManager)engine.getManager(VariableManager.class)).getVariable(this.m_wikiContext, "jspwiki.rss.author");
            if (editor != null) {
                mail = (String)mail + " (" + editor + ")";
            }
            channel.addContent((Content)new Element("managingEditor").setText((String)mail));
        }
        channel.addContent(this.getItems());
        XMLOutputter output = new XMLOutputter();
        output.setFormat(Format.getPrettyFormat());
        try {
            StringWriter res = new StringWriter();
            output.output(root, (Writer)res);
            return res.toString();
        }
        catch (IOException e) {
            return null;
        }
    }
}

