/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import javax.servlet.jsp.JspWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.diff.DifferenceManager;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.tags.WikiTagBase;

public class InsertDiffTag
extends WikiTagBase {
    private static final long serialVersionUID = 0L;
    private static final Logger LOG = LogManager.getLogger(InsertDiffTag.class);
    public static final String ATTR_OLDVERSION = "olddiff";
    public static final String ATTR_NEWVERSION = "newdiff";
    protected String m_pageName;

    @Override
    public void initTag() {
        super.initTag();
        this.m_pageName = null;
    }

    public void setPage(String page) {
        this.m_pageName = page;
    }

    public String getPage() {
        return this.m_pageName;
    }

    @Override
    public final int doWikiStartTag() throws IOException {
        Context ctx;
        Engine engine = this.m_wikiContext.getEngine();
        if (this.m_pageName == null) {
            ctx = this.m_wikiContext;
        } else {
            ctx = this.m_wikiContext.clone();
            ctx.setPage(((PageManager)engine.getManager(PageManager.class)).getPage(this.m_pageName));
        }
        Integer vernew = (Integer)this.pageContext.getAttribute(ATTR_NEWVERSION, 2);
        Integer verold = (Integer)this.pageContext.getAttribute(ATTR_OLDVERSION, 2);
        LOG.debug("Request diff between version " + verold + " and " + vernew);
        if (ctx.getPage() != null) {
            JspWriter out = this.pageContext.getOut();
            String diff = ((DifferenceManager)engine.getManager(DifferenceManager.class)).getDiff(ctx, vernew, verold);
            if (diff.isEmpty()) {
                return 1;
            }
            out.write(diff);
        }
        return 0;
    }
}

