/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui;

import java.security.Principal;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Session;
import org.apache.wiki.auth.SessionMonitor;
import org.apache.wiki.auth.authorize.Role;

public class WikiRequestWrapper
extends HttpServletRequestWrapper {
    private final Session m_session;

    public WikiRequestWrapper(Engine engine, HttpServletRequest request) {
        super(request);
        this.m_session = SessionMonitor.getInstance(engine).find(request.getSession());
    }

    public String getRemoteUser() {
        if (super.getRemoteUser() != null) {
            return super.getRemoteUser();
        }
        if (this.m_session.isAuthenticated()) {
            return this.m_session.getLoginPrincipal().getName();
        }
        return null;
    }

    public Principal getUserPrincipal() {
        if (super.getUserPrincipal() != null) {
            return super.getUserPrincipal();
        }
        if (this.m_session.isAuthenticated()) {
            return this.m_session.getLoginPrincipal();
        }
        return null;
    }

    public boolean isUserInRole(String role) {
        boolean hasContainerRole = super.isUserInRole(role);
        if (hasContainerRole) {
            return true;
        }
        Principal[] principals = this.m_session.getRoles();
        return Arrays.stream(principals).filter(value -> value instanceof Role).map(value -> (Role)value).anyMatch(principal -> Role.isBuiltInRole(principal) && principal.getName().equals(role));
    }
}

