/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.forms;

import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.forms.FormElement;
import org.apache.wiki.forms.FormInfo;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.util.TextUtil;

public class FormOpen
extends FormElement {
    private static final Logger LOG = LogManager.getLogger(FormOpen.class);
    public static final String PARAM_METHOD = "method";

    public String execute(Context ctx, Map<String, String> params) throws PluginException {
        String method;
        ResourceBundle rb = Preferences.getBundle(ctx, "plugin.PluginResources");
        String formName = TextUtil.replaceEntities((String)params.get("form"));
        if (formName == null) {
            throw new PluginException(MessageFormat.format(rb.getString("formopen.missingparam"), "form"));
        }
        String hide = params.get("hide");
        String sourcePage = ctx.getPage().getName();
        String submitServlet = TextUtil.replaceEntities((String)params.get("submit"));
        if (submitServlet == null) {
            submitServlet = ctx.getURL(ContextEnum.PAGE_VIEW.getRequestContext(), sourcePage);
        }
        if ((method = params.get(PARAM_METHOD)) == null) {
            method = "post";
        }
        if (!method.equalsIgnoreCase("get") && !method.equalsIgnoreCase("post")) {
            throw new PluginException(rb.getString("formopen.postorgetonly"));
        }
        FormInfo info = this.getFormInfo(ctx);
        if (info != null) {
            if (formName.equals(info.getName())) {
                LOG.debug("Previous FormInfo for this form was found in context.");
                if ("onsuccess".equals(hide) && info.getStatus() == 1) {
                    info.setHide(true);
                    return "<p>" + rb.getString("formopen.noneedtoshow") + "</p>";
                }
            } else {
                info = new FormInfo();
            }
        } else {
            info = new FormInfo();
            this.storeFormInfo(ctx, info);
        }
        info.setName(formName);
        info.setAction(submitServlet);
        return "<div class=\"wikiform\">\n<form action=\"" + submitServlet + "\" name=\"" + formName + "\" accept-charset=\"" + ctx.getEngine().getContentEncoding() + "\" method=\"" + method + "\" enctype=\"application/x-www-form-urlencoded\">\n  <input type=\"hidden\" name=\"formname\" value=\"" + formName + "\"/>\n  <input type=\"hidden\" name=\"X-XSRF-TOKEN\" value=\"" + ctx.getWikiSession().antiCsrfToken() + "\"/>\n";
    }
}

