/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui;

import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.modules.BaseModuleManager;
import org.apache.wiki.modules.WikiModuleInfo;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.ui.TemplateManager;

public class DefaultTemplateManager
extends BaseModuleManager
implements TemplateManager {
    private static final Logger LOG = LogManager.getLogger(DefaultTemplateManager.class);

    public DefaultTemplateManager(Engine engine, Properties properties) {
        super(engine);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean templateExists(String templateName) {
        ServletContext context = this.m_engine.getServletContext();
        try (InputStream in = context.getResourceAsStream(DefaultTemplateManager.getPath(templateName) + "ViewTemplate.jsp");){
            if (in == null) return false;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private static String findResource(ServletContext sContext, String name) {
        String resourceName;
        block14: {
            resourceName = name;
            try (InputStream is = sContext.getResourceAsStream(resourceName);){
                if (is != null) break block14;
                String defname = DefaultTemplateManager.makeFullJSPName("default", DefaultTemplateManager.removeTemplatePart(resourceName));
                try (InputStream iis = sContext.getResourceAsStream(defname);){
                    resourceName = iis != null ? defname : null;
                }
            }
            catch (IOException e) {
                LOG.error("unable to open " + name + " as resource stream", (Throwable)e);
            }
        }
        return resourceName;
    }

    private static String findResource(ServletContext sContext, String template, String name) {
        if (name.charAt(0) == '/') {
            return DefaultTemplateManager.findResource(sContext, name);
        }
        String fullname = DefaultTemplateManager.makeFullJSPName(template, name);
        return DefaultTemplateManager.findResource(sContext, fullname);
    }

    @Override
    public String findJSP(PageContext pageContext, String name) {
        ServletContext sContext = pageContext.getServletContext();
        return DefaultTemplateManager.findResource(sContext, name);
    }

    private static String removeTemplatePart(String name) {
        int idx = 0;
        if (name.startsWith("/")) {
            idx = 1;
        }
        if ((idx = name.indexOf(47, idx)) != -1 && (idx = name.indexOf(47, idx + 1)) != -1) {
            name = name.substring(idx + 1);
        }
        LOG.debug("Final name = {}", (Object)name);
        return name;
    }

    private static String makeFullJSPName(String template, String name) {
        return "/templates/" + template + "/" + name;
    }

    @Override
    public String findJSP(PageContext pageContext, String template, String name) {
        if (name == null || template == null) {
            LOG.fatal("findJSP() was asked to find a null template or name (" + template + "," + name + "). JSP page '" + ((HttpServletRequest)pageContext.getRequest()).getRequestURI() + "'");
            throw new InternalWikiException("Illegal arguments to findJSP(); please check logs.");
        }
        return DefaultTemplateManager.findResource(pageContext.getServletContext(), template, name);
    }

    @Override
    public String findResource(Context ctx, String template, String name) {
        if (this.m_engine.getServletContext() != null) {
            return DefaultTemplateManager.findResource(this.m_engine.getServletContext(), template, name);
        }
        return DefaultTemplateManager.getPath(template) + "/" + name;
    }

    private static String getPath(String template) {
        return "/templates/" + template + "/";
    }

    @Override
    public Set<String> listSkins(PageContext pageContext, String template) {
        String place = DefaultTemplateManager.makeFullJSPName(template, "skins");
        ServletContext sContext = pageContext.getServletContext();
        Set skinSet = sContext.getResourcePaths(place);
        TreeSet<String> resultSet = new TreeSet<String>();
        LOG.debug("Listings skins from {}", (Object)place);
        if (skinSet != null) {
            String[] skins;
            for (String skin : skins = skinSet.toArray(new String[0])) {
                String[] s = StringUtils.split((String)skin, (String)"/");
                if (s.length <= 2 || !skin.endsWith("/")) continue;
                String skinName = s[s.length - 1];
                resultSet.add(skinName);
                LOG.debug("...adding skin '{}'", (Object)skinName);
            }
        }
        return resultSet;
    }

    @Override
    public Map<String, String> listTimeFormats(PageContext pageContext) {
        Context context = Context.findContext((PageContext)pageContext);
        Properties props = this.m_engine.getWikiProperties();
        ArrayList<String> tfArr = new ArrayList<String>(40);
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith("jspwiki.defaultprefs.timeformat.")) continue;
            tfArr.add(name);
        }
        if (tfArr.size() == 0) {
            tfArr.add("dd-MMM-yy");
            tfArr.add("d-MMM-yyyy");
            tfArr.add("EEE, dd-MMM-yyyy, zzzz");
        } else {
            Collections.sort(tfArr);
            tfArr.replaceAll(props::getProperty);
        }
        String prefTimeZone = Preferences.getPreference(context, "TimeZone");
        TimeZone tz = TimeZone.getTimeZone(prefTimeZone);
        Date d = new Date();
        try {
            SimpleDateFormat fmt = Preferences.getDateFormat(context, Preferences.TimeFormat.DATETIME);
            fmt.setTimeZone(tz);
            for (String s : tfArr) {
                try {
                    fmt.applyPattern(s);
                    resultMap.put(s, fmt.format(d));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return resultMap;
    }

    @Override
    public Collection<WikiModuleInfo> modules() {
        return new ArrayList<WikiModuleInfo>();
    }

    @Override
    public WikiModuleInfo getModuleInfo(String moduleName) {
        return null;
    }
}

