/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.runtime.WorkerSourceTask;
import org.apache.kafka.connect.util.ConnectorTaskId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SourceTaskOffsetCommitter {
    private static final Logger log = LoggerFactory.getLogger(SourceTaskOffsetCommitter.class);
    private WorkerConfig config;
    private ScheduledExecutorService commitExecutorService = null;
    private final HashMap<ConnectorTaskId, ScheduledCommitTask> committers = new HashMap();

    SourceTaskOffsetCommitter(WorkerConfig config) {
        this.config = config;
        this.commitExecutorService = Executors.newSingleThreadScheduledExecutor();
    }

    public void close(long timeoutMs) {
        this.commitExecutorService.shutdown();
        try {
            if (!this.commitExecutorService.awaitTermination(timeoutMs, TimeUnit.MILLISECONDS)) {
                log.error("Graceful shutdown of offset commitOffsets thread timed out.");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(final ConnectorTaskId id, final WorkerSourceTask workerTask) {
        HashMap<ConnectorTaskId, ScheduledCommitTask> hashMap = this.committers;
        synchronized (hashMap) {
            long commitIntervalMs = this.config.getLong("offset.flush.interval.ms");
            ScheduledFuture<?> commitFuture = this.commitExecutorService.schedule(new Runnable(){

                @Override
                public void run() {
                    SourceTaskOffsetCommitter.this.commit(id, workerTask);
                }
            }, commitIntervalMs, TimeUnit.MILLISECONDS);
            this.committers.put(id, new ScheduledCommitTask(commitFuture));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ConnectorTaskId id) {
        ScheduledCommitTask task;
        HashMap<ConnectorTaskId, ScheduledCommitTask> hashMap = this.committers;
        synchronized (hashMap) {
            task = this.committers.remove(id);
            task.cancelled = true;
            task.commitFuture.cancel(false);
        }
        if (task.finishedLatch != null) {
            try {
                task.finishedLatch.await();
            }
            catch (InterruptedException e) {
                throw new ConnectException("Unexpected interruption in SourceTaskOffsetCommitter.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit(ConnectorTaskId id, WorkerSourceTask workerTask) {
        ScheduledCommitTask task;
        HashMap<ConnectorTaskId, ScheduledCommitTask> hashMap = this.committers;
        synchronized (hashMap) {
            task = this.committers.get(id);
            if (task == null || task.cancelled) {
                return;
            }
            task.finishedLatch = new CountDownLatch(1);
        }
        try {
            log.debug("Committing offsets for {}", (Object)workerTask);
            boolean success = workerTask.commitOffsets();
            if (!success) {
                log.error("Failed to commit offsets for {}", (Object)workerTask);
            }
        }
        catch (Throwable t) {
            log.error("Unhandled exception when committing {}: ", (Object)workerTask, (Object)t);
        }
        finally {
            HashMap<ConnectorTaskId, ScheduledCommitTask> success = this.committers;
            synchronized (success) {
                task.finishedLatch.countDown();
                if (!task.cancelled) {
                    this.schedule(id, workerTask);
                }
            }
        }
    }

    private static class ScheduledCommitTask {
        ScheduledFuture<?> commitFuture;
        boolean cancelled;
        CountDownLatch finishedLatch;

        ScheduledCommitTask(ScheduledFuture<?> commitFuture) {
            this.commitFuture = commitFuture;
            this.cancelled = false;
            this.finishedLatch = null;
        }
    }
}

