/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.health;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.health.ConnectClusterState;
import org.apache.kafka.connect.health.ConnectorHealth;
import org.apache.kafka.connect.health.ConnectorState;
import org.apache.kafka.connect.health.ConnectorType;
import org.apache.kafka.connect.health.TaskState;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorStateInfo;
import org.apache.kafka.connect.util.FutureCallback;

public class ConnectClusterStateImpl
implements ConnectClusterState {
    private final long herderRequestTimeoutMs;
    private final Herder herder;

    public ConnectClusterStateImpl(long connectorsTimeoutMs, Herder herder) {
        this.herderRequestTimeoutMs = connectorsTimeoutMs;
        this.herder = herder;
    }

    public Collection<String> connectors() {
        FutureCallback<Collection<String>> connectorsCallback = new FutureCallback<Collection<String>>();
        this.herder.connectors(connectorsCallback);
        try {
            return (Collection)connectorsCallback.get(this.herderRequestTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new ConnectException("Failed to retrieve list of connectors", (Throwable)e);
        }
    }

    public ConnectorHealth connectorHealth(String connName) {
        ConnectorStateInfo state = this.herder.connectorStatus(connName);
        ConnectorState connectorState = new ConnectorState(state.connector().state(), state.connector().workerId(), state.connector().trace());
        Map<Integer, TaskState> taskStates = this.taskStates(state.tasks());
        ConnectorHealth connectorHealth = new ConnectorHealth(connName, connectorState, taskStates, ConnectorType.valueOf((String)state.type().name()));
        return connectorHealth;
    }

    private Map<Integer, TaskState> taskStates(List<ConnectorStateInfo.TaskState> states) {
        HashMap<Integer, TaskState> taskStates = new HashMap<Integer, TaskState>();
        for (ConnectorStateInfo.TaskState state : states) {
            taskStates.put(state.id(), new TaskState(state.id(), state.workerId(), state.state(), state.trace()));
        }
        return taskStates;
    }
}

