/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.raft.ElectionState;
import org.apache.kafka.raft.EpochState;
import org.apache.kafka.raft.LogOffsetMetadata;

public class FollowerState
implements EpochState {
    private final int fetchTimeoutMs;
    private final int epoch;
    private final int leaderId;
    private final Set<Integer> voters;
    private final Timer fetchTimer;
    private OptionalLong highWatermark;

    public FollowerState(Time time, int epoch, int leaderId, Set<Integer> voters, int fetchTimeoutMs) {
        this.fetchTimeoutMs = fetchTimeoutMs;
        this.epoch = epoch;
        this.leaderId = leaderId;
        this.voters = voters;
        this.fetchTimer = time.timer((long)fetchTimeoutMs);
        this.highWatermark = OptionalLong.empty();
    }

    @Override
    public ElectionState election() {
        return new ElectionState(this.epoch, OptionalInt.of(this.leaderId), OptionalInt.empty(), this.voters);
    }

    @Override
    public int epoch() {
        return this.epoch;
    }

    @Override
    public String name() {
        return "Follower";
    }

    public long remainingFetchTimeMs(long currentTimeMs) {
        this.fetchTimer.update(currentTimeMs);
        return this.fetchTimer.remainingMs();
    }

    public int leaderId() {
        return this.leaderId;
    }

    public boolean hasFetchTimeoutExpired(long currentTimeMs) {
        this.fetchTimer.update(currentTimeMs);
        return this.fetchTimer.isExpired();
    }

    public void resetFetchTimeout(long currentTimeMs) {
        this.fetchTimer.update(currentTimeMs);
        this.fetchTimer.reset((long)this.fetchTimeoutMs);
    }

    public void overrideFetchTimeout(long currentTimeMs, long timeoutMs) {
        this.fetchTimer.update(currentTimeMs);
        this.fetchTimer.reset(timeoutMs);
    }

    public void updateHighWatermark(OptionalLong highWatermark) {
        if (!highWatermark.isPresent() && this.highWatermark.isPresent()) {
            throw new IllegalArgumentException("Attempt to overwrite current high watermark " + this.highWatermark + " with unknown value");
        }
        this.highWatermark.ifPresent(previousHighWatermark -> {
            long updatedHighWatermark = highWatermark.getAsLong();
            if (updatedHighWatermark < 0L) {
                throw new IllegalArgumentException("Illegal negative high watermark update");
            }
            if (previousHighWatermark > highWatermark.getAsLong()) {
                throw new IllegalArgumentException("Non-monotonic update of high watermark attempted");
            }
        });
        this.highWatermark = highWatermark;
    }

    @Override
    public Optional<LogOffsetMetadata> highWatermark() {
        if (this.highWatermark.isPresent()) {
            return Optional.of(new LogOffsetMetadata(this.highWatermark.getAsLong()));
        }
        return Optional.empty();
    }

    public String toString() {
        return "FollowerState(fetchTimeoutMs=" + this.fetchTimeoutMs + ", epoch=" + this.epoch + ", leaderId=" + this.leaderId + ", voters=" + this.voters + ')';
    }
}

