/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft.internals;

import java.util.function.Predicate;
import org.apache.kafka.raft.Isolation;

public class LogOffset {
    public final long offset;
    public final Isolation isolation;

    public LogOffset(long offset, Isolation isolation) {
        this.offset = offset;
        this.isolation = isolation;
    }

    public static Predicate<LogOffset> await(long offset, Isolation isolation) {
        if (isolation == Isolation.COMMITTED) {
            return LogOffset.awaitCommitted(offset);
        }
        return LogOffset.awaitUncommitted(offset);
    }

    public static Predicate<LogOffset> awaitCommitted(long offset) {
        return logOffset -> logOffset.isolation == Isolation.COMMITTED && logOffset.offset > offset;
    }

    public static Predicate<LogOffset> awaitUncommitted(long offset) {
        return logOffset -> logOffset.offset > offset;
    }
}

