/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.HashSet;
import java.util.Set;

public class ClientState<T> {
    static final double COST_ACTIVE = 0.1;
    static final double COST_STANDBY = 0.2;
    static final double COST_LOAD = 0.5;
    public final Set<T> activeTasks;
    public final Set<T> standbyTasks;
    public final Set<T> assignedTasks;
    public final Set<T> prevActiveTasks;
    public final Set<T> prevAssignedTasks;
    public double capacity;
    public double cost;

    public ClientState() {
        this(0.0);
    }

    public ClientState(double capacity) {
        this(new HashSet(), new HashSet(), new HashSet(), new HashSet(), new HashSet(), capacity);
    }

    private ClientState(Set<T> activeTasks, Set<T> standbyTasks, Set<T> assignedTasks, Set<T> prevActiveTasks, Set<T> prevAssignedTasks, double capacity) {
        this.activeTasks = activeTasks;
        this.standbyTasks = standbyTasks;
        this.assignedTasks = assignedTasks;
        this.prevActiveTasks = prevActiveTasks;
        this.prevAssignedTasks = prevAssignedTasks;
        this.capacity = capacity;
        this.cost = 0.0;
    }

    public ClientState<T> copy() {
        return new ClientState<T>(new HashSet<T>(this.activeTasks), new HashSet<T>(this.standbyTasks), new HashSet<T>(this.assignedTasks), new HashSet<T>(this.prevActiveTasks), new HashSet<T>(this.prevAssignedTasks), this.capacity);
    }

    public void assign(T taskId, boolean active) {
        if (active) {
            this.activeTasks.add(taskId);
        } else {
            this.standbyTasks.add(taskId);
        }
        this.assignedTasks.add(taskId);
        double cost = 0.5;
        cost = this.prevAssignedTasks.remove(taskId) ? 0.2 : cost;
        cost = this.prevActiveTasks.remove(taskId) ? 0.1 : cost;
        this.cost += cost;
    }

    public String toString() {
        return "[activeTasks: (" + this.activeTasks + ") assignedTasks: (" + this.assignedTasks + ") prevActiveTasks: (" + this.prevActiveTasks + ") prevAssignedTasks: (" + this.prevAssignedTasks + ") capacity: " + this.capacity + " cost: " + this.cost + "]";
    }
}

