/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.NoSuchElementException;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.internals.HasNextCondition;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.PeekingKeyValueIterator;

class FilteredCacheIterator
implements PeekingKeyValueIterator<Bytes, LRUCacheEntry> {
    private final PeekingKeyValueIterator<Bytes, LRUCacheEntry> cacheIterator;
    private final HasNextCondition hasNextCondition;

    FilteredCacheIterator(PeekingKeyValueIterator<Bytes, LRUCacheEntry> cacheIterator, HasNextCondition hasNextCondition) {
        this.cacheIterator = cacheIterator;
        this.hasNextCondition = hasNextCondition;
    }

    @Override
    public void close() {
    }

    @Override
    public Bytes peekNextKey() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return (Bytes)this.cacheIterator.peekNextKey();
    }

    @Override
    public boolean hasNext() {
        return this.hasNextCondition.hasNext(this.cacheIterator);
    }

    @Override
    public KeyValue<Bytes, LRUCacheEntry> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return (KeyValue)this.cacheIterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public KeyValue<Bytes, LRUCacheEntry> peekNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.cacheIterator.peekNext();
    }
}

