/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateRestoreCallback;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.AbstractStoreSupplier;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.InMemoryKeyValueLoggedStore;
import org.apache.kafka.streams.state.internals.MeteredKeyValueStore;

public class InMemoryKeyValueStoreSupplier<K, V>
extends AbstractStoreSupplier<K, V, KeyValueStore> {
    public InMemoryKeyValueStoreSupplier(String name, Serde<K> keySerde, Serde<V> valueSerde, boolean logged, Map<String, String> logConfig) {
        this(name, keySerde, valueSerde, null, logged, logConfig);
    }

    public InMemoryKeyValueStoreSupplier(String name, Serde<K> keySerde, Serde<V> valueSerde, Time time, boolean logged, Map<String, String> logConfig) {
        super(name, keySerde, valueSerde, time, logged, logConfig);
    }

    @Override
    public KeyValueStore get() {
        MemoryStore store = new MemoryStore(this.name, this.keySerde, this.valueSerde);
        return new MeteredKeyValueStore(this.logged ? store.enableLogging() : store, "in-memory-state", this.time);
    }

    private static class MemoryStore<K, V>
    implements KeyValueStore<K, V> {
        private final String name;
        private final Serde<K> keySerde;
        private final Serde<V> valueSerde;
        private final NavigableMap<K, V> map;
        private volatile boolean open = false;
        private StateSerdes<K, V> serdes;

        public MemoryStore(String name, Serde<K> keySerde, Serde<V> valueSerde) {
            this.name = name;
            this.keySerde = keySerde;
            this.valueSerde = valueSerde;
            this.map = new TreeMap();
        }

        public KeyValueStore<K, V> enableLogging() {
            return new InMemoryKeyValueLoggedStore<K, V>(this.name, this, this.keySerde, this.valueSerde);
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public void init(ProcessorContext context, StateStore root) {
            this.serdes = new StateSerdes(ProcessorStateManager.storeChangelogTopic(context.applicationId(), this.name), (Serde<?>)(this.keySerde == null ? context.keySerde() : this.keySerde), (Serde<?>)(this.valueSerde == null ? context.valueSerde() : this.valueSerde));
            context.register(root, true, new StateRestoreCallback(){

                @Override
                public void restore(byte[] key, byte[] value) {
                    if (value == null) {
                        MemoryStore.this.put(MemoryStore.this.serdes.keyFrom(key), null);
                    } else {
                        MemoryStore.this.put(MemoryStore.this.serdes.keyFrom(key), MemoryStore.this.serdes.valueFrom(value));
                    }
                }
            });
            this.open = true;
        }

        @Override
        public boolean persistent() {
            return false;
        }

        @Override
        public boolean isOpen() {
            return this.open;
        }

        @Override
        public synchronized V get(K key) {
            return this.map.get(key);
        }

        @Override
        public synchronized void put(K key, V value) {
            this.map.put(key, value);
        }

        @Override
        public synchronized V putIfAbsent(K key, V value) {
            V originalValue = this.get(key);
            if (originalValue == null) {
                this.put(key, value);
            }
            return originalValue;
        }

        @Override
        public synchronized void putAll(List<KeyValue<K, V>> entries) {
            for (KeyValue<K, V> entry : entries) {
                this.put(entry.key, entry.value);
            }
        }

        @Override
        public synchronized V delete(K key) {
            return this.map.remove(key);
        }

        @Override
        public synchronized KeyValueIterator<K, V> range(K from, K to) {
            return new DelegatingPeekingKeyValueIterator(this.name, new MemoryStoreIterator(this.map.subMap(from, true, to, false).entrySet().iterator()));
        }

        @Override
        public synchronized KeyValueIterator<K, V> all() {
            TreeMap<K, V> copy = new TreeMap<K, V>(this.map);
            return new DelegatingPeekingKeyValueIterator<K, V>(this.name, new MemoryStoreIterator<K, V>(copy.entrySet().iterator()));
        }

        @Override
        public long approximateNumEntries() {
            return this.map.size();
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
            this.open = false;
        }

        private static class MemoryStoreIterator<K, V>
        implements KeyValueIterator<K, V> {
            private final Iterator<Map.Entry<K, V>> iter;

            public MemoryStoreIterator(Iterator<Map.Entry<K, V>> iter) {
                this.iter = iter;
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public KeyValue<K, V> next() {
                Map.Entry<K, V> entry = this.iter.next();
                return new KeyValue<K, V>(entry.getKey(), entry.getValue());
            }

            @Override
            public void remove() {
                this.iter.remove();
            }

            @Override
            public void close() {
            }

            @Override
            public K peekNextKey() {
                throw new UnsupportedOperationException("peekNextKey not supported on MemoryStoreIterator");
            }
        }
    }
}

