/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.ForwardingCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.TupleForwarder;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.state.KeyValueStore;

class KTableKTableJoinMerger<K, V>
implements KTableProcessorSupplier<K, V, V> {
    private final KTableImpl<K, ?, V> parent1;
    private final KTableImpl<K, ?, V> parent2;
    private final String queryableName;
    private boolean sendOldValues = false;

    public KTableKTableJoinMerger(KTableImpl<K, ?, V> parent1, KTableImpl<K, ?, V> parent2, String queryableName) {
        this.parent1 = parent1;
        this.parent2 = parent2;
        this.queryableName = queryableName;
    }

    @Override
    public Processor<K, Change<V>> get() {
        return new KTableKTableJoinMergeProcessor();
    }

    @Override
    public KTableValueGetterSupplier<K, V> view() {
        return this.parent1.valueGetterSupplier();
    }

    @Override
    public void enableSendingOldValues() {
        this.parent1.enableSendingOldValues();
        this.parent2.enableSendingOldValues();
        this.sendOldValues = true;
    }

    private class KTableKTableJoinMergeProcessor<K, V>
    extends AbstractProcessor<K, Change<V>> {
        private KeyValueStore<K, V> store;
        private TupleForwarder<K, V> tupleForwarder;

        private KTableKTableJoinMergeProcessor() {
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            if (KTableKTableJoinMerger.this.queryableName != null) {
                this.store = (KeyValueStore)context.getStateStore(KTableKTableJoinMerger.this.queryableName);
                this.tupleForwarder = new TupleForwarder(this.store, context, new ForwardingCacheFlushListener(context, KTableKTableJoinMerger.this.sendOldValues), KTableKTableJoinMerger.this.sendOldValues);
            }
        }

        @Override
        public void process(K key, Change<V> value) {
            if (KTableKTableJoinMerger.this.queryableName != null) {
                this.store.put(key, value.newValue);
                this.tupleForwarder.maybeForward(key, value.newValue, value.oldValue);
            } else {
                this.context().forward(key, value);
            }
        }
    }
}

