/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.List;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

public class MeteredKeyValueStore<K, V>
extends WrappedStateStore.AbstractStateStore
implements KeyValueStore<K, V> {
    private final KeyValueStore<K, V> inner;
    private final String metricScope;
    protected final Time time;
    private Sensor putTime;
    private Sensor putIfAbsentTime;
    private Sensor getTime;
    private Sensor deleteTime;
    private Sensor putAllTime;
    private Sensor allTime;
    private Sensor rangeTime;
    private Sensor flushTime;
    private StreamsMetrics metrics;
    private ProcessorContext context;
    private StateStore root;

    public MeteredKeyValueStore(KeyValueStore<K, V> inner, String metricScope, Time time) {
        super(inner);
        this.inner = inner;
        this.metricScope = metricScope;
        this.time = time != null ? time : Time.SYSTEM;
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        String tagKey = "task-id";
        String tagValue = context.taskId().toString();
        this.context = context;
        this.root = root;
        this.metrics = context.metrics();
        this.putTime = this.metrics.addLatencyAndThroughputSensor(this.metricScope, this.name(), "put", Sensor.RecordingLevel.DEBUG, "task-id", tagValue);
        this.putIfAbsentTime = this.metrics.addLatencyAndThroughputSensor(this.metricScope, this.name(), "put-if-absent", Sensor.RecordingLevel.DEBUG, "task-id", tagValue);
        this.getTime = this.metrics.addLatencyAndThroughputSensor(this.metricScope, this.name(), "get", Sensor.RecordingLevel.DEBUG, "task-id", tagValue);
        this.deleteTime = this.metrics.addLatencyAndThroughputSensor(this.metricScope, this.name(), "delete", Sensor.RecordingLevel.DEBUG, "task-id", tagValue);
        this.putAllTime = this.metrics.addLatencyAndThroughputSensor(this.metricScope, this.name(), "put-all", Sensor.RecordingLevel.DEBUG, "task-id", tagValue);
        this.allTime = this.metrics.addLatencyAndThroughputSensor(this.metricScope, this.name(), "all", Sensor.RecordingLevel.DEBUG, "task-id", tagValue);
        this.rangeTime = this.metrics.addLatencyAndThroughputSensor(this.metricScope, this.name(), "range", Sensor.RecordingLevel.DEBUG, "task-id", tagValue);
        this.flushTime = this.metrics.addLatencyAndThroughputSensor(this.metricScope, this.name(), "flush", Sensor.RecordingLevel.DEBUG, "task-id", tagValue);
        Sensor restoreTime = this.metrics.addLatencyAndThroughputSensor(this.metricScope, this.name(), "restore", Sensor.RecordingLevel.DEBUG, "task-id", tagValue);
        if (restoreTime.shouldRecord()) {
            this.measureLatency(new Action<V>(){

                @Override
                public V execute() {
                    MeteredKeyValueStore.this.inner.init(MeteredKeyValueStore.this.context, MeteredKeyValueStore.this.root);
                    return null;
                }
            }, restoreTime);
        } else {
            this.inner.init(this.context, this.root);
        }
    }

    @Override
    public long approximateNumEntries() {
        return this.inner.approximateNumEntries();
    }

    @Override
    public V get(final K key) {
        if (this.getTime.shouldRecord()) {
            return this.measureLatency(new Action<V>(){

                @Override
                public V execute() {
                    return MeteredKeyValueStore.this.inner.get(key);
                }
            }, this.getTime);
        }
        return this.inner.get(key);
    }

    @Override
    public void put(final K key, final V value) {
        if (this.putTime.shouldRecord()) {
            this.measureLatency(new Action<V>(){

                @Override
                public V execute() {
                    MeteredKeyValueStore.this.inner.put(key, value);
                    return null;
                }
            }, this.putTime);
        } else {
            this.inner.put(key, value);
        }
    }

    @Override
    public V putIfAbsent(final K key, final V value) {
        if (this.putIfAbsentTime.shouldRecord()) {
            return this.measureLatency(new Action<V>(){

                @Override
                public V execute() {
                    return MeteredKeyValueStore.this.inner.putIfAbsent(key, value);
                }
            }, this.putIfAbsentTime);
        }
        return this.inner.putIfAbsent(key, value);
    }

    @Override
    public void putAll(final List<KeyValue<K, V>> entries) {
        if (this.putAllTime.shouldRecord()) {
            this.measureLatency(new Action<V>(){

                @Override
                public V execute() {
                    MeteredKeyValueStore.this.inner.putAll(entries);
                    return null;
                }
            }, this.putAllTime);
        } else {
            this.inner.putAll(entries);
        }
    }

    @Override
    public V delete(final K key) {
        if (this.deleteTime.shouldRecord()) {
            return this.measureLatency(new Action<V>(){

                @Override
                public V execute() {
                    return MeteredKeyValueStore.this.inner.delete(key);
                }
            }, this.deleteTime);
        }
        return this.inner.delete(key);
    }

    @Override
    public KeyValueIterator<K, V> range(K from, K to) {
        return new MeteredKeyValueIterator(this.inner.range(from, to), this.rangeTime);
    }

    @Override
    public KeyValueIterator<K, V> all() {
        return new MeteredKeyValueIterator(this.inner.all(), this.allTime);
    }

    @Override
    public void flush() {
        if (this.flushTime.shouldRecord()) {
            this.measureLatency(new Action<V>(){

                @Override
                public V execute() {
                    MeteredKeyValueStore.this.inner.flush();
                    return null;
                }
            }, this.flushTime);
        } else {
            this.inner.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V measureLatency(Action<V> action, Sensor sensor) {
        long startNs = this.time.nanoseconds();
        try {
            V v = action.execute();
            return v;
        }
        finally {
            this.metrics.recordLatency(sensor, startNs, this.time.nanoseconds());
        }
    }

    private class MeteredKeyValueIterator<K1, V1>
    implements KeyValueIterator<K1, V1> {
        private final KeyValueIterator<K1, V1> iter;
        private final Sensor sensor;
        private final long startNs;

        MeteredKeyValueIterator(KeyValueIterator<K1, V1> iter, Sensor sensor) {
            this.iter = iter;
            this.sensor = sensor;
            this.startNs = MeteredKeyValueStore.this.time.nanoseconds();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public KeyValue<K1, V1> next() {
            return (KeyValue)this.iter.next();
        }

        @Override
        public void remove() {
            this.iter.remove();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            try {
                this.iter.close();
            }
            finally {
                MeteredKeyValueStore.this.metrics.recordLatency(this.sensor, this.startNs, MeteredKeyValueStore.this.time.nanoseconds());
            }
        }

        @Override
        public K1 peekNextKey() {
            return this.iter.peekNextKey();
        }
    }

    static interface Action<V> {
        public V execute();
    }
}

