/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.ArrayDeque;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.streams.processor.internals.MinTimestampTracker;
import org.apache.kafka.streams.processor.internals.RecordDeserializer;
import org.apache.kafka.streams.processor.internals.SourceNode;
import org.apache.kafka.streams.processor.internals.SourceNodeRecordDeserializer;
import org.apache.kafka.streams.processor.internals.StampedRecord;
import org.apache.kafka.streams.processor.internals.TimestampTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordQueue {
    private static final Logger log = LoggerFactory.getLogger(RecordQueue.class);
    private final SourceNode source;
    private final TimestampExtractor timestampExtractor;
    private final TopicPartition partition;
    private final ArrayDeque<StampedRecord> fifoQueue;
    private final TimestampTracker<ConsumerRecord<Object, Object>> timeTracker;
    private final RecordDeserializer recordDeserializer;
    private long partitionTime = -1L;

    RecordQueue(TopicPartition partition, SourceNode source, TimestampExtractor timestampExtractor) {
        this.partition = partition;
        this.source = source;
        this.timestampExtractor = timestampExtractor;
        this.fifoQueue = new ArrayDeque();
        this.timeTracker = new MinTimestampTracker<ConsumerRecord<Object, Object>>();
        this.recordDeserializer = new SourceNodeRecordDeserializer(source);
    }

    public SourceNode source() {
        return this.source;
    }

    public TopicPartition partition() {
        return this.partition;
    }

    public int addRawRecords(Iterable<ConsumerRecord<byte[], byte[]>> rawRecords) {
        for (ConsumerRecord<byte[], byte[]> rawRecord : rawRecords) {
            ConsumerRecord<Object, Object> record = this.recordDeserializer.deserialize(rawRecord);
            long timestamp = this.timestampExtractor.extract(record, this.timeTracker.get());
            log.trace("Source node {} extracted timestamp {} for record {}", new Object[]{this.source.name(), timestamp, record});
            if (timestamp < 0L) continue;
            StampedRecord stampedRecord = new StampedRecord(record, timestamp);
            this.fifoQueue.addLast(stampedRecord);
            this.timeTracker.addElement(stampedRecord);
        }
        long timestamp = this.timeTracker.get();
        if (timestamp > this.partitionTime) {
            this.partitionTime = timestamp;
        }
        return this.size();
    }

    public StampedRecord poll() {
        StampedRecord elem = this.fifoQueue.pollFirst();
        if (elem == null) {
            return null;
        }
        this.timeTracker.removeElement(elem);
        long timestamp = this.timeTracker.get();
        if (timestamp > this.partitionTime) {
            this.partitionTime = timestamp;
        }
        return elem;
    }

    public int size() {
        return this.fifoQueue.size();
    }

    public boolean isEmpty() {
        return this.fifoQueue.isEmpty();
    }

    public long timestamp() {
        return this.partitionTime;
    }

    public void clear() {
        this.fifoQueue.clear();
        this.timeTracker.clear();
        this.partitionTime = -1L;
    }

    TimestampTracker<ConsumerRecord<Object, Object>> timeTracker() {
        return this.timeTracker;
    }
}

