/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Map;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.AbstractStoreSupplier;
import org.apache.kafka.streams.state.internals.CachingKeyValueStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingKeyValueBytesStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingKeyValueStore;
import org.apache.kafka.streams.state.internals.MeteredKeyValueStore;
import org.apache.kafka.streams.state.internals.RocksDBStore;

public class RocksDBKeyValueStoreSupplier<K, V>
extends AbstractStoreSupplier<K, V, KeyValueStore> {
    private static final String METRICS_SCOPE = "rocksdb-state";
    private final boolean cached;

    public RocksDBKeyValueStoreSupplier(String name, Serde<K> keySerde, Serde<V> valueSerde, boolean logged, Map<String, String> logConfig, boolean cached) {
        this(name, keySerde, valueSerde, null, logged, logConfig, cached);
    }

    public RocksDBKeyValueStoreSupplier(String name, Serde<K> keySerde, Serde<V> valueSerde, Time time, boolean logged, Map<String, String> logConfig, boolean cached) {
        super(name, keySerde, valueSerde, time, logged, logConfig);
        this.cached = cached;
    }

    @Override
    public KeyValueStore get() {
        if (!this.cached && !this.logged) {
            return new MeteredKeyValueStore(new RocksDBStore(this.name, this.keySerde, this.valueSerde), METRICS_SCOPE, this.time);
        }
        RocksDBStore<Bytes, byte[]> rocks = new RocksDBStore<Bytes, byte[]>(this.name, Serdes.Bytes(), Serdes.ByteArray());
        if (this.cached && this.logged) {
            return new CachingKeyValueStore(new MeteredKeyValueStore<Bytes, byte[]>(new ChangeLoggingKeyValueBytesStore(rocks), METRICS_SCOPE, this.time), this.keySerde, this.valueSerde);
        }
        if (this.cached) {
            return new CachingKeyValueStore(new MeteredKeyValueStore<Bytes, byte[]>(rocks, METRICS_SCOPE, this.time), this.keySerde, this.valueSerde);
        }
        return new MeteredKeyValueStore(new ChangeLoggingKeyValueStore(rocks, this.keySerde, this.valueSerde), METRICS_SCOPE, this.time);
    }
}

