/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.ForwardingCacheFlushListener;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.internals.CachedStateStore;

class TupleForwarder<K, V> {
    private final boolean cached;
    private final ProcessorContext context;
    private final boolean sendOldValues;

    TupleForwarder(StateStore store, ProcessorContext context, ForwardingCacheFlushListener flushListener, boolean sendOldValues) {
        this.cached = store instanceof CachedStateStore;
        this.context = context;
        this.sendOldValues = sendOldValues;
        if (this.cached) {
            ((CachedStateStore)((Object)store)).setFlushListener(flushListener);
        }
    }

    public void maybeForward(K key, V newValue, V oldValue) {
        if (!this.cached) {
            if (this.sendOldValues) {
                this.context.forward(key, new Change<V>(newValue, oldValue));
            } else {
                this.context.forward(key, new Change<Object>(newValue, null));
            }
        }
    }
}

