/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.errors.LockException;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.ChangelogReader;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTask {
    private static final Logger log = LoggerFactory.getLogger(AbstractTask.class);
    private static final int STATE_DIR_LOCK_RETRIES = 5;
    final TaskId id;
    final String applicationId;
    final ProcessorTopology topology;
    final ProcessorStateManager stateMgr;
    final Set<TopicPartition> partitions;
    final Consumer consumer;
    final String logPrefix;
    final boolean eosEnabled;
    private final StateDirectory stateDirectory;
    boolean taskInitialized;
    InternalProcessorContext processorContext;

    AbstractTask(TaskId id, String applicationId, Collection<TopicPartition> partitions, ProcessorTopology topology, Consumer<byte[], byte[]> consumer, ChangelogReader changelogReader, boolean isStandby, StateDirectory stateDirectory, StreamsConfig config) {
        this.id = id;
        this.applicationId = applicationId;
        this.partitions = new HashSet<TopicPartition>(partitions);
        this.topology = topology;
        this.consumer = consumer;
        this.eosEnabled = "exactly_once".equals(config.getString("processing.guarantee"));
        this.stateDirectory = stateDirectory;
        this.logPrefix = String.format("%s [%s]", isStandby ? "standby-task" : "task", this.id());
        try {
            this.stateMgr = new ProcessorStateManager(id, partitions, isStandby, stateDirectory, topology.storeToChangelogTopic(), changelogReader, this.eosEnabled);
        }
        catch (IOException e) {
            throw new ProcessorStateException(String.format("%s Error while creating the state manager", this.logPrefix), e);
        }
    }

    public abstract void resume();

    public abstract void commit();

    public abstract void suspend();

    public abstract void close(boolean var1, boolean var2);

    public TaskId id() {
        return this.id;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public Set<TopicPartition> partitions() {
        return this.partitions;
    }

    public final ProcessorTopology topology() {
        return this.topology;
    }

    public final ProcessorContext context() {
        return this.processorContext;
    }

    public StateStore getStore(String name) {
        return this.stateMgr.getStore(name);
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(indent);
        sb.append("StreamsTask taskId: ");
        sb.append(this.id);
        sb.append("\n");
        if (this.topology != null) {
            sb.append(indent).append(this.topology.toString(indent + "\t"));
        }
        if (this.partitions != null && !this.partitions.isEmpty()) {
            sb.append(indent).append("Partitions [");
            for (TopicPartition topicPartition : this.partitions) {
                sb.append(topicPartition.toString()).append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append("]\n");
        }
        return sb.toString();
    }

    protected Map<TopicPartition, Long> activeTaskCheckpointableOffsets() {
        return Collections.emptyMap();
    }

    protected void updateOffsetLimits() {
        for (TopicPartition partition : this.partitions) {
            try {
                OffsetAndMetadata metadata = this.consumer.committed(partition);
                long offset = metadata != null ? metadata.offset() : 0L;
                this.stateMgr.putOffsetLimit(partition, offset);
                if (!log.isTraceEnabled()) continue;
                log.trace("{} Updating store offset limits {} for changelog {}", new Object[]{this.logPrefix, offset, partition});
            }
            catch (AuthorizationException e) {
                throw new ProcessorStateException(String.format("task [%s] AuthorizationException when initializing offsets for %s", this.id, partition), e);
            }
            catch (WakeupException e) {
                throw e;
            }
            catch (KafkaException e) {
                throw new ProcessorStateException(String.format("task [%s] Failed to initialize offsets for %s", this.id, partition), e);
            }
        }
    }

    void flushState() {
        this.stateMgr.flush();
    }

    void initStateStores() {
        if (this.topology.stateStores().isEmpty()) {
            return;
        }
        try {
            if (!this.stateDirectory.lock(this.id, 5)) {
                throw new LockException(String.format("%s Failed to lock the state directory for task %s", this.logPrefix, this.id));
            }
        }
        catch (IOException e) {
            throw new StreamsException(String.format("%s Fatal error while trying to lock the state directory for task %s %s", this.logPrefix, this.id, e.getMessage()));
        }
        log.trace("{} Initializing state stores", (Object)this.logPrefix);
        this.updateOffsetLimits();
        for (StateStore store : this.topology.stateStores()) {
            log.trace("{} Initializing store {}", (Object)this.logPrefix, (Object)store.name());
            store.init(this.processorContext, store);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void closeStateManager(boolean writeCheckpoint) throws ProcessorStateException {
        ProcessorStateException exception;
        block14: {
            exception = null;
            log.trace("{} Closing state manager", (Object)this.logPrefix);
            this.stateMgr.close(writeCheckpoint ? this.activeTaskCheckpointableOffsets() : null);
            try {
                this.stateDirectory.unlock(this.id);
            }
            catch (IOException e) {
                if (exception == null) {
                    exception = new ProcessorStateException(String.format("%s Failed to release state dir lock", this.logPrefix), e);
                }
                log.error("{} Failed to release state dir lock: ", (Object)this.logPrefix, (Object)e);
            }
            break block14;
            catch (ProcessorStateException e) {
                try {
                    exception = e;
                }
                catch (Throwable throwable) {
                    try {
                        this.stateDirectory.unlock(this.id);
                    }
                    catch (IOException e2) {
                        if (exception == null) {
                            exception = new ProcessorStateException(String.format("%s Failed to release state dir lock", this.logPrefix), e2);
                        }
                        log.error("{} Failed to release state dir lock: ", (Object)this.logPrefix, (Object)e2);
                    }
                    throw throwable;
                }
                try {
                    this.stateDirectory.unlock(this.id);
                }
                catch (IOException e3) {
                    if (exception == null) {
                        exception = new ProcessorStateException(String.format("%s Failed to release state dir lock", this.logPrefix), e3);
                    }
                    log.error("{} Failed to release state dir lock: ", (Object)this.logPrefix, (Object)e3);
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public abstract boolean initializeStateStores();

    public abstract void initializeTopology();

    abstract boolean process();

    boolean hasStateStores() {
        return !this.topology.stateStores().isEmpty();
    }

    Collection<TopicPartition> changelogPartitions() {
        return this.stateMgr.changelogPartitions();
    }

    abstract boolean maybePunctuate();

    abstract boolean commitNeeded();
}

