/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.trogdor.rest.Message;

public class TasksRequest
extends Message {
    private final Set<String> taskIds;
    private final long firstStartMs;
    private final long lastStartMs;
    private final long firstEndMs;
    private final long lastEndMs;

    @JsonCreator
    public TasksRequest(@JsonProperty(value="taskIds") Collection<String> taskIds, @JsonProperty(value="firstStartMs") long firstStartMs, @JsonProperty(value="lastStartMs") long lastStartMs, @JsonProperty(value="firstEndMs") long firstEndMs, @JsonProperty(value="lastEndMs") long lastEndMs) {
        this.taskIds = Collections.unmodifiableSet(taskIds == null ? new HashSet() : new HashSet<String>(taskIds));
        this.firstStartMs = Math.max(0L, firstStartMs);
        this.lastStartMs = Math.max(0L, lastStartMs);
        this.firstEndMs = Math.max(0L, firstEndMs);
        this.lastEndMs = Math.max(0L, lastEndMs);
    }

    @JsonProperty
    public Collection<String> taskIds() {
        return this.taskIds;
    }

    @JsonProperty
    public long firstStartMs() {
        return this.firstStartMs;
    }

    @JsonProperty
    public long lastStartMs() {
        return this.lastStartMs;
    }

    @JsonProperty
    public long firstEndMs() {
        return this.firstEndMs;
    }

    @JsonProperty
    public long lastEndMs() {
        return this.lastEndMs;
    }

    public boolean matches(String taskId, long startMs, long endMs) {
        if (!this.taskIds.isEmpty() && !this.taskIds.contains(taskId)) {
            return false;
        }
        if (this.firstStartMs > 0L && startMs < this.firstStartMs) {
            return false;
        }
        if (this.lastStartMs > 0L && (startMs < 0L || startMs > this.lastStartMs)) {
            return false;
        }
        if (this.firstEndMs > 0L && endMs < this.firstEndMs) {
            return false;
        }
        return this.lastEndMs <= 0L || endMs >= 0L && endMs <= this.lastEndMs;
    }
}

