/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import kafka.consumer.SimpleConsumer;
import kafka.integration.KafkaServerTestHarness;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.clients.producer.internals.ErrorLoggingCallback;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.NotEnoughReplicasAfterAppendException;
import org.apache.kafka.common.errors.NotEnoughReplicasException;
import org.apache.kafka.common.internals.TopicConstants;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t=a\u0001B\u0001\u0003\u0001\u001d\u00111\u0004\u0015:pIV\u001cWM\u001d$bS2,(/\u001a%b]\u0012d\u0017N\\4UKN$(BA\u0002\u0005\u0003\r\t\u0007/\u001b\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t%A\u0011\u0011\u0002E\u0007\u0002\u0015)\u00111\u0002D\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001b9\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003=\t1a\u001c:h\u0013\t\t\"B\u0001\u0006K+:LGoU;ji\u0016\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\u0017%tG/Z4sCRLwN\\\u0005\u0003/Q\u0011acS1gW\u0006\u001cVM\u001d<feR+7\u000f\u001e%be:,7o\u001d\u0005\u00063\u0001!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"\u0001\b\u0001\u000e\u0003\tAqA\b\u0001C\u0002\u0013%q$\u0001\nqe>$WoY3s\u0005V4g-\u001a:TSj,W#\u0001\u0011\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\u0007%sG\u000f\u0003\u0004(\u0001\u0001\u0006I\u0001I\u0001\u0014aJ|G-^2fe\n+hMZ3s'&TX\r\t\u0005\bS\u0001\u0011\r\u0011\"\u0003 \u0003U\u0019XM\u001d<fe6+7o]1hK6\u000b\u0007PQ=uKNDaa\u000b\u0001!\u0002\u0013\u0001\u0013AF:feZ,'/T3tg\u0006<W-T1y\u0005f$Xm\u001d\u0011\t\u000f5\u0002!\u0019!C\u0001?\u0005Qa.^7TKJ4XM]:\t\r=\u0002\u0001\u0015!\u0003!\u0003-qW/\\*feZ,'o\u001d\u0011\t\u000fE\u0002!\u0019!C\u0001e\u0005yqN^3se&$\u0017N\\4Qe>\u00048/F\u00014!\t!\u0014(D\u00016\u0015\t1t'\u0001\u0003vi&d'\"\u0001\u001d\u0002\t)\fg/Y\u0005\u0003uU\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u0019a\u0004\u0001)A\u0005g\u0005\u0001rN^3se&$\u0017N\\4Qe>\u00048\u000f\t\u0005\u0006}\u0001!\taP\u0001\u0010O\u0016tWM]1uK\u000e{gNZ5hgR\t\u0001\tE\u0002B\u00132s!AQ$\u000f\u0005\r3U\"\u0001#\u000b\u0005\u00153\u0011A\u0002\u001fs_>$h(C\u0001$\u0013\tA%%A\u0004qC\u000e\\\u0017mZ3\n\u0005)[%aA*fc*\u0011\u0001J\t\t\u0003\u001bBk\u0011A\u0014\u0006\u0003\u001f\u0012\taa]3sm\u0016\u0014\u0018BA)O\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u000fM\u0003\u0001\u0019!C\u0005)\u0006I1m\u001c8tk6,'/M\u000b\u0002+B\u0011a+W\u0007\u0002/*\u0011\u0001\fB\u0001\tG>t7/^7fe&\u0011!l\u0016\u0002\u000f'&l\u0007\u000f\\3D_:\u001cX/\\3s\u0011\u001da\u0006\u00011A\u0005\nu\u000bQbY8ogVlWM]\u0019`I\u0015\fHC\u00010b!\t\ts,\u0003\u0002aE\t!QK\\5u\u0011\u001d\u00117,!AA\u0002U\u000b1\u0001\u001f\u00132\u0011\u0019!\u0007\u0001)Q\u0005+\u0006Q1m\u001c8tk6,'/\r\u0011\t\u000f\u0019\u0004\u0001\u0019!C\u0005)\u0006I1m\u001c8tk6,'O\r\u0005\bQ\u0002\u0001\r\u0011\"\u0003j\u00035\u0019wN\\:v[\u0016\u0014(g\u0018\u0013fcR\u0011aL\u001b\u0005\bE\u001e\f\t\u00111\u0001V\u0011\u0019a\u0007\u0001)Q\u0005+\u0006Q1m\u001c8tk6,'O\r\u0011\t\u000f9\u0004\u0001\u0019!C\u0005_\u0006I\u0001O]8ek\u000e,'/M\u000b\u0002aB!\u0011/_>|\u001b\u0005\u0011(BA:u\u0003!\u0001(o\u001c3vG\u0016\u0014(BA;w\u0003\u001d\u0019G.[3oiNT!!B<\u000b\u0005at\u0011AB1qC\u000eDW-\u0003\u0002{e\ni1*\u00194lCB\u0013x\u000eZ;dKJ\u00042!\t?\u007f\u0013\ti(EA\u0003BeJ\f\u0017\u0010\u0005\u0002\"\u007f&\u0019\u0011\u0011\u0001\u0012\u0003\t\tKH/\u001a\u0005\n\u0003\u000b\u0001\u0001\u0019!C\u0005\u0003\u000f\tQ\u0002\u001d:pIV\u001cWM]\u0019`I\u0015\fHc\u00010\u0002\n!A!-a\u0001\u0002\u0002\u0003\u0007\u0001\u000fC\u0004\u0002\u000e\u0001\u0001\u000b\u0015\u00029\u0002\u0015A\u0014x\u000eZ;dKJ\f\u0004\u0005\u0003\u0005\u0002\u0012\u0001\u0001\r\u0011\"\u0003p\u0003%\u0001(o\u001c3vG\u0016\u0014(\u0007C\u0005\u0002\u0016\u0001\u0001\r\u0011\"\u0003\u0002\u0018\u0005i\u0001O]8ek\u000e,'OM0%KF$2AXA\r\u0011!\u0011\u00171CA\u0001\u0002\u0004\u0001\bbBA\u000f\u0001\u0001\u0006K\u0001]\u0001\u000baJ|G-^2feJ\u0002\u0003\u0002CA\u0011\u0001\u0001\u0007I\u0011B8\u0002\u0013A\u0014x\u000eZ;dKJ\u001c\u0004\"CA\u0013\u0001\u0001\u0007I\u0011BA\u0014\u00035\u0001(o\u001c3vG\u0016\u00148g\u0018\u0013fcR\u0019a,!\u000b\t\u0011\t\f\u0019#!AA\u0002ADq!!\f\u0001A\u0003&\u0001/\u0001\u0006qe>$WoY3sg\u0001B\u0001\"!\r\u0001\u0001\u0004%Ia\\\u0001\naJ|G-^2feRB\u0011\"!\u000e\u0001\u0001\u0004%I!a\u000e\u0002\u001bA\u0014x\u000eZ;dKJ$t\fJ3r)\rq\u0016\u0011\b\u0005\tE\u0006M\u0012\u0011!a\u0001a\"9\u0011Q\b\u0001!B\u0013\u0001\u0018A\u00039s_\u0012,8-\u001a:5A!I\u0011\u0011\t\u0001C\u0002\u0013%\u00111I\u0001\u0007i>\u0004\u0018nY\u0019\u0016\u0005\u0005\u0015\u0003\u0003BA$\u0003\u001bj!!!\u0013\u000b\u0007\u0005-s'\u0001\u0003mC:<\u0017\u0002BA(\u0003\u0013\u0012aa\u0015;sS:<\u0007\u0002CA*\u0001\u0001\u0006I!!\u0012\u0002\u000fQ|\u0007/[22A!I\u0011q\u000b\u0001C\u0002\u0013%\u00111I\u0001\u0007i>\u0004\u0018n\u0019\u001a\t\u0011\u0005m\u0003\u0001)A\u0005\u0003\u000b\nq\u0001^8qS\u000e\u0014\u0004\u0005C\u0004\u0002`\u0001!\t%!\u0019\u0002\u000bM,G/\u00169\u0015\u0003yCC!!\u0018\u0002fA!\u0011qMA6\u001b\t\tIG\u0003\u0002\f\u001d%!\u0011QNA5\u0005\u0019\u0011UMZ8sK\"9\u0011\u0011\u000f\u0001\u0005B\u0005\u0005\u0014\u0001\u0003;fCJ$un\u001e8)\t\u0005=\u0014Q\u000f\t\u0005\u0003O\n9(\u0003\u0003\u0002z\u0005%$!B!gi\u0016\u0014\bbBA?\u0001\u0011\u0005\u0011\u0011M\u0001\u001ei\u0016\u001cH\u000fV8p\u0019\u0006\u0014x-\u001a*fG>\u0014HmV5uQ\u0006\u001b7NW3s_\"\"\u00111PAA!\u0011\t9'a!\n\t\u0005\u0015\u0015\u0011\u000e\u0002\u0005)\u0016\u001cH\u000fC\u0004\u0002\n\u0002!\t!!\u0019\u00029Q,7\u000f\u001e+p_2\u000b'oZ3SK\u000e|'\u000fZ,ji\"\f5m[(oK\"\"\u0011qQAA\u0011\u001d\ty\t\u0001C\u0001\u0003C\nA\u0003^3ti:{g.\u0012=jgR,g\u000e\u001e+pa&\u001c\u0007\u0006BAG\u0003\u0003Cq!!&\u0001\t\u0003\t\t'A\nuKN$xK]8oO\n\u0013xn[3s\u0019&\u001cH\u000f\u000b\u0003\u0002\u0014\u0006\u0005\u0005bBAN\u0001\u0011\u0005\u0011\u0011M\u0001\u0015i\u0016\u001cH/\u00138wC2LG\rU1si&$\u0018n\u001c8)\t\u0005e\u0015\u0011\u0011\u0005\b\u0003C\u0003A\u0011AA1\u0003M!Xm\u001d;TK:$\u0017I\u001a;fe\u000ecwn]3eQ\u0011\ty*!!\t\u000f\u0005\u001d\u0006\u0001\"\u0001\u0002b\u0005iB/Z:u\u0007\u0006tgn\u001c;TK:$Gk\\%oi\u0016\u0014h.\u00197U_BL7\r\u000b\u0003\u0002&\u0006\u0005\u0005bBAW\u0001\u0011\u0005\u0011\u0011M\u0001\u0016i\u0016\u001cHOT8u\u000b:|Wo\u001a5SKBd\u0017nY1tQ\u0011\tY+!!\t\u000f\u0005M\u0006\u0001\"\u0001\u0002b\u0005AC/Z:u\u001d>$XI\\8vO\"\u0014V\r\u001d7jG\u0006\u001c\u0018I\u001a;fe\n\u0013xn[3s'\",H\u000fZ8x]\"\"\u0011\u0011WAA\r\u0019\tI\f\u0001\u0003\u0002<\n\t\u0002K]8ek\u000e,'oU2iK\u0012,H.\u001a:\u0014\t\u0005]\u0016Q\u0018\t\u0005\u0003\u007f\u000b)-\u0004\u0002\u0002B*\u0019\u00111\u0019\u0003\u0002\u000bU$\u0018\u000e\\:\n\t\u0005\u001d\u0017\u0011\u0019\u0002\u0013'\",H\u000fZ8x]\u0006\u0014G.\u001a+ie\u0016\fG\rC\u0004\u001a\u0003o#\t!a3\u0015\u0005\u00055\u0007\u0003BAh\u0003ok\u0011\u0001\u0001\u0005\n\u0003'\f9L1A\u0005\u0002}\t!B\\;n%\u0016\u001cwN\u001d3t\u0011!\t9.a.!\u0002\u0013\u0001\u0013a\u00038v[J+7m\u001c:eg\u0002B\u0011\"a7\u00028\u0002\u0007I\u0011A\u0010\u0002\tM,g\u000e\u001e\u0005\u000b\u0003?\f9\f1A\u0005\u0002\u0005\u0005\u0018\u0001C:f]R|F%Z9\u0015\u0007y\u000b\u0019\u000f\u0003\u0005c\u0003;\f\t\u00111\u0001!\u0011!\t9/a.!B\u0013\u0001\u0013!B:f]R\u0004\u0003BCAv\u0003o\u0003\r\u0011\"\u0001\u0002n\u00061a-Y5mK\u0012,\"!a<\u0011\u0007\u0005\n\t0C\u0002\u0002t\n\u0012qAQ8pY\u0016\fg\u000e\u0003\u0006\u0002x\u0006]\u0006\u0019!C\u0001\u0003s\f!BZ1jY\u0016$w\fJ3r)\rq\u00161 \u0005\nE\u0006U\u0018\u0011!a\u0001\u0003_D\u0011\"a@\u00028\u0002\u0006K!a<\u0002\u000f\u0019\f\u0017\u000e\\3eA!A1/a.C\u0002\u0013\u0005q\u000e\u0003\u0005\u0003\u0006\u0005]\u0006\u0015!\u0003q\u0003%\u0001(o\u001c3vG\u0016\u0014\b\u0005\u0003\u0005\u0003\n\u0005]F\u0011IA1\u0003\u0019!wnV8sW\"A!QBA\\\t\u0003\n\t'\u0001\u0005tQV$Hm\\<o\u0001")
public class ProducerFailureHandlingTest
extends JUnitSuite
implements KafkaServerTestHarness {
    private final int kafka$api$ProducerFailureHandlingTest$$producerBufferSize;
    private final int serverMessageMaxBytes;
    private final int numServers;
    private final Properties overridingProps;
    private SimpleConsumer consumer1;
    private SimpleConsumer consumer2;
    private KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer1;
    private KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer2;
    private KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer3;
    private KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer4;
    private final String kafka$api$ProducerFailureHandlingTest$$topic1;
    private final String topic2;
    private Seq<KafkaConfig> instanceConfigs;
    private Buffer<KafkaServer> servers;
    private String brokerList;
    private boolean[] alive;
    private final String kafkaPrincipalType;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public Seq<KafkaConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    @Override
    public void instanceConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.instanceConfigs = x$1;
    }

    @Override
    public Buffer<KafkaServer> servers() {
        return this.servers;
    }

    @Override
    public void servers_$eq(Buffer<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public String brokerList() {
        return this.brokerList;
    }

    @Override
    public void brokerList_$eq(String x$1) {
        this.brokerList = x$1;
    }

    @Override
    public boolean[] alive() {
        return this.alive;
    }

    @Override
    public void alive_$eq(boolean[] x$1) {
        this.alive = x$1;
    }

    @Override
    public String kafkaPrincipalType() {
        return this.kafkaPrincipalType;
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$_setter_$kafkaPrincipalType_$eq(String x$1) {
        this.kafkaPrincipalType = x$1;
    }

    @Override
    public void setAclsBeforeServersStart() {
        KafkaServerTestHarness$class.setAclsBeforeServersStart(this);
    }

    @Override
    public Seq<KafkaConfig> configs() {
        return KafkaServerTestHarness$class.configs(this);
    }

    @Override
    public Option<KafkaServer> serverForId(int id) {
        return KafkaServerTestHarness$class.serverForId(this, id);
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return KafkaServerTestHarness$class.securityProtocol(this);
    }

    @Override
    public Option<File> trustStoreFile() {
        return KafkaServerTestHarness$class.trustStoreFile(this);
    }

    @Override
    public Option<Properties> saslProperties() {
        return KafkaServerTestHarness$class.saslProperties(this);
    }

    @Override
    public int killRandomBroker() {
        return KafkaServerTestHarness$class.killRandomBroker(this);
    }

    @Override
    public void restartDeadBrokers() {
        KafkaServerTestHarness$class.restartDeadBrokers(this);
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ProducerFailureHandlingTest producerFailureHandlingTest = this;
        synchronized (producerFailureHandlingTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public int kafka$api$ProducerFailureHandlingTest$$producerBufferSize() {
        return this.kafka$api$ProducerFailureHandlingTest$$producerBufferSize;
    }

    private int serverMessageMaxBytes() {
        return this.serverMessageMaxBytes;
    }

    public int numServers() {
        return this.numServers;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numServers(), this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.$outer.overridingProps());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private SimpleConsumer consumer1() {
        return this.consumer1;
    }

    private void consumer1_$eq(SimpleConsumer x$1) {
        this.consumer1 = x$1;
    }

    private SimpleConsumer consumer2() {
        return this.consumer2;
    }

    private void consumer2_$eq(SimpleConsumer x$1) {
        this.consumer2 = x$1;
    }

    public KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer1() {
        return this.kafka$api$ProducerFailureHandlingTest$$producer1;
    }

    private void kafka$api$ProducerFailureHandlingTest$$producer1_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.kafka$api$ProducerFailureHandlingTest$$producer1 = x$1;
    }

    public KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer2() {
        return this.kafka$api$ProducerFailureHandlingTest$$producer2;
    }

    private void kafka$api$ProducerFailureHandlingTest$$producer2_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.kafka$api$ProducerFailureHandlingTest$$producer2 = x$1;
    }

    public KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer3() {
        return this.kafka$api$ProducerFailureHandlingTest$$producer3;
    }

    private void kafka$api$ProducerFailureHandlingTest$$producer3_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.kafka$api$ProducerFailureHandlingTest$$producer3 = x$1;
    }

    public KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer4() {
        return this.kafka$api$ProducerFailureHandlingTest$$producer4;
    }

    private void kafka$api$ProducerFailureHandlingTest$$producer4_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.kafka$api$ProducerFailureHandlingTest$$producer4 = x$1;
    }

    public String kafka$api$ProducerFailureHandlingTest$$topic1() {
        return this.kafka$api$ProducerFailureHandlingTest$$topic1;
    }

    private String topic2() {
        return this.topic2;
    }

    @Override
    @Before
    public void setUp() {
        KafkaServerTestHarness$class.setUp(this);
        String x$3 = this.brokerList();
        int x$4 = 0;
        long x$5 = 30000L;
        long x$6 = 10000L;
        long x$7 = this.kafka$api$ProducerFailureHandlingTest$$producerBufferSize();
        int x$8 = TestUtils$.MODULE$.createNewProducer$default$5();
        long x$9 = TestUtils$.MODULE$.createNewProducer$default$6();
        SecurityProtocol x$10 = TestUtils$.MODULE$.createNewProducer$default$8();
        Option<File> x$11 = TestUtils$.MODULE$.createNewProducer$default$9();
        Option<Properties> x$12 = TestUtils$.MODULE$.createNewProducer$default$10();
        ByteArraySerializer x$13 = TestUtils$.MODULE$.createNewProducer$default$11();
        ByteArraySerializer x$14 = TestUtils$.MODULE$.createNewProducer$default$12();
        Option<Properties> x$15 = TestUtils$.MODULE$.createNewProducer$default$13();
        this.kafka$api$ProducerFailureHandlingTest$$producer1_$eq(TestUtils$.MODULE$.createNewProducer(x$3, x$4, x$6, x$7, x$8, x$9, x$5, x$10, x$11, x$12, x$13, x$14, x$15));
        String x$16 = this.brokerList();
        int x$17 = 1;
        long x$18 = 30000L;
        long x$19 = 10000L;
        long x$20 = this.kafka$api$ProducerFailureHandlingTest$$producerBufferSize();
        int x$21 = TestUtils$.MODULE$.createNewProducer$default$5();
        long x$22 = TestUtils$.MODULE$.createNewProducer$default$6();
        SecurityProtocol x$23 = TestUtils$.MODULE$.createNewProducer$default$8();
        Option<File> x$24 = TestUtils$.MODULE$.createNewProducer$default$9();
        Option<Properties> x$25 = TestUtils$.MODULE$.createNewProducer$default$10();
        ByteArraySerializer x$26 = TestUtils$.MODULE$.createNewProducer$default$11();
        ByteArraySerializer x$27 = TestUtils$.MODULE$.createNewProducer$default$12();
        Option<Properties> x$28 = TestUtils$.MODULE$.createNewProducer$default$13();
        this.kafka$api$ProducerFailureHandlingTest$$producer2_$eq(TestUtils$.MODULE$.createNewProducer(x$16, x$17, x$19, x$20, x$21, x$22, x$18, x$23, x$24, x$25, x$26, x$27, x$28));
        String x$29 = this.brokerList();
        int x$30 = -1;
        long x$31 = 30000L;
        long x$32 = 10000L;
        long x$33 = this.kafka$api$ProducerFailureHandlingTest$$producerBufferSize();
        int x$34 = TestUtils$.MODULE$.createNewProducer$default$5();
        long x$35 = TestUtils$.MODULE$.createNewProducer$default$6();
        SecurityProtocol x$36 = TestUtils$.MODULE$.createNewProducer$default$8();
        Option<File> x$37 = TestUtils$.MODULE$.createNewProducer$default$9();
        Option<Properties> x$38 = TestUtils$.MODULE$.createNewProducer$default$10();
        ByteArraySerializer x$39 = TestUtils$.MODULE$.createNewProducer$default$11();
        ByteArraySerializer x$40 = TestUtils$.MODULE$.createNewProducer$default$12();
        Option<Properties> x$41 = TestUtils$.MODULE$.createNewProducer$default$13();
        this.kafka$api$ProducerFailureHandlingTest$$producer3_$eq(TestUtils$.MODULE$.createNewProducer(x$29, x$30, x$32, x$33, x$34, x$35, x$31, x$36, x$37, x$38, x$39, x$40, x$41));
    }

    @Override
    @After
    public void tearDown() {
        if (this.kafka$api$ProducerFailureHandlingTest$$producer1() != null) {
            this.kafka$api$ProducerFailureHandlingTest$$producer1().close();
        }
        if (this.kafka$api$ProducerFailureHandlingTest$$producer2() != null) {
            this.kafka$api$ProducerFailureHandlingTest$$producer2().close();
        }
        if (this.kafka$api$ProducerFailureHandlingTest$$producer3() != null) {
            this.kafka$api$ProducerFailureHandlingTest$$producer3().close();
        }
        if (this.kafka$api$ProducerFailureHandlingTest$$producer4() != null) {
            this.kafka$api$ProducerFailureHandlingTest$$producer4().close();
        }
        KafkaServerTestHarness$class.tearDown(this);
    }

    @Test
    public void testTooLargeRecordWithAckZero() {
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.kafka$api$ProducerFailureHandlingTest$$topic1(), 1, this.numServers(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        ProducerRecord record = new ProducerRecord(this.kafka$api$ProducerFailureHandlingTest$$topic1(), null, (Object)"key".getBytes(), (Object)new byte[this.serverMessageMaxBytes() + 1]);
        Assert.assertEquals((String)"Returned metadata should have offset -1", (long)((RecordMetadata)this.kafka$api$ProducerFailureHandlingTest$$producer1().send(record).get()).offset(), (long)-1L);
    }

    @Test
    public void testTooLargeRecordWithAckOne() {
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.kafka$api$ProducerFailureHandlingTest$$topic1(), 1, this.numServers(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        ProducerRecord record = new ProducerRecord(this.kafka$api$ProducerFailureHandlingTest$$topic1(), null, (Object)"key".getBytes(), (Object)new byte[this.serverMessageMaxBytes() + 1]);
        this.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$1;

            public final RecordMetadata apply() {
                return (RecordMetadata)this.$outer.kafka$api$ProducerFailureHandlingTest$$producer2().send(this.record$1).get();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.record$1 = record$1;
            }
        }, ManifestFactory$.MODULE$.classType(ExecutionException.class));
    }

    @Test
    public void testNonExistentTopic() {
        ProducerRecord record = new ProducerRecord(this.topic2(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$2;

            public final RecordMetadata apply() {
                return (RecordMetadata)this.$outer.kafka$api$ProducerFailureHandlingTest$$producer1().send(this.record$2).get();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.record$2 = record$2;
            }
        }, ManifestFactory$.MODULE$.classType(ExecutionException.class));
    }

    @Test
    public void testWrongBrokerList() {
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.kafka$api$ProducerFailureHandlingTest$$topic1(), 1, this.numServers(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.kafka$api$ProducerFailureHandlingTest$$producer4_$eq(TestUtils$.MODULE$.createNewProducer("localhost:8686,localhost:4242", 1, 10000L, this.kafka$api$ProducerFailureHandlingTest$$producerBufferSize(), TestUtils$.MODULE$.createNewProducer$default$5(), TestUtils$.MODULE$.createNewProducer$default$6(), TestUtils$.MODULE$.createNewProducer$default$7(), TestUtils$.MODULE$.createNewProducer$default$8(), TestUtils$.MODULE$.createNewProducer$default$9(), TestUtils$.MODULE$.createNewProducer$default$10(), TestUtils$.MODULE$.createNewProducer$default$11(), TestUtils$.MODULE$.createNewProducer$default$12(), TestUtils$.MODULE$.createNewProducer$default$13()));
        ProducerRecord record = new ProducerRecord(this.kafka$api$ProducerFailureHandlingTest$$topic1(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$3;

            public final RecordMetadata apply() {
                return (RecordMetadata)this.$outer.kafka$api$ProducerFailureHandlingTest$$producer4().send(this.record$3).get();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.record$3 = record$3;
            }
        }, ManifestFactory$.MODULE$.classType(ExecutionException.class));
    }

    @Test
    public void testInvalidPartition() {
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.kafka$api$ProducerFailureHandlingTest$$topic1(), 1, this.numServers(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        ProducerRecord record = new ProducerRecord(this.kafka$api$ProducerFailureHandlingTest$$topic1(), new Integer(1), (Object)"key".getBytes(), (Object)"value".getBytes());
        this.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$4;

            public final Future<RecordMetadata> apply() {
                return this.$outer.kafka$api$ProducerFailureHandlingTest$$producer1().send(this.record$4);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.record$4 = record$4;
            }
        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
        this.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$4;

            public final Future<RecordMetadata> apply() {
                return this.$outer.kafka$api$ProducerFailureHandlingTest$$producer2().send(this.record$4);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.record$4 = record$4;
            }
        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
        this.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$4;

            public final Future<RecordMetadata> apply() {
                return this.$outer.kafka$api$ProducerFailureHandlingTest$$producer3().send(this.record$4);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.record$4 = record$4;
            }
        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
    }

    @Test
    public void testSendAfterClosed() {
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.kafka$api$ProducerFailureHandlingTest$$topic1(), 1, this.numServers(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        ProducerRecord record = new ProducerRecord(this.kafka$api$ProducerFailureHandlingTest$$topic1(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.kafka$api$ProducerFailureHandlingTest$$producer1().send(record).get();
        this.kafka$api$ProducerFailureHandlingTest$$producer2().send(record).get();
        this.kafka$api$ProducerFailureHandlingTest$$producer3().send(record).get();
        this.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$5;

            public final Future<RecordMetadata> apply() {
                this.$outer.kafka$api$ProducerFailureHandlingTest$$producer1().close();
                return this.$outer.kafka$api$ProducerFailureHandlingTest$$producer1().send(this.record$5);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.record$5 = record$5;
            }
        }, ManifestFactory$.MODULE$.classType(IllegalStateException.class));
        this.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$5;

            public final Future<RecordMetadata> apply() {
                this.$outer.kafka$api$ProducerFailureHandlingTest$$producer2().close();
                return this.$outer.kafka$api$ProducerFailureHandlingTest$$producer2().send(this.record$5);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.record$5 = record$5;
            }
        }, ManifestFactory$.MODULE$.classType(IllegalStateException.class));
        this.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$5;

            public final Future<RecordMetadata> apply() {
                this.$outer.kafka$api$ProducerFailureHandlingTest$$producer3().close();
                return this.$outer.kafka$api$ProducerFailureHandlingTest$$producer3().send(this.record$5);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.record$5 = record$5;
            }
        }, ManifestFactory$.MODULE$.classType(IllegalStateException.class));
    }

    @Test
    public void testCannotSendToInternalTopic() {
        ExecutionException thrown = (ExecutionException)this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;

            public final RecordMetadata apply() {
                return (RecordMetadata)this.$outer.kafka$api$ProducerFailureHandlingTest$$producer2().send(new ProducerRecord((String)TopicConstants.INTERNAL_TOPICS.iterator().next(), (Object)"test".getBytes(), (Object)"test".getBytes())).get();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ManifestFactory$.MODULE$.classType(ExecutionException.class));
        Assert.assertTrue((String)new StringBuilder().append((Object)"Unexpected exception while sending to an invalid topic ").append((Object)thrown.getCause()).toString(), (boolean)(thrown.getCause() instanceof InvalidTopicException));
    }

    @Test
    public void testNotEnoughReplicas() {
        String topicName = "minisrtest";
        Properties topicProps = new Properties();
        topicProps.put("min.insync.replicas", ((Object)BoxesRunTime.boxToInteger((int)(this.numServers() + 1))).toString());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topicName, 1, this.numServers(), (Seq<KafkaServer>)this.servers(), topicProps);
        ProducerRecord record = new ProducerRecord(topicName, null, (Object)"key".getBytes(), (Object)"value".getBytes());
        try {
            this.kafka$api$ProducerFailureHandlingTest$$producer3().send(record).get();
            throw this.fail("Expected exception when producing to topic with fewer brokers than min.insync.replicas");
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof NotEnoughReplicasException) {
                return;
            }
            throw this.fail("Expected NotEnoughReplicasException when producing to topic with fewer brokers than min.insync.replicas");
        }
    }

    @Test
    public void testNotEnoughReplicasAfterBrokerShutdown() {
        String topicName = "minisrtest2";
        Properties topicProps = new Properties();
        topicProps.put("min.insync.replicas", ((Object)BoxesRunTime.boxToInteger((int)this.numServers())).toString());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topicName, 1, this.numServers(), (Seq<KafkaServer>)this.servers(), topicProps);
        ProducerRecord record = new ProducerRecord(topicName, null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.kafka$api$ProducerFailureHandlingTest$$producer3().send(record).get();
        ((KafkaServer)this.servers().head()).shutdown();
        ((KafkaServer)this.servers().head()).awaitShutdown();
        try {
            this.kafka$api$ProducerFailureHandlingTest$$producer3().send(record).get();
            throw this.fail("Expected exception when producing to topic with fewer brokers than min.insync.replicas");
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof NotEnoughReplicasException || executionException.getCause() instanceof NotEnoughReplicasAfterAppendException || executionException.getCause() instanceof TimeoutException) {
                ((KafkaServer)this.servers().head()).startup();
                return;
            }
            throw this.fail(new StringBuilder().append((Object)"Expected NotEnoughReplicasException or NotEnoughReplicasAfterAppendException when producing to topic with fewer brokers than min.insync.replicas, but saw ").append((Object)executionException.getCause()).toString());
        }
    }

    public ProducerFailureHandlingTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        KafkaServerTestHarness$class.$init$(this);
        this.kafka$api$ProducerFailureHandlingTest$$producerBufferSize = 30000;
        this.serverMessageMaxBytes = this.kafka$api$ProducerFailureHandlingTest$$producerBufferSize() / 2;
        this.numServers = 2;
        this.overridingProps = new Properties();
        this.overridingProps().put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)this.serverMessageMaxBytes())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)1)).toString());
        this.consumer1 = null;
        this.consumer2 = null;
        this.kafka$api$ProducerFailureHandlingTest$$producer1 = null;
        this.kafka$api$ProducerFailureHandlingTest$$producer2 = null;
        this.kafka$api$ProducerFailureHandlingTest$$producer3 = null;
        this.kafka$api$ProducerFailureHandlingTest$$producer4 = null;
        this.kafka$api$ProducerFailureHandlingTest$$topic1 = "topic-1";
        this.topic2 = "topic-2";
    }

    public class ProducerScheduler
    extends ShutdownableThread {
        private final int numRecords;
        private int sent;
        private boolean failed;
        private final KafkaProducer<byte[], byte[]> producer;

        public int numRecords() {
            return this.numRecords;
        }

        public int sent() {
            return this.sent;
        }

        public void sent_$eq(int x$1) {
            this.sent = x$1;
        }

        public boolean failed() {
            return this.failed;
        }

        public void failed_$eq(boolean x$1) {
            this.failed = x$1;
        }

        public KafkaProducer<byte[], byte[]> producer() {
            return this.producer;
        }

        public void doWork() {
            IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(this.sent() + 1), this.sent() + this.numRecords()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ProducerScheduler $outer;

                public final Future<RecordMetadata> apply(int i) {
                    return this.$outer.producer().send(new ProducerRecord(this.$outer.kafka$api$ProducerFailureHandlingTest$ProducerScheduler$$$outer().kafka$api$ProducerFailureHandlingTest$$topic1(), null, null, (Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes()), (Callback)new ErrorLoggingCallback(this.$outer.kafka$api$ProducerFailureHandlingTest$ProducerScheduler$$$outer().kafka$api$ProducerFailureHandlingTest$$topic1(), null, null, true));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            List futures = responses.toList();
            try {
                futures.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RecordMetadata apply(Future<RecordMetadata> x$2) {
                        return x$2.get();
                    }
                }, List$.MODULE$.canBuildFrom());
                this.sent_$eq(this.sent() + this.numRecords());
            }
            catch (Exception exception) {
                this.failed_$eq(true);
            }
        }

        public void shutdown() {
            super.shutdown();
            this.producer().close();
        }

        public /* synthetic */ ProducerFailureHandlingTest kafka$api$ProducerFailureHandlingTest$ProducerScheduler$$$outer() {
            return ProducerFailureHandlingTest.this;
        }

        public ProducerScheduler() {
            if (ProducerFailureHandlingTest.this == null) {
                throw new NullPointerException();
            }
            super("daemon-producer", false);
            this.numRecords = 1000;
            this.sent = 0;
            this.failed = false;
            String x$42 = ProducerFailureHandlingTest.this.brokerList();
            long x$43 = ProducerFailureHandlingTest.this.kafka$api$ProducerFailureHandlingTest$$producerBufferSize();
            int x$44 = 10;
            int x$45 = TestUtils$.MODULE$.createNewProducer$default$2();
            long x$46 = TestUtils$.MODULE$.createNewProducer$default$3();
            long x$47 = TestUtils$.MODULE$.createNewProducer$default$6();
            long x$48 = TestUtils$.MODULE$.createNewProducer$default$7();
            SecurityProtocol x$49 = TestUtils$.MODULE$.createNewProducer$default$8();
            Option<File> x$50 = TestUtils$.MODULE$.createNewProducer$default$9();
            Option<Properties> x$51 = TestUtils$.MODULE$.createNewProducer$default$10();
            ByteArraySerializer x$52 = TestUtils$.MODULE$.createNewProducer$default$11();
            ByteArraySerializer x$53 = TestUtils$.MODULE$.createNewProducer$default$12();
            Option<Properties> x$54 = TestUtils$.MODULE$.createNewProducer$default$13();
            this.producer = TestUtils$.MODULE$.createNewProducer(x$42, x$45, x$46, x$43, x$44, x$47, x$48, x$49, x$50, x$51, x$52, x$53, x$54);
        }
    }
}

