/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import kafka.common.KafkaException;
import kafka.common.LongRef;
import kafka.log.FileMessageSet;
import kafka.log.OffsetPosition;
import kafka.message.BaseMessageSetTestCases;
import kafka.message.BaseMessageSetTestCases$class;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.message.NoCompressionCodec$;
import kafka.utils.TestUtils$;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001m4A!\u0001\u0002\u0001\u000f\t\u0011b)\u001b7f\u001b\u0016\u001c8/Y4f'\u0016$H+Z:u\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0005\t\u0003\u0013Ai\u0011A\u0003\u0006\u0003\u00171\tQA[;oSRT!!\u0004\b\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\b\u0002\u0007=\u0014x-\u0003\u0002\u0012\u0015\tQ!*\u00168jiN+\u0018\u000e^3\u0011\u0005M1R\"\u0001\u000b\u000b\u0005U!\u0011aB7fgN\fw-Z\u0005\u0003/Q\u0011qCQ1tK6+7o]1hKN+G\u000fV3ti\u000e\u000b7/Z:\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001b\u0002\u0010\u0001\u0005\u0004%\taH\u0001\u000b[\u0016\u001c8/Y4f'\u0016$X#\u0001\u0011\u0011\u0005q\t\u0013B\u0001\u0012\u0003\u000591\u0015\u000e\\3NKN\u001c\u0018mZ3TKRDa\u0001\n\u0001!\u0002\u0013\u0001\u0013aC7fgN\fw-Z*fi\u0002BQA\n\u0001\u0005\u0002\u001d\n\u0001c\u0019:fCR,W*Z:tC\u001e,7+\u001a;\u0015\u0005\u0001B\u0003\"B\u0015&\u0001\u0004Q\u0013\u0001C7fgN\fw-Z:\u0011\u0007-*\u0004H\u0004\u0002-e9\u0011Q\u0006M\u0007\u0002])\u0011qFB\u0001\u0007yI|w\u000e\u001e \n\u0003E\nQa]2bY\u0006L!a\r\u001b\u0002\u000fA\f7m[1hK*\t\u0011'\u0003\u00027o\t\u00191+Z9\u000b\u0005M\"\u0004CA\n:\u0013\tQDCA\u0004NKN\u001c\u0018mZ3\t\u000bq\u0002A\u0011A\u001f\u0002\u0019Q,7\u000f\u001e$jY\u0016\u001c\u0016N_3\u0015\u0003y\u0002\"a\u0010!\u000e\u0003QJ!!\u0011\u001b\u0003\tUs\u0017\u000e\u001e\u0015\u0003w\r\u0003\"\u0001\u0012$\u000e\u0003\u0015S!a\u0003\b\n\u0005\u001d+%\u0001\u0002+fgRDQ!\u0013\u0001\u0005\u0002u\nQ\u0005^3ti&#XM]1uS>twJ^3s!\u0006\u0014H/[1m\u0003:$GK];oG\u0006$\u0018n\u001c8)\u0005!\u001b\u0005\"\u0002'\u0001\t\u0003i\u0015\u0001\u0005;fgR\u0004\u0016M\u001d;jC2<&/\u001b;f)\rqdj\u0015\u0005\u0006\u001f.\u0003\r\u0001U\u0001\u0005g&TX\r\u0005\u0002@#&\u0011!\u000b\u000e\u0002\u0004\u0013:$\b\"\u0002\u0010L\u0001\u0004\u0001\u0003\"B+\u0001\t\u0003i\u0014!\t;fgRLE/\u001a:bi&|g\u000eR8fg:$8\t[1oO\u0016\u0004vn]5uS>t\u0007F\u0001+D\u0011\u0015A\u0006\u0001\"\u0001>\u0003!!Xm\u001d;SK\u0006$\u0007FA,D\u0011\u0015Y\u0006\u0001\"\u0001>\u0003)!Xm\u001d;TK\u0006\u00148\r\u001b\u0015\u00035\u000eCQA\u0018\u0001\u0005\u0002u\na\u0003^3ti&#XM]1u_J<\u0016\u000e\u001e5MS6LGo\u001d\u0015\u0003;\u000eCQ!\u0019\u0001\u0005\u0002u\nA\u0002^3tiR\u0013XO\\2bi\u0016D#\u0001Y\"\t\u000b\u0011\u0004A\u0011A\u001f\u0002[Q,7\u000f\u001e+sk:\u001c\u0017\r^3O_R\u001c\u0015\r\u001c7fI&37+\u001b>f\u0013N\u001c\u0016-\\3BgR\u000b'oZ3u'&TX\r\u000b\u0002d\u0007\")q\r\u0001C\u0001{\u0005\tD/Z:u)J,hnY1uK:{GoQ1mY\u0016$\u0017JZ*ju\u0016L5OQ5hO\u0016\u0014H\u000b[1o)\u0006\u0014x-\u001a;TSj,\u0007F\u00014D\u0011\u0015Q\u0007\u0001\"\u0001>\u0003%\"Xm\u001d;UeVt7-\u0019;f\u0013\u001a\u001c\u0016N_3Jg\u0012KgMZ3sK:$Hk\u001c+be\u001e,GoU5{K\"\u0012\u0011n\u0011\u0005\u0006[\u0002!\t!P\u0001\u0014i\u0016\u001cH\u000f\u0015:fC2dwnY1uKR\u0013X/\u001a\u0015\u0003Y\u000eCQ\u0001\u001d\u0001\u0005\u0002u\nA\u0003^3tiB\u0013X-\u00197m_\u000e\fG/\u001a$bYN,\u0007FA8D\u0011\u0015\u0019\b\u0001\"\u0001>\u0003q!Xm\u001d;Qe\u0016\fG\u000e\\8dCR,7\t\\3beNCW\u000f\u001e3po:D#A]\"\t\u000bY\u0004A\u0011A\u001f\u0002MQ,7\u000f\u001e$pe6\fGoQ8om\u0016\u00148/[8o/&$\b\u000eU1si&\fG.T3tg\u0006<W\r\u000b\u0002v\u0007\")\u0011\u0010\u0001C\u0001{\u0005YB/Z:u\u001b\u0016\u001c8/Y4f\r>\u0014X.\u0019;D_:4XM]:j_:D#\u0001_\"")
public class FileMessageSetTest
extends JUnitSuite
implements BaseMessageSetTestCases {
    private final FileMessageSet messageSet;
    private final Message[] messages;

    @Override
    public Message[] messages() {
        return this.messages;
    }

    @Override
    public void kafka$message$BaseMessageSetTestCases$_setter_$messages_$eq(Message[] x$1) {
        this.messages = x$1;
    }

    @Override
    @Test
    public void testWrittenEqualsRead() {
        BaseMessageSetTestCases$class.testWrittenEqualsRead(this);
    }

    @Override
    @Test
    public void testIteratorIsConsistent() {
        BaseMessageSetTestCases$class.testIteratorIsConsistent(this);
    }

    @Override
    @Test
    public void testSizeInBytes() {
        BaseMessageSetTestCases$class.testSizeInBytes(this);
    }

    @Override
    @Test
    public void testWriteTo() {
        BaseMessageSetTestCases$class.testWriteTo(this);
    }

    @Override
    @Test
    public void testWriteToChannelThatConsumesPartially() {
        BaseMessageSetTestCases$class.testWriteToChannelThatConsumesPartially(this);
    }

    @Override
    public void checkWriteToWithMessageSet(MessageSet messageSet) {
        BaseMessageSetTestCases$class.checkWriteToWithMessageSet(this, messageSet);
    }

    @Override
    public void checkWriteWithMessageSet(MessageSet set, Function1<GatheringByteChannel, Object> write2) {
        BaseMessageSetTestCases$class.checkWriteWithMessageSet(this, set, write2);
    }

    public FileMessageSet messageSet() {
        return this.messageSet;
    }

    /*
     * WARNING - void declaration
     */
    public FileMessageSet createMessageSet(Seq<Message> messages2) {
        void var2_2;
        FileMessageSet set = new FileMessageSet(TestUtils$.MODULE$.tempFile());
        set.append(new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, messages2));
        set.flush();
        return var2_2;
    }

    @Test
    public void testFileSize() {
        Assert.assertEquals((long)this.messageSet().channel().size(), (long)this.messageSet().sizeInBytes());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileMessageSetTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.messageSet().append(TestUtils$.MODULE$.singleMessageSet("abcd".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4()));
                Assert.assertEquals((long)this.$outer.messageSet().channel().size(), (long)this.$outer.messageSet().sizeInBytes());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testIterationOverPartialAndTruncation() {
        this.testPartialWrite(0, this.messageSet());
        this.testPartialWrite(2, this.messageSet());
        this.testPartialWrite(4, this.messageSet());
        this.testPartialWrite(5, this.messageSet());
        this.testPartialWrite(6, this.messageSet());
    }

    public void testPartialWrite(int size2, FileMessageSet messageSet) {
        ByteBuffer buffer = ByteBuffer.allocate(size2);
        long originalPosition = messageSet.channel().position();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size2).foreach((Function1)new Serializable(this, buffer){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer buffer$1;

            public final ByteBuffer apply(int i) {
                return this.buffer$1.put((byte)0);
            }
            {
                this.buffer$1 = buffer$1;
            }
        });
        buffer.rewind();
        messageSet.channel().write(buffer);
        TestUtils$.MODULE$.checkEquals(Predef$.MODULE$.refArrayOps((Object[])this.messages()).iterator(), ((IterableLike)messageSet.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Message apply(MessageAndOffset m) {
                return m.message();
            }
        }, Iterable$.MODULE$.canBuildFrom())).iterator());
    }

    @Test
    public void testIterationDoesntChangePosition() {
        long position = this.messageSet().channel().position();
        TestUtils$.MODULE$.checkEquals(Predef$.MODULE$.refArrayOps((Object[])this.messages()).iterator(), ((IterableLike)this.messageSet().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Message apply(MessageAndOffset m) {
                return m.message();
            }
        }, Iterable$.MODULE$.canBuildFrom())).iterator());
        Assert.assertEquals((long)position, (long)this.messageSet().channel().position());
    }

    @Test
    public void testRead() {
        FileMessageSet read = this.messageSet().read(0, this.messageSet().sizeInBytes());
        TestUtils$.MODULE$.checkEquals(this.messageSet().iterator(), read.iterator());
        List items = read.iterator().toList();
        MessageAndOffset sec = (MessageAndOffset)((IterableLike)items.tail()).head();
        read = this.messageSet().read(MessageSet$.MODULE$.entrySize(sec.message()), this.messageSet().sizeInBytes());
        Assert.assertEquals((String)"Try a read starting from the second message", (Object)items.tail(), (Object)read.toList());
        read = this.messageSet().read(MessageSet$.MODULE$.entrySize(sec.message()), MessageSet$.MODULE$.entrySize(sec.message()));
        Assert.assertEquals((String)"Try a read of a single message starting from the second message", (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MessageAndOffset[]{(MessageAndOffset)((IterableLike)items.tail()).head()})), (Object)read.toList());
    }

    @Test
    public void testSearch() {
        Message lastMessage = new Message("test".getBytes());
        this.messageSet().append(new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, new LongRef(50L), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{lastMessage})));
        int position = 0;
        Assert.assertEquals((String)"Should be able to find the first message by its offset", (Object)new OffsetPosition(0L, position), (Object)this.messageSet().searchFor(0L, 0));
        Assert.assertEquals((String)"Should be able to find second message when starting from 0", (Object)new OffsetPosition(1L, position += MessageSet$.MODULE$.entrySize(((MessageAndOffset)this.messageSet().head()).message())), (Object)this.messageSet().searchFor(1L, 0));
        Assert.assertEquals((String)"Should be able to find second message starting from its offset", (Object)new OffsetPosition(1L, position), (Object)this.messageSet().searchFor(1L, position));
        Assert.assertEquals((String)"Should be able to find fourth message from a non-existant offset", (Object)new OffsetPosition(50L, position += MessageSet$.MODULE$.entrySize(((MessageAndOffset)((IterableLike)this.messageSet().tail()).head()).message()) + MessageSet$.MODULE$.entrySize(((MessageAndOffset)((IterableLike)((TraversableLike)this.messageSet().tail()).tail()).head()).message())), (Object)this.messageSet().searchFor(3L, position));
        Assert.assertEquals((String)"Should be able to find fourth message by correct offset", (Object)new OffsetPosition(50L, position), (Object)this.messageSet().searchFor(50L, position));
    }

    @Test
    public void testIteratorWithLimits() {
        MessageAndOffset message = (MessageAndOffset)this.messageSet().toList().apply(1);
        int start2 = this.messageSet().searchFor(1L, 0).position();
        int size2 = message.message().size() + 12;
        FileMessageSet slice = this.messageSet().read(start2, size2);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MessageAndOffset[]{message})), (Object)slice.toList());
        FileMessageSet slice2 = this.messageSet().read(start2, size2 - 1);
        Assert.assertEquals((Object)Nil$.MODULE$, (Object)slice2.toList());
    }

    @Test
    public void testTruncate() {
        MessageAndOffset message = (MessageAndOffset)this.messageSet().toList().apply(0);
        int end = this.messageSet().searchFor(1L, 0).position();
        this.messageSet().truncateTo(end);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MessageAndOffset[]{message})), (Object)this.messageSet().toList());
        Assert.assertEquals((long)MessageSet$.MODULE$.entrySize(message.message()), (long)this.messageSet().sizeInBytes());
    }

    @Test
    public void testTruncateNotCalledIfSizeIsSameAsTargetSize() {
        FileChannel channelMock = (FileChannel)EasyMock.createMock(FileChannel.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)channelMock.size())).andReturn((Object)BoxesRunTime.boxToLong((long)42L)).atLeastOnce();
        EasyMock.expect((Object)channelMock.position(42L)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{channelMock});
        FileMessageSet msgSet = new FileMessageSet(TestUtils$.MODULE$.tempFile(), channelMock);
        msgSet.truncateTo(42);
        EasyMock.verify((Object[])new Object[]{channelMock});
    }

    @Test
    public void testTruncateNotCalledIfSizeIsBiggerThanTargetSize() {
        FileChannel channelMock = (FileChannel)EasyMock.createMock(FileChannel.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)channelMock.size())).andReturn((Object)BoxesRunTime.boxToLong((long)42L)).atLeastOnce();
        EasyMock.expect((Object)channelMock.position(42L)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{channelMock});
        FileMessageSet msgSet = new FileMessageSet(TestUtils$.MODULE$.tempFile(), channelMock);
        try {
            msgSet.truncateTo(43);
            throw this.fail("Should throw KafkaException");
        }
        catch (KafkaException kafkaException) {
            EasyMock.verify((Object[])new Object[]{channelMock});
            return;
        }
    }

    @Test
    public void testTruncateIfSizeIsDifferentToTargetSize() {
        FileChannel channelMock = (FileChannel)EasyMock.createMock(FileChannel.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)channelMock.size())).andReturn((Object)BoxesRunTime.boxToLong((long)42L)).atLeastOnce();
        EasyMock.expect((Object)channelMock.position(42L)).andReturn(null).once();
        EasyMock.expect((Object)channelMock.truncate(23L)).andReturn(null).once();
        EasyMock.expect((Object)channelMock.position(23L)).andReturn(null).once();
        EasyMock.replay((Object[])new Object[]{channelMock});
        FileMessageSet msgSet = new FileMessageSet(TestUtils$.MODULE$.tempFile(), channelMock);
        msgSet.truncateTo(23);
        EasyMock.verify((Object[])new Object[]{channelMock});
    }

    @Test
    public void testPreallocateTrue() {
        File temp = TestUtils$.MODULE$.tempFile();
        FileMessageSet set = new FileMessageSet(temp, false, 0x20000000, true);
        long position = set.channel().position();
        int size2 = set.sizeInBytes();
        Assert.assertEquals((long)0L, (long)position);
        Assert.assertEquals((long)0L, (long)size2);
        Assert.assertEquals((long)0x20000000L, (long)temp.length());
    }

    @Test
    public void testPreallocateFalse() {
        File temp = TestUtils$.MODULE$.tempFile();
        FileMessageSet set = new FileMessageSet(temp, false, 0x20000000, false);
        long position = set.channel().position();
        int size2 = set.sizeInBytes();
        Assert.assertEquals((long)0L, (long)position);
        Assert.assertEquals((long)0L, (long)size2);
        Assert.assertEquals((long)0L, (long)temp.length());
    }

    @Test
    public void testPreallocateClearShutdown() {
        File temp = TestUtils$.MODULE$.tempFile();
        FileMessageSet set = new FileMessageSet(temp, false, 0x20000000, true);
        set.append(new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])this.messages())));
        long oldposition = set.channel().position();
        int oldsize = set.sizeInBytes();
        Assert.assertEquals((long)this.messageSet().sizeInBytes(), (long)oldposition);
        Assert.assertEquals((long)this.messageSet().sizeInBytes(), (long)oldsize);
        set.close();
        File tempReopen = new File(temp.getAbsolutePath());
        FileMessageSet setReopen = new FileMessageSet(tempReopen, true, 0x20000000, true);
        long position = setReopen.channel().position();
        int size2 = setReopen.sizeInBytes();
        Assert.assertEquals((long)oldposition, (long)position);
        Assert.assertEquals((long)oldposition, (long)size2);
        Assert.assertEquals((long)oldposition, (long)tempReopen.length());
    }

    @Test
    public void testFormatConversionWithPartialMessage() {
        MessageAndOffset message = (MessageAndOffset)this.messageSet().toList().apply(1);
        int start2 = this.messageSet().searchFor(1L, 0).position();
        int size2 = message.message().size() + 12;
        FileMessageSet slice = this.messageSet().read(start2, size2 - 1);
        MessageSet messageV0 = slice.toMessageFormat(Message$.MODULE$.MagicValue_V0());
        Assert.assertEquals((String)"No message should be there", (long)0L, (long)messageV0.size());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"There should be ", " bytes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(size2 - 1))})), (long)(size2 - 1), (long)messageV0.sizeInBytes());
    }

    @Test
    public void testMessageFormatConversion() {
        Seq offsets = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 2L}));
        Seq messagesV0 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes(), "k1".getBytes(), Message$.MODULE$.NoTimestamp(), Message$.MODULE$.MagicValue_V0()), new Message("goodbye".getBytes(), "k2".getBytes(), Message$.MODULE$.NoTimestamp(), Message$.MODULE$.MagicValue_V0())}));
        ByteBufferMessageSet messageSetV0 = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, offsets, messagesV0);
        ByteBufferMessageSet compressedMessageSetV0 = new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, offsets, messagesV0);
        Seq messagesV1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes(), "k1".getBytes(), 1L, Message$.MODULE$.MagicValue_V1()), new Message("goodbye".getBytes(), "k2".getBytes(), 2L, Message$.MODULE$.MagicValue_V1())}));
        ByteBufferMessageSet messageSetV1 = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, offsets, messagesV1);
        ByteBufferMessageSet compressedMessageSetV1 = new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, offsets, messagesV1);
        FileMessageSet fileMessageSet = new FileMessageSet(TestUtils$.MODULE$.tempFile());
        fileMessageSet.append(messageSetV1);
        fileMessageSet.flush();
        MessageSet convertedMessageSet = fileMessageSet.toMessageFormat(Message$.MODULE$.MagicValue_V0());
        this.verifyConvertedMessageSet$1(convertedMessageSet, Message$.MODULE$.MagicValue_V0(), offsets, messagesV0);
        fileMessageSet = new FileMessageSet(TestUtils$.MODULE$.tempFile());
        fileMessageSet.append(compressedMessageSetV1);
        fileMessageSet.flush();
        convertedMessageSet = fileMessageSet.toMessageFormat(Message$.MODULE$.MagicValue_V0());
        this.verifyConvertedMessageSet$1(convertedMessageSet, Message$.MODULE$.MagicValue_V0(), offsets, messagesV0);
        fileMessageSet = new FileMessageSet(TestUtils$.MODULE$.tempFile());
        fileMessageSet.append(messageSetV0);
        fileMessageSet.flush();
        convertedMessageSet = fileMessageSet.toMessageFormat(Message$.MODULE$.MagicValue_V1());
        this.verifyConvertedMessageSet$1(convertedMessageSet, Message$.MODULE$.MagicValue_V1(), offsets, messagesV0);
        fileMessageSet = new FileMessageSet(TestUtils$.MODULE$.tempFile());
        fileMessageSet.append(compressedMessageSetV0);
        fileMessageSet.flush();
        convertedMessageSet = fileMessageSet.toMessageFormat(Message$.MODULE$.MagicValue_V1());
        this.verifyConvertedMessageSet$1(convertedMessageSet, Message$.MODULE$.MagicValue_V1(), offsets, messagesV0);
    }

    private final void verifyConvertedMessageSet$1(MessageSet convertedMessageSet, byte magicByte, Seq offsets$1, Seq messagesV0$1) {
        IntRef i = new IntRef(0);
        convertedMessageSet.foreach((Function1)new Serializable(this, offsets$1, messagesV0$1, magicByte, i){
            public static final long serialVersionUID = 0L;
            private final Seq offsets$1;
            private final Seq messagesV0$1;
            private final byte magicByte$1;
            private final IntRef i$1;

            public final void apply(MessageAndOffset messageAndOffset) {
                Assert.assertEquals((String)"magic byte should be 1", (long)this.magicByte$1, (long)messageAndOffset.message().magic());
                Assert.assertEquals((String)"offset should not change", (long)BoxesRunTime.unboxToLong((Object)this.offsets$1.apply(this.i$1.elem)), (long)messageAndOffset.offset());
                Assert.assertEquals((String)"key should not change", (Object)((Message)this.messagesV0$1.apply(this.i$1.elem)).key(), (Object)messageAndOffset.message().key());
                Assert.assertEquals((String)"payload should not change", (Object)((Message)this.messagesV0$1.apply(this.i$1.elem)).payload(), (Object)messageAndOffset.message().payload());
                ++this.i$1.elem;
            }
            {
                this.offsets$1 = offsets$1;
                this.messagesV0$1 = messagesV0$1;
                this.magicByte$1 = magicByte$1;
                this.i$1 = i$1;
            }
        });
    }

    public FileMessageSetTest() {
        BaseMessageSetTestCases$class.$init$(this);
        this.messageSet = this.createMessageSet((Seq<Message>)Predef$.MODULE$.wrapRefArray((Object[])this.messages()));
    }
}

