/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.Collection;
import java.util.Properties;
import kafka.api.KAFKA_0_10_0_IV1$;
import kafka.api.KAFKA_0_9_0$;
import kafka.common.TopicAndPartition;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerIntegrationTest$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.message.ByteBufferMessageSet;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.CompressionCodec$;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.NoCompressionCodec$;
import kafka.server.OffsetCheckpoint;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\t%e\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0004T8h\u00072,\u0017M\\3s\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u0011=\u0001!\u0011!Q\u0001\nA\t\u0001cY8naJ,7o]5p]\u000e{G-Z2\u0011\u0005E!bBA\u0005\u0013\u0013\t\u0019\"\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003+Y\u0011aa\u0015;sS:<'BA\n\u000b\u0011\u0015A\u0002\u0001\"\u0001\u001a\u0003\u0019a\u0014N\\5u}Q\u0011!\u0004\b\t\u00037\u0001i\u0011A\u0001\u0005\u0006\u001f]\u0001\r\u0001\u0005\u0005\b=\u0001\u0011\r\u0011\"\u0001 \u0003\u0015\u0019w\u000eZ3d+\u0005\u0001\u0003CA\u0011%\u001b\u0005\u0011#BA\u0012\u0005\u0003\u001diWm]:bO\u0016L!!\n\u0012\u0003!\r{W\u000e\u001d:fgNLwN\\\"pI\u0016\u001c\u0007BB\u0014\u0001A\u0003%\u0001%\u0001\u0004d_\u0012,7\r\t\u0005\bS\u0001\u0011\r\u0011\"\u0001+\u0003\u0011!\u0018.\\3\u0016\u0003-\u0002\"\u0001L\u0018\u000e\u00035R!A\f\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005Aj#\u0001C'pG.$\u0016.\\3\t\rI\u0002\u0001\u0015!\u0003,\u0003\u0015!\u0018.\\3!\u0011\u001d!\u0004A1A\u0005\u0002U\n1b]3h[\u0016tGoU5{KV\ta\u0007\u0005\u0002\no%\u0011\u0001H\u0003\u0002\u0004\u0013:$\bB\u0002\u001e\u0001A\u0003%a'\u0001\u0007tK\u001elWM\u001c;TSj,\u0007\u0005C\u0004=\u0001\t\u0007I\u0011A\u001b\u0002\u0017\u0011,G.\u001a;f\t\u0016d\u0017-\u001f\u0005\u0007}\u0001\u0001\u000b\u0011\u0002\u001c\u0002\u0019\u0011,G.\u001a;f\t\u0016d\u0017-\u001f\u0011\t\u000f\u0001\u0003!\u0019!C\u0001\u0003\u00069An\\4OC6,W#\u0001\"\u0011\u0005\rCU\"\u0001#\u000b\u0005\u00153\u0015\u0001\u00027b]\u001eT\u0011aR\u0001\u0005U\u00064\u0018-\u0003\u0002\u0016\t\"1!\n\u0001Q\u0001\n\t\u000b\u0001\u0002\\8h\u001d\u0006lW\r\t\u0005\b\u0019\u0002\u0011\r\u0011\"\u0001N\u0003\u0019awn\u001a#jeV\ta\n\u0005\u0002P%6\t\u0001K\u0003\u0002R\r\u0006\u0011\u0011n\\\u0005\u0003'B\u0013AAR5mK\"1Q\u000b\u0001Q\u0001\n9\u000bq\u0001\\8h\t&\u0014\b\u0005C\u0004X\u0001\u0001\u0007I\u0011A\u001b\u0002\u000f\r|WO\u001c;fe\"9\u0011\f\u0001a\u0001\n\u0003Q\u0016aC2pk:$XM]0%KF$\"a\u00170\u0011\u0005%a\u0016BA/\u000b\u0005\u0011)f.\u001b;\t\u000f}C\u0016\u0011!a\u0001m\u0005\u0019\u0001\u0010J\u0019\t\r\u0005\u0004\u0001\u0015)\u00037\u0003!\u0019w.\u001e8uKJ\u0004\u0003\"C2\u0001\u0001\u0004\u0005\r\u0011\"\u0001e\u0003\u001d\u0019G.Z1oKJ,\u0012!\u001a\t\u00037\u0019L!a\u001a\u0002\u0003\u00151{wm\u00117fC:,'\u000fC\u0005j\u0001\u0001\u0007\t\u0019!C\u0001U\u0006Y1\r\\3b]\u0016\u0014x\fJ3r)\tY6\u000eC\u0004`Q\u0006\u0005\t\u0019A3\t\r5\u0004\u0001\u0015)\u0003f\u0003!\u0019G.Z1oKJ\u0004\u0003bB8\u0001\u0005\u0004%\t\u0001]\u0001\u0007i>\u0004\u0018nY:\u0016\u0003E\u00042!\u0003:u\u0013\t\u0019(BA\u0003BeJ\f\u0017\u0010\u0005\u0002vq6\taO\u0003\u0002x\t\u000511m\\7n_:L!!\u001f<\u0003#Q{\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004|\u0001\u0001\u0006I!]\u0001\bi>\u0004\u0018nY:!\u0011\u0015i\b\u0001\"\u0001\u007f\u0003-\u0019G.Z1oKJ$Vm\u001d;\u0015\u0003mC3\u0001`A\u0001!\u0011\t\u0019!!\u0004\u000e\u0005\u0005\u0015!\u0002BA\u0004\u0003\u0013\tQA[;oSRT!!a\u0003\u0002\u0007=\u0014x-\u0003\u0003\u0002\u0010\u0005\u0015!\u0001\u0002+fgRDq!a\u0005\u0001\t\u0013\t)\"A\u000ede\u0016\fG/\u001a'be\u001e,7+\u001b8hY\u0016lUm]:bO\u0016\u001cV\r\u001e\u000b\u0007\u0003/\t\u0019#a\n\u0011\r%\tI\u0002EA\u000f\u0013\r\tYB\u0003\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007\u0005\ny\"C\u0002\u0002\"\t\u0012ACQ=uK\n+hMZ3s\u001b\u0016\u001c8/Y4f'\u0016$\bbBA\u0013\u0003#\u0001\rAN\u0001\u0004W\u0016L\b\u0002CA\u0015\u0003#\u0001\r!a\u000b\u0002)5,7o]1hK\u001a{'/\\1u-\u0016\u00148/[8o!\rI\u0011QF\u0005\u0004\u0003_Q!\u0001\u0002\"zi\u0016Da!a\r\u0001\t\u0003q\u0018A\b;fgR\u001cE.Z1oKJ<\u0016\u000e\u001e5NKN\u001c\u0018mZ3G_Jl\u0017\r\u001e,1Q\u0011\t\t$!\u0001\t\u000f\u0005e\u0002\u0001\"\u0003\u0002<\u0005\u00012\r[3dW2\u000b7\u000f^\"mK\u0006tW\r\u001a\u000b\b7\u0006u\u0012\u0011IA#\u0011\u001d\ty$a\u000eA\u0002A\tQ\u0001^8qS\u000eDq!a\u0011\u00028\u0001\u0007a'A\u0006qCJ$\u0018\u000e^5p]&#\u0007\u0002CA$\u0003o\u0001\r!!\u0013\u0002\u0015\u0019L'o\u001d;ESJ$\u0018\u0010E\u0002\n\u0003\u0017J1!!\u0014\u000b\u0005\u0011auN\\4\t\u000f\u0005E\u0003\u0001\"\u0003\u0002T\u0005Q2\r[3dW2{w-\u00114uKJ\f\u0005\u000f]3oI&tw\rR;qgR91,!\u0016\u0002^\u0005\u0005\u0004bB\u0002\u0002P\u0001\u0007\u0011q\u000b\t\u00047\u0005e\u0013bAA.\u0005\t\u0019Aj\\4\t\u0011\u0005}\u0013q\na\u0001\u0003\u0013\n\u0011b\u001d;beR\u001c\u0016N_3\t\u0011\u0005\r\u0014q\na\u0001\u0003K\nq!\u00199qK:$7\u000f\u0005\u0004\u0002h\u00055\u0014\u0011O\u0007\u0003\u0003SR1!a\u001b\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003_\nIGA\u0002TKF\u0004R!CA\rmAAq!!\u001e\u0001\t\u0013\t9(A\u0006sK\u0006$gI]8n\u0019><G\u0003BA=\u0003\u007f\u0002b!a\u001a\u0002|\u0005E\u0014\u0002BA?\u0003S\u0012\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0005\b\u0007\u0005M\u0004\u0019AA,\u0011\u001d\t\u0019\t\u0001C\u0005\u0003\u000b\u000b\u0011b\u001e:ji\u0016$U\u000f]:\u0015\u001d\u0005\u0015\u0014qQAF\u0003\u001f\u000b\t*a%\u0002\u0018\"9\u0011\u0011RAA\u0001\u00041\u0014a\u00028v[.+\u0017p\u001d\u0005\b\u0003\u001b\u000b\t\t1\u00017\u0003\u001dqW/\u001c#vaNDqaAAA\u0001\u0004\t9\u0006\u0003\u0004\u001f\u0003\u0003\u0003\r\u0001\t\u0005\n\u0003+\u000b\t\t%AA\u0002Y\n\u0001b\u001d;beR\\U-\u001f\u0005\u000b\u00033\u000b\t\t%AA\u0002\u0005-\u0012AC7bO&\u001cg+\u00197vK\"1\u0011Q\u0014\u0001\u0005\u0002y\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0005\u00037\u000b\t\u000b\u0005\u0003\u0002\u0004\u0005\r\u0016\u0002BAS\u0003\u000b\u0011Q!\u00114uKJDq!!+\u0001\t\u0013\tY+A\nm_\u001e\u001cuN\u001c4jOB\u0013x\u000e]3si&,7\u000f\u0006\u0004\u0002.\u0006e\u0016Q\u0018\t\u0005\u0003_\u000b),\u0004\u0002\u00022*\u0019\u00111\u0017$\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003o\u000b\tL\u0001\u0006Qe>\u0004XM\u001d;jKNDq!a/\u0002(\u0002\u0007a'\u0001\bnCblUm]:bO\u0016\u001c\u0016N_3\t\u0015\u0005}\u0016q\u0015I\u0001\u0002\u0004\t\t-\u0001\fnS:\u001cE.Z1oC\ndW\rR5sif\u0014\u0016\r^5p!\rI\u00111Y\u0005\u0004\u0003\u000bT!!\u0002$m_\u0006$\bbBAe\u0001\u0011%\u00111Z\u0001\f[\u0006\\Wm\u00117fC:,'\u000fF\u0007f\u0003\u001b\f\t.a5\u0002X\u0006e\u0017Q\u001c\u0005\b\u0003\u001f\f9\r1\u00017\u0003\u0015\u0001\u0018M\u001d;t\u0011)\ty,a2\u0011\u0002\u0003\u0007\u0011\u0011\u0019\u0005\n\u0003+\f9\r%AA\u0002Y\n!B\\;n)\"\u0014X-\u00193t\u0011%\tY,a2\u0011\u0002\u0003\u0007a\u0007C\u0005\u0002\\\u0006\u001d\u0007\u0013!a\u0001!\u0005iA-\u001a4bk2$\bk\u001c7jGfD!\"a8\u0002HB\u0005\t\u0019AAq\u0003=\u0001x\u000e\\5ds>3XM\u001d:jI\u0016\u001c\bCBA4\u0003G\u0004\u0002#\u0003\u0003\u0002f\u0006%$aA'ba\"I\u0011\u0011\u001e\u0001\u0012\u0002\u0013%\u00111^\u0001\u0016[\u0006\\Wm\u00117fC:,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tiO\u000b\u0003\u0002B\u0006=8FAAy!\u0011\t\u00190!@\u000e\u0005\u0005U(\u0002BA|\u0003s\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005m(\"\u0001\u0006b]:|G/\u0019;j_:LA!a@\u0002v\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\t\r\u0001!%A\u0005\n\t\u0015\u0011!F7bW\u0016\u001cE.Z1oKJ$C-\u001a4bk2$HeM\u000b\u0003\u0005\u000fQ3ANAx\u0011%\u0011Y\u0001AI\u0001\n\u0013\u0011)!A\u000bnC.,7\t\\3b]\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\t\u0013\t=\u0001!%A\u0005\n\tE\u0011!F7bW\u0016\u001cE.Z1oKJ$C-\u001a4bk2$H%N\u000b\u0003\u0005'Q3\u0001EAx\u0011%\u00119\u0002AI\u0001\n\u0013\u0011I\"A\u000bnC.,7\t\\3b]\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\tm!\u0006BAq\u0003_D\u0011Ba\b\u0001#\u0003%IA!\u0002\u0002']\u0014\u0018\u000e^3EkB\u001cH\u0005Z3gCVdG\u000fJ\u001b\t\u0013\t\r\u0002!%A\u0005\n\t\u0015\u0012aE<sSR,G)\u001e9tI\u0011,g-Y;mi\u00122TC\u0001B\u0014U\u0011\tY#a<\t\u0013\t-\u0002!%A\u0005\n\u0005-\u0018!\b7pO\u000e{gNZ5h!J|\u0007/\u001a:uS\u0016\u001cH\u0005Z3gCVdG\u000f\n\u001a)\u000f\u0001\u0011yCa\u000f\u0003>A!!\u0011\u0007B\u001c\u001b\t\u0011\u0019D\u0003\u0003\u00036\u0005\u0015\u0011A\u0002:v]:,'/\u0003\u0003\u0003:\tM\"a\u0002*v]^KG\u000f[\u0001\u0006m\u0006dW/Z\u0012\u0003\u0005\u007f\u0001BA!\u0011\u0003H5\u0011!1\t\u0006\u0005\u0005\u000b\n)!A\u0004sk:tWM]:\n\t\t%#1\t\u0002\u000e!\u0006\u0014\u0018-\\3uKJL'0\u001a3\b\u000f\t5#\u0001#\u0001\u0003P\u0005IBj\\4DY\u0016\fg.\u001a:J]R,wM]1uS>tG+Z:u!\rY\"\u0011\u000b\u0004\u0007\u0003\tA\tAa\u0015\u0014\u0007\tE\u0003\u0002C\u0004\u0019\u0005#\"\tAa\u0016\u0015\u0005\t=\u0003\u0002\u0003B.\u0005#\"\tA!\u0018\u0002\u0015A\f'/Y7fi\u0016\u00148/\u0006\u0002\u0003`A1\u0011q\u0016B1\u0005KJAAa\u0019\u00022\nQ1i\u001c7mK\u000e$\u0018n\u001c8\u0011\u0007%\u0011\b\u0003\u000b\u0003\u0003Z\t%\u0004\u0003\u0002B6\u0005\u0007sAA!\u001c\u0003\u00009!!q\u000eB?\u001d\u0011\u0011\tHa\u001f\u000f\t\tM$\u0011P\u0007\u0003\u0005kR1Aa\u001e\u0007\u0003\u0019a$o\\8u}%\u0011\u00111B\u0005\u0005\u0003\u000f\tI!\u0003\u0003\u0003F\u0005\u0015\u0011\u0002\u0002BA\u0005\u0007\nQ\u0002U1sC6,G/\u001a:ju\u0016$\u0017\u0002\u0002BC\u0005\u000f\u0013!\u0002U1sC6,G/\u001a:t\u0015\u0011\u0011\tIa\u0011")
public class LogCleanerIntegrationTest {
    private final CompressionCodec codec;
    private final MockTime time;
    private final int segmentSize;
    private final int deleteDelay;
    private final String logName;
    private final File logDir;
    private int counter;
    private LogCleaner cleaner;
    private final TopicAndPartition[] topics;

    @Parameterized.Parameters
    public static Collection<String[]> parameters() {
        return LogCleanerIntegrationTest$.MODULE$.parameters();
    }

    public CompressionCodec codec() {
        return this.codec;
    }

    public MockTime time() {
        return this.time;
    }

    public int segmentSize() {
        return this.segmentSize;
    }

    public int deleteDelay() {
        return this.deleteDelay;
    }

    public String logName() {
        return this.logName;
    }

    public File logDir() {
        return this.logDir;
    }

    public int counter() {
        return this.counter;
    }

    public void counter_$eq(int x$1) {
        this.counter = x$1;
    }

    public LogCleaner cleaner() {
        return this.cleaner;
    }

    public void cleaner_$eq(LogCleaner x$1) {
        this.cleaner = x$1;
    }

    public TopicAndPartition[] topics() {
        return this.topics;
    }

    @Test
    public void cleanerTest() {
        int largeMessageKey = 20;
        Tuple2<String, ByteBufferMessageSet> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, Message$.MODULE$.MagicValue_V1());
        if (tuple2 != null) {
            Tuple2 tuple22;
            String largeMessageValue = (String)tuple2._1();
            ByteBufferMessageSet largeMessageSet = (ByteBufferMessageSet)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)largeMessageValue, (Object)largeMessageSet);
            String largeMessageValue2 = (String)tuple23._1();
            ByteBufferMessageSet largeMessageSet2 = (ByteBufferMessageSet)tuple23._2();
            int maxMessageSize = largeMessageSet2.sizeInBytes();
            int x$5 = 3;
            int x$6 = maxMessageSize;
            float x$7 = this.makeCleaner$default$2();
            int x$8 = this.makeCleaner$default$3();
            String x$9 = this.makeCleaner$default$5();
            Map<String, String> x$10 = this.makeCleaner$default$6();
            this.cleaner_$eq(this.makeCleaner(x$5, x$7, x$8, x$6, x$9, x$10));
            Log log = (Log)this.cleaner().logs().get((Object)this.topics()[0]);
            Seq<Tuple2<Object, String>> appends = this.writeDups(100, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
            long startSize = log.size();
            this.cleaner().startup();
            long firstDirty = log.activeSegment().baseOffset();
            this.checkLastCleaned("log", 0, firstDirty);
            long compactedSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)log.logSegments().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply(LogSegment x$2) {
                    return x$2.size();
                }
            }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToLong((long)compactedSize)})), (startSize > compactedSize ? 1 : 0) != 0);
            this.checkLogAfterAppendingDups(log, startSize, appends);
            log.append(largeMessageSet2, true);
            int x$11 = largeMessageKey + 1;
            int x$12 = 100;
            int x$13 = 3;
            Log x$14 = log;
            CompressionCodec x$15 = this.codec();
            byte x$16 = this.writeDups$default$6();
            Seq<Tuple2<Object, String>> dups = this.writeDups(x$12, x$13, x$14, x$15, x$11, x$16);
            Seq appends2 = (Seq)((TraversableLike)appends.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)largeMessageKey)), (Object)largeMessageValue2)})), Seq$.MODULE$.canBuildFrom())).$plus$plus(dups, Seq$.MODULE$.canBuildFrom());
            long firstDirty2 = log.activeSegment().baseOffset();
            this.checkLastCleaned("log", 0, firstDirty2);
            this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple2<Object, String>>)appends2);
            this.cleaner().logs().remove((Object)this.topics()[0]);
            this.cleaner().updateCheckpoints(this.logDir());
            Map checkpoints = new OffsetCheckpoint(new File(this.logDir(), this.cleaner().cleanerManager().offsetCheckpointFile())).read();
            Assert.assertFalse((boolean)checkpoints.contains((Object)this.topics()[0]));
            return;
        }
        throw new MatchError(tuple2);
    }

    private Tuple2<String, ByteBufferMessageSet> createLargeSingleMessageSet(int key, byte messageFormatVersion) {
        String value = this.messageValue$1(128);
        ByteBufferMessageSet messageSet = TestUtils$.MODULE$.singleMessageSet(value.getBytes(), this.codec(), ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), messageFormatVersion);
        return new Tuple2((Object)value, (Object)messageSet);
    }

    @Test
    public void testCleanerWithMessageFormatV0() {
        int largeMessageKey = 20;
        Tuple2<String, ByteBufferMessageSet> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, Message$.MODULE$.MagicValue_V0());
        if (tuple2 != null) {
            Tuple2 tuple22;
            String largeMessageValue = (String)tuple2._1();
            ByteBufferMessageSet largeMessageSet = (ByteBufferMessageSet)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)largeMessageValue, (Object)largeMessageSet);
            String largeMessageValue2 = (String)tuple23._1();
            ByteBufferMessageSet largeMessageSet2 = (ByteBufferMessageSet)tuple23._2();
            CompressionCodec compressionCodec = this.codec();
            NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
            CompressionCodec compressionCodec2 = compressionCodec;
            int n = !(noCompressionCodec$ != null ? !noCompressionCodec$.equals(compressionCodec2) : compressionCodec2 != null) ? largeMessageSet2.sizeInBytes() : largeMessageSet2.sizeInBytes() + 5;
            int maxMessageSize = n;
            int x$17 = 3;
            int x$18 = maxMessageSize;
            float x$19 = this.makeCleaner$default$2();
            int x$20 = this.makeCleaner$default$3();
            String x$21 = this.makeCleaner$default$5();
            Map<String, String> x$22 = this.makeCleaner$default$6();
            this.cleaner_$eq(this.makeCleaner(x$17, x$19, x$20, x$18, x$21, x$22));
            Log log = (Log)this.cleaner().logs().get((Object)this.topics()[0]);
            Properties props = this.kafka$log$LogCleanerIntegrationTest$$logConfigProperties(maxMessageSize, this.logConfigProperties$default$2());
            props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_9_0$.MODULE$.version());
            log.config_$eq(new LogConfig((java.util.Map)props));
            int x$23 = 100;
            int x$24 = 3;
            Log x$25 = log;
            CompressionCodec x$26 = this.codec();
            byte x$27 = Message$.MODULE$.MagicValue_V0();
            int x$28 = this.writeDups$default$5();
            Seq<Tuple2<Object, String>> appends = this.writeDups(x$23, x$24, x$25, x$26, x$28, x$27);
            long startSize = log.size();
            this.cleaner().startup();
            long firstDirty = log.activeSegment().baseOffset();
            this.checkLastCleaned("log", 0, firstDirty);
            long compactedSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)log.logSegments().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply(LogSegment x$4) {
                    return x$4.size();
                }
            }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToLong((long)compactedSize)})), (startSize > compactedSize ? 1 : 0) != 0);
            this.checkLogAfterAppendingDups(log, startSize, appends);
            int x$29 = 40;
            int x$30 = 3;
            Log x$31 = log;
            CompressionCodec x$32 = this.codec();
            byte x$33 = Message$.MODULE$.MagicValue_V0();
            int x$34 = this.writeDups$default$5();
            Seq<Tuple2<Object, String>> dupsV0 = this.writeDups(x$29, x$30, x$31, x$32, x$34, x$33);
            log.append(largeMessageSet2, true);
            props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_10_0_IV1$.MODULE$.version());
            log.config_$eq(new LogConfig((java.util.Map)props));
            int x$35 = 30;
            int x$36 = 40;
            int x$37 = 3;
            Log x$38 = log;
            CompressionCodec x$39 = this.codec();
            byte x$40 = Message$.MODULE$.MagicValue_V1();
            Seq<Tuple2<Object, String>> dupsV1 = this.writeDups(x$36, x$37, x$38, x$39, x$35, x$40);
            Seq appends2 = (Seq)((TraversableLike)((TraversableLike)appends.$plus$plus(dupsV0, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)largeMessageKey)), (Object)largeMessageValue2)})), Seq$.MODULE$.canBuildFrom())).$plus$plus(dupsV1, Seq$.MODULE$.canBuildFrom());
            long firstDirty2 = log.activeSegment().baseOffset();
            this.checkLastCleaned("log", 0, firstDirty2);
            this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple2<Object, String>>)appends2);
            return;
        }
        throw new MatchError(tuple2);
    }

    private void checkLastCleaned(String topic, int partitionId, long firstDirty) {
        LogCleaner qual$1 = this.cleaner();
        String x$41 = topic;
        int x$42 = partitionId;
        long x$43 = firstDirty;
        long x$44 = qual$1.awaitCleaned$default$4();
        qual$1.awaitCleaned(x$41, x$42, x$43, x$44);
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().get((Object)new TopicAndPartition(topic, partitionId)).get());
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log cleaner should have processed up to offset ", ", but lastCleaned=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)firstDirty), BoxesRunTime.boxToLong((long)lastCleaned)})), (lastCleaned >= firstDirty ? 1 : 0) != 0);
    }

    private void checkLogAfterAppendingDups(Log log, long startSize, Seq<Tuple2<Object, String>> appends) {
        Iterable<Tuple2<Object, String>> read = this.readFromLog(log);
        Assert.assertEquals((String)"Contents of the map shouldn't change", (Object)appends.toMap(Predef$.MODULE$.conforms()), (Object)read.toMap(Predef$.MODULE$.conforms()));
        Assert.assertTrue((startSize > log.size() ? 1 : 0) != 0);
    }

    private Iterable<Tuple2<Object, String>> readFromLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerIntegrationTest $outer;

            public final Iterable<Tuple2<Object, String>> apply(LogSegment segment) {
                return (Iterable)segment.log().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$readFromLog$1 $outer;

                    public final Iterator<Tuple2<Object, String>> apply(MessageAndOffset entry) {
                        return this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().kafka$log$LogCleanerIntegrationTest$$messageIterator$1(entry).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<Object, String> apply(MessageAndOffset messageAndOffset) {
                                int key = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(messageAndOffset.message().key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
                                String value = TestUtils$.MODULE$.readString(messageAndOffset.message().payload(), TestUtils$.MODULE$.readString$default$2());
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)value);
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ LogCleanerIntegrationTest kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple2<Object, String>> writeDups(int numKeys, int numDups, Log log, CompressionCodec codec, int startKey, byte magicValue) {
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1)new Serializable(this, numKeys, log, codec, startKey, magicValue){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerIntegrationTest $outer;
            private final int numKeys$1;
            public final Log log$1;
            public final CompressionCodec codec$1;
            private final int startKey$1;
            public final byte magicValue$1;

            public final IndexedSeq<Tuple2<Object, String>> apply(int _) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.startKey$1), this.startKey$1 + this.numKeys$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$writeDups$1 $outer;

                    public final Tuple2<Object, String> apply(int key) {
                        String payload = ((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter())).toString();
                        this.$outer.log$1.append(TestUtils$.MODULE$.singleMessageSet(payload.toString().getBytes(), this.$outer.codec$1, ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), this.$outer.magicValue$1), true);
                        this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter_$eq(this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter() + 1);
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)key), (Object)payload);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ LogCleanerIntegrationTest kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.numKeys$1 = numKeys$1;
                this.log$1 = log$1;
                this.codec$1 = codec$1;
                this.startKey$1 = startKey$1;
                this.magicValue$1 = magicValue$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    private int writeDups$default$5() {
        return 0;
    }

    private byte writeDups$default$6() {
        return Message$.MODULE$.CurrentMagicValue();
    }

    @After
    public void tearDown() {
        this.cleaner().shutdown();
        this.time().scheduler().shutdown();
        Utils.delete((File)this.logDir());
    }

    /*
     * WARNING - void declaration
     */
    public Properties kafka$log$LogCleanerIntegrationTest$$logConfigProperties(int maxMessageSize, float minCleanableDirtyRatio) {
        void var3_3;
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(maxMessageSize));
        props.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(this.segmentSize()));
        props.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(102400));
        props.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.int2Integer(this.deleteDelay()));
        props.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        props.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.float2Float(minCleanableDirtyRatio));
        return var3_3;
    }

    private float logConfigProperties$default$2() {
        return 0.0f;
    }

    private LogCleaner makeCleaner(int parts, float minCleanableDirtyRatio, int numThreads, int maxMessageSize, String defaultPolicy, Map<String, String> policyOverrides) {
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), parts).foreach((Function1)new Serializable(this, minCleanableDirtyRatio, maxMessageSize, logs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerIntegrationTest $outer;
            private final float minCleanableDirtyRatio$1;
            private final int maxMessageSize$1;
            private final Pool logs$1;

            public final Log apply(int i) {
                File dir = new File(this.$outer.logDir(), new StringBuilder().append((Object)"log-").append((Object)BoxesRunTime.boxToInteger((int)i)).toString());
                dir.mkdirs();
                Log log = new Log(dir, new LogConfig((java.util.Map)this.$outer.kafka$log$LogCleanerIntegrationTest$$logConfigProperties(this.maxMessageSize$1, this.minCleanableDirtyRatio$1)), 0L, (Scheduler)this.$outer.time().scheduler(), (Time)this.$outer.time());
                return (Log)this.logs$1.put((Object)new TopicAndPartition("log", i), (Object)log);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.minCleanableDirtyRatio$1 = minCleanableDirtyRatio$1;
                this.maxMessageSize$1 = maxMessageSize$1;
                this.logs$1 = logs$1;
            }
        });
        int x$45 = numThreads;
        int x$46 = maxMessageSize / 2;
        int x$47 = maxMessageSize;
        long x$48 = CleanerConfig$.MODULE$.apply$default$2();
        double x$49 = CleanerConfig$.MODULE$.apply$default$3();
        double x$50 = CleanerConfig$.MODULE$.apply$default$6();
        long x$51 = CleanerConfig$.MODULE$.apply$default$7();
        boolean x$52 = CleanerConfig$.MODULE$.apply$default$8();
        String x$53 = CleanerConfig$.MODULE$.apply$default$9();
        return new LogCleaner(new CleanerConfig(x$45, x$48, x$49, x$46, x$47, x$50, x$51, x$52, x$53), (File[])((Object[])new File[]{this.logDir()}), logs, (Time)this.time());
    }

    private float makeCleaner$default$2() {
        return 0.0f;
    }

    private int makeCleaner$default$3() {
        return 1;
    }

    private int makeCleaner$default$4() {
        return 128;
    }

    private String makeCleaner$default$5() {
        return "compact";
    }

    private Map<String, String> makeCleaner$default$6() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    private final String messageValue$1(int length) {
        Random random = new Random(0);
        return new String((char[])random.alphanumeric().take(length).toArray(ClassTag$.MODULE$.Char()));
    }

    public final Iterator kafka$log$LogCleanerIntegrationTest$$messageIterator$1(MessageAndOffset entry) {
        CompressionCodec compressionCodec = entry.message().compressionCodec();
        NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
        return !(compressionCodec != null ? !compressionCodec.equals(noCompressionCodec$) : noCompressionCodec$ != null) ? Iterator$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MessageAndOffset[]{entry})) : ByteBufferMessageSet$.MODULE$.deepIterator(entry);
    }

    public LogCleanerIntegrationTest(String compressionCodec) {
        this.codec = CompressionCodec$.MODULE$.getCompressionCodec(compressionCodec);
        this.time = new MockTime();
        this.segmentSize = 256;
        this.deleteDelay = 1000;
        this.logName = "log";
        this.logDir = TestUtils$.MODULE$.tempDir();
        this.counter = 0;
        this.topics = (TopicAndPartition[])((Object[])new TopicAndPartition[]{new TopicAndPartition("log", 0), new TopicAndPartition("log", 1), new TopicAndPartition("log", 2)});
    }
}

