/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.auth;

import java.net.InetAddress;
import java.util.Properties;
import java.util.UUID;
import kafka.network.RequestChannel;
import kafka.security.auth.Acl;
import kafka.security.auth.Acl$;
import kafka.security.auth.All$;
import kafka.security.auth.Allow$;
import kafka.security.auth.Alter$;
import kafka.security.auth.Authorizer;
import kafka.security.auth.Cluster$;
import kafka.security.auth.Deny$;
import kafka.security.auth.Describe$;
import kafka.security.auth.Group$;
import kafka.security.auth.Operation;
import kafka.security.auth.PermissionType;
import kafka.security.auth.Read$;
import kafka.security.auth.Resource;
import kafka.security.auth.Resource$;
import kafka.security.auth.ResourceType;
import kafka.security.auth.SimpleAclAuthorizer;
import kafka.security.auth.SimpleAclAuthorizer$;
import kafka.security.auth.SimpleAclAuthorizerTest$;
import kafka.security.auth.Topic$;
import kafka.security.auth.Write$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Eg\u0001B\u0001\u0003\u0001%\u0011qcU5na2,\u0017i\u00197BkRDwN]5{KJ$Vm\u001d;\u000b\u0005\r!\u0011\u0001B1vi\"T!!\u0002\u0004\u0002\u0011M,7-\u001e:jifT\u0011aB\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001!\u0002\u0006\t\u0003\u0017Ii\u0011\u0001\u0004\u0006\u0003\u001b9\tQA[;oSRT!a\u0004\t\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\t\u0002\u0007=\u0014x-\u0003\u0002\u0014\u0019\tQ!*\u00168jiN+\u0018\u000e^3\u0011\u0005UAR\"\u0001\f\u000b\u0005]1\u0011A\u0001>l\u0013\tIbC\u0001\u000b[_>\\U-\u001a9feR+7\u000f\u001e%be:,7o\u001d\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u0003\tAq\u0001\t\u0001C\u0002\u0013\u0005\u0011%A\ntS6\u0004H.Z!dY\u0006+H\u000f[8sSj,'/F\u0001#!\tq2%\u0003\u0002%\u0005\t\u00192+[7qY\u0016\f5\r\\!vi\"|'/\u001b>fe\"1a\u0005\u0001Q\u0001\n\t\nAc]5na2,\u0017i\u00197BkRDwN]5{KJ\u0004\u0003b\u0002\u0015\u0001\u0005\u0004%\t!I\u0001\u0015g&l\u0007\u000f\\3BG2\fU\u000f\u001e5pe&TXM\u001d\u001a\t\r)\u0002\u0001\u0015!\u0003#\u0003U\u0019\u0018.\u001c9mK\u0006\u001bG.Q;uQ>\u0014\u0018N_3se\u0001Bq\u0001\f\u0001C\u0002\u0013\u0005Q&A\u0007uKN$\bK]5oG&\u0004\u0018\r\\\u000b\u0002]A\u0011qfN\u0007\u0002a)\u00111!\r\u0006\u0003\u000bIR!a\r\u001b\u0002\r\r|W.\\8o\u0015\t9QG\u0003\u00027!\u00051\u0011\r]1dQ\u0016L!\u0001\u000f\u0019\u0003\u001d-\u000bgm[1Qe&t7-\u001b9bY\"1!\b\u0001Q\u0001\n9\na\u0002^3tiB\u0013\u0018N\\2ja\u0006d\u0007\u0005C\u0004=\u0001\t\u0007I\u0011A\u001f\u0002\u0019Q,7\u000f\u001e%pgRt\u0015-\\3\u0016\u0003y\u0002\"a\u0010#\u000e\u0003\u0001S!!\u0011\"\u0002\u00079,GOC\u0001D\u0003\u0011Q\u0017M^1\n\u0005\u0015\u0003%aC%oKR\fE\r\u001a:fgNDaa\u0012\u0001!\u0002\u0013q\u0014!\u0004;fgRDun\u001d;OC6,\u0007\u0005C\u0004J\u0001\t\u0007I\u0011\u0001&\u0002\u000fM,7o]5p]V\t1\n\u0005\u0002M1:\u0011Q*\u0016\b\u0003\u001dNs!a\u0014*\u000e\u0003AS!!\u0015\u0005\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0011B\u0001+\u0007\u0003\u001dqW\r^<pe.L!AV,\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY*\u0011AKB\u0005\u00033j\u0013qaU3tg&|gN\u0003\u0002W/\"1A\f\u0001Q\u0001\n-\u000b\u0001b]3tg&|g\u000e\t\u0005\b=\u0002\u0001\r\u0011\"\u0001`\u0003!\u0011Xm]8ve\u000e,W#\u00011\u0011\u0005y\t\u0017B\u00012\u0003\u0005!\u0011Vm]8ve\u000e,\u0007b\u00023\u0001\u0001\u0004%\t!Z\u0001\re\u0016\u001cx.\u001e:dK~#S-\u001d\u000b\u0003M2\u0004\"a\u001a6\u000e\u0003!T\u0011![\u0001\u0006g\u000e\fG.Y\u0005\u0003W\"\u0014A!\u00168ji\"9QnYA\u0001\u0002\u0004\u0001\u0017a\u0001=%c!1q\u000e\u0001Q!\n\u0001\f\u0011B]3t_V\u00148-\u001a\u0011\t\u000fE\u0004!\u0019!C\u0001e\u0006Q1/\u001e9feV\u001bXM]:\u0016\u0003M\u0004\"\u0001^<\u000e\u0003UT!A\u001e\"\u0002\t1\fgnZ\u0005\u0003qV\u0014aa\u0015;sS:<\u0007B\u0002>\u0001A\u0003%1/A\u0006tkB,'/V:feN\u0004\u0003b\u0002?\u0001\u0005\u0004%\tA]\u0001\tkN,'O\\1nK\"1a\u0010\u0001Q\u0001\nM\f\u0011\"^:fe:\fW.\u001a\u0011\t\u0013\u0005\u0005\u0001\u00011A\u0005\u0002\u0005\r\u0011AB2p]\u001aLw-\u0006\u0002\u0002\u0006A!\u0011qAA\u0007\u001b\t\tIAC\u0002\u0002\f\u0019\taa]3sm\u0016\u0014\u0018\u0002BA\b\u0003\u0013\u00111bS1gW\u0006\u001cuN\u001c4jO\"I\u00111\u0003\u0001A\u0002\u0013\u0005\u0011QC\u0001\u000bG>tg-[4`I\u0015\fHc\u00014\u0002\u0018!IQ.!\u0005\u0002\u0002\u0003\u0007\u0011Q\u0001\u0005\t\u00037\u0001\u0001\u0015)\u0003\u0002\u0006\u000591m\u001c8gS\u001e\u0004\u0003bBA\u0010\u0001\u0011\u0005\u0013\u0011E\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002M\"\"\u0011QDA\u0013!\u0011\t9#a\u000b\u000e\u0005\u0005%\"BA\u0007\u0011\u0013\u0011\ti#!\u000b\u0003\r\t+gm\u001c:f\u0011\u001d\t\t\u0004\u0001C!\u0003C\t\u0001\u0002^3be\u0012{wO\u001c\u0015\u0005\u0003_\t)\u0004\u0005\u0003\u0002(\u0005]\u0012\u0002BA\u001d\u0003S\u0011Q!\u00114uKJDq!!\u0010\u0001\t\u0003\t\t#\u0001\u0007uKN$Hk\u001c9jG\u0006\u001bG\u000e\u000b\u0003\u0002<\u0005\u0005\u0003\u0003BA\u0014\u0003\u0007JA!!\u0012\u0002*\t!A+Z:u\u0011\u001d\tI\u0005\u0001C\u0001\u0003C\tq\u0003^3ti\u0012+g.\u001f+bW\u0016\u001c\bK]3dK\u0012,gnY3)\t\u0005\u001d\u0013\u0011\t\u0005\b\u0003\u001f\u0002A\u0011AA\u0011\u0003I!Xm\u001d;BY2|w/\u00117m\u0003\u000e\u001cWm]:)\t\u00055\u0013\u0011\t\u0005\b\u0003+\u0002A\u0011AA\u0011\u0003Y!Xm\u001d;TkB,'/V:fe\"\u000b7/Q2dKN\u001c\b\u0006BA*\u0003\u0003Bq!a\u0017\u0001\t\u0003\t\t#\u0001\tuKN$x+\u001b7e\u0007\u0006\u0014H-Q2mg\"\"\u0011\u0011LA!\u0011\u001d\t\t\u0007\u0001C\u0001\u0003C\ta\u0002^3ti:{\u0017i\u00197G_VtG\r\u000b\u0003\u0002`\u0005\u0005\u0003bBA4\u0001\u0011\u0005\u0011\u0011E\u0001\u0017i\u0016\u001cHOT8BG24u.\u001e8e\u001fZ,'O]5eK\"\"\u0011QMA!\u0011\u001d\ti\u0007\u0001C\u0001\u0003C\tQ\u0003^3ti\u0006\u001bG.T1oC\u001e,W.\u001a8u\u0003BK5\u000f\u000b\u0003\u0002l\u0005\u0005\u0003bBA:\u0001\u0011\u0005\u0011\u0011E\u0001\u000ei\u0016\u001cH\u000fT8bI\u000e\u000b7\r[3)\t\u0005E\u0014\u0011\t\u0005\b\u0003s\u0002A\u0011AA\u0011\u00035\"Xm\u001d;M_\u000e\fGnQ8oGV\u0014(/\u001a8u\u001b>$\u0017NZ5dCRLwN\\(g%\u0016\u001cx.\u001e:dK\u0006\u001bGn\u001d\u0015\u0005\u0003o\n\t\u0005C\u0004\u0002\u0000\u0001!\t!!\t\u0002gQ,7\u000f\u001e#jgR\u0014\u0018NY;uK\u0012\u001cuN\\2veJ,g\u000e^'pI&4\u0017nY1uS>twJ\u001a*fg>,(oY3BG2\u001c\b\u0006BA?\u0003\u0003Bq!!\"\u0001\t\u0003\t\t#A\u0017uKN$\b*[4i\u0007>t7-\u001e:sK:\u001c\u00170T8eS\u001aL7-\u0019;j_:|eMU3t_V\u00148-Z!dYNDC!a!\u0002B!9\u00111\u0012\u0001\u0005\u0002\u0005\u0005\u0012!\u000b;fgRD\u0015n\u001a5D_:\u001cWO\u001d:f]\u000eLH)\u001a7fi&|gn\u00144SKN|WO]2f\u0003\u000ed7\u000f\u000b\u0003\u0002\n\u0006\u0005\u0003bBAI\u0001\u0011%\u00111S\u0001\u0013G\"\fgnZ3BG2\fe\u000e\u001a,fe&4\u0017\u0010\u0006\u0006\u0002\u0016\u0006%\u0016QVAY\u0003k\u0003b!a&\u0002\u001e\u0006\rfbA4\u0002\u001a&\u0019\u00111\u00145\u0002\rA\u0013X\rZ3g\u0013\u0011\ty*!)\u0003\u0007M+GOC\u0002\u0002\u001c\"\u00042AHAS\u0013\r\t9K\u0001\u0002\u0004\u0003\u000ed\u0007\u0002CAV\u0003\u001f\u0003\r!!&\u0002\u0019=\u0014\u0018nZ5oC2\f5\r\\:\t\u0011\u0005=\u0016q\u0012a\u0001\u0003+\u000b\u0011\"\u00193eK\u0012\f5\r\\:\t\u0011\u0005M\u0016q\u0012a\u0001\u0003+\u000b1B]3n_Z,G-Q2mg\"Aa,a$\u0011\u0002\u0003\u0007\u0001\rC\u0005\u0002:\u0002\t\n\u0011\"\u0003\u0002<\u0006a2\r[1oO\u0016\f5\r\\!oIZ+'/\u001b4zI\u0011,g-Y;mi\u0012\"TCAA_U\r\u0001\u0017qX\u0016\u0003\u0003\u0003\u0004B!a1\u0002N6\u0011\u0011Q\u0019\u0006\u0005\u0003\u000f\fI-A\u0005v]\u000eDWmY6fI*\u0019\u00111\u001a5\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002P\u0006\u0015'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class SimpleAclAuthorizerTest
extends JUnitSuite
implements ZooKeeperTestHarness {
    private final SimpleAclAuthorizer simpleAclAuthorizer;
    private final SimpleAclAuthorizer simpleAclAuthorizer2;
    private final KafkaPrincipal testPrincipal;
    private final InetAddress testHostName;
    private final RequestChannel.Session session;
    private Resource resource;
    private final String superUsers;
    private final String username;
    private KafkaConfig config;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        SimpleAclAuthorizerTest simpleAclAuthorizerTest = this;
        synchronized (simpleAclAuthorizerTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public SimpleAclAuthorizer simpleAclAuthorizer() {
        return this.simpleAclAuthorizer;
    }

    public SimpleAclAuthorizer simpleAclAuthorizer2() {
        return this.simpleAclAuthorizer2;
    }

    public KafkaPrincipal testPrincipal() {
        return this.testPrincipal;
    }

    public InetAddress testHostName() {
        return this.testHostName;
    }

    public RequestChannel.Session session() {
        return this.session;
    }

    public Resource resource() {
        return this.resource;
    }

    public void resource_$eq(Resource x$1) {
        this.resource = x$1;
    }

    public String superUsers() {
        return this.superUsers;
    }

    public String username() {
        return this.username;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
        this.simpleAclAuthorizer().maxUpdateRetries_$eq(Integer.MAX_VALUE);
        this.simpleAclAuthorizer2().maxUpdateRetries_$eq(Integer.MAX_VALUE);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        props.put(SimpleAclAuthorizer$.MODULE$.SuperUsersProp(), this.superUsers());
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        this.simpleAclAuthorizer().configure(this.config().originals());
        this.simpleAclAuthorizer2().configure(this.config().originals());
        this.resource_$eq(new Resource((ResourceType)Topic$.MODULE$, UUID.randomUUID().toString()));
    }

    @Override
    @After
    public void tearDown() {
        this.simpleAclAuthorizer().close();
        this.simpleAclAuthorizer2().close();
    }

    @Test
    public void testTopicAcl() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "rob");
        KafkaPrincipal user3 = new KafkaPrincipal("User", "batman");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        Acl acl1 = new Acl(user1, (PermissionType)Allow$.MODULE$, host1.getHostAddress(), (Operation)Read$.MODULE$);
        Acl acl2 = new Acl(user1, (PermissionType)Allow$.MODULE$, host2.getHostAddress(), (Operation)Read$.MODULE$);
        Acl acl3 = new Acl(user1, (PermissionType)Deny$.MODULE$, host1.getHostAddress(), (Operation)Read$.MODULE$);
        Acl acl4 = new Acl(user1, (PermissionType)Allow$.MODULE$, host1.getHostAddress(), (Operation)Write$.MODULE$);
        Acl acl5 = new Acl(user1, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Describe$.MODULE$);
        Acl acl6 = new Acl(user2, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        Acl acl7 = new Acl(user3, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Write$.MODULE$);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2, acl3, acl4, acl5, acl6, acl7}));
        this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)acls, (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestChannel.Session host1Session = new RequestChannel.Session(user1, host1);
        RequestChannel.Session host2Session = new RequestChannel.Session(user1, host2);
        Assert.assertTrue((String)"User1 should have READ access from host2", (boolean)this.simpleAclAuthorizer().authorize(host2Session, (Operation)Read$.MODULE$, this.resource()));
        Assert.assertFalse((String)"User1 should not have READ access from host1 due to denyAcl", (boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Read$.MODULE$, this.resource()));
        Assert.assertTrue((String)"User1 should have WRITE access from host1", (boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Write$.MODULE$, this.resource()));
        Assert.assertFalse((String)"User1 should not have WRITE access from host2 as no allow acl is defined", (boolean)this.simpleAclAuthorizer().authorize(host2Session, (Operation)Write$.MODULE$, this.resource()));
        Assert.assertTrue((String)"User1 should not have DESCRIBE access from host1", (boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Describe$.MODULE$, this.resource()));
        Assert.assertTrue((String)"User1 should have DESCRIBE access from host2", (boolean)this.simpleAclAuthorizer().authorize(host2Session, (Operation)Describe$.MODULE$, this.resource()));
        Assert.assertFalse((String)"User1 should not have edit access from host1", (boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Alter$.MODULE$, this.resource()));
        Assert.assertFalse((String)"User1 should not have edit access from host2", (boolean)this.simpleAclAuthorizer().authorize(host2Session, (Operation)Alter$.MODULE$, this.resource()));
        RequestChannel.Session user2Session = new RequestChannel.Session(user2, host1);
        RequestChannel.Session user3Session = new RequestChannel.Session(user3, host1);
        Assert.assertTrue((String)"User2 should have DESCRIBE access from host1", (boolean)this.simpleAclAuthorizer().authorize(user2Session, (Operation)Describe$.MODULE$, this.resource()));
        Assert.assertTrue((String)"User3 should have DESCRIBE access from host2", (boolean)this.simpleAclAuthorizer().authorize(user3Session, (Operation)Describe$.MODULE$, this.resource()));
        Assert.assertTrue((String)"User2 should have READ access from host1", (boolean)this.simpleAclAuthorizer().authorize(user2Session, (Operation)Read$.MODULE$, this.resource()));
        Assert.assertTrue((String)"User3 should have WRITE access from host2", (boolean)this.simpleAclAuthorizer().authorize(user3Session, (Operation)Write$.MODULE$, this.resource()));
    }

    @Test
    public void testDenyTakesPrecedence() {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        InetAddress host = InetAddress.getByName("192.168.2.1");
        RequestChannel.Session session = new RequestChannel.Session(user, host);
        Acl allowAll = Acl$.MODULE$.AllowAllAcl();
        Acl denyAcl = new Acl(user, (PermissionType)Deny$.MODULE$, host.getHostAddress(), (Operation)All$.MODULE$);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{allowAll, denyAcl}));
        this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)acls, (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        Assert.assertFalse((String)"deny should take precedence over allow.", (boolean)this.simpleAclAuthorizer().authorize(session, (Operation)Read$.MODULE$, this.resource()));
    }

    @Test
    public void testAllowAllAccess() {
        Acl allowAllAcl = Acl$.MODULE$.AllowAllAcl();
        this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{allowAllAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestChannel.Session session = new RequestChannel.Session(new KafkaPrincipal("User", "random"), InetAddress.getByName("192.0.4.4"));
        Assert.assertTrue((String)"allow all acl should allow access to all.", (boolean)this.simpleAclAuthorizer().authorize(session, (Operation)Read$.MODULE$, this.resource()));
    }

    @Test
    public void testSuperUserHasAccess() {
        Acl denyAllAcl = new Acl(Acl$.MODULE$.WildCardPrincipal(), (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)All$.MODULE$);
        this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{denyAllAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestChannel.Session session1 = new RequestChannel.Session(new KafkaPrincipal("User", "superuser1"), InetAddress.getByName("192.0.4.4"));
        RequestChannel.Session session2 = new RequestChannel.Session(new KafkaPrincipal("User", "superuser2"), InetAddress.getByName("192.0.4.4"));
        Assert.assertTrue((String)"superuser always has access, no matter what acls.", (boolean)this.simpleAclAuthorizer().authorize(session1, (Operation)Read$.MODULE$, this.resource()));
        Assert.assertTrue((String)"superuser always has access, no matter what acls.", (boolean)this.simpleAclAuthorizer().authorize(session2, (Operation)Read$.MODULE$, this.resource()));
    }

    @Test
    public void testWildCardAcls() {
        Assert.assertFalse((String)"when acls = [],  authorizer should fail close.", (boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, this.resource()));
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.3.1");
        Acl readAcl = new Acl(user1, (PermissionType)Allow$.MODULE$, host1.getHostAddress(), (Operation)Read$.MODULE$);
        Resource wildCardResource = new Resource(this.resource().resourceType(), Resource$.MODULE$.WildCardResource());
        Set<Acl> acls = this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{readAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), wildCardResource);
        RequestChannel.Session host1Session = new RequestChannel.Session(user1, host1);
        Assert.assertTrue((String)"User1 should have Read access from host1", (boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Read$.MODULE$, this.resource()));
        Acl writeAcl = new Acl(user1, (PermissionType)Allow$.MODULE$, host1.getHostAddress(), (Operation)Write$.MODULE$);
        this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{writeAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        Acl denyWriteOnWildCardResourceAcl = new Acl(user1, (PermissionType)Deny$.MODULE$, host1.getHostAddress(), (Operation)Write$.MODULE$);
        this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify(acls, (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{denyWriteOnWildCardResourceAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), wildCardResource);
        Assert.assertFalse((String)"User1 should not have Write access from host1", (boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Write$.MODULE$, this.resource()));
    }

    @Test
    public void testNoAclFound() {
        Assert.assertFalse((String)"when acls = [],  authorizer should fail close.", (boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, this.resource()));
    }

    @Test
    public void testNoAclFoundOverride() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        props.put(SimpleAclAuthorizer$.MODULE$.AllowEveryoneIfNoAclIsFoundProp(), "true");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        SimpleAclAuthorizer testAuthoizer = new SimpleAclAuthorizer();
        testAuthoizer.configure(cfg.originals());
        Assert.assertTrue((String)"when acls = null or [],  authorizer should fail open with allow.everyone = true.", (boolean)testAuthoizer.authorize(this.session(), (Operation)Read$.MODULE$, this.resource()));
    }

    @Test
    public void testAclManagementAPIs() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        String host1 = "host1";
        String host2 = "host2";
        Acl acl1 = new Acl(user1, (PermissionType)Allow$.MODULE$, host1, (Operation)Read$.MODULE$);
        Acl acl2 = new Acl(user1, (PermissionType)Allow$.MODULE$, host1, (Operation)Write$.MODULE$);
        Acl acl3 = new Acl(user2, (PermissionType)Allow$.MODULE$, host2, (Operation)Read$.MODULE$);
        Acl acl4 = new Acl(user2, (PermissionType)Allow$.MODULE$, host2, (Operation)Write$.MODULE$);
        ObjectRef acls = new ObjectRef(this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2, acl3, acl4}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4()));
        Acl acl5 = new Acl(user2, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        acls.elem = this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)((Set)acls.elem), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl5}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, user1, acl1, acl2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SimpleAclAuthorizerTest $outer;
            private final KafkaPrincipal user1$1;
            private final Acl acl1$1;
            private final Acl acl2$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                GenMap genMap = Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.$outer.resource()), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.acl1$1, this.acl2$1})))}));
                Map map = this.$outer.simpleAclAuthorizer().getAcls(this.user1$1);
                return !(genMap != null ? !genMap.equals(map) : map != null);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.user1$1 = user1$1;
                this.acl1$1 = acl1$1;
                this.acl2$1 = acl2$1;
            }
        }, "changes not propagated in timeout period", TestUtils$.MODULE$.waitUntilTrue$default$3());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, user2, acl3, acl4, acl5){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SimpleAclAuthorizerTest $outer;
            private final KafkaPrincipal user2$1;
            private final Acl acl3$1;
            private final Acl acl4$1;
            private final Acl acl5$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                GenMap genMap = Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.$outer.resource()), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.acl3$1, this.acl4$1, this.acl5$1})))}));
                Map map = this.$outer.simpleAclAuthorizer().getAcls(this.user2$1);
                return !(genMap != null ? !genMap.equals(map) : map != null);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.user2$1 = user2$1;
                this.acl3$1 = acl3$1;
                this.acl4$1 = acl4$1;
                this.acl5$1 = acl5$1;
            }
        }, "changes not propagated in timeout period", TestUtils$.MODULE$.waitUntilTrue$default$3());
        Map resourceToAcls = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new Resource((ResourceType)Topic$.MODULE$, Resource$.MODULE$.WildCardResource())), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(user2, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new Resource((ResourceType)Cluster$.MODULE$, Resource$.MODULE$.WildCardResource())), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(user2, (PermissionType)Allow$.MODULE$, host1, (Operation)Read$.MODULE$)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new Resource((ResourceType)Group$.MODULE$, Resource$.MODULE$.WildCardResource())), (Object)((Set)acls.elem)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new Resource((ResourceType)Group$.MODULE$, "test-ConsumerGroup")), (Object)((Set)acls.elem))}));
        resourceToAcls.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SimpleAclAuthorizerTest $outer;

            public final Set<Acl> apply(Tuple2<Resource, Set<Acl>> x0$1) {
                Tuple2<Resource, Set<Acl>> tuple2 = x0$1;
                if (tuple2 != null) {
                    Resource key = (Resource)tuple2._1();
                    Set value = (Set)tuple2._2();
                    Set<Acl> set = this.$outer.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)value, (Set<Acl>)Predef$.MODULE$.Set().empty(), key);
                    return set;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, acls, resourceToAcls){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SimpleAclAuthorizerTest $outer;
            private final ObjectRef acls$1;
            private final Map resourceToAcls$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Map map = this.resourceToAcls$1.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.$outer.resource()), (Object)((Set)this.acls$1.elem)));
                Map map2 = this.$outer.simpleAclAuthorizer().getAcls();
                return !(map != null ? !map.equals(map2) : map2 != null);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.acls$1 = acls$1;
                this.resourceToAcls$1 = resourceToAcls$1;
            }
        }, "changes not propagated in timeout period.", TestUtils$.MODULE$.waitUntilTrue$default$3());
        acls.elem = this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)((Set)acls.elem), (Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl5}))), this.changeAclAndVerify$default$4());
        this.simpleAclAuthorizer().removeAcls(this.resource());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)Predef$.MODULE$.Set().empty(), (Authorizer)this.simpleAclAuthorizer(), this.resource());
        Assert.assertTrue((!this.zkUtils().pathExists(this.simpleAclAuthorizer().toResourcePath(this.resource())) ? 1 : 0) != 0);
        acls.elem = this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)((Set)acls.elem), (Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)acls.elem), this.changeAclAndVerify$default$4());
        Assert.assertTrue((!this.zkUtils().pathExists(this.simpleAclAuthorizer().toResourcePath(this.resource())) ? 1 : 0) != 0);
    }

    @Test
    public void testLoadCache() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        Acl acl1 = new Acl(user1, (PermissionType)Allow$.MODULE$, "host-1", (Operation)Read$.MODULE$);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1}));
        this.simpleAclAuthorizer().addAcls(acls, this.resource());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        Resource resource1 = new Resource((ResourceType)Topic$.MODULE$, "test-2");
        Acl acl2 = new Acl(user2, (PermissionType)Deny$.MODULE$, "host3", (Operation)Read$.MODULE$);
        Set acls1 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl2}));
        this.simpleAclAuthorizer().addAcls(acls1, resource1);
        this.zkUtils().deletePathRecursive(SimpleAclAuthorizer$.MODULE$.AclChangedZkPath());
        SimpleAclAuthorizer authorizer = new SimpleAclAuthorizer();
        authorizer.configure(this.config().originals());
        Assert.assertEquals((Object)acls, (Object)authorizer.getAcls(this.resource()));
        Assert.assertEquals((Object)acls1, (Object)authorizer.getAcls(resource1));
    }

    @Test
    public void testLocalConcurrentModificationOfResourceAcls() {
        Resource commonResource = new Resource((ResourceType)Topic$.MODULE$, "test");
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        Acl acl1 = new Acl(user1, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        Acl acl2 = new Acl(user2, (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1})), commonResource);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl2})), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2}))), (Authorizer)this.simpleAclAuthorizer(), commonResource);
    }

    @Test
    public void testDistributedConcurrentModificationOfResourceAcls() {
        Resource commonResource = new Resource((ResourceType)Topic$.MODULE$, "test");
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        Acl acl1 = new Acl(user1, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        Acl acl2 = new Acl(user2, (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1})), commonResource);
        this.simpleAclAuthorizer2().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl2})), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2}))), (Authorizer)this.simpleAclAuthorizer(), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2}))), (Authorizer)this.simpleAclAuthorizer2(), commonResource);
        KafkaPrincipal user3 = new KafkaPrincipal("User", "joe");
        Acl acl3 = new Acl(user3, (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl3})), commonResource);
        boolean deleted = this.simpleAclAuthorizer2().removeAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl3})), commonResource);
        Assert.assertTrue((String)"The authorizer should see a value that needs to be deleted", (boolean)deleted);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2}))), (Authorizer)this.simpleAclAuthorizer(), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2}))), (Authorizer)this.simpleAclAuthorizer2(), commonResource);
    }

    @Test
    public void testHighConcurrencyModificationOfResourceAcls() {
        Resource commonResource = new Resource((ResourceType)Topic$.MODULE$, "test");
        IndexedSeq acls = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 50).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Acl apply(int i) {
                KafkaPrincipal useri = new KafkaPrincipal("User", ((Object)BoxesRunTime.boxToInteger((int)i)).toString());
                return new Acl(useri, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq concurrentFuctions = (IndexedSeq)acls.map((Function1)new Serializable(this, commonResource){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SimpleAclAuthorizerTest $outer;
            public final Resource commonResource$1;

            public final Function0<Object> apply(Acl acl) {
                return new Serializable(this, acl){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;
                    private final Acl acl$1;

                    public final Object apply() {
                        int aclId = new StringOps(Predef$.MODULE$.augmentString(this.acl$1.principal().getName())).toInt();
                        if (aclId % 2 == 0) {
                            this.$outer.kafka$security$auth$SimpleAclAuthorizerTest$$anonfun$$$outer().simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.acl$1})), this.$outer.commonResource$1);
                        } else {
                            this.$outer.kafka$security$auth$SimpleAclAuthorizerTest$$anonfun$$$outer().simpleAclAuthorizer2().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.acl$1})), this.$outer.commonResource$1);
                        }
                        return aclId % 10 == 0 ? BoxesRunTime.boxToBoolean((boolean)this.$outer.kafka$security$auth$SimpleAclAuthorizerTest$$anonfun$$$outer().simpleAclAuthorizer2().removeAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.acl$1})), this.$outer.commonResource$1)) : BoxedUnit.UNIT;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.acl$1 = acl$1;
                    }
                };
            }

            public /* synthetic */ SimpleAclAuthorizerTest kafka$security$auth$SimpleAclAuthorizerTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.commonResource$1 = commonResource$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Set expectedAcls = ((TraversableOnce)acls.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Acl acl) {
                int aclId = new StringOps(Predef$.MODULE$.augmentString(acl.principal().getName())).toInt();
                return aclId % 10 != 0;
            }
        })).toSet();
        TestUtils$.MODULE$.assertConcurrent("Should support many concurrent calls", (Seq<Function0<Object>>)concurrentFuctions, 30000);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)expectedAcls, (Authorizer)this.simpleAclAuthorizer(), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)expectedAcls, (Authorizer)this.simpleAclAuthorizer2(), commonResource);
    }

    @Test
    public void testHighConcurrencyDeletionOfResourceAcls() {
        Acl acl = new Acl(new KafkaPrincipal("User", this.username()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)All$.MODULE$);
        IndexedSeq concurrentFuctions = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 50).map((Function1)new Serializable(this, acl){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SimpleAclAuthorizerTest $outer;
            public final Acl acl$2;

            public final Function0<Object> apply(int i) {
                return new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        this.$outer.kafka$security$auth$SimpleAclAuthorizerTest$$anonfun$$$outer().simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.$outer.acl$2})), this.$outer.kafka$security$auth$SimpleAclAuthorizerTest$$anonfun$$$outer().resource());
                        return this.$outer.kafka$security$auth$SimpleAclAuthorizerTest$$anonfun$$$outer().simpleAclAuthorizer2().removeAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.$outer.acl$2})), this.$outer.kafka$security$auth$SimpleAclAuthorizerTest$$anonfun$$$outer().resource());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                };
            }

            public /* synthetic */ SimpleAclAuthorizerTest kafka$security$auth$SimpleAclAuthorizerTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.acl$2 = acl$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.assertConcurrent("Should support many concurrent calls", (Seq<Function0<Object>>)concurrentFuctions, 30000);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)Predef$.MODULE$.Set().empty(), (Authorizer)this.simpleAclAuthorizer(), this.resource());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)Predef$.MODULE$.Set().empty(), (Authorizer)this.simpleAclAuthorizer2(), this.resource());
    }

    public Set<Acl> kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify(Set<Acl> originalAcls, Set<Acl> addedAcls, Set<Acl> removedAcls, Resource resource) {
        Set acls = originalAcls;
        if (addedAcls.nonEmpty()) {
            this.simpleAclAuthorizer().addAcls(addedAcls, resource);
            acls = (Set)acls.$plus$plus(addedAcls);
        }
        if (removedAcls.nonEmpty()) {
            this.simpleAclAuthorizer().removeAcls(removedAcls, resource);
            acls = (Set)acls.$minus$minus(removedAcls);
        }
        TestUtils$.MODULE$.waitAndVerifyAcls(acls, (Authorizer)this.simpleAclAuthorizer(), resource);
        return acls;
    }

    private Resource changeAclAndVerify$default$4() {
        return this.resource();
    }

    public SimpleAclAuthorizerTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        this.simpleAclAuthorizer = new SimpleAclAuthorizer();
        this.simpleAclAuthorizer2 = new SimpleAclAuthorizer();
        this.testPrincipal = Acl$.MODULE$.WildCardPrincipal();
        this.testHostName = InetAddress.getByName("192.168.0.1");
        this.session = new RequestChannel.Session(this.testPrincipal(), this.testHostName());
        this.resource = null;
        this.superUsers = "User:superuser1; User:superuser2";
        this.username = "alice";
        this.config = null;
    }
}

