/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.cluster.Replica;
import kafka.common.TopicAndPartition;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.OffsetCheckpoint;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h\u0001B\u0001\u0003\u0001\u001d\u0011q\u0002T8h%\u0016\u001cwN^3ssR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\n\u0011\u0005%\u0001R\"\u0001\u0006\u000b\u0005-a\u0011!\u00026v]&$(BA\u0007\u000f\u0003%\u00198-\u00197bi\u0016\u001cHOC\u0001\u0010\u0003\ry'oZ\u0005\u0003#)\u0011!BS+oSR\u001cV/\u001b;f!\t\u0019b#D\u0001\u0015\u0015\t)B!\u0001\u0002{W&\u0011q\u0003\u0006\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001b\u0002\u0010\u0001\u0005\u0004%\taH\u0001\u0014e\u0016\u0004H.[2b\u0019\u0006<G+[7f\u001b\u0006DXj]\u000b\u0002AA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t!Aj\u001c8h\u0011\u00199\u0003\u0001)A\u0005A\u0005!\"/\u001a9mS\u000e\fG*Y4US6,W*\u0019=Ng\u0002Bq!\u000b\u0001C\u0002\u0013\u0005q$A\u000bsKBd\u0017nY1MC\u001el\u0015\r_'fgN\fw-Z:\t\r-\u0002\u0001\u0015!\u0003!\u0003Y\u0011X\r\u001d7jG\u0006d\u0015mZ'bq6+7o]1hKN\u0004\u0003bB\u0017\u0001\u0005\u0004%\tAL\u0001\u0016e\u0016\u0004H.[2b\r\u0016$8\r[,bSRl\u0015\r_'t+\u0005y\u0003CA\u00111\u0013\t\t$EA\u0002J]RDaa\r\u0001!\u0002\u0013y\u0013A\u0006:fa2L7-\u0019$fi\u000eDw+Y5u\u001b\u0006DXj\u001d\u0011\t\u000fU\u0002!\u0019!C\u0001]\u0005!\"/\u001a9mS\u000e\fg)\u001a;dQ6KgNQ=uKNDaa\u000e\u0001!\u0002\u0013y\u0013!\u0006:fa2L7-\u0019$fi\u000eDW*\u001b8CsR,7\u000f\t\u0005\bs\u0001\u0011\r\u0011\"\u0001;\u0003=yg/\u001a:sS\u0012Lgn\u001a)s_B\u001cX#A\u001e\u0011\u0005q\nU\"A\u001f\u000b\u0005yz\u0014\u0001B;uS2T\u0011\u0001Q\u0001\u0005U\u00064\u0018-\u0003\u0002C{\tQ\u0001K]8qKJ$\u0018.Z:\t\r\u0011\u0003\u0001\u0015!\u0003<\u0003Ayg/\u001a:sS\u0012Lgn\u001a)s_B\u001c\b\u0005C\u0004G\u0001\u0001\u0007I\u0011A$\u0002\u000f\r|gNZ5hgV\t\u0001\nE\u0002J#Rs!AS(\u000f\u0005-sU\"\u0001'\u000b\u000553\u0011A\u0002\u001fs_>$h(C\u0001$\u0013\t\u0001&%A\u0004qC\u000e\\\u0017mZ3\n\u0005I\u001b&aA*fc*\u0011\u0001K\t\t\u00039UK!A\u0016\u0002\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\b1\u0002\u0001\r\u0011\"\u0001Z\u0003-\u0019wN\u001c4jON|F%Z9\u0015\u0005ik\u0006CA\u0011\\\u0013\ta&E\u0001\u0003V]&$\bb\u00020X\u0003\u0003\u0005\r\u0001S\u0001\u0004q\u0012\n\u0004B\u00021\u0001A\u0003&\u0001*\u0001\u0005d_:4\u0017nZ:!\u0011\u001d\u0011\u0007A1A\u0005\u0002\r\fQ\u0001^8qS\u000e,\u0012\u0001\u001a\t\u0003K\"l\u0011A\u001a\u0006\u0003O~\nA\u0001\\1oO&\u0011\u0011N\u001a\u0002\u0007'R\u0014\u0018N\\4\t\r-\u0004\u0001\u0015!\u0003e\u0003\u0019!x\u000e]5dA!9Q\u000e\u0001b\u0001\n\u0003q\u0013a\u00039beRLG/[8o\u0013\u0012Daa\u001c\u0001!\u0002\u0013y\u0013\u0001\u00049beRLG/[8o\u0013\u0012\u0004\u0003bB9\u0001\u0001\u0004%\tA]\u0001\bg\u0016\u0014h/\u001a:2+\u0005\u0019\bC\u0001\u000fu\u0013\t)(AA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\bbB<\u0001\u0001\u0004%\t\u0001_\u0001\fg\u0016\u0014h/\u001a:2?\u0012*\u0017\u000f\u0006\u0002[s\"9aL^A\u0001\u0002\u0004\u0019\bBB>\u0001A\u0003&1/\u0001\u0005tKJ4XM]\u0019!\u0011\u001di\b\u00011A\u0005\u0002I\fqa]3sm\u0016\u0014(\u0007\u0003\u0005\u0000\u0001\u0001\u0007I\u0011AA\u0001\u0003-\u0019XM\u001d<feJzF%Z9\u0015\u0007i\u000b\u0019\u0001C\u0004_}\u0006\u0005\t\u0019A:\t\u000f\u0005\u001d\u0001\u0001)Q\u0005g\u0006A1/\u001a:wKJ\u0014\u0004\u0005C\u0004\u0002\f\u0001!\t!!\u0004\u0002\u0019\r|gNZ5h!J|\u0007o]\u0019\u0016\u0003QCq!!\u0005\u0001\t\u0003\ti!\u0001\u0007d_:4\u0017n\u001a)s_B\u001c(\u0007\u0003\u0005\u0002\u0016\u0001\u0011\r\u0011\"\u0001d\u0003\u001diWm]:bO\u0016Dq!!\u0007\u0001A\u0003%A-\u0001\u0005nKN\u001c\u0018mZ3!\u0011%\ti\u0002\u0001a\u0001\n\u0003\ty\"\u0001\u0005qe>$WoY3s+\t\t\t\u0003\u0005\u0005\u0002$\u0005E\u0012QGA\u001e\u001b\t\t)C\u0003\u0003\u0002\u001e\u0005\u001d\"\u0002BA\u0015\u0003W\tqa\u00197jK:$8OC\u0002\u0006\u0003[Q1!a\f\u000f\u0003\u0019\t\u0007/Y2iK&!\u00111GA\u0013\u00055Y\u0015MZ6b!J|G-^2feB\u0019Q-a\u000e\n\u0007\u0005ebMA\u0004J]R,w-\u001a:\u0011\t\u0005u\u00121\t\b\u0004C\u0005}\u0012bAA!E\u00051\u0001K]3eK\u001aL1![A#\u0015\r\t\tE\t\u0005\n\u0003\u0013\u0002\u0001\u0019!C\u0001\u0003\u0017\nA\u0002\u001d:pIV\u001cWM]0%KF$2AWA'\u0011%q\u0016qIA\u0001\u0002\u0004\t\t\u0003\u0003\u0005\u0002R\u0001\u0001\u000b\u0015BA\u0011\u0003%\u0001(o\u001c3vG\u0016\u0014\b\u0005C\u0004\u0002V\u0001!\t!a\u0016\u0002\u000f!<h)\u001b7fcU\u0011\u0011\u0011\f\t\u00049\u0005m\u0013bAA/\u0005\t\u0001rJ\u001a4tKR\u001c\u0005.Z2la>Lg\u000e\u001e\u0005\b\u0003C\u0002A\u0011AA,\u0003\u001dAwOR5mKJB\u0011\"!\u001a\u0001\u0001\u0004%\t!a\u001a\u0002\u000fM,'O^3sgV\u0011\u0011\u0011\u000e\t\u0006\u0003W\n\th]\u0007\u0003\u0003[R1!a\u001c#\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0004%\u00065\u0004\"CA;\u0001\u0001\u0007I\u0011AA<\u0003-\u0019XM\u001d<feN|F%Z9\u0015\u0007i\u000bI\bC\u0005_\u0003g\n\t\u00111\u0001\u0002j!A\u0011Q\u0010\u0001!B\u0013\tI'\u0001\u0005tKJ4XM]:!\u0011\u001d\t\t\t\u0001C\u0001\u0003\u0007\u000ba\"\u001e9eCR,\u0007K]8ek\u000e,'\u000fF\u0001[\u0011\u001d\t9\t\u0001C!\u0003\u0007\u000bQa]3u+BDC!!\"\u0002\fB!\u0011QRAI\u001b\t\tyI\u0003\u0002\f\u001d%!\u00111SAH\u0005\u0019\u0011UMZ8sK\"9\u0011q\u0013\u0001\u0005B\u0005\r\u0015\u0001\u0003;fCJ$un\u001e8)\t\u0005U\u00151\u0014\t\u0005\u0003\u001b\u000bi*\u0003\u0003\u0002 \u0006=%!B!gi\u0016\u0014\bbBAR\u0001\u0011\u0005\u0011QU\u0001+i\u0016\u001cH\u000fS,DQ\u0016\u001c7\u000e]8j]RtuNR1jYV\u0014Xm]*j]\u001edW\rT8h'\u0016<W.\u001a8u+\u0005Q\u0006\u0006BAQ\u0003S\u0003B!!$\u0002,&!\u0011QVAH\u0005\u0011!Vm\u001d;\t\u000f\u0005E\u0006\u0001\"\u0001\u0002&\u0006aC/Z:u\u0011^\u001b\u0005.Z2la>Lg\u000e^,ji\"4\u0015-\u001b7ve\u0016\u001c8+\u001b8hY\u0016dunZ*fO6,g\u000e\u001e\u0015\u0005\u0003_\u000bI\u000bC\u0004\u00028\u0002!\t!!*\u0002[Q,7\u000f\u001e%X\u0007\",7m\u001b9pS:$hj\u001c$bS2,(/Z:Nk2$\u0018\u000e\u001d7f\u0019><7+Z4nK:$8\u000f\u000b\u0003\u00026\u0006%\u0006bBA_\u0001\u0011\u0005\u0011QU\u00010i\u0016\u001cH\u000fS,DQ\u0016\u001c7\u000e]8j]R<\u0016\u000e\u001e5GC&dWO]3t\u001bVdG/\u001b9mK2{wmU3h[\u0016tGo\u001d\u0015\u0005\u0003w\u000bI\u000bC\u0004\u0002D\u0002!I!!2\u0002\u0019M,g\u000eZ'fgN\fw-Z:\u0015\u0007i\u000b9\rC\u0005\u0002J\u0006\u0005\u0007\u0013!a\u0001_\u0005\ta\u000eC\u0005\u0002N\u0002\t\n\u0011\"\u0003\u0002P\u000612/\u001a8e\u001b\u0016\u001c8/Y4fg\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002R*\u001aq&a5,\u0005\u0005U\u0007\u0003BAl\u0003Cl!!!7\u000b\t\u0005m\u0017Q\\\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a8#\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003G\fINA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class LogRecoveryTest
extends JUnitSuite
implements ZooKeeperTestHarness {
    private final long replicaLagTimeMaxMs;
    private final long replicaLagMaxMessages;
    private final int replicaFetchWaitMaxMs;
    private final int replicaFetchMinBytes;
    private final Properties overridingProps;
    private Seq<KafkaConfig> configs;
    private final String topic;
    private final int partitionId;
    private KafkaServer server1;
    private KafkaServer server2;
    private final String message;
    private KafkaProducer<Integer, String> producer;
    private Seq<KafkaServer> servers;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LogRecoveryTest logRecoveryTest = this;
        synchronized (logRecoveryTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public long replicaLagTimeMaxMs() {
        return this.replicaLagTimeMaxMs;
    }

    public long replicaLagMaxMessages() {
        return this.replicaLagMaxMessages;
    }

    public int replicaFetchWaitMaxMs() {
        return this.replicaFetchWaitMaxMs;
    }

    public int replicaFetchMinBytes() {
        return this.replicaFetchMinBytes;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public void configs_$eq(Seq<KafkaConfig> x$1) {
        this.configs = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public KafkaServer server1() {
        return this.server1;
    }

    public void server1_$eq(KafkaServer x$1) {
        this.server1 = x$1;
    }

    public KafkaServer server2() {
        return this.server2;
    }

    public void server2_$eq(KafkaServer x$1) {
        this.server2 = x$1;
    }

    public KafkaConfig configProps1() {
        return (KafkaConfig)this.configs().head();
    }

    public KafkaConfig configProps2() {
        return (KafkaConfig)this.configs().last();
    }

    public String message() {
        return this.message;
    }

    public KafkaProducer<Integer, String> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<Integer, String> x$1) {
        this.producer = x$1;
    }

    public OffsetCheckpoint hwFile1() {
        return new OffsetCheckpoint(new File((String)this.configProps1().logDirs().apply(0), ReplicaManager$.MODULE$.HighWatermarkFilename()));
    }

    public OffsetCheckpoint hwFile2() {
        return new OffsetCheckpoint(new File((String)this.configProps2().logDirs().apply(0), ReplicaManager$.MODULE$.HighWatermarkFilename()));
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public void updateProducer() {
        if (this.producer() != null) {
            this.producer().close();
        }
        String x$8 = TestUtils$.MODULE$.getBrokerListStrFromServers(this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        int x$9 = 5;
        IntegerSerializer x$10 = new IntegerSerializer();
        StringSerializer x$11 = new StringSerializer();
        int x$12 = TestUtils$.MODULE$.createNewProducer$default$2();
        long x$13 = TestUtils$.MODULE$.createNewProducer$default$3();
        long x$14 = TestUtils$.MODULE$.createNewProducer$default$4();
        long x$15 = TestUtils$.MODULE$.createNewProducer$default$6();
        long x$16 = TestUtils$.MODULE$.createNewProducer$default$7();
        SecurityProtocol x$17 = TestUtils$.MODULE$.createNewProducer$default$8();
        Option<File> x$18 = TestUtils$.MODULE$.createNewProducer$default$9();
        Option<Properties> x$19 = TestUtils$.MODULE$.createNewProducer$default$10();
        Option<Properties> x$20 = TestUtils$.MODULE$.createNewProducer$default$13();
        this.producer_$eq(TestUtils$.MODULE$.createNewProducer(x$8, x$12, x$13, x$14, x$9, x$15, x$16, x$17, x$18, x$19, x$10, x$11, x$20));
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
        this.configs_$eq((Seq<KafkaConfig>)((Seq)TestUtils$.MODULE$.createBrokerConfigs(2, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.$outer.overridingProps());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())));
        this.server1_$eq(TestUtils$.MODULE$.createServer(this.configProps1(), TestUtils$.MODULE$.createServer$default$2()));
        this.server2_$eq(TestUtils$.MODULE$.createServer(this.configProps2(), TestUtils$.MODULE$.createServer$default$2()));
        this.servers_$eq((Seq<KafkaServer>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server1(), this.server2()})));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.servers());
        this.updateProducer();
    }

    @Override
    @After
    public void tearDown() {
        this.producer().close();
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                server.shutdown();
                Utils.delete((File)new File((String)server.config().logDirs().apply(0)));
            }
        });
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Test
    public void testHWCheckpointNoFailuresSingleLogSegment() {
        long numMessages = 2L;
        this.sendMessages((int)numMessages);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, numMessages){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;
            private final long numMessages$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                int x$23;
                int x$22;
                String x$21;
                ReplicaManager qual$1 = this.$outer.server2().replicaManager();
                return ((Replica)qual$1.getReplica(x$21 = this.$outer.topic(), x$22 = 0, x$23 = qual$1.getReplica$default$3()).get()).highWatermark().messageOffset() == this.numMessages$1;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.numMessages$1 = numMessages$1;
            }
        }, "Failed to update high watermark for follower after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$2) {
                x$2.replicaManager().checkpointHighWatermarks();
            }
        });
        long leaderHW = BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        Assert.assertEquals((long)numMessages, (long)leaderHW);
        long followerHW = BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        Assert.assertEquals((long)numMessages, (long)followerHW);
    }

    @Test
    public void testHWCheckpointWithFailuresSingleLogSegment() {
        Option<Object> leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        this.sendMessages(1);
        Thread.sleep(1000L);
        LongRef hw = new LongRef(1L);
        this.server1().shutdown();
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        ZkUtils x$24 = this.zkUtils();
        String x$25 = this.topic();
        int x$26 = this.partitionId();
        Option<Object> x$27 = leader;
        long x$28 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$29 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$24, x$25, x$26, x$28, x$27, x$29);
        Assert.assertEquals((String)"Leader must move to broker 1", (long)1L, (long)BoxesRunTime.unboxToInt((Object)leader.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })));
        this.server1().startup();
        this.updateProducer();
        leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        Assert.assertTrue((String)"Leader must remain on broker 1, in case of zookeeper session expiration it can move to broker 0", (leader.isDefined() && (BoxesRunTime.unboxToInt((Object)leader.get()) == 0 || BoxesRunTime.unboxToInt((Object)leader.get()) == 1) ? 1 : 0) != 0);
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        this.server2().shutdown();
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        this.server2().startup();
        this.updateProducer();
        ZkUtils x$30 = this.zkUtils();
        String x$31 = this.topic();
        int x$32 = this.partitionId();
        Option<Object> x$33 = leader;
        long x$34 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$35 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$30, x$31, x$32, x$34, x$33, x$35);
        Assert.assertTrue((String)"Leader must remain on broker 0, in case of zookeeper session expiration it can move to broker 1", (leader.isDefined() && (BoxesRunTime.unboxToInt((Object)leader.get()) == 0 || BoxesRunTime.unboxToInt((Object)leader.get()) == 1) ? 1 : 0) != 0);
        this.sendMessages(1);
        ++hw.elem;
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, hw){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;
            private final LongRef hw$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                int x$38;
                int x$37;
                String x$36;
                ReplicaManager qual$2 = this.$outer.server2().replicaManager();
                return ((Replica)qual$2.getReplica(x$36 = this.$outer.topic(), x$37 = 0, x$38 = qual$2.getReplica$default$3()).get()).highWatermark().messageOffset() == this.hw$1.elem;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.hw$1 = hw$1;
            }
        }, "Failed to update high watermark for follower after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$3) {
                x$3.shutdown();
            }
        });
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
    }

    @Test
    public void testHWCheckpointNoFailuresMultipleLogSegments() {
        this.sendMessages(20);
        long hw = 20L;
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, hw){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;
            private final long hw$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                int x$41;
                int x$40;
                String x$39;
                ReplicaManager qual$3 = this.$outer.server2().replicaManager();
                return ((Replica)qual$3.getReplica(x$39 = this.$outer.topic(), x$40 = 0, x$41 = qual$3.getReplica$default$3()).get()).highWatermark().messageOffset() == this.hw$2;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.hw$2 = hw$2;
            }
        }, "Failed to update high watermark for follower after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$4) {
                x$4.shutdown();
            }
        });
        long leaderHW = BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        Assert.assertEquals((long)hw, (long)leaderHW);
        long followerHW = BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        Assert.assertEquals((long)hw, (long)followerHW);
    }

    @Test
    public void testHWCheckpointWithFailuresMultipleLogSegments() {
        Option<Object> leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        this.sendMessages(2);
        LongRef hw = new LongRef(2L);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, hw){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;
            private final LongRef hw$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                int x$44;
                int x$43;
                String x$42;
                ReplicaManager qual$4 = this.$outer.server2().replicaManager();
                return ((Replica)qual$4.getReplica(x$42 = this.$outer.topic(), x$43 = 0, x$44 = qual$4.getReplica$default$3()).get()).highWatermark().messageOffset() == this.hw$3.elem;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.hw$3 = hw$3;
            }
        }, "Failed to update high watermark for follower after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3());
        this.server1().shutdown();
        this.server2().shutdown();
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        this.server2().startup();
        this.updateProducer();
        ZkUtils x$45 = this.zkUtils();
        String x$46 = this.topic();
        int x$47 = this.partitionId();
        Option<Object> x$48 = leader;
        long x$49 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$50 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$45, x$46, x$47, x$49, x$48, x$50);
        Assert.assertEquals((String)"Leader must move to broker 1", (long)1L, (long)BoxesRunTime.unboxToInt((Object)leader.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })));
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        this.server1().startup();
        this.updateProducer();
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        this.sendMessages(2);
        hw.elem += 2L;
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ReplicaManager qual$5 = this.$outer.server1().replicaManager();
                String x$51 = this.$outer.topic();
                int x$52 = 0;
                int x$53 = qual$5.getReplica$default$3();
                return qual$5.getReplica(x$51, x$52, x$53).nonEmpty();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, "Failed to create replica in follower after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, hw){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;
            private final LongRef hw$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                int x$56;
                int x$55;
                String x$54;
                ReplicaManager qual$6 = this.$outer.server1().replicaManager();
                return ((Replica)qual$6.getReplica(x$54 = this.$outer.topic(), x$55 = 0, x$56 = qual$6.getReplica$default$3()).get()).highWatermark().messageOffset() == this.hw$3.elem;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.hw$3 = hw$3;
            }
        }, "Failed to update high watermark for follower after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$5) {
                x$5.shutdown();
            }
        });
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
    }

    private void sendMessages(int n) {
        ((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;

            public final Future<RecordMetadata> apply(int x$6) {
                return this.$outer.producer().send(new ProducerRecord(this.$outer.topic(), (Object)Predef$.MODULE$.int2Integer(0), (Object)this.$outer.message()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$7) {
                return x$7.get();
            }
        });
    }

    private int sendMessages$default$1() {
        return 1;
    }

    public LogRecoveryTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        this.replicaLagTimeMaxMs = 5000L;
        this.replicaLagMaxMessages = 10L;
        this.replicaFetchWaitMaxMs = 1000;
        this.replicaFetchMinBytes = 20;
        this.overridingProps = new Properties();
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)this.replicaLagTimeMaxMs())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.replicaFetchWaitMaxMs())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchMinBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)this.replicaFetchMinBytes())).toString());
        this.configs = null;
        this.topic = "new-topic";
        this.partitionId = 0;
        this.server1 = null;
        this.server2 = null;
        this.message = "hello";
        this.producer = null;
        this.servers = (Seq)Seq$.MODULE$.empty();
    }
}

