/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.FetchResponsePartitionData;
import kafka.api.PartitionFetchInfo;
import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.Partition;
import kafka.common.TopicAndPartition;
import kafka.log.LogManager;
import kafka.message.ByteBufferMessageSet;
import kafka.message.Message;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.ReplicaManagerTest$;
import kafka.utils.MockScheduler;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.PartitionState;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Function2;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ea\u0001B\u0001\u0003\u0001\u001d\u0011!CU3qY&\u001c\u0017-T1oC\u001e,'\u000fV3ti*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001!\u0019!C\u0001+\u0005)Ao\u001c9jGV\ta\u0003\u0005\u0002\u001895\t\u0001D\u0003\u0002\u001a5\u0005!A.\u00198h\u0015\u0005Y\u0012\u0001\u00026bm\u0006L!!\b\r\u0003\rM#(/\u001b8h\u0011\u0019y\u0002\u0001)A\u0005-\u00051Ao\u001c9jG\u0002Bq!\t\u0001C\u0002\u0013\u0005!%\u0001\u0003uS6,W#A\u0012\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019\"\u0011!B;uS2\u001c\u0018B\u0001\u0015&\u0005!iunY6US6,\u0007B\u0002\u0016\u0001A\u0003%1%A\u0003uS6,\u0007\u0005C\u0004-\u0001\t\u0007I\u0011A\u0017\u0002\u000b)$\u0016.\\3\u0016\u00039\u0002\"a\f\u001d\u000e\u0003AR!AJ\u0019\u000b\u0005I\u001a\u0014AB2p[6|gN\u0003\u0002\u0006i)\u0011QGN\u0001\u0007CB\f7\r[3\u000b\u0003]\n1a\u001c:h\u0013\tA\u0003\u0007\u0003\u0004;\u0001\u0001\u0006IAL\u0001\u0007URKW.\u001a\u0011\t\u000fq\u0002!\u0019!C\u0001{\u00059Q.\u001a;sS\u000e\u001cX#\u0001 \u0011\u0005}\nU\"\u0001!\u000b\u0005q\n\u0014B\u0001\"A\u0005\u001diU\r\u001e:jGNDa\u0001\u0012\u0001!\u0002\u0013q\u0014\u0001C7fiJL7m\u001d\u0011\t\u0013\u0019\u0003\u0001\u0019!a\u0001\n\u00039\u0015\u0001\u0003>l\u00072LWM\u001c;\u0016\u0003!\u0003\"!\u0013(\u000e\u0003)S!a\u0013'\u0002\u0011i\\7\r\\5f]RT!!\u0014\u001c\u0002\r%\u0003\u0014\n^3d\u0013\ty%J\u0001\u0005[W\u000ec\u0017.\u001a8u\u0011%\t\u0006\u00011AA\u0002\u0013\u0005!+\u0001\u0007{W\u000ec\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0002T-B\u0011\u0011\u0002V\u0005\u0003+*\u0011A!\u00168ji\"9q\u000bUA\u0001\u0002\u0004A\u0015a\u0001=%c!1\u0011\f\u0001Q!\n!\u000b\u0011B_6DY&,g\u000e\u001e\u0011\t\u0013m\u0003\u0001\u0019!a\u0001\n\u0003a\u0016a\u0002>l+RLGn]\u000b\u0002;B\u0011AEX\u0005\u0003?\u0016\u0012qAW6Vi&d7\u000fC\u0005b\u0001\u0001\u0007\t\u0019!C\u0001E\u0006Y!p[+uS2\u001cx\fJ3r)\t\u00196\rC\u0004XA\u0006\u0005\t\u0019A/\t\r\u0015\u0004\u0001\u0015)\u0003^\u0003!Q8.\u0016;jYN\u0004\u0003\"B4\u0001\t\u0003A\u0017!B:fiV\u0003H#A*)\u0005\u0019T\u0007CA6o\u001b\u0005a'BA77\u0003\u0015QWO\\5u\u0013\tyGN\u0001\u0004CK\u001a|'/\u001a\u0005\u0006c\u0002!\t\u0001[\u0001\ti\u0016\f'\u000fR8x]\"\u0012\u0001o\u001d\t\u0003WRL!!\u001e7\u0003\u000b\u00053G/\u001a:\t\u000b]\u0004A\u0011\u00015\u0002CQ,7\u000f\u001e%jO\"<\u0016\r^3s\u001b\u0006\u00148\u000eR5sK\u000e$xN]=NCB\u0004\u0018N\\4)\u0005YL\bCA6{\u0013\tYHN\u0001\u0003UKN$\b\"B?\u0001\t\u0003A\u0017!\u000b;fgRD\u0015n\u001a5xCR,'/T1sWJ+G.\u0019;jm\u0016$\u0015N]3di>\u0014\u00180T1qa&tw\r\u000b\u0002}s\"1\u0011\u0011\u0001\u0001\u0005\u0002!\fq\u0003^3ti&cG.Z4bYJ+\u0017/^5sK\u0012\f5m[:)\u0005}L\bBBA\u0004\u0001\u0011\u0005\u0001.\u0001\u0013uKN$8\t\\3beB+(oZ1u_JLxJ\u001c\"fG>l\u0017N\\4G_2dwn^3sQ\r\t)!\u001f\u0005\u0007\u0003\u001b\u0001A\u0011\u00015\u0002_Q,7\u000f\u001e$fi\u000eD')Z=p]\u0012D\u0015n\u001a5XCR,'/\\1sWJ+G/\u001e:o\u000b6\u0004H/\u001f*fgB|gn]3)\u0007\u0005-\u0011\u0010")
public class ReplicaManagerTest {
    private final String topic;
    private final kafka.utils.MockTime time = new kafka.utils.MockTime();
    private final MockTime jTime = new MockTime();
    private final Metrics metrics = new Metrics();
    private ZkClient zkClient;
    private ZkUtils zkUtils;

    public String topic() {
        return this.topic;
    }

    public kafka.utils.MockTime time() {
        return this.time;
    }

    public MockTime jTime() {
        return this.jTime;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public ZkClient zkClient() {
        return this.zkClient;
    }

    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Before
    public void setUp() {
        this.zkClient_$eq((ZkClient)EasyMock.createMock(ZkClient.class));
        this.zkUtils_$eq(ZkUtils$.MODULE$.apply(this.zkClient(), false));
    }

    @After
    public void tearDown() {
        this.metrics().close();
    }

    @Test
    public void testHighWaterMarkDirectoryMapping() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((File[])((TraversableOnce)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$1) {
                return new File(x$1);
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(File.class)), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (kafka.utils.Time)this.time(), (Time)this.jTime(), this.zkUtils(), (Scheduler)new MockScheduler(this.time()), mockLogMgr, new AtomicBoolean(false), ReplicaManager$.MODULE$.$lessinit$greater$default$9());
        try {
            Partition partition = rm.getOrCreatePartition(this.topic(), 1);
            partition.getOrCreateReplica(1);
            rm.checkpointHighWatermarks();
            return;
        }
        finally {
            rm.shutdown(false);
        }
    }

    @Test
    public void testHighwaterMarkRelativeDirectoryMapping() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((File[])((TraversableOnce)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$2) {
                return new File(x$2);
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(File.class)), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (kafka.utils.Time)this.time(), (Time)this.jTime(), this.zkUtils(), (Scheduler)new MockScheduler(this.time()), mockLogMgr, new AtomicBoolean(false), ReplicaManager$.MODULE$.$lessinit$greater$default$9());
        try {
            Partition partition = rm.getOrCreatePartition(this.topic(), 1);
            partition.getOrCreateReplica(1);
            rm.checkpointHighWatermarks();
            return;
        }
        finally {
            rm.shutdown(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIllegalRequiredAcks() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((File[])((TraversableOnce)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$3) {
                return new File(x$3);
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(File.class)), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (kafka.utils.Time)this.time(), (Time)this.jTime(), this.zkUtils(), (Scheduler)new MockScheduler(this.time()), mockLogMgr, new AtomicBoolean(false), Option$.MODULE$.apply((Object)this.getClass().getName()));
        try {
            rm.appendMessages(0L, (short)3, false, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicPartition("test1", 0)), (Object)new ByteBufferMessageSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("first message".getBytes())})))})), (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;

                public final void apply(Map<TopicPartition, ProduceResponse.PartitionResponse> responseStatus) {
                    this.$outer.kafka$server$ReplicaManagerTest$$callback$1(responseStatus);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.shutdown(false);
            throw throwable;
        }
        rm.shutdown(false);
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(this.getClass().getName());
    }

    @Test
    public void testClearPurgatoryOnBecomingFollower() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((File[])((TraversableOnce)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$4) {
                return new File(x$4);
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(File.class)), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (kafka.utils.Time)this.time(), (Time)this.jTime(), this.zkUtils(), (Scheduler)new MockScheduler(this.time()), mockLogMgr, new AtomicBoolean(false), ReplicaManager$.MODULE$.$lessinit$greater$default$9());
        try {
            BooleanRef produceCallbackFired = new BooleanRef(false);
            BooleanRef fetchCallbackFired = new BooleanRef(false);
            Seq aliveBrokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{new Broker(0, "host0", 0, Broker$.MODULE$.$lessinit$greater$default$4()), new Broker(1, "host1", 1, Broker$.MODULE$.$lessinit$greater$default$4())}));
            MetadataCache metadataCache = (MetadataCache)EasyMock.createMock(MetadataCache.class);
            EasyMock.expect((Object)metadataCache.getAliveBrokers()).andReturn((Object)aliveBrokers).anyTimes();
            EasyMock.replay((Object[])new Object[]{metadataCache});
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            java.util.Set brokerSet = (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            Partition partition = rm.getOrCreatePartition(this.topic(), 0);
            partition.getOrCreateReplica(0);
            LeaderAndIsrRequest leaderAndIsrRequest1 = new LeaderAndIsrRequest(0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new PartitionState(0, 0, 0, brokerList, 0, brokerSet))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava());
            rm.becomeLeaderOrFollower(0, leaderAndIsrRequest1, metadataCache, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$5, Iterable<Partition> x$6) {
                }
            });
            rm.getLeaderReplicaIfLocal(this.topic(), 0);
            rm.appendMessages(1000L, (short)-1, false, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new ByteBufferMessageSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("first message".getBytes())})))})), (Function1)new Serializable(this, produceCallbackFired){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final BooleanRef produceCallbackFired$1;

                public final void apply(Map<TopicPartition, ProduceResponse.PartitionResponse> responseStatus) {
                    this.$outer.kafka$server$ReplicaManagerTest$$produceCallback$1(responseStatus, this.produceCallbackFired$1);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.produceCallbackFired$1 = produceCallbackFired$1;
                }
            });
            rm.fetchMessages(1000L, -1, 100000, (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(this.topic(), 0)), (Object)new PartitionFetchInfo(0L, 100000))})), (Function1)new Serializable(this, fetchCallbackFired){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final BooleanRef fetchCallbackFired$1;

                public final void apply(Map<TopicAndPartition, FetchResponsePartitionData> responseStatus) {
                    this.$outer.kafka$server$ReplicaManagerTest$$fetchCallback$1(responseStatus, this.fetchCallbackFired$1);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.fetchCallbackFired$1 = fetchCallbackFired$1;
                }
            });
            LeaderAndIsrRequest leaderAndIsrRequest2 = new LeaderAndIsrRequest(0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new PartitionState(0, 1, 1, brokerList, 0, brokerSet))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava());
            rm.becomeLeaderOrFollower(1, leaderAndIsrRequest2, metadataCache, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$7, Iterable<Partition> x$8) {
                }
            });
            Assert.assertTrue((boolean)produceCallbackFired.elem);
            Assert.assertTrue((boolean)fetchCallbackFired.elem);
            return;
        }
        finally {
            rm.shutdown(false);
        }
    }

    @Test
    public void testFetchBeyondHighWatermarkReturnEmptyResponse() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        props.put("broker.id", BoxesRunTime.boxToInteger((int)0));
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((File[])((TraversableOnce)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$9) {
                return new File(x$9);
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(File.class)), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (kafka.utils.Time)this.time(), (Time)this.jTime(), this.zkUtils(), (Scheduler)new MockScheduler(this.time()), mockLogMgr, new AtomicBoolean(false), Option$.MODULE$.apply((Object)this.getClass().getName()));
        try {
            Seq aliveBrokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{new Broker(0, "host0", 0, Broker$.MODULE$.$lessinit$greater$default$4()), new Broker(1, "host1", 1, Broker$.MODULE$.$lessinit$greater$default$4()), new Broker(1, "host2", 2, Broker$.MODULE$.$lessinit$greater$default$4())}));
            MetadataCache metadataCache = (MetadataCache)EasyMock.createMock(MetadataCache.class);
            EasyMock.expect((Object)metadataCache.getAliveBrokers()).andReturn((Object)aliveBrokers).anyTimes();
            EasyMock.replay((Object[])new Object[]{metadataCache});
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava();
            java.util.Set brokerSet = (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava();
            Partition partition = rm.getOrCreatePartition(this.topic(), 0);
            partition.getOrCreateReplica(0);
            LeaderAndIsrRequest leaderAndIsrRequest1 = new LeaderAndIsrRequest(0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new PartitionState(0, 0, 0, brokerList, 0, brokerSet))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1), new Node(2, "host2", 2)}))).asJava());
            rm.becomeLeaderOrFollower(0, leaderAndIsrRequest1, metadataCache, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$10, Iterable<Partition> x$11) {
                }
            });
            rm.getLeaderReplicaIfLocal(this.topic(), 0);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 2).foreach$mVc$sp((Function1)new Serializable(this, rm){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final ReplicaManager rm$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    this.rm$1.appendMessages(1000L, (short)-1, false, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicPartition(this.$outer.topic(), 0)), (Object)new ByteBufferMessageSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message(new StringOps(Predef$.MODULE$.augmentString("message %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes())})))})), (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$1 $outer;

                        public final void apply(Map<TopicPartition, ProduceResponse.PartitionResponse> responseStatus) {
                            this.$outer.kafka$server$ReplicaManagerTest$$anonfun$$$outer().kafka$server$ReplicaManagerTest$$produceCallback$2(responseStatus);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                }

                public /* synthetic */ ReplicaManagerTest kafka$server$ReplicaManagerTest$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.rm$1 = rm$1;
                }
            });
            BooleanRef fetchCallbackFired = new BooleanRef(false);
            IntRef fetchError = new IntRef(0);
            ObjectRef fetchedMessages = new ObjectRef(null);
            rm.fetchMessages(1000L, 1, 0, (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(this.topic(), 0)), (Object)new PartitionFetchInfo(1L, 100000))})), (Function1)new Serializable(this, fetchCallbackFired, fetchError, fetchedMessages){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final BooleanRef fetchCallbackFired$2;
                private final IntRef fetchError$1;
                private final ObjectRef fetchedMessages$1;

                public final void apply(Map<TopicAndPartition, FetchResponsePartitionData> responseStatus) {
                    this.$outer.kafka$server$ReplicaManagerTest$$fetchCallback$2(responseStatus, this.fetchCallbackFired$2, this.fetchError$1, this.fetchedMessages$1);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.fetchCallbackFired$2 = fetchCallbackFired$2;
                    this.fetchError$1 = fetchError$1;
                    this.fetchedMessages$1 = fetchedMessages$1;
                }
            });
            Assert.assertTrue((boolean)fetchCallbackFired.elem);
            Assert.assertEquals((String)"Should not give an exception", (long)Errors.NONE.code(), (long)fetchError.elem);
            Assert.assertTrue((String)"Should return some data", (boolean)((MessageSet)fetchedMessages.elem).iterator().hasNext());
            fetchCallbackFired.elem = false;
            rm.fetchMessages(1000L, -1, 0, (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(this.topic(), 0)), (Object)new PartitionFetchInfo(1L, 100000))})), (Function1)new Serializable(this, fetchCallbackFired, fetchError, fetchedMessages){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final BooleanRef fetchCallbackFired$2;
                private final IntRef fetchError$1;
                private final ObjectRef fetchedMessages$1;

                public final void apply(Map<TopicAndPartition, FetchResponsePartitionData> responseStatus) {
                    this.$outer.kafka$server$ReplicaManagerTest$$fetchCallback$2(responseStatus, this.fetchCallbackFired$2, this.fetchError$1, this.fetchedMessages$1);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.fetchCallbackFired$2 = fetchCallbackFired$2;
                    this.fetchError$1 = fetchError$1;
                    this.fetchedMessages$1 = fetchedMessages$1;
                }
            });
            Assert.assertTrue((boolean)fetchCallbackFired.elem);
            Assert.assertEquals((String)"Should not give an exception", (long)Errors.NONE.code(), (long)fetchError.elem);
            Assert.assertEquals((String)"Should return empty response", (Object)MessageSet$.MODULE$.Empty(), (Object)((MessageSet)fetchedMessages.elem));
            return;
        }
        finally {
            rm.shutdown(false);
        }
    }

    public final void kafka$server$ReplicaManagerTest$$callback$1(Map responseStatus) {
        Predef$.MODULE$.assert(((ProduceResponse.PartitionResponse)responseStatus.values().head()).errorCode == Errors.INVALID_REQUIRED_ACKS.code());
    }

    public final void kafka$server$ReplicaManagerTest$$produceCallback$1(Map responseStatus, BooleanRef produceCallbackFired$1) {
        Assert.assertEquals((String)"Should give NotLeaderForPartitionException", (long)Errors.NOT_LEADER_FOR_PARTITION.code(), (long)((ProduceResponse.PartitionResponse)responseStatus.values().head()).errorCode);
        produceCallbackFired$1.elem = true;
    }

    public final void kafka$server$ReplicaManagerTest$$fetchCallback$1(Map responseStatus, BooleanRef fetchCallbackFired$1) {
        Assert.assertEquals((String)"Should give NotLeaderForPartitionException", (long)Errors.NOT_LEADER_FOR_PARTITION.code(), (long)((FetchResponsePartitionData)responseStatus.values().head()).error());
        fetchCallbackFired$1.elem = true;
    }

    public final void kafka$server$ReplicaManagerTest$$produceCallback$2(Map responseStatus) {
    }

    public final void kafka$server$ReplicaManagerTest$$fetchCallback$2(Map responseStatus, BooleanRef fetchCallbackFired$2, IntRef fetchError$1, ObjectRef fetchedMessages$1) {
        fetchError$1.elem = ((FetchResponsePartitionData)responseStatus.values().head()).error();
        fetchedMessages$1.elem = ((FetchResponsePartitionData)responseStatus.values().head()).messages();
        fetchCallbackFired$2.elem = true;
    }

    public ReplicaManagerTest() {
        this.topic = "test-topic";
    }
}

