/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import kafka.api.ApiVersion$;
import kafka.server.KafkaHealthcheck;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.kafka.common.utils.MockTime;
import org.apache.zookeeper.Watcher;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001}2A!\u0001\u0002\u0001\u000f\tI2+Z:tS>tW\t\u001f9je\u0016d\u0015n\u001d;f]\u0016\u0014H+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\b)\u0001\u0001\r\u0011\"\u0003\u0016\u0003\u0011!\u0018.\\3\u0016\u0003Y\u0001\"aF\u0011\u000e\u0003aQ!!\u0007\u000e\u0002\u000bU$\u0018\u000e\\:\u000b\u0005ma\u0012AB2p[6|gN\u0003\u0002\u0006;)\u0011adH\u0001\u0007CB\f7\r[3\u000b\u0003\u0001\n1a\u001c:h\u0013\t\u0011\u0003D\u0001\u0005N_\u000e\\G+[7f\u0011\u001d!\u0003\u00011A\u0005\n\u0015\n\u0001\u0002^5nK~#S-\u001d\u000b\u0003M%\u0002\"!C\u0014\n\u0005!R!\u0001B+oSRDqAK\u0012\u0002\u0002\u0003\u0007a#A\u0002yIEBa\u0001\f\u0001!B\u00131\u0012!\u0002;j[\u0016\u0004\u0003b\u0002\u0018\u0001\u0005\u0004%IaL\u0001\tEJ|7.\u001a:JIV\t\u0001\u0007\u0005\u0002\nc%\u0011!G\u0003\u0002\u0004\u0013:$\bB\u0002\u001b\u0001A\u0003%\u0001'A\u0005ce>\\WM]%eA!)a\u0007\u0001C\u0001o\u0005\u0001C/Z:u'\u0016\u001c8/[8o\u000bb\u0004\u0018N]3MSN$XM\\3s\u001b\u0016$(/[2t)\u00051\u0003FA\u001b:!\tQT(D\u0001<\u0015\tat$A\u0003kk:LG/\u0003\u0002?w\t!A+Z:u\u0001")
public class SessionExpireListenerTest {
    private MockTime time = new MockTime();
    private final int brokerId;

    private MockTime time() {
        return this.time;
    }

    private void time_$eq(MockTime x$1) {
        this.time = x$1;
    }

    private int brokerId() {
        return this.brokerId;
    }

    @Test
    public void testSessionExpireListenerMetrics() {
        MetricsRegistry metrics = Metrics.defaultRegistry();
        ZkClient zkClient = (ZkClient)EasyMock.mock(ZkClient.class);
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(zkClient, false);
        KafkaHealthcheck healthcheck = new KafkaHealthcheck(this.brokerId(), Predef$.MODULE$.Map().empty(), zkUtils, (Option)None$.MODULE$, ApiVersion$.MODULE$.latestVersion());
        String expiresPerSecName = "ZooKeeperExpiresPerSec";
        String disconnectsPerSecName = "ZooKeeperDisconnectsPerSec";
        this.checkMeterCount$1(expiresPerSecName, 0L, metrics);
        this.checkMeterCount$1(disconnectsPerSecName, 0L, metrics);
        healthcheck.sessionExpireListener().handleStateChanged(Watcher.Event.KeeperState.Expired);
        this.checkMeterCount$1(expiresPerSecName, 1L, metrics);
        this.checkMeterCount$1(disconnectsPerSecName, 0L, metrics);
        healthcheck.sessionExpireListener().handleStateChanged(Watcher.Event.KeeperState.Disconnected);
        this.checkMeterCount$1(expiresPerSecName, 1L, metrics);
        this.checkMeterCount$1(disconnectsPerSecName, 1L, metrics);
    }

    private final void checkMeterCount$1(String name, long expected, MetricsRegistry metrics$1) {
        Meter meter = (Meter)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(metrics$1.allMetrics()).asScala()).collectFirst((PartialFunction)new Serializable(this, name){
            public static final long serialVersionUID = 0L;
            private final String name$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<MetricName, Metric>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    MetricName metricName = (MetricName)A1._1();
                    Metric meter = (Metric)A1._2();
                    if (meter instanceof Meter) {
                        Meter meter2 = (Meter)meter;
                        String string = metricName.getName();
                        String string2 = this.name$1;
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            object = meter2;
                            return (B1)object;
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<MetricName, Metric> x1) {
                Tuple2<MetricName, Metric> tuple2 = x1;
                if (tuple2 == null) return false;
                MetricName metricName = (MetricName)tuple2._1();
                Metric meter = (Metric)tuple2._2();
                if (!(meter instanceof Meter)) return false;
                String string = metricName.getName();
                String string2 = this.name$1;
                if (string != null) {
                    if (!string.equals(string2)) return false;
                    return true;
                }
                if (string2 == null) return true;
                return false;
            }
            {
                this.name$1 = name$1;
            }
        }).getOrElse((Function0)new Serializable(this, name){
            public static final long serialVersionUID = 0L;
            private final String name$1;

            public final Nothing$ apply() {
                return package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find meter with name ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1})));
            }
            {
                this.name$1 = name$1;
            }
        });
        Assert.assertEquals((String)"Unexpected meter count", (long)expected, (long)meter.count());
    }

    public SessionExpireListenerTest() {
        this.brokerId = 1;
    }
}

