/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.admin;

import java.util.Properties;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u00055a\u0001B\u0001\u0003\u0001%\u0011QDU3bgNLwM\u001c)beRLG/[8og\u000ecWo\u001d;feR+7\u000f\u001e\u0006\u0003\u0007\u0011\tQ!\u00193nS:T!!\u0002\u0004\u0002\u000b-\fgm[1\u000b\u0003\u001d\tA!\u001e8ji\u000e\u00011\u0003\u0002\u0001\u000b)m\u0001\"a\u0003\n\u000e\u00031Q!!\u0004\b\u0002\u000b),h.\u001b;\u000b\u0005=\u0001\u0012!C:dC2\fG/Z:u\u0015\u0005\t\u0012aA8sO&\u00111\u0003\u0004\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0007CA\u000b\u001a\u001b\u00051\"BA\f\u0019\u0003\tQ8NC\u0001\u0006\u0013\tQbC\u0001\u000b[_>\\U-\u001a9feR+7\u000f\u001e%be:,7o\u001d\t\u00039}i\u0011!\b\u0006\u0003=a\tQ!\u001e;jYNL!\u0001I\u000f\u0003\u000f1{wmZ5oO\")!\u0005\u0001C\u0001G\u00051A(\u001b8jiz\"\u0012\u0001\n\t\u0003K\u0001i\u0011A\u0001\u0005\bO\u0001\u0011\r\u0011\"\u0001)\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\u0016\u0003%\u0002\"AK\u0017\u000e\u0003-R\u0011\u0001L\u0001\u0006g\u000e\fG.Y\u0005\u0003]-\u00121!\u00138u\u0011\u0019\u0001\u0004\u0001)A\u0005S\u0005a\u0001/\u0019:uSRLwN\\%eA!9!\u0007\u0001a\u0001\n\u0003\u0019\u0014aB:feZ,'o]\u000b\u0002iA\u0019Q\u0007\u000f\u001e\u000e\u0003YR!aN\u0016\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002:m\t\u00191+Z9\u0011\u0005mrT\"\u0001\u001f\u000b\u0005uB\u0012AB:feZ,'/\u0003\u0002@y\tY1*\u00194lCN+'O^3s\u0011\u001d\t\u0005\u00011A\u0005\u0002\t\u000b1b]3sm\u0016\u00148o\u0018\u0013fcR\u00111I\u0012\t\u0003U\u0011K!!R\u0016\u0003\tUs\u0017\u000e\u001e\u0005\b\u000f\u0002\u000b\t\u00111\u00015\u0003\rAH%\r\u0005\u0007\u0013\u0002\u0001\u000b\u0015\u0002\u001b\u0002\u0011M,'O^3sg\u0002Bqa\u0013\u0001C\u0002\u0013\u0005A*A\u0005u_BL7MT1nKV\tQ\n\u0005\u0002O'6\tqJ\u0003\u0002Q#\u0006!A.\u00198h\u0015\u0005\u0011\u0016\u0001\u00026bm\u0006L!\u0001V(\u0003\rM#(/\u001b8h\u0011\u00191\u0006\u0001)A\u0005\u001b\u0006QAo\u001c9jG:\u000bW.\u001a\u0011\t\u000ba\u0003A\u0011I-\u0002\u000bM,G/\u00169\u0015\u0003\rC#aV.\u0011\u0005qsV\"A/\u000b\u00055\u0001\u0012BA0^\u0005\u0019\u0011UMZ8sK\")\u0011\r\u0001C\u0001E\u0006a1\u000f^1si\n\u0013xn[3sgR\u00111i\u0019\u0005\u0006I\u0002\u0004\r!Z\u0001\nEJ|7.\u001a:JIN\u00042!\u000e\u001d*\u0011\u00159\u0007\u0001\"\u0011Z\u0003!!X-\u0019:E_^t\u0007F\u00014j!\ta&.\u0003\u0002l;\n)\u0011I\u001a;fe\")Q\u000e\u0001C\u0001]\u0006I2\u000f[8vY\u0012luN^3TS:<G.\u001a)beRLG/[8o+\u0005\u0019\u0005F\u00017q!\ta\u0016/\u0003\u0002s;\n!A+Z:u\u0011\u0015!\b\u0001\"\u0001Z\u0003M\u0019\bn\\;mI\u0016C\b/\u00198e\u00072,8\u000f^3sQ\t\u0019\b\u000fC\u0003x\u0001\u0011\u0005\u0011,A\ntQ>,H\u000eZ*ie&t7n\u00117vgR,'\u000f\u000b\u0002wa\")!\u0010\u0001C\u00013\u0006ar/Y5u\r>\u0014(+Z1tS\u001etW.\u001a8u)>\u001cu.\u001c9mKR,\u0007\"\u0002?\u0001\t\u0003i\u0018\u0001\u00026t_:$2A`A\u0005!\ry\u0018Q\u0001\b\u0004U\u0005\u0005\u0011bAA\u0002W\u00051\u0001K]3eK\u001aL1\u0001VA\u0004\u0015\r\t\u0019a\u000b\u0005\u0007\u0003\u0017Y\b\u0019\u0001@\u0002\u000bQ|\u0007/[2")
public class ReassignPartitionsClusterTest
extends JUnitSuite
implements ZooKeeperTestHarness {
    private final int partitionId;
    private Seq<KafkaServer> servers;
    private final String topicName;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ReassignPartitionsClusterTest reassignPartitionsClusterTest = this;
        synchronized (reassignPartitionsClusterTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public int partitionId() {
        return this.partitionId;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public String topicName() {
        return this.topicName;
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    public void startBrokers(Seq<Object> brokerIds) {
        this.servers_$eq((Seq<KafkaServer>)((Seq)((TraversableLike)brokerIds.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReassignPartitionsClusterTest $outer;

            public final Properties apply(int i) {
                return TestUtils$.MODULE$.createBrokerConfig(i, this.$outer.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties c) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(c), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom())));
    }

    @Override
    @After
    public void tearDown() {
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$1) {
                x$1.shutdown();
            }
        });
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                CoreUtils$.MODULE$.delete(server.config().logDirs());
            }
        });
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Test
    public void shouldMoveSinglePartition() {
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))));
        int partition = 0;
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})))}))), this.servers());
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"version\":1,\"partitions\":[{\"topic\":\"", "\",\"partition\":0,\"replicas\":[101]}]}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicName()})));
        this.waitForReasignmentToComplete();
        Assert.assertEquals((Object)((MapLike)this.zkUtils().getPartitionAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()}))).get((Object)this.topicName()).get()).apply((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101})));
    }

    @Test
    public void shouldExpandCluster() {
        int[] brokers = new int[]{100, 101, 102};
        this.startBrokers((Seq<Object>)Predef$.MODULE$.wrapIntArray(brokers));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.servers());
        Map newAssignment = (Map)ReassignPartitionsCommand$.MODULE$.generateAssignment(this.zkUtils(), (Seq)Predef$.MODULE$.wrapIntArray(brokers), this.json(this.topicName()), true)._1();
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), this.zkUtils().formatAsReassignmentJson(newAssignment));
        this.waitForReasignmentToComplete();
        Map actual = (Map)this.zkUtils().getPartitionAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()}))).apply((Object)this.topicName());
        Assert.assertEquals((Object)((SeqLike)((TraversableOnce)actual.values().flatten((Function1)Predef$.MODULE$.conforms())).toSeq().distinct()).sorted((Ordering)Ordering.Int$.MODULE$), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101, 102})));
    }

    @Test
    public void shouldShrinkCluster() {
        int[] brokers = new int[]{100, 101, 102};
        this.startBrokers((Seq<Object>)Predef$.MODULE$.wrapIntArray(brokers));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{102, 100})))}))), this.servers());
        Map newAssignment = (Map)ReassignPartitionsCommand$.MODULE$.generateAssignment(this.zkUtils(), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}), this.json(this.topicName()), true)._1();
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), this.zkUtils().formatAsReassignmentJson(newAssignment));
        this.waitForReasignmentToComplete();
        Map actual = (Map)this.zkUtils().getPartitionAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()}))).apply((Object)this.topicName());
        Assert.assertEquals((Object)((SeqLike)((TraversableOnce)actual.values().flatten((Function1)Predef$.MODULE$.conforms())).toSeq().distinct()).sorted((Ordering)Ordering.Int$.MODULE$), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})));
    }

    public void waitForReasignmentToComplete() {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReassignPartitionsClusterTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.$outer.zkUtils().pathExists(ZkUtils$.MODULE$.ReassignPartitionsPath());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Znode ", ".ReassignPartitionsPath wasn't deleted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkUtils()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
    }

    public String json(String topic) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"topics\": [{\"topic\": \"", "\"}],\"version\":1}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic}));
    }

    public ReassignPartitionsClusterTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        this.partitionId = 0;
        this.servers = null;
        this.topicName = "my-topic";
    }
}

