/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.common.BrokerNotAvailableException;
import kafka.common.KafkaException;
import kafka.utils.Json$;
import org.apache.kafka.common.protocol.SecurityProtocol;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.runtime.BoxesRunTime;

public final class Broker$
implements Serializable {
    public static final Broker$ MODULE$;

    static {
        new Broker$();
    }

    public Broker createBroker(int id, String brokerInfoString) {
        if (brokerInfoString == null) {
            throw new BrokerNotAvailableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker id ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id)})));
        }
        try {
            Option<Object> option = Json$.MODULE$.parseFull(brokerInfoString);
            if (option instanceof Some) {
                scala.collection.immutable.Map map;
                Some some = (Some)option;
                Object m = some.x();
                scala.collection.immutable.Map brokerInfo = (scala.collection.immutable.Map)m;
                int version = BoxesRunTime.unboxToInt((Object)brokerInfo.apply((Object)"version"));
                if (version < 1) {
                    throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported version of broker registration: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{brokerInfoString})));
                }
                if (version == 1) {
                    String host = (String)brokerInfo.apply((Object)"host");
                    int port = BoxesRunTime.unboxToInt((Object)brokerInfo.apply((Object)"port"));
                    map = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)SecurityProtocol.PLAINTEXT), (Object)new EndPoint(host, port, SecurityProtocol.PLAINTEXT))}));
                } else {
                    List listeners = (List)brokerInfo.apply((Object)"endpoints");
                    map = ((TraversableOnce)listeners.map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<SecurityProtocol, EndPoint> apply(String listener) {
                            EndPoint ep = EndPoint$.MODULE$.createEndPoint(listener);
                            return new Tuple2((Object)ep.protocolType(), (Object)ep);
                        }
                    }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
                }
                scala.collection.immutable.Map endpoints = map;
                Option rack = brokerInfo.get((Object)"rack").filter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Object x$1) {
                        return x$1 != null;
                    }
                }).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Object x$2) {
                        return (String)x$2;
                    }
                });
                Broker broker = new Broker(id, (Map<SecurityProtocol, EndPoint>)endpoints, (Option<String>)rack);
                return broker;
            }
            None$ none$ = None$.MODULE$;
            Option<Object> option2 = option;
            if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                throw new BrokerNotAvailableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker id ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id)})));
            }
            throw new MatchError(option);
        }
        catch (Throwable throwable) {
            throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to parse the broker info from zookeeper: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{brokerInfoString})), throwable);
        }
    }

    public Broker apply(int id, Map<SecurityProtocol, EndPoint> endPoints, Option<String> rack) {
        return new Broker(id, endPoints, rack);
    }

    public Option<Tuple3<Object, Map<SecurityProtocol, EndPoint>, Option<String>>> unapply(Broker x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)x$0.id()), x$0.endPoints(), x$0.rack()));
    }

    public SecurityProtocol $lessinit$greater$default$4() {
        return SecurityProtocol.PLAINTEXT;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Broker$() {
        MODULE$ = this;
    }
}

