/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminTest$;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.PreferredReplicaLeaderElectionCommand;
import kafka.admin.PreferredReplicaLeaderElectionCommand$;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareTest;
import kafka.admin.RackAwareTest$class;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReassignmentCompleted$;
import kafka.admin.ReassignmentStatus;
import kafka.admin.ReplicaDistributions;
import kafka.api.PartitionStateInfo;
import kafka.common.TopicAndPartition;
import kafka.controller.KafkaController;
import kafka.controller.ReassignedPartitionsContext;
import kafka.log.Defaults$;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\"\u00113nS:$Vm\u001d;\u000b\u0005\r!\u0011!B1e[&t'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M)\u0001\u0001\u0003\n\u0019=A\u0011\u0011\u0002E\u0007\u0002\u0015)\u00111\u0002D\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001b9\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003=\t1a\u001c:h\u0013\t\t\"B\u0001\u0006K+:LGoU;ji\u0016\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\u0005i\\\u0017BA\f\u0015\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tgB\u0011\u0011\u0004H\u0007\u00025)\u00111\u0004B\u0001\u0006kRLGn]\u0005\u0003;i\u0011q\u0001T8hO&tw\r\u0005\u0002 A5\t!!\u0003\u0002\"\u0005\ti!+Y2l\u0003^\f'/\u001a+fgRDQa\t\u0001\u0005\u0002\u0011\na\u0001P5oSRtD#A\u0013\u0011\u0005}\u0001\u0001\"B\u0014\u0001\t\u0003A\u0013!\u0006;fgR\u0014V\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e\u000b\u0002SA\u0011!&L\u0007\u0002W)\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/W\t!QK\\5uQ\t1\u0003\u0007\u0005\u00022g5\t!G\u0003\u0002\f\u001d%\u0011AG\r\u0002\u0005)\u0016\u001cH\u000fC\u00037\u0001\u0011\u0005\u0001&A\u000euKN$X*\u00198vC2\u0014V\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e\u0015\u0003kABQ!\u000f\u0001\u0005\u0002!\nQ\u0003^3tiR{\u0007/[2De\u0016\fG/[8o\u0013:T6\n\u000b\u00029a!)A\b\u0001C\u0001Q\u0005qB/Z:u)>\u0004\u0018nY\"sK\u0006$\u0018n\u001c8XSRD7i\u001c7mSNLwN\u001c\u0015\u0003wABQa\u0010\u0001\u0005\n\u0001\u000b!dZ3u\u0005J|7.\u001a:t/&$\b\u000eU1si&$\u0018n\u001c8ESJ$B!Q&`IB\u0019!)\u0012%\u000f\u0005)\u001a\u0015B\u0001#,\u0003\u0019\u0001&/\u001a3fM&\u0011ai\u0012\u0002\u0004'\u0016$(B\u0001#,!\tQ\u0013*\u0003\u0002KW\t\u0019\u0011J\u001c;\t\u000b1s\u0004\u0019A'\u0002\u000fM,'O^3sgB\u0019aJV-\u000f\u0005=#fB\u0001)T\u001b\u0005\t&B\u0001*\u0007\u0003\u0019a$o\\8u}%\tA&\u0003\u0002VW\u00059\u0001/Y2lC\u001e,\u0017BA,Y\u0005!IE/\u001a:bE2,'BA+,!\tQV,D\u0001\\\u0015\taF!\u0001\u0004tKJ4XM]\u0005\u0003=n\u00131bS1gW\u0006\u001cVM\u001d<fe\")\u0001M\u0010a\u0001C\u0006)Ao\u001c9jGB\u0011!IY\u0005\u0003G\u001e\u0013aa\u0015;sS:<\u0007\"B3?\u0001\u0004A\u0015a\u00039beRLG/[8o\u0013\u0012DQa\u001a\u0001\u0005\u0002!\n\u0001\u0007^3tiB\u000b'\u000f^5uS>t'+Z1tg&<g.\\3oi^KG\u000f\u001b'fC\u0012,'/\u00138OK^\u0014V\r\u001d7jG\u0006\u001c\bF\u000141\u0011\u0015Q\u0007\u0001\"\u0001)\u0003M\"Xm\u001d;QCJ$\u0018\u000e^5p]J+\u0017m]:jO:lWM\u001c;XSRDG*Z1eKJtu\u000e^%o\u001d\u0016<(+\u001a9mS\u000e\f7\u000f\u000b\u0002ja!)Q\u000e\u0001C\u0001Q\u0005yC/Z:u!\u0006\u0014H/\u001b;j_:\u0014V-Y:tS\u001etW.\u001a8u\u001d>twJ^3sY\u0006\u0004\b/\u001b8h%\u0016\u0004H.[2bg\"\u0012A\u000e\r\u0005\u0006a\u0002!\t\u0001K\u0001$i\u0016\u001cHOU3bgNLwM\\5oO:{g.\u0012=jgRLgn\u001a)beRLG/[8oQ\ty\u0007\u0007C\u0003t\u0001\u0011\u0005\u0001&A\u0018uKN$(+Z:v[\u0016\u0004\u0016M\u001d;ji&|gNU3bgNLwM\\7f]R$\u0006.\u0019;XCN\u001cu.\u001c9mKR,G\r\u000b\u0002sa!)a\u000f\u0001C\u0001Q\u0005aB/Z:u!J,g-\u001a:sK\u0012\u0014V\r\u001d7jG\u0006T5o\u001c8ECR\f\u0007FA;1\u0011\u0015I\b\u0001\"\u0001)\u0003\u0005\"Xm\u001d;CCNL7\r\u0015:fM\u0016\u0014(/\u001a3SKBd\u0017nY1FY\u0016\u001cG/[8oQ\tA\b\u0007C\u0003}\u0001\u0011\u0005\u0001&\u0001\nuKN$8\u000b[;uI><hN\u0011:pW\u0016\u0014\bFA>1\u0011\u0015y\b\u0001\"\u0001)\u0003U!Xm\u001d;U_BL7mQ8oM&<7\t[1oO\u0016D#A \u0019\t\r\u0005\u0015\u0001\u0001\"\u0001)\u0003\r\u001a\bn\\;mIB\u0013x\u000e]1hCR,G)\u001f8b[&\u001c'I]8lKJ\u001cuN\u001c4jOND3!a\u00011\u0011\u0019\tY\u0001\u0001C\u0001Q\u0005YB/Z:u\u0005>|Go\u001d;sCB\u001cE.[3oi&#7i\u001c8gS\u001eD3!!\u00031\u0011\u0019\t\t\u0002\u0001C\u0001Q\u00051B/Z:u\u000f\u0016$(I]8lKJlU\r^1eCR\f7\u000fK\u0002\u0002\u0010A\u0002")
public class AdminTest
extends JUnitSuite
implements ZooKeeperTestHarness,
RackAwareTest {
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest$class.checkReplicaDistribution(this, assignment, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping) {
        return RackAwareTest$class.getReplicaDistribution(this, assignment, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest$class.toBrokerMetadata(this, rackMap, brokersWithoutRack);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest$class.checkReplicaDistribution$default$6(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest$class.checkReplicaDistribution$default$7(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest$class.checkReplicaDistribution$default$8(this);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest$class.toBrokerMetadata$default$2(this);
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    @After
    public void tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        AdminTest adminTest = this;
        synchronized (adminTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    @Test
    public void testReplicaAssignment() {
        IndexedSeq brokerMetadatas = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(int x$1) {
                return new BrokerMetadata(x$1, (Option)None$.MODULE$);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        this.intercept((Function0)new Serializable(this, brokerMetadatas){
            public static final long serialVersionUID = 0L;
            private final IndexedSeq brokerMetadatas$1;

            public final Map<Object, Seq<Object>> apply() {
                return AdminUtils$.MODULE$.assignReplicasToBrokers((Seq)this.brokerMetadatas$1, 10, 0, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
            }
            {
                this.brokerMetadatas$1 = brokerMetadatas$1;
            }
        }, ManifestFactory$.MODULE$.classType(InvalidReplicationFactorException.class));
        this.intercept((Function0)new Serializable(this, brokerMetadatas){
            public static final long serialVersionUID = 0L;
            private final IndexedSeq brokerMetadatas$1;

            public final Map<Object, Seq<Object>> apply() {
                return AdminUtils$.MODULE$.assignReplicasToBrokers((Seq)this.brokerMetadatas$1, 10, 6, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
            }
            {
                this.brokerMetadatas$1 = brokerMetadatas$1;
            }
        }, ManifestFactory$.MODULE$.classType(InvalidReplicationFactorException.class));
        Map expectedAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 1, 2})))}));
        Map actualAssignment = AdminUtils$.MODULE$.assignReplicasToBrokers((Seq)brokerMetadatas, 10, 3, 0, AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
        Assert.assertEquals((Object)expectedAssignment, (Object)actualAssignment);
    }

    @Test
    public void testManualReplicaAssignment() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkUtils(), (Seq<Object>)brokers);
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.$outer.zkUtils(), "test", (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 0})))})), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ManifestFactory$.MODULE$.classType(InvalidReplicaAssignmentException.class));
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.$outer.zkUtils(), "test", (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))})), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ManifestFactory$.MODULE$.classType(InvalidReplicaAssignmentException.class));
        Map assignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))}));
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), "test", assignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        scala.collection.mutable.Map found = this.zkUtils().getPartitionAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test"})));
        Assert.assertEquals((Object)assignment, (Object)found.apply((Object)"test"));
    }

    @Test
    public void testTopicCreationInZK() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4})))}));
        scala.collection.immutable.Map leaderForPartitionMap = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)BoxesRunTime.boxToInteger((int)1))}));
        String topic = "test";
        TestUtils$.MODULE$.createBrokersInZk(this.zkUtils(), (Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4})));
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        TestUtils$.MODULE$.makeLeaderForPartition(this.zkUtils(), topic, (scala.collection.immutable.Map<Object, Object>)leaderForPartitionMap, 1);
        scala.collection.immutable.Map actualReplicaList = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps((int[])leaderForPartitionMap.keys().toArray(ClassTag$.MODULE$.Int())).map((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final String topic$1;

            public final Tuple2<Object, Seq<Object>> apply(int p) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)p)), (Object)this.$outer.zkUtils().getReplicasForPartition(this.topic$1, p));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.conforms());
        Assert.assertEquals((long)expectedReplicaAssignment.size(), (long)actualReplicaList.size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), actualReplicaList.size()).foreach$mVc$sp((Function1)new Serializable(this, expectedReplicaAssignment, actualReplicaList){
            public static final long serialVersionUID = 0L;
            private final Map expectedReplicaAssignment$1;
            private final scala.collection.immutable.Map actualReplicaList$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((Object)this.expectedReplicaAssignment$1.get((Object)BoxesRunTime.boxToInteger((int)i)).get(), (Object)this.actualReplicaList$1.apply((Object)BoxesRunTime.boxToInteger((int)i)));
            }
            {
                this.expectedReplicaAssignment$1 = expectedReplicaAssignment$1;
                this.actualReplicaList$1 = actualReplicaList$1;
            }
        });
        this.intercept((Function0)new Serializable(this, expectedReplicaAssignment, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final Map expectedReplicaAssignment$1;
            private final String topic$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.$outer.zkUtils(), this.topic$1, this.expectedReplicaAssignment$1, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.expectedReplicaAssignment$1 = expectedReplicaAssignment$1;
                this.topic$1 = topic$1;
            }
        }, ManifestFactory$.MODULE$.classType(TopicExistsException.class));
    }

    @Test
    public void testTopicCreationWithCollision() {
        String topic = "test.topic";
        String collidingTopic = "test_topic";
        TestUtils$.MODULE$.createBrokersInZk(this.zkUtils(), (Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4})));
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), topic, 3, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.intercept((Function0)new Serializable(this, collidingTopic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final String collidingTopic$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AdminUtils$.MODULE$.createTopic(this.$outer.zkUtils(), this.collidingTopic$1, 3, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.collidingTopic$1 = collidingTopic$1;
            }
        }, ManifestFactory$.MODULE$.classType(InvalidTopicException.class));
    }

    public scala.collection.immutable.Set<Object> kafka$admin$AdminTest$$getBrokersWithPartitionDir(Iterable<KafkaServer> servers, String topic, int partitionId) {
        return ((TraversableOnce)((TraversableLike)servers.filter((Function1)new Serializable(this, topic, partitionId){
            public static final long serialVersionUID = 0L;
            private final String topic$2;
            private final int partitionId$1;

            public final boolean apply(KafkaServer server) {
                return new File((String)server.config().logDirs().head(), new StringBuilder().append((Object)this.topic$2).append((Object)"-").append((Object)BoxesRunTime.boxToInteger((int)this.partitionId$1)).toString()).exists();
            }
            {
                this.topic$2 = topic$2;
                this.partitionId$1 = partitionId$1;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$2) {
                return x$2.config().brokerId();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    @Test
    public void testPartitionReassignmentWithLeaderInNewReplicas() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        Seq servers = (Seq)TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3}));
        int partitionToBeReassigned = 0;
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partitionToBeReassigned);
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(this.zkUtils(), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)})));
        Assert.assertTrue((String)"Partition reassignment attempt failed for [test, 0]", (boolean)reassignPartitionsCommand.reassignPartitions(reassignPartitionsCommand.reassignPartitions$default$1()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, newReplicas, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final Seq newReplicas$1;
            private final TopicAndPartition topicAndPartition$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Map partitionsBeingReassigned = this.$outer.zkUtils().getPartitionsBeingReassigned().mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Object> apply(ReassignedPartitionsContext x$3) {
                        return x$3.newReplicas();
                    }
                });
                ReassignmentStatus reassignmentStatus = ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.$outer.zkUtils(), this.topicAndPartition$1, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.topicAndPartition$1), (Object)this.newReplicas$1)})), partitionsBeingReassigned);
                ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
                return !(reassignmentStatus != null ? !reassignmentStatus.equals(reassignmentCompleted$) : reassignmentCompleted$ != null);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.newReplicas$1 = newReplicas$1;
                this.topicAndPartition$1 = topicAndPartition$1;
            }
        }, "Partition reassignment should complete", TestUtils$.MODULE$.waitUntilTrue$default$3());
        Seq assignedReplicas = this.zkUtils().getReplicasForPartition(topic, partitionToBeReassigned);
        TestUtils$.MODULE$.checkForPhantomInSyncReplicas(this.zkUtils(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas);
        Assert.assertEquals((String)"Partition should have been reassigned to 0, 2, 3", (Object)newReplicas, (Object)assignedReplicas);
        TestUtils$.MODULE$.ensureNoUnderReplicatedPartitions(this.zkUtils(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas, (Seq<KafkaServer>)servers);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, servers, newReplicas){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final String topic$3;
            private final Seq servers$1;
            private final Seq newReplicas$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                scala.collection.immutable.Set<Object> set = this.$outer.kafka$admin$AdminTest$$getBrokersWithPartitionDir((Iterable<KafkaServer>)this.servers$1, this.topic$3, 0);
                scala.collection.immutable.Set set2 = this.newReplicas$1.toSet();
                return !(set != null ? !set.equals((Object)set2) : set2 != null);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topic$3 = topic$3;
                this.servers$1 = servers$1;
                this.newReplicas$1 = newReplicas$1;
            }
        }, "New replicas should exist on brokers", TestUtils$.MODULE$.waitUntilTrue$default$3());
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$4) {
                x$4.shutdown();
            }
        });
    }

    @Test
    public void testPartitionReassignmentWithLeaderNotInNewReplicas() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        Seq servers = (Seq)TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        int partitionToBeReassigned = 0;
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partitionToBeReassigned);
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(this.zkUtils(), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)})));
        Assert.assertTrue((String)"Partition reassignment failed for test, 0", (boolean)reassignPartitionsCommand.reassignPartitions(reassignPartitionsCommand.reassignPartitions$default$1()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, newReplicas, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final Seq newReplicas$2;
            private final TopicAndPartition topicAndPartition$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Map partitionsBeingReassigned = this.$outer.zkUtils().getPartitionsBeingReassigned().mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Object> apply(ReassignedPartitionsContext x$5) {
                        return x$5.newReplicas();
                    }
                });
                ReassignmentStatus reassignmentStatus = ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.$outer.zkUtils(), this.topicAndPartition$2, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.topicAndPartition$2), (Object)this.newReplicas$2)})), partitionsBeingReassigned);
                ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
                return !(reassignmentStatus != null ? !reassignmentStatus.equals(reassignmentCompleted$) : reassignmentCompleted$ != null);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.newReplicas$2 = newReplicas$2;
                this.topicAndPartition$2 = topicAndPartition$2;
            }
        }, "Partition reassignment should complete", TestUtils$.MODULE$.waitUntilTrue$default$3());
        Seq assignedReplicas = this.zkUtils().getReplicasForPartition(topic, partitionToBeReassigned);
        Assert.assertEquals((String)"Partition should have been reassigned to 0, 2, 3", (Object)newReplicas, (Object)assignedReplicas);
        TestUtils$.MODULE$.checkForPhantomInSyncReplicas(this.zkUtils(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas);
        TestUtils$.MODULE$.ensureNoUnderReplicatedPartitions(this.zkUtils(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas, (Seq<KafkaServer>)servers);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, servers, newReplicas){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final String topic$4;
            private final Seq servers$2;
            private final Seq newReplicas$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                scala.collection.immutable.Set<Object> set = this.$outer.kafka$admin$AdminTest$$getBrokersWithPartitionDir((Iterable<KafkaServer>)this.servers$2, this.topic$4, 0);
                scala.collection.immutable.Set set2 = this.newReplicas$2.toSet();
                return !(set != null ? !set.equals((Object)set2) : set2 != null);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topic$4 = topic$4;
                this.servers$2 = servers$2;
                this.newReplicas$2 = newReplicas$2;
            }
        }, "New replicas should exist on brokers", TestUtils$.MODULE$.waitUntilTrue$default$3());
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$6) {
                x$6.shutdown();
            }
        });
    }

    @Test
    public void testPartitionReassignmentNonOverlappingReplicas() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}));
        String topic = "test";
        Seq servers = (Seq)TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}));
        int partitionToBeReassigned = 0;
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partitionToBeReassigned);
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(this.zkUtils(), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)})));
        Assert.assertTrue((String)"Partition reassignment failed for test, 0", (boolean)reassignPartitionsCommand.reassignPartitions(reassignPartitionsCommand.reassignPartitions$default$1()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, newReplicas, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final Seq newReplicas$3;
            private final TopicAndPartition topicAndPartition$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Map partitionsBeingReassigned = this.$outer.zkUtils().getPartitionsBeingReassigned().mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Object> apply(ReassignedPartitionsContext x$7) {
                        return x$7.newReplicas();
                    }
                });
                ReassignmentStatus reassignmentStatus = ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.$outer.zkUtils(), this.topicAndPartition$3, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.topicAndPartition$3), (Object)this.newReplicas$3)})), partitionsBeingReassigned);
                ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
                return !(reassignmentStatus != null ? !reassignmentStatus.equals(reassignmentCompleted$) : reassignmentCompleted$ != null);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.newReplicas$3 = newReplicas$3;
                this.topicAndPartition$3 = topicAndPartition$3;
            }
        }, "Partition reassignment should complete", TestUtils$.MODULE$.waitUntilTrue$default$3());
        Seq assignedReplicas = this.zkUtils().getReplicasForPartition(topic, partitionToBeReassigned);
        Assert.assertEquals((String)"Partition should have been reassigned to 2, 3", (Object)newReplicas, (Object)assignedReplicas);
        TestUtils$.MODULE$.checkForPhantomInSyncReplicas(this.zkUtils(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas);
        TestUtils$.MODULE$.ensureNoUnderReplicatedPartitions(this.zkUtils(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas, (Seq<KafkaServer>)servers);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, servers, newReplicas){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final String topic$5;
            private final Seq servers$3;
            private final Seq newReplicas$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                scala.collection.immutable.Set<Object> set = this.$outer.kafka$admin$AdminTest$$getBrokersWithPartitionDir((Iterable<KafkaServer>)this.servers$3, this.topic$5, 0);
                scala.collection.immutable.Set set2 = this.newReplicas$3.toSet();
                return !(set != null ? !set.equals((Object)set2) : set2 != null);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topic$5 = topic$5;
                this.servers$3 = servers$3;
                this.newReplicas$3 = newReplicas$3;
            }
        }, "New replicas should exist on brokers", TestUtils$.MODULE$.waitUntilTrue$default$3());
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$8) {
                x$8.shutdown();
            }
        });
    }

    @Test
    public void testReassigningNonExistingPartition() {
        String topic = "test";
        Seq servers = (Seq)TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}));
        int partitionToBeReassigned = 0;
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partitionToBeReassigned);
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(this.zkUtils(), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)})));
        Assert.assertFalse((String)"Partition reassignment failed for test, 0", (boolean)reassignPartitionsCommand.reassignPartitions(reassignPartitionsCommand.reassignPartitions$default$1()));
        Map reassignedPartitions = this.zkUtils().getPartitionsBeingReassigned();
        Assert.assertFalse((String)"Partition should not be reassigned", (boolean)reassignedPartitions.contains((Object)topicAndPartition));
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$9) {
                x$9.shutdown();
            }
        });
    }

    @Test
    public void testResumePartitionReassignmentThatWasCompleted() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}));
        String topic = "test";
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
        int partitionToBeReassigned = 0;
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partitionToBeReassigned);
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(this.zkUtils(), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)})));
        reassignPartitionsCommand.reassignPartitions(reassignPartitionsCommand.reassignPartitions$default$1());
        Seq servers = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !TestUtils$.MODULE$.checkIfReassignPartitionPathExists(this.$outer.zkUtils());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, "Partition reassignment should complete", TestUtils$.MODULE$.waitUntilTrue$default$3());
        Seq assignedReplicas = this.zkUtils().getReplicasForPartition(topic, partitionToBeReassigned);
        Assert.assertEquals((String)"Partition should have been reassigned to 0, 1", (Object)newReplicas, (Object)assignedReplicas);
        TestUtils$.MODULE$.checkForPhantomInSyncReplicas(this.zkUtils(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas);
        TestUtils$.MODULE$.ensureNoUnderReplicatedPartitions(this.zkUtils(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas, (Seq<KafkaServer>)servers);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, newReplicas, servers){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final String topic$6;
            private final Seq newReplicas$4;
            private final Seq servers$4;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                scala.collection.immutable.Set<Object> set = this.$outer.kafka$admin$AdminTest$$getBrokersWithPartitionDir((Iterable<KafkaServer>)this.servers$4, this.topic$6, 0);
                scala.collection.immutable.Set set2 = this.newReplicas$4.toSet();
                return !(set != null ? !set.equals((Object)set2) : set2 != null);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topic$6 = topic$6;
                this.newReplicas$4 = newReplicas$4;
                this.servers$4 = servers$4;
            }
        }, "New replicas should exist on brokers", TestUtils$.MODULE$.waitUntilTrue$default$3());
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$10) {
                x$10.shutdown();
            }
        });
    }

    @Test
    public void testPreferredReplicaJsonData() {
        scala.collection.immutable.Set partitionsForPreferredReplicaElection = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{new TopicAndPartition("test", 1), new TopicAndPartition("test2", 1)}));
        PreferredReplicaLeaderElectionCommand$.MODULE$.writePreferredReplicaElectionData(this.zkUtils(), (Set)partitionsForPreferredReplicaElection);
        String preferredReplicaElectionZkData = (String)this.zkUtils().readData(ZkUtils$.MODULE$.PreferredReplicaLeaderElectionPath())._1();
        scala.collection.immutable.Set partitionsUndergoingPreferredReplicaElection = PreferredReplicaLeaderElectionCommand$.MODULE$.parsePreferredReplicaElectionData(preferredReplicaElectionZkData);
        Assert.assertEquals((String)"Preferred replica election ser-de failed", (Object)partitionsForPreferredReplicaElection, (Object)partitionsUndergoingPreferredReplicaElection);
    }

    @Test
    public void testBasicPreferredReplicaElection() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        int partition = 1;
        int preferredReplica = 0;
        Map brokerRack = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2")}));
        int x$24 = 3;
        String x$25 = this.zkConnect();
        boolean x$26 = false;
        Map x$27 = brokerRack;
        boolean x$28 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        Option<SecurityProtocol> x$29 = TestUtils$.MODULE$.createBrokerConfigs$default$5();
        Option<File> x$30 = TestUtils$.MODULE$.createBrokerConfigs$default$6();
        Option<Properties> x$31 = TestUtils$.MODULE$.createBrokerConfigs$default$7();
        boolean x$32 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$33 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$34 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$35 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        Seq serverConfigs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$24, x$25, x$26, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, (Map<Object, String>)x$27).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom());
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        Seq servers = (Seq)serverConfigs.reverseMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(KafkaConfig s) {
                return TestUtils$.MODULE$.createServer(s, TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
        ZkUtils x$36 = this.zkUtils();
        String x$37 = topic;
        int x$38 = partition;
        None$ x$39 = None$.MODULE$;
        long x$40 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$41 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        int currentLeader = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$36, x$37, x$38, x$40, (Option<Object>)x$39, x$41).get());
        PreferredReplicaLeaderElectionCommand preferredReplicaElection = new PreferredReplicaLeaderElectionCommand(this.zkUtils(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{new TopicAndPartition(topic, partition)})));
        preferredReplicaElection.moveLeaderToPreferredReplica();
        ZkUtils x$42 = this.zkUtils();
        String x$43 = topic;
        int x$44 = partition;
        Some x$45 = new Some((Object)BoxesRunTime.boxToInteger((int)currentLeader));
        long x$46 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$47 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        int newLeader = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$42, x$43, x$44, x$46, (Option<Object>)x$45, x$47).get());
        Assert.assertEquals((String)"Preferred replica election failed", (long)preferredReplica, (long)newLeader);
        servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$11) {
                x$11.shutdown();
            }
        });
    }

    @Test
    public void testShutdownBroker() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        int partition = 1;
        Seq serverConfigs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq servers = (Seq)serverConfigs.reverseMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(KafkaConfig s) {
                return TestUtils$.MODULE$.createServer(s, TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, (Seq<KafkaServer>)servers);
        int controllerId = this.zkUtils().getController();
        KafkaController controller = ((KafkaServer)servers.find((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$1;

            public final boolean apply(KafkaServer p) {
                return p.config().brokerId() == this.controllerId$1;
            }
            {
                this.controllerId$1 = controllerId$1;
            }
        }).get()).kafkaController();
        Set partitionsRemaining = controller.shutdownBroker(2);
        ObjectRef activeServers = new ObjectRef((Object)((Seq)servers.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() != 2;
            }
        })));
        try {
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, partition, activeServers){
                public static final long serialVersionUID = 0L;
                public final String topic$7;
                public final int partition$1;
                private final ObjectRef activeServers$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return ((Seq)this.activeServers$1.elem).forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testShutdownBroker$1 $outer;

                        public final boolean apply(KafkaServer x$12) {
                            return ((PartitionStateInfo)x$12.apis().metadataCache().getPartitionInfo(this.$outer.topic$7, this.$outer.partition$1).get()).leaderIsrAndControllerEpoch().leaderAndIsr().isr().size() != 3;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.topic$7 = topic$7;
                    this.partition$1 = partition$1;
                    this.activeServers$1 = activeServers$1;
                }
            }, "Topic test not created after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3());
            Assert.assertEquals((long)0L, (long)partitionsRemaining.size());
            PartitionStateInfo partitionStateInfo = (PartitionStateInfo)((KafkaServer)((Seq)activeServers.elem).head()).apis().metadataCache().getPartitionInfo(topic, partition).get();
            int leaderAfterShutdown = partitionStateInfo.leaderIsrAndControllerEpoch().leaderAndIsr().leader();
            Assert.assertEquals((long)0L, (long)leaderAfterShutdown);
            Assert.assertEquals((long)2L, (long)partitionStateInfo.leaderIsrAndControllerEpoch().leaderAndIsr().isr().size());
            Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)partitionStateInfo.leaderIsrAndControllerEpoch().leaderAndIsr().isr());
            partitionsRemaining = controller.shutdownBroker(1);
            Assert.assertEquals((long)0L, (long)partitionsRemaining.size());
            activeServers.elem = (Seq)servers.filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(KafkaServer s) {
                    return s.config().brokerId() == 0;
                }
            });
            partitionStateInfo = (PartitionStateInfo)((KafkaServer)((Seq)activeServers.elem).head()).apis().metadataCache().getPartitionInfo(topic, partition).get();
            leaderAfterShutdown = partitionStateInfo.leaderIsrAndControllerEpoch().leaderAndIsr().leader();
            Assert.assertEquals((long)0L, (long)leaderAfterShutdown);
            Assert.assertTrue((boolean)servers.forall((Function1)new Serializable(this, topic, partition){
                public static final long serialVersionUID = 0L;
                private final String topic$7;
                private final int partition$1;

                public final boolean apply(KafkaServer x$13) {
                    return ((PartitionStateInfo)x$13.apis().metadataCache().getPartitionInfo(this.topic$7, this.partition$1).get()).leaderIsrAndControllerEpoch().leaderAndIsr().leader() == 0;
                }
                {
                    this.topic$7 = topic$7;
                    this.partition$1 = partition$1;
                }
            }));
            partitionsRemaining = controller.shutdownBroker(0);
            Assert.assertEquals((long)1L, (long)partitionsRemaining.size());
            Assert.assertTrue((boolean)servers.forall((Function1)new Serializable(this, topic, partition){
                public static final long serialVersionUID = 0L;
                private final String topic$7;
                private final int partition$1;

                public final boolean apply(KafkaServer x$14) {
                    return ((PartitionStateInfo)x$14.apis().metadataCache().getPartitionInfo(this.topic$7, this.partition$1).get()).leaderIsrAndControllerEpoch().leaderAndIsr().leader() == 0;
                }
                {
                    this.topic$7 = topic$7;
                    this.partition$1 = partition$1;
                }
            }));
        }
        catch (Throwable throwable) {
            servers.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(KafkaServer x$15) {
                    x$15.shutdown();
                }
            });
            throw throwable;
        }
        servers.foreach((Function1)new /* invalid duplicate definition of identical inner class */);
    }

    @Test
    public void testTopicConfigChange() {
        int partitions = 3;
        String topic = "my-topic";
        KafkaServer server = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16())), TestUtils$.MODULE$.createServer$default$2());
        try {
            int maxMessageSize = 1024;
            int retentionMs = 1000000;
            AdminUtils$.MODULE$.createTopic(server.zkUtils(), topic, partitions, 1, this.makeConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1"), AdminUtils$.MODULE$.createTopic$default$6());
            this.checkConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1", false, partitions, topic, server);
            AdminUtils$.MODULE$.changeTopicConfig(server.zkUtils(), topic, this.makeConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1"));
            this.checkConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1", true, partitions, topic, server);
            Properties newConfig = this.makeConfig$1(2 * maxMessageSize, 2 * retentionMs, "*", "*");
            AdminUtils$.MODULE$.changeTopicConfig(server.zkUtils(), topic, this.makeConfig$1(2 * maxMessageSize, 2 * retentionMs, "*", "*"));
            this.checkConfig$1(2 * maxMessageSize, 2 * retentionMs, "*", "*", true, partitions, topic, server);
            Properties configInZk = AdminUtils$.MODULE$.fetchEntityConfig(server.zkUtils(), ConfigType$.MODULE$.Topic(), topic);
            Assert.assertEquals((Object)newConfig, (Object)configInZk);
            AdminUtils$.MODULE$.changeTopicConfig(server.zkUtils(), topic, new Properties());
            this.checkConfig$1(Defaults$.MODULE$.MaxMessageSize(), Defaults$.MODULE$.RetentionMs(), "", "", false, partitions, topic, server);
            AdminUtils$.MODULE$.changeTopicConfig(server.zkUtils(), topic, this.makeConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1"));
            this.checkConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1", true, partitions, topic, server);
            AdminUtils$.MODULE$.changeTopicConfig(server.zkUtils(), topic, CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), (Object)""), new Tuple2((Object)LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), (Object)"")})));
            this.checkConfig$1(Defaults$.MODULE$.MaxMessageSize(), Defaults$.MODULE$.RetentionMs(), "", "", false, partitions, topic, server);
            return;
        }
        finally {
            server.shutdown();
            CoreUtils$.MODULE$.delete(server.config().logDirs());
        }
    }

    @Test
    public void shouldPropagateDynamicBrokerConfigs() {
        Seq brokerIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Seq servers = (Seq)((TraversableLike)TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(KafkaConfig x$16) {
                return TestUtils$.MODULE$.createServer(x$16, TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
        try {
            long limit = 1000000L;
            AdminUtils$.MODULE$.changeBrokerConfig(this.zkUtils(), brokerIds, CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)((Object)BoxesRunTime.boxToLong((long)limit)).toString()), new Tuple2((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)((Object)BoxesRunTime.boxToLong((long)limit)).toString())})));
            this.checkConfig$2(limit, servers);
            long newLimit = 2L * limit;
            AdminUtils$.MODULE$.changeBrokerConfig(this.zkUtils(), brokerIds, CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)((Object)BoxesRunTime.boxToLong((long)newLimit)).toString()), new Tuple2((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)((Object)BoxesRunTime.boxToLong((long)newLimit)).toString())})));
            this.checkConfig$2(newLimit, servers);
            brokerIds.foreach((Function1)new Serializable(this, servers, newLimit){
                public static final long serialVersionUID = 0L;
                private final Seq servers$5;
                private final long newLimit$1;

                public final void apply(int brokerId) {
                    this.apply$mcVI$sp(brokerId);
                }

                public void apply$mcVI$sp(int brokerId) {
                    Properties configInZk = AdminUtils$.MODULE$.fetchEntityConfig(((KafkaServer)this.servers$5.apply(brokerId)).zkUtils(), ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger((int)brokerId)).toString());
                    Assert.assertEquals((long)this.newLimit$1, (long)new StringOps(Predef$.MODULE$.augmentString(configInZk.getProperty(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp()))).toInt());
                    Assert.assertEquals((long)this.newLimit$1, (long)new StringOps(Predef$.MODULE$.augmentString(configInZk.getProperty(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp()))).toInt());
                }
                {
                    this.servers$5 = servers$5;
                    this.newLimit$1 = newLimit$1;
                }
            });
            AdminUtils$.MODULE$.changeBrokerConfig(((KafkaServer)servers.apply(0)).zkUtils(), brokerIds, new Properties());
            this.checkConfig$2(DynamicConfig.Broker$.MODULE$.DefaultReplicationThrottledRate(), servers);
        }
        catch (Throwable throwable) {
            servers.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(KafkaServer x$17) {
                    x$17.shutdown();
                }
            });
            servers.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(KafkaServer server) {
                    CoreUtils$.MODULE$.delete(server.config().logDirs());
                }
            });
            throw throwable;
        }
        servers.foreach((Function1)new /* invalid duplicate definition of identical inner class */);
        servers.foreach((Function1)new /* invalid duplicate definition of identical inner class */);
    }

    @Test
    public void testBootstrapClientIdConfig() {
        String clientId = "my-client";
        Properties props = new Properties();
        props.setProperty("producer_byte_rate", "1000");
        props.setProperty("consumer_byte_rate", "2000");
        Map configMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"producer_byte_rate"), (Object)"1000"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"consumer_byte_rate"), (Object)"2000")}));
        Map map = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"config"), (Object)configMap)}));
        ZkUtils qual$1 = this.zkUtils();
        String x$48 = ZkUtils$.MODULE$.getEntityConfigPath(ConfigType$.MODULE$.Client(), clientId);
        String x$49 = Json$.MODULE$.encode((Object)map);
        java.util.List x$50 = qual$1.updatePersistentPath$default$3();
        qual$1.updatePersistentPath(x$48, x$49, x$50);
        Map configInZk = AdminUtils$.MODULE$.fetchAllEntityConfigs(this.zkUtils(), ConfigType$.MODULE$.Client());
        Assert.assertEquals((String)"Must have 1 overriden client config", (long)1L, (long)configInZk.size());
        Assert.assertEquals((Object)props, (Object)configInZk.apply((Object)clientId));
        KafkaServer server = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16())), TestUtils$.MODULE$.createServer$default$2());
        try {
            Assert.assertEquals((Object)new Quota(1000.0, true), (Object)server.apis().quotas().produce().quota("ANONYMOUS", clientId));
            Assert.assertEquals((Object)new Quota(2000.0, true), (Object)server.apis().quotas().fetch().quota("ANONYMOUS", clientId));
            return;
        }
        finally {
            server.shutdown();
            CoreUtils$.MODULE$.delete(server.config().logDirs());
        }
    }

    @Test
    public void testGetBrokerMetadatas() {
        Range.Inclusive brokerList = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 5);
        Map rackInfo = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        Seq<BrokerMetadata> brokerMetadatas = this.toBrokerMetadata((Map<Object, String>)rackInfo, (Seq<Object>)((Seq)brokerList.filterNot((Function1)rackInfo.keySet())));
        TestUtils$.MODULE$.createBrokersInZk(brokerMetadatas, this.zkUtils());
        Seq processedMetadatas1 = AdminUtils$.MODULE$.getBrokerMetadatas(this.zkUtils(), (RackAwareMode)RackAwareMode.Disabled$.MODULE$, AdminUtils$.MODULE$.getBrokerMetadatas$default$3());
        Assert.assertEquals((Object)brokerList, (Object)processedMetadatas1.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(BrokerMetadata x$18) {
                return x$18.id();
            }
        }, Seq$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)List$.MODULE$.fill(brokerList.size(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final None$ apply() {
                return None$.MODULE$;
            }
        }), (Object)processedMetadatas1.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(BrokerMetadata x$19) {
                return x$19.rack();
            }
        }, Seq$.MODULE$.canBuildFrom()));
        Seq processedMetadatas2 = AdminUtils$.MODULE$.getBrokerMetadatas(this.zkUtils(), (RackAwareMode)RackAwareMode.Safe$.MODULE$, AdminUtils$.MODULE$.getBrokerMetadatas$default$3());
        Assert.assertEquals((Object)brokerList, (Object)processedMetadatas2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(BrokerMetadata x$20) {
                return x$20.id();
            }
        }, Seq$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)List$.MODULE$.fill(brokerList.size(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final None$ apply() {
                return None$.MODULE$;
            }
        }), (Object)processedMetadatas2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(BrokerMetadata x$21) {
                return x$21.rack();
            }
        }, Seq$.MODULE$.canBuildFrom()));
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;

            public final Seq<BrokerMetadata> apply() {
                return AdminUtils$.MODULE$.getBrokerMetadatas(this.$outer.zkUtils(), (RackAwareMode)RackAwareMode.Enforced$.MODULE$, AdminUtils$.MODULE$.getBrokerMetadatas$default$3());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ManifestFactory$.MODULE$.classType(AdminOperationException.class));
        List partialList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 5}));
        Seq processedMetadatas3 = AdminUtils$.MODULE$.getBrokerMetadatas(this.zkUtils(), (RackAwareMode)RackAwareMode.Enforced$.MODULE$, (Option)new Some((Object)partialList));
        Assert.assertEquals((Object)partialList, (Object)processedMetadatas3.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(BrokerMetadata x$22) {
                return x$22.id();
            }
        }, Seq$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)partialList.map((Function1)rackInfo, List$.MODULE$.canBuildFrom()), (Object)processedMetadatas3.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<String> apply(BrokerMetadata x$23) {
                return Option$.MODULE$.option2Iterable(x$23.rack());
            }
        }, Seq$.MODULE$.canBuildFrom()));
        int numPartitions = 3;
        ZkUtils x$51 = this.zkUtils();
        String x$52 = "foo";
        int x$53 = numPartitions;
        int x$54 = 2;
        RackAwareMode.Safe$ x$55 = RackAwareMode.Safe$.MODULE$;
        Properties x$56 = AdminUtils$.MODULE$.createTopic$default$5();
        AdminUtils$.MODULE$.createTopic(x$51, x$52, x$53, x$54, x$56, (RackAwareMode)x$55);
        scala.collection.mutable.Map assignment = this.zkUtils().getReplicaAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assert.assertEquals((long)numPartitions, (long)assignment.size());
    }

    private final Properties makeConfig$1(int messageSize, long retentionMs, String throttledLeaders, String throttledFollowers) {
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)messageSize)).toString());
        props.setProperty(LogConfig$.MODULE$.RetentionMsProp(), ((Object)BoxesRunTime.boxToLong((long)retentionMs)).toString());
        props.setProperty(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), throttledLeaders);
        props.setProperty(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), throttledFollowers);
        return props;
    }

    public final void kafka$admin$AdminTest$$checkList$1(java.util.List actual, String expected) {
        Assert.assertNotNull((Object)actual);
        String string = expected;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Assert.assertTrue((boolean)actual.isEmpty());
        } else {
            Assert.assertEquals((Object)Predef$.MODULE$.refArrayOps((Object[])expected.split(",")).toSeq(), (Object)JavaConverters$.MODULE$.asScalaBufferConverter(actual).asScala());
        }
    }

    private final void checkConfig$1(int messageSize, long retentionMs, String throttledLeaders, String throttledFollowers, boolean quotaManagerIsThrottled, int partitions$1, String topic$8, KafkaServer server$1) {
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)new Serializable(this, partitions$1, topic$8, server$1, messageSize, retentionMs, throttledLeaders, throttledFollowers, quotaManagerIsThrottled){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminTest $outer;
            private final int partitions$1;
            public final String topic$8;
            public final KafkaServer server$1;
            public final int messageSize$1;
            public final long retentionMs$1;
            public final String throttledLeaders$1;
            public final String throttledFollowers$1;
            public final boolean quotaManagerIsThrottled$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.partitions$1).foreach$mVc$sp((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$checkConfig$1$1 $outer;

                    public final void apply(int part) {
                        this.apply$mcVI$sp(part);
                    }

                    public void apply$mcVI$sp(int part) {
                        Option log = this.$outer.server$1.logManager().getLog(new TopicAndPartition(this.$outer.topic$8, part));
                        Assert.assertTrue((boolean)log.isDefined());
                        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)this.$outer.retentionMs$1), (Object)((Log)log.get()).config().retentionMs());
                        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)this.$outer.messageSize$1), (Object)((Log)log.get()).config().maxMessageSize());
                        this.$outer.kafka$admin$AdminTest$$anonfun$$$outer().kafka$admin$AdminTest$$checkList$1(((Log)log.get()).config().LeaderReplicationThrottledReplicas(), this.$outer.throttledLeaders$1);
                        this.$outer.kafka$admin$AdminTest$$anonfun$$$outer().kafka$admin$AdminTest$$checkList$1(((Log)log.get()).config().FollowerReplicationThrottledReplicas(), this.$outer.throttledFollowers$1);
                        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.quotaManagerIsThrottled$1), (Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.server$1.quotaManagers().leader().isThrottled(new TopicAndPartition(this.$outer.topic$8, part))));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ AdminTest kafka$admin$AdminTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.partitions$1 = partitions$1;
                this.topic$8 = topic$8;
                this.server$1 = server$1;
                this.messageSize$1 = messageSize$1;
                this.retentionMs$1 = retentionMs$1;
                this.throttledLeaders$1 = throttledLeaders$1;
                this.throttledFollowers$1 = throttledFollowers$1;
                this.quotaManagerIsThrottled$1 = quotaManagerIsThrottled$1;
            }
        });
    }

    private final void checkConfig$2(long limit, Seq servers$5) {
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)new Serializable(this, servers$5, limit){
            public static final long serialVersionUID = 0L;
            private final Seq servers$5;
            public final long limit$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.servers$5.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$checkConfig$2$1 $outer;

                    public final void apply(KafkaServer server) {
                        Assert.assertEquals((String)"Leader Quota Manager was not updated", (long)this.$outer.limit$1, (long)server.quotaManagers().leader().upperBound());
                        Assert.assertEquals((String)"Follower Quota Manager was not updated", (long)this.$outer.limit$1, (long)server.quotaManagers().follower().upperBound());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.servers$5 = servers$5;
                this.limit$1 = limit$1;
            }
        });
    }

    public AdminTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        RackAwareTest$class.$init$(this);
    }
}

