/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kafka.api.EndToEndClusterIdTest$MockBrokerMetricsReporter$;
import kafka.api.EndToEndClusterIdTest$MockConsumerMetricsReporter$;
import kafka.api.EndToEndClusterIdTest$MockProducerMetricsReporter$;
import kafka.common.TopicAndPartition;
import kafka.integration.KafkaServerTestHarness;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.ClusterResourceListener;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.test.MockConsumerInterceptor;
import org.apache.kafka.test.MockDeserializer;
import org.apache.kafka.test.MockMetricsReporter;
import org.apache.kafka.test.MockProducerInterceptor;
import org.apache.kafka.test.MockSerializer;
import org.apache.kafka.test.TestUtils;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tEt!B\u0001\u0003\u0011\u00039\u0011!F#oIR{WI\u001c3DYV\u001cH/\u001a:JIR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1!\u00199j\u0015\u0005)\u0011!B6bM.\f7\u0001\u0001\t\u0003\u0011%i\u0011A\u0001\u0004\u0006\u0015\tA\ta\u0003\u0002\u0016\u000b:$Gk\\#oI\u000ecWo\u001d;fe&#G+Z:u'\rIAB\u0005\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u00055\u0019\u0012B\u0001\u000b\u000f\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u00151\u0012\u0002\"\u0001\u0018\u0003\u0019a\u0014N\\5u}Q\tqaB\u0003\u001a\u0013!\u0005!$A\u000eN_\u000e\\7i\u001c8tk6,'/T3ue&\u001c7OU3q_J$XM\u001d\t\u00037qi\u0011!\u0003\u0004\u0006;%A\tA\b\u0002\u001c\u001b>\u001c7nQ8ogVlWM]'fiJL7m\u001d*fa>\u0014H/\u001a:\u0014\u0005qa\u0001\"\u0002\f\u001d\t\u0003\u0001C#\u0001\u000e\t\u000f\tb\"\u0019!C\u0001G\u0005a1\tT+T)\u0016\u0013v,T#U\u0003V\tA\u0005E\u0002&]Aj\u0011A\n\u0006\u0003O!\na!\u0019;p[&\u001c'BA\u0015+\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003W1\nA!\u001e;jY*\tQ&\u0001\u0003kCZ\f\u0017BA\u0018'\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0007CA\u0019:\u001b\u0005\u0011$BA\u001a5\u0003\u0019\u0019w.\\7p]*\u0011Q!\u000e\u0006\u0003m]\na!\u00199bG\",'\"\u0001\u001d\u0002\u0007=\u0014x-\u0003\u0002;e\ty1\t\\;ti\u0016\u0014(+Z:pkJ\u001cW\r\u0003\u0004=9\u0001\u0006I\u0001J\u0001\u000e\u00072+6\u000bV#S?6+E+\u0011\u0011\u0007\tuI\u0001AP\n\u0004{}*\u0005C\u0001!D\u001b\u0005\t%B\u0001\"5\u0003\u0011!Xm\u001d;\n\u0005\u0011\u000b%aE'pG.lU\r\u001e:jGN\u0014V\r]8si\u0016\u0014\bCA\u0019G\u0013\t9%GA\fDYV\u001cH/\u001a:SKN|WO]2f\u0019&\u001cH/\u001a8fe\")a#\u0010C\u0001\u0013R\t!\n\u0005\u0002\u001c{!)A*\u0010C!\u001b\u0006AqN\\+qI\u0006$X\r\u0006\u0002O#B\u0011QbT\u0005\u0003!:\u0011A!\u00168ji\")!k\u0013a\u0001a\u0005y1\r\\;ti\u0016\u0014X*\u001a;bI\u0006$\u0018mB\u0003U\u0013!\u0005Q+A\u000eN_\u000e\\\u0007K]8ek\u000e,'/T3ue&\u001c7OU3q_J$XM\u001d\t\u00037Y3QaV\u0005\t\u0002a\u00131$T8dWB\u0013x\u000eZ;dKJlU\r\u001e:jGN\u0014V\r]8si\u0016\u00148C\u0001,\r\u0011\u00151b\u000b\"\u0001[)\u0005)\u0006b\u0002\u0012W\u0005\u0004%\ta\t\u0005\u0007yY\u0003\u000b\u0011\u0002\u0013\u0007\t]K\u0001AX\n\u0004;~*\u0005\"\u0002\f^\t\u0003\u0001G#A1\u0011\u0005mi\u0006\"\u0002'^\t\u0003\u001aGC\u0001(e\u0011\u0015\u0011&\r1\u00011\u000f\u00151\u0017\u0002#\u0001h\u0003eiunY6Ce>\\WM]'fiJL7m\u001d*fa>\u0014H/\u001a:\u0011\u0005mAg!B5\n\u0011\u0003Q'!G'pG.\u0014%o\\6fe6+GO]5dgJ+\u0007o\u001c:uKJ\u001c\"\u0001\u001b\u0007\t\u000bYAG\u0011\u00017\u0015\u0003\u001dDqA\t5C\u0002\u0013\u00051\u0005\u0003\u0004=Q\u0002\u0006I\u0001\n\u0004\u0005S&\u0001\u0001oE\u0002p\u007f\u0015CQAF8\u0005\u0002I$\u0012a\u001d\t\u00037=DQ\u0001T8\u0005BU$\"A\u0014<\t\u000bI#\b\u0019\u0001\u0019\t\u000faL\u0011\u0011!C\u0005s\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u0005Q\bCA>\u007f\u001b\u0005a(BA?-\u0003\u0011a\u0017M\\4\n\u0005}d(AB(cU\u0016\u001cGOB\u0003\u000b\u0005\u0001\t\u0019a\u0005\u0004\u0002\u0002\u0005\u0015\u0011Q\u0003\t\u0005\u0003\u000f\t\t\"\u0004\u0002\u0002\n)!\u00111BA\u0007\u0003\u0015QWO\\5u\u0015\r\tyaN\u0001\ng\u000e\fG.\u0019;fgRLA!a\u0005\u0002\n\tQ!*\u00168jiN+\u0018\u000e^3\u0011\t\u0005]\u0011QD\u0007\u0003\u00033Q1!a\u0007\u0005\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\t\u0005}\u0011\u0011\u0004\u0002\u0017\u0017\u000647.Y*feZ,'\u000fV3ti\"\u000b'O\\3tg\"9a#!\u0001\u0005\u0002\u0005\rBCAA\u0013!\rA\u0011\u0011\u0001\u0005\u000b\u0003S\t\tA1A\u0005\u0002\u0005-\u0012!\u00049s_\u0012,8-\u001a:D_VtG/\u0006\u0002\u0002.A\u0019Q\"a\f\n\u0007\u0005EbBA\u0002J]RD\u0011\"!\u000e\u0002\u0002\u0001\u0006I!!\f\u0002\u001dA\u0014x\u000eZ;dKJ\u001cu.\u001e8uA!Q\u0011\u0011HA\u0001\u0005\u0004%\t!a\u000b\u0002\u001b\r|gn];nKJ\u001cu.\u001e8u\u0011%\ti$!\u0001!\u0002\u0013\ti#\u0001\bd_:\u001cX/\\3s\u0007>,h\u000e\u001e\u0011\t\u0015\u0005\u0005\u0013\u0011\u0001b\u0001\n\u0003\tY#A\u0006tKJ4XM]\"pk:$\b\"CA#\u0003\u0003\u0001\u000b\u0011BA\u0017\u00031\u0019XM\u001d<fe\u000e{WO\u001c;!\u0011-\tI%!\u0001\t\u0006\u0004%\t!a\u0013\u0002\u001dA\u0014x\u000eZ;dKJ\u001cuN\u001c4jOV\u0011\u0011Q\n\t\u0005\u0003\u001f\n\t&D\u0001+\u0013\r\t\u0019F\u000b\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bbCA,\u0003\u0003A\t\u0011)Q\u0005\u0003\u001b\nq\u0002\u001d:pIV\u001cWM]\"p]\u001aLw\r\t\u0005\f\u00037\n\t\u0001#b\u0001\n\u0003\tY%\u0001\bd_:\u001cX/\\3s\u0007>tg-[4\t\u0017\u0005}\u0013\u0011\u0001E\u0001B\u0003&\u0011QJ\u0001\u0010G>t7/^7fe\u000e{gNZ5hA!Y\u00111MA\u0001\u0011\u000b\u0007I\u0011AA&\u00031\u0019XM\u001d<fe\u000e{gNZ5h\u0011-\t9'!\u0001\t\u0002\u0003\u0006K!!\u0014\u0002\u001bM,'O^3s\u0007>tg-[4!\u0011)\tY'!\u0001C\u0002\u0013\u0005\u00111F\u0001\u000b]Vl'+Z2pe\u0012\u001c\b\"CA8\u0003\u0003\u0001\u000b\u0011BA\u0017\u0003-qW/\u001c*fG>\u0014Hm\u001d\u0011\t\u0015\u0005M\u0014\u0011\u0001b\u0001\n\u0003\t)(A\u0003u_BL7-\u0006\u0002\u0002xA\u001910!\u001f\n\u0007\u0005mDP\u0001\u0004TiJLgn\u001a\u0005\n\u0003\u007f\n\t\u0001)A\u0005\u0003o\na\u0001^8qS\u000e\u0004\u0003BCAB\u0003\u0003\u0011\r\u0011\"\u0001\u0002,\u0005!\u0001/\u0019:u\u0011%\t9)!\u0001!\u0002\u0013\ti#A\u0003qCJ$\b\u0005\u0003\u0006\u0002\f\u0006\u0005!\u0019!C\u0001\u0003\u001b\u000b!\u0001\u001e9\u0016\u0005\u0005=\u0005cA\u0019\u0002\u0012&\u0019\u00111\u0013\u001a\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"I\u0011qSA\u0001A\u0003%\u0011qR\u0001\u0004iB\u0004\u0003BCAN\u0003\u0003\u0011\r\u0011\"\u0001\u0002\u001e\u0006\tBo\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8\u0016\u0005\u0005}\u0005\u0003BAQ\u0003Kk!!a)\u000b\u0005M\"\u0011\u0002BAT\u0003G\u0013\u0011\u0003V8qS\u000e\fe\u000e\u001a)beRLG/[8o\u0011%\tY+!\u0001!\u0002\u0013\ty*\u0001\nu_BL7-\u00118e!\u0006\u0014H/\u001b;j_:\u0004\u0003\u0002CAX\u0003\u0003!\t%!-\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON$\"!a-\u0011\r\u0005U\u0016QYAf\u001d\u0011\t9,!1\u000f\t\u0005e\u0016qX\u0007\u0003\u0003wS1!!0\u0007\u0003\u0019a$o\\8u}%\tq\"C\u0002\u0002D:\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002H\u0006%'aA*fc*\u0019\u00111\u0019\b\u0011\t\u00055\u00171[\u0007\u0003\u0003\u001fT1!!5\u0005\u0003\u0019\u0019XM\u001d<fe&!\u0011Q[Ah\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u0011\u0005e\u0017\u0011\u0001C!\u00037\fQa]3u+B$\u0012A\u0014\u0015\u0005\u0003/\fy\u000e\u0005\u0003\u0002b\u0006\u0015XBAAr\u0015\r\tYaN\u0005\u0005\u0003O\f\u0019O\u0001\u0004CK\u001a|'/\u001a\u0005\t\u0003W\f\t\u0001\"\u0001\u0002\\\u0006aA/Z:u\u000b:$Gk\\#oI\"\"\u0011\u0011^Ax!\u0011\t\t/!=\n\t\u0005M\u00181\u001d\u0002\u0005)\u0016\u001cH\u000f\u0003\u0005\u0002x\u0006\u0005A\u0011BA}\u0003-\u0019XM\u001c3SK\u000e|'\u000fZ:\u0015\u000f9\u000bYP!\u0007\u0003\u001c!A\u0011Q`A{\u0001\u0004\ty0\u0001\u0005qe>$WoY3s!!\u0011\tA!\u0003\u0003\u000e\t5QB\u0001B\u0002\u0015\u0011\tiP!\u0002\u000b\u0007\t\u001dA'A\u0004dY&,g\u000e^:\n\t\t-!1\u0001\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\u0011\u000b5\u0011yAa\u0005\n\u0007\tEaBA\u0003BeJ\f\u0017\u0010E\u0002\u000e\u0005+I1Aa\u0006\u000f\u0005\u0011\u0011\u0015\u0010^3\t\u0011\u0005-\u0014Q\u001fa\u0001\u0003[A\u0001\"a#\u0002v\u0002\u0007\u0011q\u0012\u0005\t\u0005?\t\t\u0001\"\u0003\u0003\"\u0005q1m\u001c8tk6,'+Z2pe\u0012\u001cHc\u0003(\u0003$\tE\"1\u0007B\u001c\u0005\u000bB\u0001B!\n\u0003\u001e\u0001\u0007!qE\u0001\tG>t7/^7feBA!\u0011\u0006B\u0017\u0005\u001b\u0011i!\u0004\u0002\u0003,)!!Q\u0005B\u0003\u0013\u0011\u0011yCa\u000b\u0003\u0011\r{gn];nKJD!\"a\u001b\u0003\u001eA\u0005\t\u0019AA\u0017\u0011)\u0011)D!\b\u0011\u0002\u0003\u0007\u0011QF\u0001\u000fgR\f'\u000f^5oO>3gm]3u\u0011)\t\u0019H!\b\u0011\u0002\u0003\u0007!\u0011\b\t\u0005\u0005w\u0011\tED\u0002\u000e\u0005{I1Aa\u0010\u000f\u0003\u0019\u0001&/\u001a3fM&!\u00111\u0010B\"\u0015\r\u0011yD\u0004\u0005\u000b\u0003\u0007\u0013i\u0002%AA\u0002\u00055\u0002B\u0003B%\u0003\u0003\t\n\u0011\"\u0003\u0003L\u0005A2m\u001c8tk6,'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t5#\u0006BA\u0017\u0005\u001fZ#A!\u0015\u0011\t\tM#QL\u0007\u0003\u0005+RAAa\u0016\u0003Z\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00057r\u0011AC1o]>$\u0018\r^5p]&!!q\fB+\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0005G\n\t!%A\u0005\n\t-\u0013\u0001G2p]N,X.\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%g!Q!qMA\u0001#\u0003%IA!\u001b\u00021\r|gn];nKJ+7m\u001c:eg\u0012\"WMZ1vYR$C'\u0006\u0002\u0003l)\"!\u0011\bB(\u0011)\u0011y'!\u0001\u0012\u0002\u0013%!1J\u0001\u0019G>t7/^7f%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012*\u0004")
public class EndToEndClusterIdTest
extends JUnitSuite
implements KafkaServerTestHarness {
    private final int producerCount;
    private final int consumerCount;
    private final int serverCount;
    private Properties producerConfig;
    private Properties consumerConfig;
    private Properties serverConfig;
    private final int numRecords;
    private final String topic;
    private final int part;
    private final TopicPartition tp;
    private final TopicAndPartition topicAndPartition;
    private Seq<KafkaConfig> instanceConfigs;
    private Buffer<KafkaServer> servers;
    private String brokerList;
    private boolean[] alive;
    private final String kafkaPrincipalType;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile byte bitmap$0;

    private Properties producerConfig$lzycompute() {
        EndToEndClusterIdTest endToEndClusterIdTest = this;
        synchronized (endToEndClusterIdTest) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.producerConfig = new Properties();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.producerConfig;
        }
    }

    private Properties consumerConfig$lzycompute() {
        EndToEndClusterIdTest endToEndClusterIdTest = this;
        synchronized (endToEndClusterIdTest) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.consumerConfig = new Properties();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.consumerConfig;
        }
    }

    private Properties serverConfig$lzycompute() {
        EndToEndClusterIdTest endToEndClusterIdTest = this;
        synchronized (endToEndClusterIdTest) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.serverConfig = new Properties();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.serverConfig;
        }
    }

    @Override
    public Seq<KafkaConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    @Override
    public void instanceConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.instanceConfigs = x$1;
    }

    @Override
    public Buffer<KafkaServer> servers() {
        return this.servers;
    }

    @Override
    public void servers_$eq(Buffer<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public String brokerList() {
        return this.brokerList;
    }

    @Override
    public void brokerList_$eq(String x$1) {
        this.brokerList = x$1;
    }

    @Override
    public boolean[] alive() {
        return this.alive;
    }

    @Override
    public void alive_$eq(boolean[] x$1) {
        this.alive = x$1;
    }

    @Override
    public String kafkaPrincipalType() {
        return this.kafkaPrincipalType;
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$_setter_$kafkaPrincipalType_$eq(String x$1) {
        this.kafkaPrincipalType = x$1;
    }

    @Override
    public void setAclsBeforeServersStart() {
        KafkaServerTestHarness$class.setAclsBeforeServersStart(this);
    }

    @Override
    public Seq<KafkaConfig> configs() {
        return KafkaServerTestHarness$class.configs(this);
    }

    @Override
    public Option<KafkaServer> serverForId(int id) {
        return KafkaServerTestHarness$class.serverForId(this, id);
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return KafkaServerTestHarness$class.securityProtocol(this);
    }

    @Override
    public Option<File> trustStoreFile() {
        return KafkaServerTestHarness$class.trustStoreFile(this);
    }

    @Override
    public Option<Properties> saslProperties() {
        return KafkaServerTestHarness$class.saslProperties(this);
    }

    @Override
    @After
    public void tearDown() {
        KafkaServerTestHarness$class.tearDown(this);
    }

    @Override
    public int killRandomBroker() {
        return KafkaServerTestHarness$class.killRandomBroker(this);
    }

    @Override
    public void restartDeadBrokers() {
        KafkaServerTestHarness$class.restartDeadBrokers(this);
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        EndToEndClusterIdTest endToEndClusterIdTest = this;
        synchronized (endToEndClusterIdTest) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public int producerCount() {
        return this.producerCount;
    }

    public int consumerCount() {
        return this.consumerCount;
    }

    public int serverCount() {
        return this.serverCount;
    }

    public Properties producerConfig() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.producerConfig$lzycompute() : this.producerConfig;
    }

    public Properties consumerConfig() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.consumerConfig$lzycompute() : this.consumerConfig;
    }

    public Properties serverConfig() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.serverConfig$lzycompute() : this.serverConfig;
    }

    public int numRecords() {
        return this.numRecords;
    }

    public String topic() {
        return this.topic;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public TopicAndPartition topicAndPartition() {
        return this.topicAndPartition;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$3 = this.serverCount();
        String x$4 = this.zkConnect();
        Some x$5 = new Some((Object)this.securityProtocol());
        Option<File> x$6 = this.trustStoreFile();
        Option<Properties> x$7 = this.saslProperties();
        boolean x$8 = TestUtils$.MODULE$.createBrokerConfigs$default$3();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$13 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        Map<Object, String> x$14 = TestUtils$.MODULE$.createBrokerConfigs$default$12();
        Seq<Properties> cfgs = TestUtils$.MODULE$.createBrokerConfigs(x$3, x$4, x$8, x$9, (Option<SecurityProtocol>)x$5, x$6, x$7, x$10, x$11, x$12, x$13, x$14);
        cfgs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EndToEndClusterIdTest $outer;

            public final void apply(Properties x$1) {
                x$1.putAll((java.util.Map<?, ?>)this.$outer.serverConfig());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        return (Seq)cfgs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    @Before
    public void setUp() {
        KafkaServerTestHarness$class.setUp(this);
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
    }

    @Test
    public void testEndToEnd() {
        String appendStr = "mock";
        MockConsumerInterceptor.resetCounters();
        MockProducerInterceptor.resetCounters();
        Assert.assertNotNull(EndToEndClusterIdTest$MockBrokerMetricsReporter$.MODULE$.CLUSTER_META());
        TestUtils.isValidClusterId((String)EndToEndClusterIdTest$MockBrokerMetricsReporter$.MODULE$.CLUSTER_META().get().clusterId());
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.brokerList());
        producerProps.put("interceptor.classes", "org.apache.kafka.test.MockProducerInterceptor");
        producerProps.put("mock.interceptor.append", appendStr);
        producerProps.put("metric.reporters", "kafka.api.EndToEndClusterIdTest$MockProducerMetricsReporter");
        KafkaProducer testProducer = new KafkaProducer(producerProps, (Serializer)new MockSerializer(), (Serializer)new MockSerializer());
        this.sendRecords((KafkaProducer<byte[], byte[]>)testProducer, 1, this.tp());
        Assert.assertNotEquals((Object)MockProducerInterceptor.CLUSTER_ID_BEFORE_ON_ACKNOWLEDGEMENT, (Object)MockProducerInterceptor.NO_CLUSTER_ID);
        Assert.assertNotNull((Object)MockProducerInterceptor.CLUSTER_META);
        Assert.assertEquals((Object)((ClusterResource)MockProducerInterceptor.CLUSTER_ID_BEFORE_ON_ACKNOWLEDGEMENT.get()).clusterId(), (Object)((ClusterResource)MockProducerInterceptor.CLUSTER_META.get()).clusterId());
        TestUtils.isValidClusterId((String)((ClusterResource)MockProducerInterceptor.CLUSTER_META.get()).clusterId());
        Assert.assertNotEquals((Object)MockSerializer.CLUSTER_ID_BEFORE_SERIALIZE, (Object)MockSerializer.NO_CLUSTER_ID);
        Assert.assertNotNull((Object)MockSerializer.CLUSTER_META);
        TestUtils.isValidClusterId((String)((ClusterResource)MockSerializer.CLUSTER_META.get()).clusterId());
        Assert.assertNotNull(EndToEndClusterIdTest$MockProducerMetricsReporter$.MODULE$.CLUSTER_META());
        TestUtils.isValidClusterId((String)EndToEndClusterIdTest$MockProducerMetricsReporter$.MODULE$.CLUSTER_META().get().clusterId());
        this.consumerConfig().put("bootstrap.servers", this.brokerList());
        this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
        this.consumerConfig().put("metric.reporters", "kafka.api.EndToEndClusterIdTest$MockConsumerMetricsReporter");
        KafkaConsumer testConsumer = new KafkaConsumer(this.consumerConfig(), (Deserializer)new MockDeserializer(), (Deserializer)new MockDeserializer());
        testConsumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        testConsumer.seek(this.tp(), 0L);
        this.consumeRecords((Consumer<byte[], byte[]>)testConsumer, this.numRecords(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5());
        Assert.assertNotEquals((Object)MockConsumerInterceptor.CLUSTER_ID_BEFORE_ON_CONSUME, (Object)MockConsumerInterceptor.NO_CLUSTER_ID);
        Assert.assertNotNull((Object)MockConsumerInterceptor.CLUSTER_META);
        TestUtils.isValidClusterId((String)((ClusterResource)MockConsumerInterceptor.CLUSTER_META.get()).clusterId());
        Assert.assertEquals((Object)((ClusterResource)MockConsumerInterceptor.CLUSTER_ID_BEFORE_ON_CONSUME.get()).clusterId(), (Object)((ClusterResource)MockConsumerInterceptor.CLUSTER_META.get()).clusterId());
        Assert.assertNotEquals((Object)MockDeserializer.CLUSTER_ID_BEFORE_DESERIALIZE, (Object)MockDeserializer.NO_CLUSTER_ID);
        Assert.assertNotNull((Object)MockDeserializer.CLUSTER_META);
        TestUtils.isValidClusterId((String)((ClusterResource)MockDeserializer.CLUSTER_META.get()).clusterId());
        Assert.assertEquals((Object)((ClusterResource)MockDeserializer.CLUSTER_ID_BEFORE_DESERIALIZE.get()).clusterId(), (Object)((ClusterResource)MockDeserializer.CLUSTER_META.get()).clusterId());
        Assert.assertNotNull(EndToEndClusterIdTest$MockConsumerMetricsReporter$.MODULE$.CLUSTER_META());
        TestUtils.isValidClusterId((String)EndToEndClusterIdTest$MockConsumerMetricsReporter$.MODULE$.CLUSTER_META().get().clusterId());
        Assert.assertEquals((Object)((ClusterResource)MockProducerInterceptor.CLUSTER_META.get()).clusterId(), (Object)((ClusterResource)MockSerializer.CLUSTER_META.get()).clusterId());
        Assert.assertEquals((Object)((ClusterResource)MockProducerInterceptor.CLUSTER_META.get()).clusterId(), (Object)EndToEndClusterIdTest$MockProducerMetricsReporter$.MODULE$.CLUSTER_META().get().clusterId());
        Assert.assertEquals((Object)((ClusterResource)MockProducerInterceptor.CLUSTER_META.get()).clusterId(), (Object)((ClusterResource)MockConsumerInterceptor.CLUSTER_META.get()).clusterId());
        Assert.assertEquals((Object)((ClusterResource)MockProducerInterceptor.CLUSTER_META.get()).clusterId(), (Object)((ClusterResource)MockDeserializer.CLUSTER_META.get()).clusterId());
        Assert.assertEquals((Object)((ClusterResource)MockProducerInterceptor.CLUSTER_META.get()).clusterId(), (Object)EndToEndClusterIdTest$MockConsumerMetricsReporter$.MODULE$.CLUSTER_META().get().clusterId());
        Assert.assertEquals((Object)((ClusterResource)MockProducerInterceptor.CLUSTER_META.get()).clusterId(), (Object)EndToEndClusterIdTest$MockBrokerMetricsReporter$.MODULE$.CLUSTER_META().get().clusterId());
        testConsumer.close();
        testProducer.close();
        MockConsumerInterceptor.resetCounters();
        MockProducerInterceptor.resetCounters();
    }

    private void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition tp) {
        IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1)new Serializable(this, producer, tp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EndToEndClusterIdTest $outer;
            private final KafkaProducer producer$1;
            private final TopicPartition tp$1;

            public final Future<RecordMetadata> apply(int i) {
                ProducerRecord record = new ProducerRecord(this.tp$1.topic(), Predef$.MODULE$.int2Integer(this.tp$1.partition()), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes());
                this.$outer.debug((Function0<String>)new Serializable(this, record){
                    public static final long serialVersionUID = 0L;
                    private final ProducerRecord record$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending this record: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.record$1}));
                    }
                    {
                        this.record$1 = record$1;
                    }
                });
                return this.producer$1.send(record);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.producer$1 = producer$1;
                this.tp$1 = tp$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        try {
            futures.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final RecordMetadata apply(Future<RecordMetadata> x$2) {
                    return x$2.get();
                }
            });
            return;
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    private void consumeRecords(Consumer<byte[], byte[]> consumer, int numRecords, int startingOffset, String topic, int part) {
        ArrayBuffer records = new ArrayBuffer();
        int maxIters = numRecords * 50;
        int iters = 0;
        while (records.size() < numRecords) {
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)consumer.poll(50L)).asScala()).foreach((Function1)new Serializable(this, records){
                public static final long serialVersionUID = 0L;
                private final ArrayBuffer records$1;

                public final ArrayBuffer<ConsumerRecord<byte[], byte[]>> apply(ConsumerRecord<byte[], byte[]> record) {
                    return this.records$1.$plus$eq(record);
                }
                {
                    this.records$1 = records$1;
                }
            });
            if (iters > maxIters) {
                throw new IllegalStateException(new StringBuilder().append((Object)"Failed to consume the expected records after ").append((Object)BoxesRunTime.boxToInteger((int)iters)).append((Object)" iterations.").toString());
            }
            ++iters;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)new Serializable(this, startingOffset, topic, part, records){
            public static final long serialVersionUID = 0L;
            private final int startingOffset$1;
            private final String topic$1;
            private final int part$1;
            private final ArrayBuffer records$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                ConsumerRecord record = (ConsumerRecord)this.records$1.apply(i);
                int offset = this.startingOffset$1 + i;
                Assert.assertEquals((Object)this.topic$1, (Object)record.topic());
                Assert.assertEquals((long)this.part$1, (long)record.partition());
                Assert.assertEquals((long)offset, (long)record.offset());
            }
            {
                this.startingOffset$1 = startingOffset$1;
                this.topic$1 = topic$1;
                this.part$1 = part$1;
                this.records$1 = records$1;
            }
        });
    }

    private int consumeRecords$default$2() {
        return 1;
    }

    private int consumeRecords$default$3() {
        return 0;
    }

    private String consumeRecords$default$4() {
        return this.topic();
    }

    private int consumeRecords$default$5() {
        return this.part();
    }

    public EndToEndClusterIdTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        KafkaServerTestHarness$class.$init$(this);
        this.producerCount = 1;
        this.consumerCount = 1;
        this.serverCount = 1;
        this.numRecords = 1;
        this.topic = "e2etopic";
        this.part = 0;
        this.tp = new TopicPartition(this.topic(), this.part());
        this.topicAndPartition = new TopicAndPartition(this.topic(), this.part());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.MetricReporterClassesProp(), "kafka.api.EndToEndClusterIdTest$MockBrokerMetricsReporter");
    }

    public static class MockBrokerMetricsReporter
    extends MockMetricsReporter
    implements ClusterResourceListener {
        public void onUpdate(ClusterResource clusterMetadata) {
            EndToEndClusterIdTest$MockBrokerMetricsReporter$.MODULE$.CLUSTER_META().set(clusterMetadata);
        }
    }

    public static class MockConsumerMetricsReporter
    extends MockMetricsReporter
    implements ClusterResourceListener {
        public void onUpdate(ClusterResource clusterMetadata) {
            EndToEndClusterIdTest$MockConsumerMetricsReporter$.MODULE$.CLUSTER_META().set(clusterMetadata);
        }
    }

    public static class MockProducerMetricsReporter
    extends MockMetricsReporter
    implements ClusterResourceListener {
        public void onUpdate(ClusterResource clusterMetadata) {
            EndToEndClusterIdTest$MockProducerMetricsReporter$.MODULE$.CLUSTER_META().set(clusterMetadata);
        }
    }
}

