/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.io.File;
import java.util.Properties;
import kafka.consumer.Consumer$;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerConnector;
import kafka.consumer.ConsumerIterator;
import kafka.consumer.ConsumerTimeoutException;
import kafka.consumer.KafkaStream;
import kafka.integration.KafkaServerTestHarness;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.producer.KeyedMessage;
import kafka.producer.Producer;
import kafka.serializer.StringEncoder;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRequestHandler;
import kafka.server.KafkaServer;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\rc\u0001B\u0001\u0003\u0001\u001d\u00111#Q;u_>3gm]3u%\u0016\u001cX\r\u001e+fgRT!a\u0001\u0003\u0002\u0017%tG/Z4sCRLwN\u001c\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\t%Y\u0001\"!\u0003\t\u000e\u0003)Q!a\u0003\u0007\u0002\u000b),h.\u001b;\u000b\u00055q\u0011!C:dC2\fG/Z:u\u0015\u0005y\u0011aA8sO&\u0011\u0011C\u0003\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0007CA\n\u0015\u001b\u0005\u0011\u0011BA\u000b\u0003\u0005YY\u0015MZ6b'\u0016\u0014h/\u001a:UKN$\b*\u0019:oKN\u001c\bCA\f\u001b\u001b\u0005A\"BA\r\u0005\u0003\u0015)H/\u001b7t\u0013\tY\u0002DA\u0004M_\u001e<\u0017N\\4\t\u000bu\u0001A\u0011\u0001\u0010\u0002\rqJg.\u001b;?)\u0005y\u0002CA\n\u0001\u0011\u0015\t\u0003\u0001\"\u0001#\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001cH#A\u0012\u0011\u0007\u0011ZS&D\u0001&\u0015\t1s%A\u0005j[6,H/\u00192mK*\u0011\u0001&K\u0001\u000bG>dG.Z2uS>t'\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051*#\u0001\u0002'jgR\u0004\"AL\u0019\u000e\u0003=R!\u0001\r\u0003\u0002\rM,'O^3s\u0013\t\u0011tFA\u0006LC\u001a\\\u0017mQ8oM&<\u0007b\u0002\u001b\u0001\u0005\u0004%\t!N\u0001\u0006i>\u0004\u0018nY\u000b\u0002mA\u0011q\u0007P\u0007\u0002q)\u0011\u0011HO\u0001\u0005Y\u0006twMC\u0001<\u0003\u0011Q\u0017M^1\n\u0005uB$AB*ue&tw\r\u0003\u0004@\u0001\u0001\u0006IAN\u0001\u0007i>\u0004\u0018n\u0019\u0011\t\u000f\u0005\u0003!\u0019!C\u0001k\u0005)qM]8va\"11\t\u0001Q\u0001\nY\naa\u001a:pkB\u0004\u0003bB#\u0001\u0005\u0004%\t!N\u0001\ri\u0016\u001cHoQ8ogVlWM\u001d\u0005\u0007\u000f\u0002\u0001\u000b\u0011\u0002\u001c\u0002\u001bQ,7\u000f^\"p]N,X.\u001a:!\u0011\u001dI\u0005A1A\u0005\u0002)\u000b1BT;n\u001b\u0016\u001c8/Y4fgV\t1\n\u0005\u0002M\u001b6\t\u0011&\u0003\u0002OS\t\u0019\u0011J\u001c;\t\rA\u0003\u0001\u0015!\u0003L\u00031qU/\\'fgN\fw-Z:!\u0011\u001d\u0011\u0006A1A\u0005\u0002)\u000b1\u0002T1sO\u0016|eMZ:fi\"1A\u000b\u0001Q\u0001\n-\u000bA\u0002T1sO\u0016|eMZ:fi\u0002BqA\u0016\u0001C\u0002\u0013\u0005!*A\u0006T[\u0006dGn\u00144gg\u0016$\bB\u0002-\u0001A\u0003%1*\u0001\u0007T[\u0006dGn\u00144gg\u0016$\b\u0005C\u0004[\u0001\t\u0007I\u0011A.\u0002)I,\u0017/^3ti\"\u000bg\u000e\u001a7fe2{wmZ3s+\u0005a\u0006CA/c\u001b\u0005q&BA0a\u0003\u0015awn\u001a\u001bk\u0015\t\tg\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003Gz\u0013a\u0001T8hO\u0016\u0014\bBB3\u0001A\u0003%A,A\u000bsKF,Xm\u001d;IC:$G.\u001a:M_\u001e<WM\u001d\u0011\t\u000b\u001d\u0004A\u0011\t5\u0002\u000bM,G/\u00169\u0015\u0003%\u0004\"\u0001\u00146\n\u0005-L#\u0001B+oSRD#AZ7\u0011\u00059\u0004X\"A8\u000b\u0005-q\u0011BA9p\u0005\u0019\u0011UMZ8sK\")1\u000f\u0001C!Q\u0006AA/Z1s\t><h\u000e\u000b\u0002skB\u0011aN^\u0005\u0003o>\u0014Q!\u00114uKJDQ!\u001f\u0001\u0005\u0002!\fA\u0005^3tiJ+7/\u001a;U_\u0016\u000b'\u000f\\5fgR<\u0006.\u001a8PM\u001a\u001cX\r\u001e+p_\"Kw\r\u001b\u0015\u0003qn\u0004\"A\u001c?\n\u0005u|'\u0001\u0002+fgRDQa \u0001\u0005\u0002!\f1\u0005^3tiJ+7/\u001a;U_\u0016\u000b'\u000f\\5fgR<\u0006.\u001a8PM\u001a\u001cX\r\u001e+p_2{w\u000f\u000b\u0002\u007fw\"1\u0011Q\u0001\u0001\u0005\u0002!\f!\u0005^3tiJ+7/\u001a;U_2\u000bG/Z:u/\",gn\u00144gg\u0016$Hk\\8IS\u001eD\u0007fAA\u0002w\"1\u00111\u0002\u0001\u0005\u0002!\f\u0011\u0005^3tiJ+7/\u001a;U_2\u000bG/Z:u/\",gn\u00144gg\u0016$Hk\\8M_^D3!!\u0003|\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'\tqB]3tKR\fe\u000eZ\"p]N,X.\u001a\u000b\b\u0017\u0006U\u0011\u0011DA\u0015\u0011\u001d\t9\"a\u0004A\u0002-\u000b1B\\;n\u001b\u0016\u001c8/Y4fg\"A\u00111DA\b\u0001\u0004\ti\"A\u0004sKN,G\u000fV8\u0011\t\u0005}\u0011Q\u0005\b\u0004\u0019\u0006\u0005\u0012bAA\u0012S\u00051\u0001K]3eK\u001aL1!PA\u0014\u0015\r\t\u0019#\u000b\u0005\t\u0003W\ty\u00011\u0001\u0002.\u00051qN\u001a4tKR\u00042\u0001TA\u0018\u0013\r\t\t$\u000b\u0002\u0005\u0019>tw\rK\u0004\u0001\u0003k\tY$a\u0010\u0011\u00071\u000b9$C\u0002\u0002:%\u0012!\u0002Z3qe\u0016\u001c\u0017\r^3eC\t\ti$\u0001%UQ&\u001c\b\u0005^3ti\u0002B\u0017m\u001d\u0011cK\u0016t\u0007\u0005Z3qe\u0016\u001c\u0017\r^3eA\u0005tG\rI5uA]LG\u000e\u001c\u0011cK\u0002\u0012X-\\8wK\u0012\u0004\u0013N\u001c\u0011bA\u0019,H/\u001e:fAI,G.Z1tK\u0006\u0012\u0011\u0011I\u0001\ta9\n\u0004G\f\u0019/a\u0001")
public class AutoOffsetResetTest
extends JUnitSuite
implements KafkaServerTestHarness {
    private final String topic;
    private final String group;
    private final String testConsumer;
    private final int NumMessages;
    private final int LargeOffset;
    private final int SmallOffset;
    private final Logger requestHandlerLogger;
    private Seq<KafkaConfig> instanceConfigs;
    private Buffer<KafkaServer> servers;
    private String brokerList;
    private boolean[] alive;
    private final String kafkaPrincipalType;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public Seq<KafkaConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    @Override
    public void instanceConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.instanceConfigs = x$1;
    }

    @Override
    public Buffer<KafkaServer> servers() {
        return this.servers;
    }

    @Override
    public void servers_$eq(Buffer<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public String brokerList() {
        return this.brokerList;
    }

    @Override
    public void brokerList_$eq(String x$1) {
        this.brokerList = x$1;
    }

    @Override
    public boolean[] alive() {
        return this.alive;
    }

    @Override
    public void alive_$eq(boolean[] x$1) {
        this.alive = x$1;
    }

    @Override
    public String kafkaPrincipalType() {
        return this.kafkaPrincipalType;
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$_setter_$kafkaPrincipalType_$eq(String x$1) {
        this.kafkaPrincipalType = x$1;
    }

    @Override
    public void setAclsBeforeServersStart() {
        KafkaServerTestHarness$class.setAclsBeforeServersStart(this);
    }

    @Override
    public Seq<KafkaConfig> configs() {
        return KafkaServerTestHarness$class.configs(this);
    }

    @Override
    public Option<KafkaServer> serverForId(int id) {
        return KafkaServerTestHarness$class.serverForId(this, id);
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return KafkaServerTestHarness$class.securityProtocol(this);
    }

    @Override
    public Option<File> trustStoreFile() {
        return KafkaServerTestHarness$class.trustStoreFile(this);
    }

    @Override
    public Option<Properties> saslProperties() {
        return KafkaServerTestHarness$class.saslProperties(this);
    }

    @Override
    public int killRandomBroker() {
        return KafkaServerTestHarness$class.killRandomBroker(this);
    }

    @Override
    public void restartDeadBrokers() {
        KafkaServerTestHarness$class.restartDeadBrokers(this);
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        AutoOffsetResetTest autoOffsetResetTest = this;
        synchronized (autoOffsetResetTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public List<KafkaConfig> generateConfigs() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16()))}));
    }

    public String topic() {
        return this.topic;
    }

    public String group() {
        return this.group;
    }

    public String testConsumer() {
        return this.testConsumer;
    }

    public int NumMessages() {
        return this.NumMessages;
    }

    public int LargeOffset() {
        return this.LargeOffset;
    }

    public int SmallOffset() {
        return this.SmallOffset;
    }

    public Logger requestHandlerLogger() {
        return this.requestHandlerLogger;
    }

    @Override
    @Before
    public void setUp() {
        KafkaServerTestHarness$class.setUp(this);
        this.requestHandlerLogger().setLevel(Level.FATAL);
    }

    @Override
    @After
    public void tearDown() {
        this.requestHandlerLogger().setLevel(Level.ERROR);
        KafkaServerTestHarness$class.tearDown(this);
    }

    @Test
    public void testResetToEarliestWhenOffsetTooHigh() {
        Assert.assertEquals((long)this.NumMessages(), (long)this.resetAndConsume(this.NumMessages(), "smallest", this.LargeOffset()));
    }

    @Test
    public void testResetToEarliestWhenOffsetTooLow() {
        Assert.assertEquals((long)this.NumMessages(), (long)this.resetAndConsume(this.NumMessages(), "smallest", this.SmallOffset()));
    }

    @Test
    public void testResetToLatestWhenOffsetTooHigh() {
        Assert.assertEquals((long)0L, (long)this.resetAndConsume(this.NumMessages(), "largest", this.LargeOffset()));
    }

    @Test
    public void testResetToLatestWhenOffsetTooLow() {
        Assert.assertEquals((long)0L, (long)this.resetAndConsume(this.NumMessages(), "largest", this.SmallOffset()));
    }

    public int resetAndConsume(int numMessages, String resetTo, long offset) {
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 1, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        String x$2 = StringEncoder.class.getName();
        String x$3 = TestUtils$.MODULE$.createProducer$default$2();
        String x$4 = TestUtils$.MODULE$.createProducer$default$4();
        Properties x$5 = TestUtils$.MODULE$.createProducer$default$5();
        Producer producer = TestUtils$.MODULE$.createProducer(x$1, x$3, x$2, x$4, x$5);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)new Serializable(this, producer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AutoOffsetResetTest $outer;
            private final Producer producer$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.producer$1.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(this.$outer.topic(), (Object)this.$outer.topic(), (Object)"test".getBytes())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.producer$1 = producer$1;
            }
        });
        ZKGroupTopicDirs dirs = new ZKGroupTopicDirs(this.group(), this.topic());
        Properties consumerProps = TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), this.group(), this.testConsumer(), TestUtils$.MODULE$.createConsumerProperties$default$4());
        consumerProps.put("auto.offset.reset", resetTo);
        consumerProps.put("consumer.timeout.ms", "2000");
        consumerProps.put("fetch.wait.max.ms", "0");
        ConsumerConfig consumerConfig = new ConsumerConfig(consumerProps);
        TestUtils$.MODULE$.updateConsumerOffset(consumerConfig, new StringBuilder().append((Object)dirs.consumerOffsetDir()).append((Object)"/").append((Object)"0").toString(), offset);
        this.info((Function0<String>)new Serializable(this, offset){
            public static final long serialVersionUID = 0L;
            private final long offset$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Updated consumer offset to ").append((Object)BoxesRunTime.boxToLong((long)this.offset$1)).toString();
            }
            {
                this.offset$1 = offset$1;
            }
        });
        ConsumerConnector consumerConnector = Consumer$.MODULE$.create(consumerConfig);
        KafkaStream messageStream = (KafkaStream)((IterableLike)consumerConnector.createMessageStreams((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.topic()), (Object)BoxesRunTime.boxToInteger((int)1))}))).apply((Object)this.topic())).head();
        IntRef received = new IntRef(0);
        ConsumerIterator iter = messageStream.iterator();
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)new Serializable(this, received, iter){
                public static final long serialVersionUID = 0L;
                private final IntRef received$1;
                private final ConsumerIterator iter$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    this.iter$1.next();
                    ++this.received$1.elem;
                }
                {
                    this.received$1 = received$1;
                    this.iter$1 = iter$1;
                }
            });
        }
        catch (ConsumerTimeoutException consumerTimeoutException) {
            this.info((Function0<String>)new Serializable(this, received){
                public static final long serialVersionUID = 0L;
                private final IntRef received$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"consumer timed out after receiving ").append((Object)BoxesRunTime.boxToInteger((int)this.received$1.elem)).append((Object)" messages.").toString();
                }
                {
                    this.received$1 = received$1;
                }
            });
        }
        finally {
            producer.close();
            consumerConnector.shutdown();
        }
        return received.elem;
    }

    public AutoOffsetResetTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        KafkaServerTestHarness$class.$init$(this);
        this.topic = "test_topic";
        this.group = "default_group";
        this.testConsumer = "consumer";
        this.NumMessages = 10;
        this.LargeOffset = 10000;
        this.SmallOffset = -1;
        this.requestHandlerLogger = Logger.getLogger(KafkaRequestHandler.class);
    }
}

