/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.DataOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import kafka.common.LogCleaningAbortedException;
import kafka.common.LongRef;
import kafka.common.TopicAndPartition;
import kafka.log.Cleaner;
import kafka.log.CleanerTest$;
import kafka.log.FakeOffsetMap;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.OffsetMap;
import kafka.message.ByteBufferMessageSet;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.CompressionFactory$;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet$;
import kafka.message.MessageWriter;
import kafka.message.NoCompressionCodec$;
import kafka.message.SnappyCompressionCodec$;
import kafka.utils.CoreUtils$;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.Throttler;
import kafka.utils.Throttler$;
import kafka.utils.Time;
import org.apache.kafka.common.record.LogEntry;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.ListSet$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;

@ScalaSignature(bytes="\u0006\u0001\t=e\u0001B\u0001\u0003\u0001\u001d\u00111b\u00117fC:,'\u000fV3ti*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u0013Ai\u0011A\u0003\u0006\u0003\u00171\tQA[;oSRT!!\u0004\b\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\b\u0002\u0007=\u0014x-\u0003\u0002\u0012\u0015\tQ!*\u00168jiN+\u0018\u000e^3\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005\u0011\u0001b\u0002\r\u0001\u0005\u0004%\t!G\u0001\u0007i6\u0004H-\u001b:\u0016\u0003i\u0001\"a\u0007\u0011\u000e\u0003qQ!!\b\u0010\u0002\u0005%|'\"A\u0010\u0002\t)\fg/Y\u0005\u0003Cq\u0011AAR5mK\"11\u0005\u0001Q\u0001\ni\tq\u0001^7qI&\u0014\b\u0005C\u0004&\u0001\t\u0007I\u0011A\r\u0002\u0007\u0011L'\u000f\u0003\u0004(\u0001\u0001\u0006IAG\u0001\u0005I&\u0014\b\u0005C\u0004*\u0001\t\u0007I\u0011\u0001\u0016\u0002\u00111|w\r\u0015:paN,\u0012a\u000b\t\u0003Y=j\u0011!\f\u0006\u0003]y\tA!\u001e;jY&\u0011\u0001'\f\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bB\u0002\u001a\u0001A\u0003%1&A\u0005m_\u001e\u0004&o\u001c9tA!9A\u0007\u0001b\u0001\n\u0003)\u0014!\u00037pO\u000e{gNZ5h+\u00051\u0004C\u0001\f8\u0013\tA$AA\u0005M_\u001e\u001cuN\u001c4jO\"1!\b\u0001Q\u0001\nY\n!\u0002\\8h\u0007>tg-[4!\u0011\u001da\u0004A1A\u0005\u0002u\nA\u0001^5nKV\ta\b\u0005\u0002@\u00056\t\u0001I\u0003\u0002B\t\u0005)Q\u000f^5mg&\u00111\t\u0011\u0002\t\u001b>\u001c7\u000eV5nK\"1Q\t\u0001Q\u0001\ny\nQ\u0001^5nK\u0002Bqa\u0012\u0001C\u0002\u0013\u0005\u0001*A\u0005uQJ|G\u000f\u001e7feV\t\u0011\n\u0005\u0002@\u0015&\u00111\n\u0011\u0002\n)\"\u0014x\u000e\u001e;mKJDa!\u0014\u0001!\u0002\u0013I\u0015A\u0003;ie>$H\u000f\\3sA!)q\n\u0001C\u0001!\u0006AA/Z1sI><h\u000eF\u0001R!\t\u0011V+D\u0001T\u0015\u0005!\u0016!B:dC2\f\u0017B\u0001,T\u0005\u0011)f.\u001b;)\u00059C\u0006CA-\\\u001b\u0005Q&BA\u0006\u000f\u0013\ta&LA\u0003BMR,'\u000fC\u0003_\u0001\u0011\u0005\u0001+A\tuKN$8\t\\3b]N+w-\\3oiND#!\u00181\u0011\u0005e\u000b\u0017B\u00012[\u0005\u0011!Vm\u001d;\t\u000b\u0011\u0004A\u0011\u0001)\u0002!Q,7\u000f\u001e'be\u001e,W*Z:tC\u001e,\u0007FA2a\u0011\u00159\u0007\u0001\"\u0001Q\u0003]!Xm\u001d;DY\u0016\fg.\u001b8h/&$\b\u000eR3mKR,7\u000f\u000b\u0002gA\")!\u000e\u0001C\u0001!\u00069B/Z:u!\u0006\u0014H/[1m'\u0016<W.\u001a8u\u00072,\u0017M\u001c\u0015\u0003S\u0002DQ!\u001c\u0001\u0005\u0002A\u000b!\u0005^3ti\u000ecW-\u00198j]\u001e<\u0016\u000e\u001e5V]\u000edW-\u00198bE2,7+Z2uS>t\u0007F\u00017a\u0011\u0015\u0001\b\u0001\"\u0001Q\u00039!Xm\u001d;M_\u001e$vn\u00117fC:D#a\u001c1\t\u000bM\u0004A\u0011\u0001)\u0002IQ,7\u000f\u001e'pOR{7\t\\3b]^KG\u000f[+oG2,\u0017M\\1cY\u0016\u001cVm\u0019;j_:D#A\u001d1\t\u000bY\u0004A\u0011\u0001)\u0002?Q,7\u000f^\"mK\u0006t\u0017N\\4XSRDWK\\6fs\u0016$W*Z:tC\u001e,7\u000f\u000b\u0002vA\")\u0011\u0010\u0001C\u0001u\u0006I1.Z=t\u0013:dun\u001a\u000b\u0004w\u0006%\u0001\u0003\u0002?\u0000\u0003\u0007i\u0011! \u0006\u0003}N\u000b!bY8mY\u0016\u001cG/[8o\u0013\r\t\t! \u0002\t\u0013R,'/\u00192mKB\u0019!+!\u0002\n\u0007\u0005\u001d1KA\u0002J]RDaa\u0001=A\u0002\u0005-\u0001c\u0001\f\u0002\u000e%\u0019\u0011q\u0002\u0002\u0003\u00071{w\rC\u0004\u0002\u0014\u0001!\t!!\u0006\u0002\u0019=4gm]3ug&sGj\\4\u0015\t\u0005]\u0011q\u0004\t\u0005y~\fI\u0002E\u0002S\u00037I1!!\bT\u0005\u0011auN\\4\t\u000f\r\t\t\u00021\u0001\u0002\f!9\u00111\u0005\u0001\u0005\u0002\u0005\u0015\u0012\u0001G;oW\u0016LX\rZ'fgN\fw-Z\"pk:$\u0018J\u001c'pOR!\u00111AA\u0014\u0011\u001d\u0019\u0011\u0011\u0005a\u0001\u0003\u0017Aq!a\u000b\u0001\t\u0003\ti#\u0001\bbE>\u0014Ho\u00115fG.$uN\\3\u0015\u0007E\u000by\u0003\u0003\u0005\u00022\u0005%\u0002\u0019AA\u001a\u0003E!x\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\u001c\t\u0005\u0003k\tY$\u0004\u0002\u00028)\u0019\u0011\u0011\b\u0003\u0002\r\r|W.\\8o\u0013\u0011\ti$a\u000e\u0003#Q{\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004\u0002B\u0001!\t\u0001U\u0001\u001bi\u0016\u001cHo\u00117fC:\u001cVmZ7f]R\u001cx+\u001b;i\u0003\n|'\u000f\u001e\u0015\u0004\u0003\u007f\u0001\u0007BBA$\u0001\u0011\u0005\u0001+A\nuKN$8+Z4nK:$xI]8va&tw\rK\u0002\u0002F\u0001Da!!\u0014\u0001\t\u0003\u0001\u0016\u0001\n;fgR\u001cVmZ7f]R<%o\\;qS:<w+\u001b;i'B\f'o]3PM\u001a\u001cX\r^:)\u0007\u0005-\u0003\rC\u0004\u0002T\u0001!I!!\u0016\u0002#\rDWmY6TK\u001elWM\u001c;Pe\u0012,'\u000fF\u0002R\u0003/B\u0001\"!\u0017\u0002R\u0001\u0007\u00111L\u0001\u0007OJ|W\u000f]:\u0011\u000bq\fi&!\u0019\n\u0007\u0005}SPA\u0002TKF\u0004R\u0001`A/\u0003G\u00022AFA3\u0013\r\t9G\u0001\u0002\u000b\u0019><7+Z4nK:$\bBBA6\u0001\u0011\u0005\u0001+\u0001\nuKN$()^5mI>3gm]3u\u001b\u0006\u0004\bfAA5A\"1\u0011\u0011\u000f\u0001\u0005\u0002A\u000ba\u0003^3tiJ+7m\u001c<fef\fe\r^3s\u0007J\f7\u000f\u001b\u0015\u0004\u0003_\u0002\u0007BBA<\u0001\u0011\u0005\u0001+A\u000euKN$()^5mI>3gm]3u\u001b\u0006\u0004h)Y6f\u0019\u0006\u0014x-\u001a\u0015\u0004\u0003k\u0002\u0007BBA?\u0001\u0011\u0005\u0001+A\ruKN$()^5mIB\u000b'\u000f^5bY>3gm]3u\u001b\u0006\u0004\bfAA>A\"1\u00111\u0011\u0001\u0005\u0002A\u000b!\u0004^3ti\u000ecW-\u00198D_J\u0014X\u000f\u001d;NKN\u001c\u0018mZ3TKRD3!!!a\u0011\u0019\tI\t\u0001C\u0001!\u0006)C/Z:u\u00072LWM\u001c;IC:$G.\u001b8h\u001f\u001a\u001cuN\u001d:vaRlUm]:bO\u0016\u001cV\r\u001e\u0015\u0004\u0003\u000f\u0003\u0007bBAH\u0001\u0011%\u0011\u0011S\u0001\u000boJLG/\u001a+p\u0019><G\u0003CA\f\u0003'\u000b)*!)\t\u000f\r\ti\t1\u0001\u0002\f!A\u0011qSAG\u0001\u0004\tI*A\u0007lKf\u001c\u0018I\u001c3WC2,Xm\u001d\t\u0005y~\fY\nE\u0004S\u0003;\u000b\u0019!a\u0001\n\u0007\u0005}5K\u0001\u0004UkBdWM\r\u0005\t\u0003G\u000bi\t1\u0001\u0002\u0018\u0005IqN\u001a4tKR\u001cV-\u001d\u0005\b\u0003O\u0003A\u0011BAU\u0003UIgN^1mS\u0012\u001cE.Z1oK\u0012lUm]:bO\u0016$\u0002\"a+\u00028\u0006m\u0016Q\u0018\t\u0005\u0003[\u000b\u0019,\u0004\u0002\u00020*\u0019\u0011\u0011\u0017\u0003\u0002\u000f5,7o]1hK&!\u0011QWAX\u0005Q\u0011\u0015\u0010^3Ck\u001a4WM]'fgN\fw-Z*fi\"A\u0011\u0011XAS\u0001\u0004\tI\"A\u0007j]&$\u0018.\u00197PM\u001a\u001cX\r\u001e\u0005\t\u0003/\u000b)\u000b1\u0001\u0002\u001a\"Q\u0011qXAS!\u0003\u0005\r!!1\u0002\u000b\r|G-Z2\u0011\t\u00055\u00161Y\u0005\u0005\u0003\u000b\fyK\u0001\tD_6\u0004(/Z:tS>t7i\u001c3fG\"9\u0011\u0011\u001a\u0001\u0005\n\u0005-\u0017!E7fgN\fw-Z,ji\"|eMZ:fiRA\u00111VAg\u0003#\f)\u000e\u0003\u0005\u0002P\u0006\u001d\u0007\u0019AA\u0002\u0003\rYW-\u001f\u0005\t\u0003'\f9\r1\u0001\u0002\u0004\u0005)a/\u00197vK\"A\u0011q[Ad\u0001\u0004\tI\"\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\b\u00037\u0004A\u0011AAo\u0003\u001di\u0017m[3M_\u001e$b!a\u0003\u0002`\u0006\u0005\b\u0002C\u0013\u0002ZB\u0005\t\u0019\u0001\u000e\t\u0013\u0005\r\u0018\u0011\u001cI\u0001\u0002\u00041\u0014AB2p]\u001aLw\rC\u0004\u0002h\u0002!\t!!;\u0002\u001b9|w\n]\"iK\u000e\\Gi\u001c8f)\r\t\u00161\u001e\u0005\t\u0003c\t)\u000f1\u0001\u00024!9\u0011q\u001e\u0001\u0005\u0002\u0005E\u0018aC7bW\u0016\u001cE.Z1oKJ$\u0002\"a=\u0002z\u0006u(q\u0001\t\u0004-\u0005U\u0018bAA|\u0005\t91\t\\3b]\u0016\u0014\b\u0002CA~\u0003[\u0004\r!a\u0001\u0002\u0011\r\f\u0007/Y2jifD!\"a@\u0002nB\u0005\t\u0019\u0001B\u0001\u0003%\u0019\u0007.Z2l\t>tW\r\u0005\u0004S\u0005\u0007\t\u0019$U\u0005\u0004\u0005\u000b\u0019&!\u0003$v]\u000e$\u0018n\u001c82\u0011)\u0011I!!<\u0011\u0002\u0003\u0007\u00111A\u0001\u000f[\u0006DX*Z:tC\u001e,7+\u001b>f\u0011\u001d\ty\t\u0001C\u0001\u0005\u001b!b!a\u0006\u0003\u0010\tE\u0001bB\u0002\u0003\f\u0001\u0007\u00111\u0002\u0005\t\u0005'\u0011Y\u00011\u0001\u0002\u001a\u0006\u00191/Z9\t\u000f\u0005=\u0007\u0001\"\u0001\u0003\u0018Q!!\u0011\u0004B\u0013!\u0011\u0011YB!\t\u000e\u0005\tu!b\u0001B\u0010=\u0005\u0019a.[8\n\t\t\r\"Q\u0004\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\b\u0002\u0003B\u0014\u0005+\u0001\r!a\u0001\u0002\u0005%$\u0007bBAY\u0001\u0011\u0005!1\u0006\u000b\u0007\u0003W\u0013iCa\f\t\u0011\u0005='\u0011\u0006a\u0001\u0003\u0007A\u0001\"a5\u0003*\u0001\u0007\u00111\u0001\u0005\b\u0003c\u0003A\u0011\u0001B\u001a)\u0019\tYK!\u000e\u00038!A\u0011q\u001aB\u0019\u0001\u0004\t\u0019\u0001\u0003\u0005\u0002T\nE\u0002\u0019\u0001B\u001d!\u0015\u0011&1\bB \u0013\r\u0011id\u0015\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004%\n\u0005\u0013b\u0001B\"'\n!!)\u001f;f\u0011\u001d\u00119\u0005\u0001C\u0001\u0005\u0013\na\"\u001e8lKf,G-T3tg\u0006<W\r\u0006\u0003\u0002,\n-\u0003\u0002CAj\u0005\u000b\u0002\r!a\u0001\t\u000f\t=\u0003\u0001\"\u0001\u0003R\u0005iA-\u001a7fi\u0016lUm]:bO\u0016$B!a+\u0003T!A\u0011q\u001aB'\u0001\u0004\t\u0019\u0001C\u0005\u0003X\u0001\t\n\u0011\"\u0001\u0003Z\u0005)R.Y6f\u00072,\u0017M\\3sI\u0011,g-Y;mi\u0012\u0012TC\u0001B.U\u0011\u0011\tA!\u0018,\u0005\t}\u0003\u0003\u0002B1\u0005Wj!Aa\u0019\u000b\t\t\u0015$qM\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u001bT\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005[\u0012\u0019GA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011B!\u001d\u0001#\u0003%\tAa\u001d\u0002+5\f7.Z\"mK\u0006tWM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!Q\u000f\u0016\u0005\u0003\u0007\u0011i\u0006C\u0005\u0003z\u0001\t\n\u0011\"\u0001\u0003|\u0005\tR.Y6f\u0019><G\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tu$f\u0001\u000e\u0003^!I!\u0011\u0011\u0001\u0012\u0002\u0013\u0005!1Q\u0001\u0012[\u0006\\W\rT8hI\u0011,g-Y;mi\u0012\u0012TC\u0001BCU\r1$Q\f\u0005\n\u0005\u0013\u0003\u0011\u0013!C\u0005\u0005\u0017\u000bq$\u001b8wC2LGm\u00117fC:,G-T3tg\u0006<W\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011iI\u000b\u0003\u0002B\nu\u0003")
public class CleanerTest
extends JUnitSuite {
    private final File tmpdir = TestUtils$.MODULE$.tempDir();
    private final File dir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpdir());
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private final MockTime time;
    private final Throttler throttler;

    public File tmpdir() {
        return this.tmpdir;
    }

    public File dir() {
        return this.dir;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    @After
    public void teardown() {
        Utils.delete((File)this.tmpdir());
    }

    @Test
    public void testCleanSegments() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$29 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$30 = this.makeLog$default$1();
        Log log = this.makeLog(x$30, x$29);
        while (log.numberOfSegments() < 4) {
            log.append(this.message((int)log.logEndOffset(), (int)log.logEndOffset()), log.append$default$2());
        }
        Iterable<Object> keysFound = this.keysInLog(log);
        Assert.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())), keysFound);
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 5, 7, 9}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final FakeOffsetMap map$1;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.map$1.put(this.$outer.key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.map$1 = map$1;
            }
        });
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(3)).toSeq(), (OffsetMap)map, 0L);
        Iterable shouldRemain = (Iterable)this.keysInLog(log).filter((Function1)new Serializable(this, keys){
            public static final long serialVersionUID = 0L;
            private final ListSet keys$1;

            public final boolean apply(int x$1) {
                return this.apply$mcZI$sp(x$1);
            }

            public boolean apply$mcZI$sp(int x$1) {
                return !this.keys$1.contains((Object)BoxesRunTime.boxToInteger((int)x$1));
            }
            {
                this.keys$1 = keys$1;
            }
        });
        Assert.assertEquals((Object)shouldRemain, this.keysInLog(log));
    }

    @Test
    public void testLargeMessage() {
        int largeMessageSize = 0x100000;
        int x$35 = Integer.MAX_VALUE;
        int x$36 = 1024;
        Function1<TopicAndPartition, BoxedUnit> x$37 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(x$35, x$37, x$36);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 16));
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 2));
        LogConfig x$38 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$39 = this.makeLog$default$1();
        Log log = this.makeLog(x$39, x$38);
        while (log.numberOfSegments() < 2) {
            log.append(this.message((int)log.logEndOffset(), (byte[])Array$.MODULE$.fill(largeMessageSize, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final byte apply() {
                    return this.apply$mcB$sp();
                }

                public byte apply$mcB$sp() {
                    return 0;
                }
            }, ClassTag$.MODULE$.Byte())), log.append$default$2());
        }
        Iterable<Object> keysFound = this.keysInLog(log);
        Assert.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())), keysFound);
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 5, 7, 9}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final FakeOffsetMap map$2;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.map$2.put(this.$outer.key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.map$2 = map$2;
            }
        });
        cleaner.cleanSegments(log, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)log.logSegments().head()})), (OffsetMap)map, 0L);
        Iterable shouldRemain = (Iterable)this.keysInLog(log).filter((Function1)new Serializable(this, keys){
            public static final long serialVersionUID = 0L;
            private final ListSet keys$2;

            public final boolean apply(int x$2) {
                return this.apply$mcZI$sp(x$2);
            }

            public boolean apply$mcZI$sp(int x$2) {
                return !this.keys$2.contains((Object)BoxesRunTime.boxToInteger((int)x$2));
            }
            {
                this.keys$2 = keys$2;
            }
        });
        Assert.assertEquals((Object)shouldRemain, this.keysInLog(log));
    }

    @Test
    public void testCleaningWithDeletes() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$40 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$41 = this.makeLog$default$1();
        Log log = this.makeLog(x$41, x$40);
        while (log.numberOfSegments() < 2) {
            log.append(this.message((int)log.logEndOffset(), (int)log.logEndOffset()), log.append$default$2());
        }
        long leo = log.logEndOffset();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)leo).by(2).foreach((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final Log log$1;

            public final LogAppendInfo apply(int key) {
                return this.log$1.append(this.$outer.deleteMessage(key), this.log$1.append$default$2());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.log$1 = log$1;
            }
        });
        while (log.numberOfSegments() < 4) {
            log.append(this.message((int)log.logEndOffset(), (int)log.logEndOffset()), log.append$default$2());
        }
        cleaner.clean(new LogToClean(new TopicAndPartition("test", 0), log, 0L, log.activeSegment().baseOffset()));
        Set keys = this.keysInLog(log).toSet();
        Assert.assertTrue((String)"None of the keys we deleted should still exist.", (boolean)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)leo).by(2).forall((Function1)new Serializable(this, keys){
            public static final long serialVersionUID = 0L;
            private final Set keys$3;

            public final boolean apply(int x$3) {
                return this.apply$mcZI$sp(x$3);
            }

            public boolean apply$mcZI$sp(int x$3) {
                return !this.keys$3.contains((Object)BoxesRunTime.boxToInteger((int)x$3));
            }
            {
                this.keys$3 = keys$3;
            }
        }));
    }

    @Test
    public void testPartialSegmentClean() {
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$46 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$47 = this.makeLog$default$1();
        Log log = this.makeLog(x$47, x$46);
        log.append(this.message(0, 0), log.append$default$2());
        log.append(this.message(1, 1), log.append$default$2());
        log.append(this.message(0, 0), log.append$default$2());
        log.append(this.message(1, 1), log.append$default$2());
        log.append(this.message(0, 0), log.append$default$2());
        log.roll();
        cleaner.clean(new LogToClean(new TopicAndPartition("test", 0), log, 2L, log.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0, 1, 0})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), this.offsetsInLog(log));
        cleaner.clean(new LogToClean(new TopicAndPartition("test", 0), log, 3L, log.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 0})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), this.offsetsInLog(log));
        cleaner.clean(new LogToClean(new TopicAndPartition("test", 0), log, 4L, log.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log));
    }

    @Test
    public void testCleaningWithUncleanableSection() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$48 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$49 = this.makeLog$default$1();
        Log log = this.makeLog(x$49, x$48);
        int N = 10;
        int numCleanableSegments = 2;
        int numTotalSegments = 7;
        while (log.numberOfSegments() <= numCleanableSegments) {
            log.append(this.message((int)log.logEndOffset() % N, (int)log.logEndOffset()), log.append$default$2());
        }
        long firstUncleanableOffset = log.logEndOffset() + 1L;
        while (log.numberOfSegments() < numTotalSegments - 1) {
            log.append(this.message((int)log.logEndOffset() % N, (int)log.logEndOffset()), log.append$default$2());
        }
        Seq disctinctValuesBySegmentBeforeClean = this.distinctValuesBySegment$1(log);
        Assert.assertTrue((String)"Test is not effective unless each segment contains duplicates. Increase segment size or decrease number of keys.", (boolean)((IterableLike)((TraversableLike)this.distinctValuesBySegment$1(log).reverse()).tail()).forall((Function1)new Serializable(this, N){
            public static final long serialVersionUID = 0L;
            private final int N$1;

            public final boolean apply(int x$4) {
                return this.apply$mcZI$sp(x$4);
            }

            public boolean apply$mcZI$sp(int x$4) {
                return x$4 > this.N$1;
            }
            {
                this.N$1 = N$1;
            }
        }));
        cleaner.clean(new LogToClean(new TopicAndPartition("test", 0), log, 0L, firstUncleanableOffset));
        Seq distinctValuesBySegmentAfterClean = this.distinctValuesBySegment$1(log);
        Assert.assertTrue((String)"The cleanable segments should have fewer number of values after cleaning", (boolean)((IterableLike)((IterableLike)disctinctValuesBySegmentBeforeClean.zip((GenIterable)distinctValuesBySegmentAfterClean, Seq$.MODULE$.canBuildFrom())).take(numCleanableSegments)).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    int before = tuple2._1$mcI$sp();
                    int after = tuple2._2$mcI$sp();
                    boolean bl = after < before;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        }));
        Assert.assertTrue((String)"The uncleanable segments should have the same number of values after cleaning", (boolean)((IterableLike)((IterableLike)disctinctValuesBySegmentBeforeClean.zip((GenIterable)distinctValuesBySegmentAfterClean, Seq$.MODULE$.canBuildFrom())).slice(numCleanableSegments, numTotalSegments)).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> x) {
                return x._1$mcI$sp() == x._2$mcI$sp();
            }
        }));
    }

    @Test
    public void testLogToClean() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
        LogConfig x$50 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$51 = this.makeLog$default$1();
        Log log = this.makeLog(x$51, x$50);
        byte[] x$52 = (byte[])Array$.MODULE$.fill(50, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte apply() {
                return this.apply$mcB$sp();
            }

            public byte apply$mcB$sp() {
                return 0;
            }
        }, ClassTag$.MODULE$.Byte());
        byte[] x$53 = ((Object)BoxesRunTime.boxToInteger((int)1)).toString().getBytes();
        CompressionCodec x$54 = TestUtils$.MODULE$.singleMessageSet$default$2();
        long x$55 = TestUtils$.MODULE$.singleMessageSet$default$4();
        byte x$56 = TestUtils$.MODULE$.singleMessageSet$default$5();
        ByteBufferMessageSet messageSet = TestUtils$.MODULE$.singleMessageSet(x$52, x$54, x$53, x$55, x$56);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach((Function1)new Serializable(this, log, messageSet){
            public static final long serialVersionUID = 0L;
            private final Log log$3;
            private final ByteBufferMessageSet messageSet$1;

            public final LogAppendInfo apply(int i) {
                return this.log$3.append(this.messageSet$1, true);
            }
            {
                this.log$3 = log$3;
                this.messageSet$1 = messageSet$1;
            }
        });
        LogToClean logToClean = new LogToClean(new TopicAndPartition("test", 0), log, log.activeSegment().baseOffset(), log.activeSegment().baseOffset());
        Assert.assertEquals((String)"Total bytes of LogToClean should equal size of all segments excluding the active segment", (long)logToClean.totalBytes(), (long)(log.size() - log.activeSegment().size()));
    }

    @Test
    public void testLogToCleanWithUncleanableSection() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
        LogConfig x$57 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$58 = this.makeLog$default$1();
        Log log = this.makeLog(x$58, x$57);
        byte[] x$59 = (byte[])Array$.MODULE$.fill(50, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte apply() {
                return this.apply$mcB$sp();
            }

            public byte apply$mcB$sp() {
                return 0;
            }
        }, ClassTag$.MODULE$.Byte());
        byte[] x$60 = ((Object)BoxesRunTime.boxToInteger((int)1)).toString().getBytes();
        CompressionCodec x$61 = TestUtils$.MODULE$.singleMessageSet$default$2();
        long x$62 = TestUtils$.MODULE$.singleMessageSet$default$4();
        byte x$63 = TestUtils$.MODULE$.singleMessageSet$default$5();
        ByteBufferMessageSet messageSet = TestUtils$.MODULE$.singleMessageSet(x$59, x$61, x$60, x$62, x$63);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach((Function1)new Serializable(this, log, messageSet){
            public static final long serialVersionUID = 0L;
            private final Log log$4;
            private final ByteBufferMessageSet messageSet$2;

            public final LogAppendInfo apply(int i) {
                return this.log$4.append(this.messageSet$2, true);
            }
            {
                this.log$4 = log$4;
                this.messageSet$2 = messageSet$2;
            }
        });
        Seq segs = log.logSegments().toSeq();
        LogToClean logToClean = new LogToClean(new TopicAndPartition("test", 0), log, ((LogSegment)segs.apply(2)).baseOffset(), ((LogSegment)segs.apply(4)).baseOffset());
        long expectedCleanSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)segs.take(2)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogSegment x$5) {
                return x$5.size();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        long expectedCleanableSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)segs.slice(2, 4)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogSegment x$6) {
                return x$6.size();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        long expectedUncleanableSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)segs.drop(4)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogSegment x$7) {
                return x$7.size();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        Assert.assertEquals((String)"Uncleanable bytes of LogToClean should equal size of all segments prior the one containing first dirty", (long)logToClean.cleanBytes(), (long)expectedCleanSize);
        Assert.assertEquals((String)"Cleanable bytes of LogToClean should equal size of all segments from the one containing first dirty offset to the segment prior to the one with the first uncleanable offset", (long)logToClean.cleanableBytes(), (long)expectedCleanableSize);
        Assert.assertEquals((String)"Total bytes should be the sum of the clean and cleanable segments", (long)logToClean.totalBytes(), (long)(expectedCleanSize + expectedCleanableSize));
        Assert.assertEquals((String)"Total cleanable ratio should be the ratio of cleanable size to clean plus cleanable", (double)logToClean.cleanableRatio(), (double)((double)expectedCleanableSize / (double)(expectedCleanSize + expectedCleanableSize)), (double)1.0E-6);
    }

    @Test
    public void testCleaningWithUnkeyedMessages() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        LogConfig x$64 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$65 = this.makeLog$default$1();
        Log log = this.makeLog(x$65, x$64);
        while (log.numberOfSegments() < 2) {
            log.append(this.unkeyedMessage((int)log.logEndOffset()), log.append$default$2());
        }
        int numInvalidMessages = this.unkeyedMessageCountInLog(log);
        long sizeWithUnkeyedMessages = log.size();
        while (log.numberOfSegments() < 3) {
            log.append(this.message((int)log.logEndOffset(), (int)log.logEndOffset()), log.append$default$2());
        }
        long expectedSizeAfterCleaning = log.size() - sizeWithUnkeyedMessages;
        cleaner.clean(new LogToClean(new TopicAndPartition("test", 0), log, 0L, log.activeSegment().baseOffset()));
        Assert.assertEquals((String)"Log should only contain keyed messages after cleaning.", (long)0L, (long)this.unkeyedMessageCountInLog(log));
        Assert.assertEquals((String)"Log should only contain keyed messages after cleaning.", (long)expectedSizeAfterCleaning, (long)log.size());
        Assert.assertEquals((String)"Cleaner should have seen %d invalid messages.", (long)numInvalidMessages, (long)cleaner.stats().invalidMessagesRead());
    }

    public Iterable<Object> keysInLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Object> apply(LogSegment s) {
                return (Iterable)((TraversableLike)((TraversableLike)s.log().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(MessageAndOffset x$8) {
                        return !x$8.message().isNull();
                    }
                })).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(MessageAndOffset x$9) {
                        return x$9.message().hasKey();
                    }
                })).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(MessageAndOffset m) {
                        return new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(m.message().key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public Iterable<Object> offsetsInLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Object> apply(LogSegment s) {
                return (Iterable)((TraversableLike)((TraversableLike)s.log().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(MessageAndOffset x$10) {
                        return !x$10.message().isNull();
                    }
                })).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(MessageAndOffset x$11) {
                        return x$11.message().hasKey();
                    }
                })).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(MessageAndOffset m) {
                        return m.offset();
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public int unkeyedMessageCountInLog(Log log) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment s) {
                return ((TraversableOnce)s.log().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(MessageAndOffset x$12) {
                        return !x$12.message().isNull();
                    }
                })).count((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(MessageAndOffset m) {
                        return !m.message().hasKey();
                    }
                });
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public void abortCheckDone(TopicAndPartition topicAndPartition) {
        throw new LogCleaningAbortedException();
    }

    @Test
    public void testCleanSegmentsWithAbort() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, (Function1<TopicAndPartition, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;

            public final void apply(TopicAndPartition topicAndPartition) {
                this.$outer.abortCheckDone(topicAndPartition);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$66 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$67 = this.makeLog$default$1();
        Log log = this.makeLog(x$67, x$66);
        while (log.numberOfSegments() < 4) {
            log.append(this.message((int)log.logEndOffset(), (int)log.logEndOffset()), log.append$default$2());
        }
        Iterable<Object> keys = this.keysInLog(log);
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final FakeOffsetMap map$3;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.map$3.put(this.$outer.key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.map$3 = map$3;
            }
        });
        this.intercept((Function0)new Serializable(this, cleaner, log, map){
            public static final long serialVersionUID = 0L;
            private final Cleaner cleaner$1;
            private final Log log$5;
            private final FakeOffsetMap map$3;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.cleaner$1.cleanSegments(this.log$5, ((TraversableOnce)this.log$5.logSegments().take(3)).toSeq(), (OffsetMap)this.map$3, 0L);
            }
            {
                this.cleaner$1 = cleaner$1;
                this.log$5 = log$5;
                this.map$3 = map$3;
            }
        }, ManifestFactory$.MODULE$.classType(LogCleaningAbortedException.class));
    }

    @Test
    public void testSegmentGrouping() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig x$68 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$69 = this.makeLog$default$1();
        Log log = this.makeLog(x$69, x$68);
        int i = 0;
        while (log.numberOfSegments() < 10) {
            byte[] x$70 = "hello".getBytes();
            byte[] x$71 = "hello".getBytes();
            CompressionCodec x$72 = TestUtils$.MODULE$.singleMessageSet$default$2();
            long x$73 = TestUtils$.MODULE$.singleMessageSet$default$4();
            byte x$74 = TestUtils$.MODULE$.singleMessageSet$default$5();
            log.append(TestUtils$.MODULE$.singleMessageSet(x$70, x$72, x$71, x$73, x$74), log.append$default$2());
            ++i;
        }
        List groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE);
        Assert.assertEquals((long)1L, (long)groups.size());
        Assert.assertEquals((long)log.numberOfSegments(), (long)((SeqLike)groups.head()).size());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        groups = cleaner.groupSegmentsBySize(log.logSegments(), 1, Integer.MAX_VALUE);
        Assert.assertEquals((long)log.numberOfSegments(), (long)groups.size());
        Assert.assertTrue((String)"All groups should be singletons.", (boolean)groups.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Seq<LogSegment> x$13) {
                return x$13.size() == 1;
            }
        }));
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, 1);
        Assert.assertEquals((long)log.numberOfSegments(), (long)groups.size());
        Assert.assertTrue((String)"All groups should be singletons.", (boolean)groups.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Seq<LogSegment> x$14) {
                return x$14.size() == 1;
            }
        }));
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        int groupSize = 3;
        int logSize = (int)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)log.logSegments().take(groupSize)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogSegment x$15) {
                return x$15.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log.logSegments(), logSize, Integer.MAX_VALUE);
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assert.assertTrue((String)"All but the last group should be the target size.", (boolean)groups.dropRight(1).forall((Function1)new Serializable(this, groupSize){
            public static final long serialVersionUID = 0L;
            private final int groupSize$1;

            public final boolean apply(Seq<LogSegment> x$16) {
                return x$16.size() == this.groupSize$1;
            }
            {
                this.groupSize$1 = groupSize$1;
            }
        }));
        int indexSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)log.logSegments().take(groupSize)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$17) {
                return x$17.index().sizeInBytes();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, indexSize);
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assert.assertTrue((String)"All but the last group should be the target size.", (boolean)groups.dropRight(1).forall((Function1)new Serializable(this, groupSize){
            public static final long serialVersionUID = 0L;
            private final int groupSize$1;

            public final boolean apply(Seq<LogSegment> x$18) {
                return x$18.size() == this.groupSize$1;
            }
            {
                this.groupSize$1 = groupSize$1;
            }
        }));
    }

    @Test
    public void testSegmentGroupingWithSparseOffsets() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig x$75 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$76 = this.makeLog$default$1();
        Log log = this.makeLog(x$76, x$75);
        while (log.numberOfSegments() == 1) {
            byte[] x$77 = "hello".getBytes();
            byte[] x$78 = "hello".getBytes();
            CompressionCodec x$79 = TestUtils$.MODULE$.singleMessageSet$default$2();
            long x$80 = TestUtils$.MODULE$.singleMessageSet$default$4();
            byte x$81 = TestUtils$.MODULE$.singleMessageSet$default$5();
            log.append(TestUtils$.MODULE$.singleMessageSet(x$77, x$79, x$78, x$80, x$81), log.append$default$2());
        }
        ByteBufferMessageSet messageSet = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, new LongRef(0x7FFFFFFEL), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes(), "hello".getBytes(), Message$.MODULE$.NoTimestamp(), Message$.MODULE$.MagicValue_V1())}));
        log.append(messageSet, false);
        byte[] x$82 = "hello".getBytes();
        byte[] x$83 = "hello".getBytes();
        CompressionCodec x$84 = TestUtils$.MODULE$.singleMessageSet$default$2();
        long x$85 = TestUtils$.MODULE$.singleMessageSet$default$4();
        byte x$86 = TestUtils$.MODULE$.singleMessageSet$default$5();
        log.append(TestUtils$.MODULE$.singleMessageSet(x$82, x$84, x$83, x$85, x$86), log.append$default$2());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)log.activeSegment().index().lastOffset());
        List groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE);
        Assert.assertEquals((long)1L, (long)groups.size());
        byte[] x$87 = "hello".getBytes();
        byte[] x$88 = "hello".getBytes();
        CompressionCodec x$89 = TestUtils$.MODULE$.singleMessageSet$default$2();
        long x$90 = TestUtils$.MODULE$.singleMessageSet$default$4();
        byte x$91 = TestUtils$.MODULE$.singleMessageSet$default$5();
        log.append(TestUtils$.MODULE$.singleMessageSet(x$87, x$89, x$88, x$90, x$91), log.append$default$2());
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE);
        Assert.assertEquals((long)2L, (long)groups.size());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        while (log.numberOfSegments() < 4) {
            byte[] x$92 = "hello".getBytes();
            byte[] x$93 = "hello".getBytes();
            CompressionCodec x$94 = TestUtils$.MODULE$.singleMessageSet$default$2();
            long x$95 = TestUtils$.MODULE$.singleMessageSet$default$4();
            byte x$96 = TestUtils$.MODULE$.singleMessageSet$default$5();
            log.append(TestUtils$.MODULE$.singleMessageSet(x$92, x$94, x$93, x$95, x$96), log.append$default$2());
        }
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE);
        Assert.assertEquals((long)(log.numberOfSegments() - 1), (long)groups.size());
        groups.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<LogSegment> group) {
                Assert.assertTrue((String)"Relative offset greater than Int.MaxValue", (((LogSegment)group.last()).index().lastOffset() - ((LogSegment)group.head()).index().baseOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0);
            }
        });
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
    }

    private void checkSegmentOrder(Seq<Seq<LogSegment>> groups) {
        Seq offsets = (Seq)groups.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Seq<LogSegment> x$19) {
                return (Seq)x$19.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(LogSegment x$20) {
                        return x$20.baseOffset();
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((String)"Offsets should be in increasing order.", (Object)offsets.sorted((Ordering)Ordering.Long$.MODULE$), (Object)offsets);
    }

    @Test
    public void testBuildOffsetMap() {
        FakeOffsetMap map = new FakeOffsetMap(1000);
        Log log = this.makeLog(this.makeLog$default$1(), this.makeLog$default$2());
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        int start2 = 0;
        int end = 500;
        Iterable<Object> offsets = this.writeToLog(log, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start2), end).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start2), end), IndexedSeq$.MODULE$.canBuildFrom())));
        Seq segments = log.logSegments().toSeq();
        this.checkRange$1(map, 0, (int)((LogSegment)segments.apply(1)).baseOffset(), log, cleaner);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(1)).baseOffset(), (int)((LogSegment)segments.apply(3)).baseOffset(), log, cleaner);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(3)).baseOffset(), (int)log.logEndOffset(), log, cleaner);
    }

    @Test
    public void testRecoveryAfterCrash() {
        LogConfig config;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.int2Integer(10));
        LogConfig x$99 = config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$100 = this.makeLog$default$1();
        Log log = this.makeLog(x$100, x$99);
        int messageCount = 0;
        while (log.numberOfSegments() < 10) {
            Log qual$1 = log;
            ByteBufferMessageSet x$101 = this.message((int)log.logEndOffset(), (int)log.logEndOffset());
            boolean x$102 = qual$1.append$default$2();
            qual$1.append(x$101, x$102);
            ++messageCount;
        }
        Iterable<Object> allKeys = this.keysInLog(log);
        FakeOffsetMap offsetMap = new FakeOffsetMap(Integer.MAX_VALUE);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)new Serializable(this, offsetMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final FakeOffsetMap offsetMap$1;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.offsetMap$1.put(this.$outer.key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.offsetMap$1 = offsetMap$1;
            }
        });
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L);
        Iterable<Object> cleanedKeys = this.keysInLog(log);
        ((LogSegment)log.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.CleanedFileSuffix());
        Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles()).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(File file) {
                Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), ""), new String[0]));
            }
        });
        log = this.recoverAndCheck$1(config, allKeys);
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L);
        cleanedKeys = this.keysInLog(log);
        ((LogSegment)log.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
        Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles()).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(File file) {
                Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), ""), new String[0]));
            }
        });
        log = this.recoverAndCheck$1(config, cleanedKeys);
        while (log.numberOfSegments() < 10) {
            Log qual$2 = log;
            ByteBufferMessageSet x$103 = this.message((int)log.logEndOffset(), (int)log.logEndOffset());
            boolean x$104 = qual$2.append$default$2();
            qual$2.append(x$103, x$104);
            ++messageCount;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)new Serializable(this, offsetMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final FakeOffsetMap offsetMap$1;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.offsetMap$1.put(this.$outer.key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.offsetMap$1 = offsetMap$1;
            }
        });
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L);
        cleanedKeys = this.keysInLog(log);
        ((LogSegment)log.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
        log = this.recoverAndCheck$1(config, cleanedKeys);
        while (log.numberOfSegments() < 10) {
            Log qual$3 = log;
            ByteBufferMessageSet x$105 = this.message((int)log.logEndOffset(), (int)log.logEndOffset());
            boolean x$106 = qual$3.append$default$2();
            qual$3.append(x$105, x$106);
            ++messageCount;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)new Serializable(this, offsetMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final FakeOffsetMap offsetMap$1;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.offsetMap$1.put(this.$outer.key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.offsetMap$1 = offsetMap$1;
            }
        });
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L);
        cleanedKeys = this.keysInLog(log);
        this.recoverAndCheck$1(config, cleanedKeys);
    }

    @Test
    public void testBuildOffsetMapFakeLarge() {
        LogConfig logConfig;
        FakeOffsetMap map = new FakeOffsetMap(1000);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(72));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(72));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        LogConfig x$107 = logConfig = new LogConfig((Map)logProps);
        File x$108 = this.makeLog$default$1();
        Log log = this.makeLog(x$108, x$107);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        int start2 = 0;
        int end = 2;
        Seq offsetSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 7206178L}));
        Iterable<Object> offsets = this.writeToLog(log, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start2), end).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start2), end), IndexedSeq$.MODULE$.canBuildFrom())), (Iterable<Object>)offsetSeq);
        cleaner.buildOffsetMap(log, (long)start2, (long)end, (OffsetMap)map);
        long endOffset = map.latestOffset();
        Assert.assertEquals((String)"Last offset should be the end offset.", (long)7206178L, (long)endOffset);
        Assert.assertEquals((String)"Should have the expected number of messages in the map.", (long)(end - start2), (long)map.size());
        Assert.assertEquals((String)"Map should contain first value", (long)0L, (long)map.get(this.key(0)));
        Assert.assertEquals((String)"Map should contain second value", (long)7206178L, (long)map.get(this.key(1)));
    }

    @Test
    public void testBuildPartialOffsetMap() {
        FakeOffsetMap map = new FakeOffsetMap(3);
        Log log = this.makeLog(this.makeLog$default$1(), this.makeLog$default$2());
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        log.append(this.message(0, 0), log.append$default$2());
        log.append(this.message(1, 1), log.append$default$2());
        log.append(this.message(2, 2), log.append$default$2());
        log.append(this.message(3, 3), log.append$default$2());
        log.append(this.message(4, 4), log.append$default$2());
        log.roll();
        cleaner.buildOffsetMap(log, 2L, Integer.MAX_VALUE, (OffsetMap)map);
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((long)-1L, (long)map.get(this.key(0)));
        Assert.assertEquals((long)2L, (long)map.get(this.key(2)));
        Assert.assertEquals((long)3L, (long)map.get(this.key(3)));
        Assert.assertEquals((long)-1L, (long)map.get(this.key(4)));
    }

    @Test
    public void testCleanCorruptMessageSet() {
        LogConfig logConfig;
        SnappyCompressionCodec$ codec = SnappyCompressionCodec$.MODULE$;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.CompressionTypeProp(), codec.name());
        LogConfig x$109 = logConfig = new LogConfig((Map)logProps);
        File x$110 = this.makeLog$default$1();
        Log log = this.makeLog(x$110, x$109);
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        IndexedSeq dupSetKeys = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2), IndexedSeq$.MODULE$.canBuildFrom());
        int dupSetOffset = 25;
        IndexedSeq dupSet = (IndexedSeq)dupSetKeys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(dupSetOffset), dupSetOffset + dupSetKeys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        Range noDupSetKeys = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(3), 5);
        int noDupSetOffset = 50;
        IndexedSeq noDupSet = (IndexedSeq)noDupSetKeys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(noDupSetOffset), noDupSetOffset + noDupSetKeys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        log.append(this.invalidCleanedMessage(dupSetOffset, (Iterable<Tuple2<Object, Object>>)dupSet, (CompressionCodec)codec), false);
        log.append(this.invalidCleanedMessage(noDupSetOffset, (Iterable<Tuple2<Object, Object>>)noDupSet, (CompressionCodec)codec), false);
        log.roll();
        cleaner.clean(new LogToClean(new TopicAndPartition("test", 0), log, 0L, log.activeSegment().baseOffset()));
        log.logSegments().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(LogSegment segment) {
                segment.log().iterator().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(MessageAndOffset shallowMessage) {
                        ByteBufferMessageSet$.MODULE$.deepIterator(shallowMessage, ByteBufferMessageSet$.MODULE$.deepIterator$default$2()).foreach((Function1)new Serializable(this, shallowMessage){
                            public static final long serialVersionUID = 0L;
                            private final MessageAndOffset shallowMessage$1;

                            public final void apply(MessageAndOffset deepMessage) {
                                Assert.assertEquals((long)this.shallowMessage$1.message().magic(), (long)deepMessage.message().magic());
                                long value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(deepMessage.message().payload(), TestUtils$.MODULE$.readString$default$2()))).toLong();
                                Assert.assertEquals((long)deepMessage.offset(), (long)value);
                            }
                            {
                                this.shallowMessage$1 = shallowMessage$1;
                            }
                        });
                    }
                });
            }
        });
    }

    @Test
    public void testClientHandlingOfCorruptMessageSet() {
        Range keys = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 10);
        int offset = 50;
        IndexedSeq set = (IndexedSeq)keys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(offset), offset + keys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        ByteBufferMessageSet corruptedMessage = this.invalidCleanedMessage(offset, (Iterable<Tuple2<Object, Object>>)set, this.invalidCleanedMessage$default$3());
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)corruptedMessage.buffer());
        ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(records.iterator()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(LogEntry logEntry) {
                long offset = logEntry.offset();
                long value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(logEntry.record().value(), TestUtils$.MODULE$.readString$default$2()))).toLong();
                Assert.assertEquals((long)offset, (long)value);
            }
        });
    }

    private Iterable<Object> writeToLog(Log log, Iterable<Tuple2<Object, Object>> keysAndValues, Iterable<Object> offsetSeq) {
        return (Iterable)((TraversableLike)keysAndValues.zip(offsetSeq, Iterable$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Tuple2<Object, Object>, Object> check$ifrefutable$1) {
                Tuple2 tuple2;
                Tuple2<Tuple2<Object, Object>, Object> tuple22 = check$ifrefutable$1;
                boolean bl = tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null;
                return bl;
            }
        }).map((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final Log log$8;

            public final long apply(Tuple2<Tuple2<Object, Object>, Object> x$21) {
                Tuple2<Tuple2<Object, Object>, Object> tuple2 = x$21;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    if (tuple22 != null) {
                        int key = tuple22._1$mcI$sp();
                        int value = tuple22._2$mcI$sp();
                        long l = this.log$8.append(this.$outer.kafka$log$CleanerTest$$messageWithOffset(key, value, offset), false).firstOffset();
                        return l;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.log$8 = log$8;
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    private ByteBufferMessageSet invalidCleanedMessage(long initialOffset, Iterable<Tuple2<Object, Object>> keysAndValues, CompressionCodec codec) {
        Iterable messages2 = (Iterable)keysAndValues.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Message apply(Tuple2<Object, Object> kv) {
                byte[] x$115 = ((Object)BoxesRunTime.boxToInteger((int)kv._1$mcI$sp())).toString().getBytes();
                byte[] x$116 = ((Object)BoxesRunTime.boxToInteger((int)kv._2$mcI$sp())).toString().getBytes();
                long x$117 = Message$.MODULE$.NoTimestamp();
                byte x$118 = Message$.MODULE$.MagicValue_V0();
                return new Message(x$116, x$115, x$117, x$118);
            }
        }, Iterable$.MODULE$.canBuildFrom());
        MessageWriter messageWriter = new MessageWriter(package$.MODULE$.min(package$.MODULE$.max(MessageSet$.MODULE$.messageSetSize(messages2) / 2, 1024), 65536));
        scala.runtime.LongRef lastOffset = new scala.runtime.LongRef(initialOffset);
        CompressionCodec x$119 = codec;
        long x$120 = Message$.MODULE$.NoTimestamp();
        TimestampType x$121 = TimestampType.CREATE_TIME;
        byte x$122 = Message$.MODULE$.MagicValue_V1();
        byte[] x$123 = messageWriter.write$default$1();
        Serializable x$124 = new Serializable(this, initialOffset, codec, messages2, lastOffset){
            public static final long serialVersionUID = 0L;
            public final long initialOffset$1;
            private final CompressionCodec codec$1;
            private final Iterable messages$1;
            public final scala.runtime.LongRef lastOffset$1;

            public final void apply(OutputStream outputStream) {
                try (DataOutputStream output = new DataOutputStream(CompressionFactory$.MODULE$.apply(this.codec$1, Message$.MODULE$.MagicValue_V1(), outputStream));){
                    this.messages$1.foreach((Function1)new Serializable(this, output){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$13 $outer;
                        private final DataOutputStream output$1;

                        public final void apply(Message message) {
                            long innerOffset = this.$outer.lastOffset$1.elem - this.$outer.initialOffset$1;
                            this.output$1.writeLong(innerOffset);
                            this.output$1.writeInt(message.size());
                            this.output$1.write(message.buffer().array(), message.buffer().arrayOffset(), message.buffer().limit());
                            ++this.$outer.lastOffset$1.elem;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.output$1 = output$1;
                        }
                    });
                    return;
                }
            }
            {
                this.initialOffset$1 = initialOffset$1;
                this.codec$1 = codec$1;
                this.messages$1 = messages$1;
                this.lastOffset$1 = lastOffset$1;
            }
        };
        messageWriter.write(x$123, x$119, x$120, x$121, x$122, (Function1)x$124);
        ByteBuffer buffer = ByteBuffer.allocate(messageWriter.size() + MessageSet$.MODULE$.LogOverhead());
        ByteBufferMessageSet$.MODULE$.writeMessage(buffer, messageWriter, lastOffset.elem - 1L);
        buffer.rewind();
        return new ByteBufferMessageSet(buffer);
    }

    private CompressionCodec invalidCleanedMessage$default$3() {
        return SnappyCompressionCodec$.MODULE$;
    }

    public ByteBufferMessageSet kafka$log$CleanerTest$$messageWithOffset(int key, int value, long offset) {
        Message[] messageArray = new Message[1];
        byte[] x$111 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
        byte[] x$112 = ((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes();
        long x$113 = Message$.MODULE$.NoTimestamp();
        byte x$114 = Message$.MODULE$.MagicValue_V1();
        messageArray[0] = new Message(x$112, x$111, x$113, x$114);
        return new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{offset})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])messageArray));
    }

    public Log makeLog(File dir, LogConfig config) {
        return new Log(dir, config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
    }

    public File makeLog$default$1() {
        return this.dir();
    }

    public LogConfig makeLog$default$2() {
        return this.logConfig();
    }

    public void noOpCheckDone(TopicAndPartition topicAndPartition) {
    }

    public Cleaner makeCleaner(int capacity, Function1<TopicAndPartition, BoxedUnit> checkDone, int maxMessageSize) {
        return new Cleaner(0, (OffsetMap)new FakeOffsetMap(capacity), maxMessageSize, maxMessageSize, 0.75, this.throttler(), (Time)this.time(), checkDone);
    }

    public Function1<TopicAndPartition, BoxedUnit> makeCleaner$default$2() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;

            public final void apply(TopicAndPartition topicAndPartition) {
                this.$outer.noOpCheckDone(topicAndPartition);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
    }

    public int makeCleaner$default$3() {
        return 65536;
    }

    public Iterable<Object> writeToLog(Log log, Iterable<Tuple2<Object, Object>> seq) {
        return (Iterable)seq.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> check$ifrefutable$2) {
                Tuple2<Object, Object> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).map((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final Log log$7;

            public final long apply(Tuple2<Object, Object> x$22) {
                Tuple2<Object, Object> tuple2 = x$22;
                if (tuple2 != null) {
                    int key = tuple2._1$mcI$sp();
                    int value = tuple2._2$mcI$sp();
                    long l = this.log$7.append(this.$outer.message(key, value), this.log$7.append$default$2()).firstOffset();
                    return l;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.log$7 = log$7;
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public ByteBuffer key(int id) {
        return ByteBuffer.wrap(((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
    }

    public ByteBufferMessageSet message(int key, int value) {
        return this.message(key, ((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes());
    }

    public ByteBufferMessageSet message(int key, byte[] value) {
        Message[] messageArray = new Message[1];
        byte[] x$31 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
        byte[] x$32 = value;
        long x$33 = Message$.MODULE$.NoTimestamp();
        byte x$34 = Message$.MODULE$.MagicValue_V1();
        messageArray[0] = new Message(x$32, x$31, x$33, x$34);
        return new ByteBufferMessageSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])messageArray));
    }

    public ByteBufferMessageSet unkeyedMessage(int value) {
        return new ByteBufferMessageSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message(((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes())}));
    }

    public ByteBufferMessageSet deleteMessage(int key) {
        Message[] messageArray = new Message[1];
        byte[] x$42 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
        Object x$43 = null;
        long x$44 = Message$.MODULE$.NoTimestamp();
        byte x$45 = Message$.MODULE$.MagicValue_V1();
        messageArray[0] = new Message(null, x$42, x$44, x$45);
        return new ByteBufferMessageSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])messageArray));
    }

    private final Seq distinctValuesBySegment$1(Log log$2) {
        return ((TraversableOnce)log$2.logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment s) {
                return ((TraversableOnce)s.log().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(MessageAndOffset m) {
                        return TestUtils$.MODULE$.readString(m.message().payload(), TestUtils$.MODULE$.readString$default$2());
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toSet().size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    private final void checkRange$1(FakeOffsetMap map, int start2, int end, Log log$6, Cleaner cleaner$2) {
        cleaner$2.buildOffsetMap(log$6, (long)start2, (long)end, (OffsetMap)map);
        long endOffset = map.latestOffset() + 1L;
        Assert.assertEquals((String)"Last offset should be the end offset.", (long)end, (long)endOffset);
        Assert.assertEquals((String)"Should have the expected number of messages in the map.", (long)(end - start2), (long)map.size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start2), end).foreach$mVc$sp((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final FakeOffsetMap map$4;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((String)"Should find all the keys", (long)i, (long)this.map$4.get(this.$outer.key(i)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.map$4 = map$4;
            }
        });
        Assert.assertEquals((String)"Should not find a value too small", (long)-1L, (long)map.get(this.key(start2 - 1)));
        Assert.assertEquals((String)"Should not find a value too large", (long)-1L, (long)map.get(this.key(end)));
    }

    /*
     * WARNING - void declaration
     */
    private final Log recoverAndCheck$1(LogConfig config, Iterable expectedKeys) {
        void var3_5;
        LogConfig x$97 = config;
        File x$98 = this.makeLog$default$1();
        Log recoveredLog = this.makeLog(x$98, x$97);
        this.time().sleep(Predef$.MODULE$.Long2long(config.fileDeleteDelayMs()) + 1L);
        Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(File file) {
                Assert.assertFalse((String)"Unexpected .deleted file after recovery", (boolean)file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix()));
                Assert.assertFalse((String)"Unexpected .cleaned file after recovery", (boolean)file.getName().endsWith(Log$.MODULE$.CleanedFileSuffix()));
                Assert.assertFalse((String)"Unexpected .swap file after recovery", (boolean)file.getName().endsWith(Log$.MODULE$.SwapFileSuffix()));
            }
        });
        Assert.assertEquals((Object)expectedKeys, this.keysInLog(recoveredLog));
        return var3_5;
    }

    public CleanerTest() {
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.logConfig = new LogConfig((Map)this.logProps());
        this.time = new MockTime();
        double x$23 = Double.MAX_VALUE;
        long x$24 = Long.MAX_VALUE;
        MockTime x$25 = this.time();
        boolean x$26 = Throttler$.MODULE$.$lessinit$greater$default$3();
        String x$27 = Throttler$.MODULE$.$lessinit$greater$default$4();
        String x$28 = Throttler$.MODULE$.$lessinit$greater$default$5();
        this.throttler = new Throttler(x$23, x$24, x$26, x$27, x$28, (Time)x$25);
    }
}

