/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.util.Map;
import java.util.Properties;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer$;
import kafka.server.ThrottledReplicaListValidator$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.ConfigException;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001Y3A!\u0001\u0002\u0001\u000f\tiAj\\4D_:4\u0017n\u001a+fgRT!a\u0001\u0003\u0002\u00071|wMC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g\u0011\u0015y\u0001\u0001\"\u0001\u0011\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0003\u0005\u0002\u0013\u00015\t!\u0001C\u0003\u0015\u0001\u0011\u0005Q#\u0001\fuKN$8*\u00194lC\u000e{gNZ5h)>\u0004&o\u001c9t)\u00051\u0002CA\u0005\u0018\u0013\tA\"B\u0001\u0003V]&$\bFA\n\u001b!\tY\u0002%D\u0001\u001d\u0015\tib$A\u0003kk:LGOC\u0001 \u0003\ry'oZ\u0005\u0003Cq\u0011A\u0001V3ti\")1\u0005\u0001C\u0001+\u0005\u0011B/Z:u\rJ|W\u000e\u0015:paN,U\u000e\u001d;zQ\t\u0011#\u0004C\u0003'\u0001\u0011\u0005Q#\u0001\u000buKN$hI]8n!J|\u0007o]%om\u0006d\u0017\u000e\u001a\u0015\u0003KiAQ!\u000b\u0001\u0005\u0002U\tQe\u001d5pk2$g+\u00197jI\u0006$X\r\u00165s_R$H.\u001a3SKBd\u0017nY1t\u0007>tg-[4)\u0005!R\u0002\"\u0002\u0017\u0001\t\u0013i\u0013aB5t-\u0006d\u0017\u000e\u001a\u000b\u0003]E\u0002\"!C\u0018\n\u0005AR!a\u0002\"p_2,\u0017M\u001c\u0005\u0006e-\u0002\raM\u0001\fG>tg-[4WC2,X\r\u0005\u00025o9\u0011\u0011\"N\u0005\u0003m)\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001d:\u0005\u0019\u0019FO]5oO*\u0011aG\u0003\u0005\u0006w\u0001!I\u0001P\u0001\u0016CN\u001cXM\u001d;Qe>\u0004XM\u001d;z\u0013:4\u0018\r\\5e)\r1Rh\u0010\u0005\u0006}i\u0002\raM\u0001\u0005]\u0006lW\rC\u0003Au\u0001\u0007\u0011)\u0001\u0004wC2,Xm\u001d\t\u0004\u0013\tC\u0011BA\"\u000b\u0005)a$/\u001a9fCR,GM\u0010\u0005\u0006\u000b\u0002!IAR\u0001\te\u0006tGM\u0012:p[V\u0011qI\u0013\u000b\u0003\u0011N\u0003\"!\u0013&\r\u0001\u0011)1\n\u0012b\u0001\u0019\n\tA+\u0005\u0002N!B\u0011\u0011BT\u0005\u0003\u001f*\u0011qAT8uQ&tw\r\u0005\u0002\n#&\u0011!K\u0003\u0002\u0004\u0003:L\b\"\u0002+E\u0001\u0004)\u0016aB2i_&\u001cWm\u001d\t\u0004\u0013\tC\u0005")
public class LogConfigTest {
    @Test
    public void testKafkaConfigToProps() {
        long millisInHour = 3600000L;
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        kafkaProps.put(KafkaConfig$.MODULE$.LogRollTimeHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRollTimeJitterHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRetentionTimeHoursProp(), "2");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Map logProps = KafkaServer$.MODULE$.copyKafkaConfigToLog(kafkaConfig);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get(LogConfig$.MODULE$.SegmentMsProp()));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get(LogConfig$.MODULE$.SegmentJitterMsProp()));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get(LogConfig$.MODULE$.RetentionMsProp()));
    }

    @Test
    public void testFromPropsEmpty() {
        Properties p = new Properties();
        LogConfig config = new LogConfig((Map)p);
        Assert.assertEquals((Object)LogConfig$.MODULE$.apply(), (Object)config);
    }

    @Test
    public void testFromPropsInvalid() {
        LogConfig$.MODULE$.configNames().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogConfigTest $outer;

            public final void apply(String name) {
                String string = name;
                String string2 = LogConfig$.MODULE$.UncleanLeaderElectionEnableProp();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    this.$outer.kafka$log$LogConfigTest$$assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not a boolean"}));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    String string4 = LogConfig$.MODULE$.RetentionBytesProp();
                    String string5 = string;
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        this.$outer.kafka$log$LogConfigTest$$assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        String string6 = LogConfig$.MODULE$.RetentionMsProp();
                        String string7 = string;
                        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                            this.$outer.kafka$log$LogConfigTest$$assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            String string8 = LogConfig$.MODULE$.CleanupPolicyProp();
                            String string9 = string;
                            if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                                this.$outer.kafka$log$LogConfigTest$$assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"true", "foobar"}));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                String string10 = LogConfig$.MODULE$.MinCleanableDirtyRatioProp();
                                String string11 = string;
                                if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                                    this.$outer.kafka$log$LogConfigTest$$assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    String string12 = LogConfig$.MODULE$.MinInSyncReplicasProp();
                                    String string13 = string;
                                    if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                                        this.$outer.kafka$log$LogConfigTest$$assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "0", "-1"}));
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        String string14 = LogConfig$.MODULE$.MessageFormatVersionProp();
                                        String string15 = string;
                                        if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                                            this.$outer.kafka$log$LogConfigTest$$assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{""}));
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        } else {
                                            this.$outer.kafka$log$LogConfigTest$$assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-1"}));
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void shouldValidateThrottledReplicasConfig() {
        Assert.assertTrue((boolean)this.isValid("*"));
        Assert.assertTrue((boolean)this.isValid("* "));
        Assert.assertTrue((boolean)this.isValid(""));
        Assert.assertTrue((boolean)this.isValid(" "));
        Assert.assertTrue((boolean)this.isValid("100:10"));
        Assert.assertTrue((boolean)this.isValid("100:10,12:10"));
        Assert.assertTrue((boolean)this.isValid("100:10,12:10,15:1"));
        Assert.assertTrue((boolean)this.isValid("100:10,12:10,15:1  "));
        Assert.assertTrue((boolean)this.isValid("100:0,"));
        Assert.assertFalse((boolean)this.isValid("100"));
        Assert.assertFalse((boolean)this.isValid("100:"));
        Assert.assertFalse((boolean)this.isValid("100:0,10"));
        Assert.assertFalse((boolean)this.isValid("100:0,10:"));
        Assert.assertFalse((boolean)this.isValid("100:0,10:   "));
        Assert.assertFalse((boolean)this.isValid("100 :0,10:   "));
        Assert.assertFalse((boolean)this.isValid("100: 0,10:   "));
        Assert.assertFalse((boolean)this.isValid("100:0,10 :   "));
    }

    private boolean isValid(String configValue) {
        boolean bl;
        try {
            ThrottledReplicaListValidator$.MODULE$.ensureValidString("", configValue);
            bl = true;
        }
        catch (ConfigException configException) {
            bl = false;
        }
        return bl;
    }

    public void kafka$log$LogConfigTest$$assertPropertyInvalid(String name, Seq<Object> values) {
        values.foreach((Function1)new Serializable(this, name){
            public static final long serialVersionUID = 0L;
            private final String name$1;

            public final Exception apply(Object value) {
                Properties props = new Properties();
                props.setProperty(this.name$1, value.toString());
                return (Exception)Assertions$.MODULE$.intercept((Function0)new Serializable(this, props){
                    public static final long serialVersionUID = 0L;
                    private final Properties props$1;

                    public final LogConfig apply() {
                        return new LogConfig((Map)this.props$1);
                    }
                    {
                        this.props$1 = props$1;
                    }
                }, ManifestFactory$.MODULE$.classType(Exception.class));
            }
            {
                this.name$1 = name$1;
            }
        });
    }

    private <T> T randFrom(Seq<T> choices) {
        return (T)choices.apply(Random$.MODULE$.nextInt(choices.size()));
    }
}

