/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.io.DataOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import kafka.message.BaseMessageSetTestCases;
import kafka.message.BaseMessageSetTestCases$class;
import kafka.message.ByteBufferMessageSet;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.ByteBufferMessageSetTest$;
import kafka.message.CompressionCodec;
import kafka.message.CompressionFactory$;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.InvalidMessageException;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.message.MessageWriter;
import kafka.message.NoCompressionCodec$;
import kafka.message.SnappyCompressionCodec$;
import kafka.message.ValidationAndOffsetAssignResult;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.record.TimestampType;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenSet;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001B\u0001\u0003\u0001\u001d\u0011\u0001DQ=uK\n+hMZ3s\u001b\u0016\u001c8/Y4f'\u0016$H+Z:u\u0015\t\u0019A!A\u0004nKN\u001c\u0018mZ3\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u0011I\u0001\"!\u0003\t\u000e\u0003)Q!a\u0003\u0007\u0002\u000b),h.\u001b;\u000b\u00055q\u0011!C:dC2\fG/Z:u\u0015\u0005y\u0011aA8sO&\u0011\u0011C\u0003\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0007CA\n\u0015\u001b\u0005\u0011\u0011BA\u000b\u0003\u0005]\u0011\u0015m]3NKN\u001c\u0018mZ3TKR$Vm\u001d;DCN,7\u000fC\u0003\u0018\u0001\u0011\u0005\u0001$\u0001\u0004=S:LGO\u0010\u000b\u00023A\u00111\u0003\u0001\u0005\u00067\u0001!\t\u0005H\u0001\u0011GJ,\u0017\r^3NKN\u001c\u0018mZ3TKR$\"!\b\u0011\u0011\u0005Mq\u0012BA\u0010\u0003\u0005Q\u0011\u0015\u0010^3Ck\u001a4WM]'fgN\fw-Z*fi\")\u0011E\u0007a\u0001E\u0005AQ.Z:tC\u001e,7\u000fE\u0002$[Ar!\u0001\n\u0016\u000f\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001d2\u0011A\u0002\u001fs_>$h(C\u0001*\u0003\u0015\u00198-\u00197b\u0013\tYC&A\u0004qC\u000e\\\u0017mZ3\u000b\u0003%J!AL\u0018\u0003\u0007M+\u0017O\u0003\u0002,YA\u00111#M\u0005\u0003e\t\u0011q!T3tg\u0006<W\rC\u00035\u0001\u0011\u0005Q'\u0001\buKN$h+\u00197jI\nKH/Z:\u0015\u0003Y\u0002\"a\u000e\u001d\u000e\u00031J!!\u000f\u0017\u0003\tUs\u0017\u000e\u001e\u0015\u0003gm\u0002\"\u0001\u0010 \u000e\u0003uR!a\u0003\b\n\u0005}j$\u0001\u0002+fgRDQ!\u0011\u0001\u0005\u0002U\nQ\u0004^3tiZ\u000bG.\u001b3CsR,7oV5uQ\u000e{W\u000e\u001d:fgNLwN\u001c\u0015\u0003\u0001nBQ\u0001\u0012\u0001\u0005\u0002U\n!\u0002^3ti\u0016\u000bX/\u00197tQ\t\u00195\bC\u0003H\u0001\u0011\u0005Q'\u0001\u0007uKN$\u0018\n^3sCR|'\u000f\u000b\u0002Gw!)!\n\u0001C\u0001k\u0005\u0001C/Z:u\u001b\u0016\u001c8/Y4f/&$\b\u000e\u0015:pm&$W\rZ(gMN,GoU3rQ\tI5\bC\u0003N\u0001\u0011\u0005Q'A\tuKN$Hj\\4BaB,g\u000e\u001a+j[\u0016D#\u0001T\u001e\t\u000bA\u0003A\u0011A\u001b\u0002\u001dQ,7\u000f^\"sK\u0006$X\rV5nK\"\u0012qj\u000f\u0005\u0006'\u0002!\t!N\u0001\u0016i\u0016\u001cH/\u00138wC2LGm\u0011:fCR,G+[7fQ\t\u00116\bC\u0003W\u0001\u0011\u0005Q'\u0001\u000fuKN$\u0018IY:pYV$Xm\u00144gg\u0016$\u0018i]:jO:lWM\u001c;)\u0005U[\u0004\"B-\u0001\t\u0003)\u0014\u0001\b;fgR\u0014V\r\\1uSZ,wJ\u001a4tKR\f5o]5h]6,g\u000e\u001e\u0015\u00031nBQ\u0001\u0018\u0001\u0005\u0002U\nA\u0004^3ti&sg/\u00197jI&sg.\u001a:NC\u001eL7MV3sg&|g\u000e\u000b\u0003\\wy{\u0016\u0001C3ya\u0016\u001cG/\u001a3$\u0003\u0001\u0004\"aE1\n\u0005\t\u0014!aF%om\u0006d\u0017\u000eZ'fgN\fw-Z#yG\u0016\u0004H/[8o\u0011\u0015!\u0007\u0001\"\u00016\u0003A\"Xm\u001d;PM\u001a\u001cX\r^!tg&<g.\\3oi\u00063G/\u001a:NKN\u001c\u0018mZ3G_Jl\u0017\r^\"p]Z,'o]5p]\"\u00121m\u000f\u0005\u0006O\u0002!\t!N\u0001\u0011i\u0016\u001cHo\u0016:ji\u00164U\u000f\u001c7z)>D#AZ\u001e\t\u000b)\u0004A\u0011A6\u0002?\rDWmY6Xe&$XMR;mYf$vnV5uQ6+7o]1hKN+G\u000f\u0006\u00027Y\")Q.\u001ba\u0001;\u0005QQ.Z:tC\u001e,7+\u001a;\t\u000b=\u0004A\u0011\u00019\u0002\u0019\rDWmY6PM\u001a\u001cX\r^:\u0015\u0007Y\n(\u000fC\u0003\"]\u0002\u0007Q\u0004C\u0003t]\u0002\u0007A/\u0001\u0006cCN,wJ\u001a4tKR\u0004\"aN;\n\u0005Yd#\u0001\u0002'p]\u001eDQ\u0001\u001f\u0001\u0005\u0002e\fQC^3sS\u001aL8\u000b[1mY><\u0018\n^3sCR|'\u000f\u0006\u00027u\")Qn\u001ea\u0001;!)A\u0010\u0001C\u0005{\u0006Yq-\u001a;NKN\u001c\u0018mZ3t)\u0019ib0a\u0002\u0002\f!Aqp\u001fI\u0001\u0002\u0004\t\t!\u0001\u0006nC\u001eL7MV1mk\u0016\u00042aNA\u0002\u0013\r\t)\u0001\f\u0002\u0005\u0005f$X\r\u0003\u0005\u0002\nm\u0004\n\u00111\u0001u\u0003%!\u0018.\\3ti\u0006l\u0007\u000fC\u0005\u0002\u000em\u0004\n\u00111\u0001\u0002\u0010\u0005)1m\u001c3fGB\u00191#!\u0005\n\u0007\u0005M!A\u0001\tD_6\u0004(/Z:tS>t7i\u001c3fG\"9\u0011q\u0003\u0001\u0005\n\u0005e\u0011aH7fgN\fw-Z*fi^KG\u000f[%om\u0006d\u0017\u000eZ%o]\u0016\u0014X*Y4jGR)Q$a\u0007\u0002\u001e!A\u0011QBA\u000b\u0001\u0004\ty\u0001C\u0004\u0002 \u0005U\u0001\u0019\u0001;\u0002\u001b%t\u0017\u000e^5bY>3gm]3u\u0011%\t\u0019\u0003AI\u0001\n\u0013\t)#A\u000bhKRlUm]:bO\u0016\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u001d\"\u0006BA\u0001\u0003SY#!a\u000b\u0011\t\u00055\u0012qG\u0007\u0003\u0003_QA!!\r\u00024\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003ka\u0013AC1o]>$\u0018\r^5p]&!\u0011\u0011HA\u0018\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003{\u0001\u0011\u0013!C\u0005\u0003\u007f\tQcZ3u\u001b\u0016\u001c8/Y4fg\u0012\"WMZ1vYR$#'\u0006\u0002\u0002B)\u001aA/!\u000b\t\u0013\u0005\u0015\u0003!%A\u0005\n\u0005\u001d\u0013!F4fi6+7o]1hKN$C-\u001a4bk2$HeM\u000b\u0003\u0003\u0013RC!a\u0004\u0002*\u0001")
public class ByteBufferMessageSetTest
extends JUnitSuite
implements BaseMessageSetTestCases {
    private final Message[] messages;

    @Override
    public Message[] messages() {
        return this.messages;
    }

    @Override
    public void kafka$message$BaseMessageSetTestCases$_setter_$messages_$eq(Message[] x$1) {
        this.messages = x$1;
    }

    @Override
    @Test
    public void testWrittenEqualsRead() {
        BaseMessageSetTestCases$class.testWrittenEqualsRead(this);
    }

    @Override
    @Test
    public void testIteratorIsConsistent() {
        BaseMessageSetTestCases$class.testIteratorIsConsistent(this);
    }

    @Override
    @Test
    public void testSizeInBytes() {
        BaseMessageSetTestCases$class.testSizeInBytes(this);
    }

    @Override
    @Test
    public void testWriteTo() {
        BaseMessageSetTestCases$class.testWriteTo(this);
    }

    @Override
    @Test
    public void testWriteToChannelThatConsumesPartially() {
        BaseMessageSetTestCases$class.testWriteToChannelThatConsumesPartially(this);
    }

    @Override
    public void checkWriteToWithMessageSet(MessageSet messageSet) {
        BaseMessageSetTestCases$class.checkWriteToWithMessageSet(this, messageSet);
    }

    @Override
    public void checkWriteWithMessageSet(MessageSet set, Function1<GatheringByteChannel, Object> write2) {
        BaseMessageSetTestCases$class.checkWriteWithMessageSet(this, set, write2);
    }

    public ByteBufferMessageSet createMessageSet(Seq<Message> messages2) {
        return new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, messages2);
    }

    @Test
    public void testValidBytes() {
        ByteBufferMessageSet messages2 = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes()), new Message("there".getBytes())}));
        ByteBuffer buffer = ByteBuffer.allocate(messages2.sizeInBytes() + 2);
        buffer.put(messages2.buffer());
        buffer.putShort((short)4);
        ByteBufferMessageSet messagesPlus = new ByteBufferMessageSet(buffer);
        Assert.assertEquals((String)"Adding invalid bytes shouldn't change byte count", (long)messages2.validBytes(), (long)messagesPlus.validBytes());
        Assert.assertEquals((String)"Valid bytes on an empty ByteBufferMessageSet should return 0", (long)0L, (long)MessageSet$.MODULE$.Empty().validBytes());
    }

    @Test
    public void testValidBytesWithCompression() {
        ByteBufferMessageSet messages2 = new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes()), new Message("there".getBytes())}));
        ByteBuffer buffer = ByteBuffer.allocate(messages2.sizeInBytes() + 2);
        buffer.put(messages2.buffer());
        buffer.putShort((short)4);
        ByteBufferMessageSet messagesPlus = new ByteBufferMessageSet(buffer);
        Assert.assertEquals((String)"Adding invalid bytes shouldn't change byte count", (long)messages2.validBytes(), (long)messagesPlus.validBytes());
    }

    @Test
    public void testEquals() {
        ByteBufferMessageSet messages2 = new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes()), new Message("there".getBytes())}));
        ByteBufferMessageSet moreMessages = new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes()), new Message("there".getBytes())}));
        Assert.assertTrue((boolean)messages2.equals((Object)moreMessages));
        messages2 = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes()), new Message("there".getBytes())}));
        moreMessages = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes()), new Message("there".getBytes())}));
        Assert.assertTrue((boolean)messages2.equals((Object)moreMessages));
    }

    @Test
    public void testIterator() {
        List messageList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("msg1".getBytes()), new Message("msg2".getBytes()), new Message("msg3".getBytes())}));
        ByteBufferMessageSet messageSet = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)messageList);
        TestUtils$.MODULE$.checkEquals(messageList.iterator(), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)messageSet.iterator()));
        TestUtils$.MODULE$.checkEquals(messageList.iterator(), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)messageSet.iterator()));
        TestUtils$.MODULE$.checkEquals(TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)messageSet.shallowIterator()), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)messageSet.iterator()));
        ByteBufferMessageSet messageSet2 = new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)messageList);
        TestUtils$.MODULE$.checkEquals(messageList.iterator(), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)messageSet2.iterator()));
        TestUtils$.MODULE$.checkEquals(messageList.iterator(), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)messageSet2.iterator()));
        this.verifyShallowIterator(messageSet2);
        Nil$ emptyMessageList = Nil$.MODULE$;
        ByteBufferMessageSet emptyMessageSet = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)emptyMessageList);
        ByteBufferMessageSet regularMessgeSet = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)messageList);
        ByteBuffer buffer = ByteBuffer.allocate(emptyMessageSet.buffer().limit() + regularMessgeSet.buffer().limit());
        buffer.put(emptyMessageSet.buffer());
        buffer.put(regularMessgeSet.buffer());
        buffer.rewind();
        ByteBufferMessageSet mixedMessageSet = new ByteBufferMessageSet(buffer);
        TestUtils$.MODULE$.checkEquals(messageList.iterator(), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)mixedMessageSet.iterator()));
        TestUtils$.MODULE$.checkEquals(messageList.iterator(), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)mixedMessageSet.iterator()));
        TestUtils$.MODULE$.checkEquals(TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)mixedMessageSet.shallowIterator()), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)mixedMessageSet.iterator()));
        Nil$ emptyMessageList2 = Nil$.MODULE$;
        ByteBufferMessageSet emptyMessageSet2 = new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)emptyMessageList2);
        ByteBufferMessageSet regularMessgeSet2 = new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)messageList);
        ByteBuffer buffer2 = ByteBuffer.allocate(emptyMessageSet2.buffer().limit() + regularMessgeSet2.buffer().limit());
        buffer2.put(emptyMessageSet2.buffer());
        buffer2.put(regularMessgeSet2.buffer());
        buffer2.rewind();
        ByteBufferMessageSet mixedMessageSet2 = new ByteBufferMessageSet(buffer2);
        TestUtils$.MODULE$.checkEquals(messageList.iterator(), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)mixedMessageSet2.iterator()));
        TestUtils$.MODULE$.checkEquals(messageList.iterator(), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)mixedMessageSet2.iterator()));
        this.verifyShallowIterator(mixedMessageSet2);
    }

    @Test
    public void testMessageWithProvidedOffsetSeq() {
        Seq offsets = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 2L}));
        ByteBufferMessageSet messages2 = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, offsets, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes()), new Message("goodbye".getBytes())}));
        Iterator iter = messages2.iterator();
        Assert.assertEquals((String)"first offset should be 0", (long)0L, (long)((MessageAndOffset)iter.next()).offset());
        Assert.assertEquals((String)"second offset should be 2", (long)2L, (long)((MessageAndOffset)iter.next()).offset());
    }

    @Test
    public void testLogAppendTime() {
        long now = System.currentTimeMillis();
        ByteBufferMessageSet messages2 = this.getMessages(Message$.MODULE$.MagicValue_V1(), 0L, (CompressionCodec)NoCompressionCodec$.MODULE$);
        byte x$1 = Message$.MODULE$.MagicValue_V0();
        DefaultCompressionCodec$ x$2 = DefaultCompressionCodec$.MODULE$;
        long x$3 = this.getMessages$default$2();
        ByteBufferMessageSet compressedMessagesWithRecompresion = this.getMessages(x$1, x$3, (CompressionCodec)x$2);
        ByteBufferMessageSet compressedMessagesWithoutRecompression = this.getMessages(Message$.MODULE$.MagicValue_V1(), 0L, (CompressionCodec)DefaultCompressionCodec$.MODULE$);
        kafka.common.LongRef x$4 = new kafka.common.LongRef(0L);
        long x$5 = now;
        NoCompressionCodec$ x$6 = NoCompressionCodec$.MODULE$;
        NoCompressionCodec$ x$7 = NoCompressionCodec$.MODULE$;
        byte x$8 = 1;
        TimestampType x$9 = TimestampType.LOG_APPEND_TIME;
        long x$10 = 1000L;
        boolean x$11 = messages2.validateMessagesAndAssignOffsets$default$5();
        ValidationAndOffsetAssignResult validatingResults = messages2.validateMessagesAndAssignOffsets(x$4, x$5, (CompressionCodec)x$6, (CompressionCodec)x$7, x$11, x$8, x$9, x$10);
        ByteBufferMessageSet validatedMessages = validatingResults.validatedMessages();
        kafka.common.LongRef x$12 = new kafka.common.LongRef(0L);
        long x$13 = now;
        DefaultCompressionCodec$ x$14 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$15 = DefaultCompressionCodec$.MODULE$;
        byte x$16 = 1;
        TimestampType x$17 = TimestampType.LOG_APPEND_TIME;
        long x$18 = 1000L;
        boolean x$19 = compressedMessagesWithRecompresion.validateMessagesAndAssignOffsets$default$5();
        ValidationAndOffsetAssignResult validatingCompressedMessagesResults = compressedMessagesWithRecompresion.validateMessagesAndAssignOffsets(x$12, x$13, (CompressionCodec)x$14, (CompressionCodec)x$15, x$19, x$16, x$17, x$18);
        ByteBufferMessageSet validatedCompressedMessages = validatingCompressedMessagesResults.validatedMessages();
        kafka.common.LongRef x$20 = new kafka.common.LongRef(0L);
        long x$21 = now;
        DefaultCompressionCodec$ x$22 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$23 = DefaultCompressionCodec$.MODULE$;
        byte x$24 = 1;
        TimestampType x$25 = TimestampType.LOG_APPEND_TIME;
        long x$26 = 1000L;
        boolean x$27 = compressedMessagesWithoutRecompression.validateMessagesAndAssignOffsets$default$5();
        ValidationAndOffsetAssignResult validatingCompressedMessagesWithoutRecompressionResults = compressedMessagesWithoutRecompression.validateMessagesAndAssignOffsets(x$20, x$21, (CompressionCodec)x$22, (CompressionCodec)x$23, x$27, x$24, x$25, x$26);
        ByteBufferMessageSet validatedCompressedMessagesWithoutRecompression = validatingCompressedMessagesWithoutRecompressionResults.validatedMessages();
        Assert.assertEquals((String)"message set size should not change", (long)messages2.size(), (long)validatedMessages.size());
        validatedMessages.foreach((Function1)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ByteBufferMessageSetTest $outer;
            private final long now$1;

            public final void apply(MessageAndOffset messageAndOffset) {
                this.$outer.kafka$message$ByteBufferMessageSetTest$$validateLogAppendTime$1(messageAndOffset.message(), this.now$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.now$1 = now$1;
            }
        });
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)now)})), (long)now, (long)validatingResults.maxTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The offset of max timestamp should be 0"})).s((Seq)Nil$.MODULE$), (long)0L, (long)validatingResults.offsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatingResults.messageSizeMaybeChanged());
        Assert.assertEquals((String)"message set size should not change", (long)compressedMessagesWithRecompresion.size(), (long)validatedCompressedMessages.size());
        validatedCompressedMessages.foreach((Function1)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ByteBufferMessageSetTest $outer;
            private final long now$1;

            public final void apply(MessageAndOffset messageAndOffset) {
                this.$outer.kafka$message$ByteBufferMessageSetTest$$validateLogAppendTime$1(messageAndOffset.message(), this.now$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.now$1 = now$1;
            }
        });
        Assert.assertTrue((String)"MessageSet should still valid", (boolean)((MessageAndOffset)validatedCompressedMessages.shallowIterator().next()).message().isValid());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)now)})), (long)now, (long)validatingCompressedMessagesResults.maxTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The offset of max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(compressedMessagesWithRecompresion.size() - 1))})), (long)(compressedMessagesWithRecompresion.size() - 1), (long)validatingCompressedMessagesResults.offsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size may have been changed", (boolean)validatingCompressedMessagesResults.messageSizeMaybeChanged());
        Assert.assertEquals((String)"message set size should not change", (long)compressedMessagesWithoutRecompression.size(), (long)validatedCompressedMessagesWithoutRecompression.size());
        validatedCompressedMessagesWithoutRecompression.foreach((Function1)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ByteBufferMessageSetTest $outer;
            private final long now$1;

            public final void apply(MessageAndOffset messageAndOffset) {
                this.$outer.kafka$message$ByteBufferMessageSetTest$$validateLogAppendTime$1(messageAndOffset.message(), this.now$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.now$1 = now$1;
            }
        });
        Assert.assertTrue((String)"MessageSet should still valid", (boolean)((MessageAndOffset)validatedCompressedMessagesWithoutRecompression.shallowIterator().next()).message().isValid());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)now)})), (long)now, (long)validatingCompressedMessagesWithoutRecompressionResults.maxTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The offset of max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(compressedMessagesWithoutRecompression.size() - 1))})), (long)(compressedMessagesWithoutRecompression.size() - 1), (long)validatingCompressedMessagesWithoutRecompressionResults.offsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatingCompressedMessagesWithoutRecompressionResults.messageSizeMaybeChanged());
    }

    @Test
    public void testCreateTime() {
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        ByteBufferMessageSet messages2 = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes(), BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), Message$.MODULE$.MagicValue_V1()), new Message("there".getBytes(), BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), Message$.MODULE$.MagicValue_V1()), new Message("beautiful".getBytes(), BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), Message$.MODULE$.MagicValue_V1())}));
        ByteBufferMessageSet compressedMessages = new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes(), BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), Message$.MODULE$.MagicValue_V1()), new Message("there".getBytes(), BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), Message$.MODULE$.MagicValue_V1()), new Message("beautiful".getBytes(), BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), Message$.MODULE$.MagicValue_V1())}));
        kafka.common.LongRef x$28 = new kafka.common.LongRef(0L);
        long x$29 = System.currentTimeMillis();
        NoCompressionCodec$ x$30 = NoCompressionCodec$.MODULE$;
        NoCompressionCodec$ x$31 = NoCompressionCodec$.MODULE$;
        byte x$32 = 1;
        TimestampType x$33 = TimestampType.CREATE_TIME;
        long x$34 = 1000L;
        boolean x$35 = messages2.validateMessagesAndAssignOffsets$default$5();
        ValidationAndOffsetAssignResult validatingResults = messages2.validateMessagesAndAssignOffsets(x$28, x$29, (CompressionCodec)x$30, (CompressionCodec)x$31, x$35, x$32, x$33, x$34);
        ByteBufferMessageSet validatedMessages = validatingResults.validatedMessages();
        kafka.common.LongRef x$36 = new kafka.common.LongRef(0L);
        long x$37 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$38 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$39 = DefaultCompressionCodec$.MODULE$;
        byte x$40 = 1;
        TimestampType x$41 = TimestampType.CREATE_TIME;
        long x$42 = 1000L;
        boolean x$43 = compressedMessages.validateMessagesAndAssignOffsets$default$5();
        ValidationAndOffsetAssignResult validatingCompressedMessagesResults = compressedMessages.validateMessagesAndAssignOffsets(x$36, x$37, (CompressionCodec)x$38, (CompressionCodec)x$39, x$43, x$40, x$41, x$42);
        ByteBufferMessageSet validatedCompressedMessages = validatingCompressedMessagesResults.validatedMessages();
        IntRef i = new IntRef(0);
        validatedMessages.foreach((Function1)new Serializable(this, timestampSeq, i){
            public static final long serialVersionUID = 0L;
            private final Seq timestampSeq$1;
            private final IntRef i$1;

            public final void apply(MessageAndOffset messageAndOffset) {
                messageAndOffset.message().ensureValid();
                Assert.assertEquals((long)messageAndOffset.message().timestamp(), (long)BoxesRunTime.unboxToLong((Object)this.timestampSeq$1.apply(this.i$1.elem)));
                Assert.assertEquals((Object)messageAndOffset.message().timestampType(), (Object)TimestampType.CREATE_TIME);
                ++this.i$1.elem;
            }
            {
                this.timestampSeq$1 = timestampSeq$1;
                this.i$1 = i$1;
            }
        });
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(now + 1L))})), (long)(now + 1L), (long)validatingResults.maxTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset of max timestamp should be 1"})).s((Seq)Nil$.MODULE$), (long)1L, (long)validatingResults.offsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatingResults.messageSizeMaybeChanged());
        i.elem = 0;
        validatedCompressedMessages.foreach((Function1)new Serializable(this, timestampSeq, i){
            public static final long serialVersionUID = 0L;
            private final Seq timestampSeq$1;
            private final IntRef i$1;

            public final void apply(MessageAndOffset messageAndOffset) {
                messageAndOffset.message().ensureValid();
                Assert.assertEquals((long)messageAndOffset.message().timestamp(), (long)BoxesRunTime.unboxToLong((Object)this.timestampSeq$1.apply(this.i$1.elem)));
                Assert.assertEquals((Object)messageAndOffset.message().timestampType(), (Object)TimestampType.CREATE_TIME);
                ++this.i$1.elem;
            }
            {
                this.timestampSeq$1 = timestampSeq$1;
                this.i$1 = i$1;
            }
        });
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(now + 1L))})), (long)(now + 1L), (long)validatingResults.maxTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset of max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(validatedCompressedMessages.size() - 1))})), (long)(validatedCompressedMessages.size() - 1), (long)validatingCompressedMessagesResults.offsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatingCompressedMessagesResults.messageSizeMaybeChanged());
    }

    @Test
    public void testInvalidCreateTime() {
        long now = System.currentTimeMillis();
        ByteBufferMessageSet messages2 = this.getMessages(Message$.MODULE$.MagicValue_V1(), now - 1001L, (CompressionCodec)NoCompressionCodec$.MODULE$);
        ByteBufferMessageSet compressedMessages = this.getMessages(Message$.MODULE$.MagicValue_V1(), now - 1001L, (CompressionCodec)DefaultCompressionCodec$.MODULE$);
        try {
            kafka.common.LongRef x$44 = new kafka.common.LongRef(0L);
            long x$45 = System.currentTimeMillis();
            NoCompressionCodec$ x$46 = NoCompressionCodec$.MODULE$;
            NoCompressionCodec$ x$47 = NoCompressionCodec$.MODULE$;
            byte x$48 = 1;
            TimestampType x$49 = TimestampType.CREATE_TIME;
            long x$50 = 1000L;
            boolean x$51 = messages2.validateMessagesAndAssignOffsets$default$5();
            messages2.validateMessagesAndAssignOffsets(x$44, x$45, (CompressionCodec)x$46, (CompressionCodec)x$47, x$51, x$48, x$49, x$50);
            throw this.fail("Should throw InvalidMessageException.");
        }
        catch (InvalidTimestampException invalidTimestampException) {
            try {
                kafka.common.LongRef x$52 = new kafka.common.LongRef(0L);
                long x$53 = System.currentTimeMillis();
                DefaultCompressionCodec$ x$54 = DefaultCompressionCodec$.MODULE$;
                DefaultCompressionCodec$ x$55 = DefaultCompressionCodec$.MODULE$;
                byte x$56 = 1;
                TimestampType x$57 = TimestampType.CREATE_TIME;
                long x$58 = 1000L;
                boolean x$59 = compressedMessages.validateMessagesAndAssignOffsets$default$5();
                compressedMessages.validateMessagesAndAssignOffsets(x$52, x$53, (CompressionCodec)x$54, (CompressionCodec)x$55, x$59, x$56, x$57, x$58);
                throw this.fail("Should throw InvalidMessageException.");
            }
            catch (InvalidTimestampException invalidTimestampException2) {
                return;
            }
        }
    }

    @Test
    public void testAbsoluteOffsetAssignment() {
        byte x$60 = Message$.MODULE$.MagicValue_V0();
        NoCompressionCodec$ x$61 = NoCompressionCodec$.MODULE$;
        long x$62 = this.getMessages$default$2();
        ByteBufferMessageSet messages2 = this.getMessages(x$60, x$62, (CompressionCodec)x$61);
        byte x$63 = Message$.MODULE$.MagicValue_V0();
        DefaultCompressionCodec$ x$64 = DefaultCompressionCodec$.MODULE$;
        long x$65 = this.getMessages$default$2();
        ByteBufferMessageSet compressedMessages = this.getMessages(x$63, x$65, (CompressionCodec)x$64);
        this.checkOffsets(messages2, 0L);
        int offset = 1234567;
        kafka.common.LongRef x$66 = new kafka.common.LongRef((long)offset);
        long x$67 = System.currentTimeMillis();
        NoCompressionCodec$ x$68 = NoCompressionCodec$.MODULE$;
        NoCompressionCodec$ x$69 = NoCompressionCodec$.MODULE$;
        byte x$70 = 0;
        TimestampType x$71 = TimestampType.CREATE_TIME;
        long x$72 = 1000L;
        boolean x$73 = messages2.validateMessagesAndAssignOffsets$default$5();
        this.checkOffsets(messages2.validateMessagesAndAssignOffsets(x$66, x$67, (CompressionCodec)x$68, (CompressionCodec)x$69, x$73, x$70, x$71, x$72).validatedMessages(), offset);
        this.checkOffsets(compressedMessages, 0L);
        kafka.common.LongRef x$74 = new kafka.common.LongRef((long)offset);
        long x$75 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$76 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$77 = DefaultCompressionCodec$.MODULE$;
        byte x$78 = 0;
        TimestampType x$79 = TimestampType.CREATE_TIME;
        long x$80 = 1000L;
        boolean x$81 = compressedMessages.validateMessagesAndAssignOffsets$default$5();
        this.checkOffsets(compressedMessages.validateMessagesAndAssignOffsets(x$74, x$75, (CompressionCodec)x$76, (CompressionCodec)x$77, x$81, x$78, x$79, x$80).validatedMessages(), offset);
    }

    @Test
    public void testRelativeOffsetAssignment() {
        long now = System.currentTimeMillis();
        ByteBufferMessageSet messages2 = this.getMessages(Message$.MODULE$.MagicValue_V1(), now, (CompressionCodec)NoCompressionCodec$.MODULE$);
        ByteBufferMessageSet compressedMessages = this.getMessages(Message$.MODULE$.MagicValue_V1(), now, (CompressionCodec)DefaultCompressionCodec$.MODULE$);
        this.checkOffsets(messages2, 0L);
        int offset = 1234567;
        kafka.common.LongRef x$82 = new kafka.common.LongRef((long)offset);
        long x$83 = System.currentTimeMillis();
        NoCompressionCodec$ x$84 = NoCompressionCodec$.MODULE$;
        NoCompressionCodec$ x$85 = NoCompressionCodec$.MODULE$;
        TimestampType x$86 = TimestampType.CREATE_TIME;
        long x$87 = 5000L;
        boolean x$88 = messages2.validateMessagesAndAssignOffsets$default$5();
        byte x$89 = messages2.validateMessagesAndAssignOffsets$default$6();
        ByteBufferMessageSet messageWithOffset = messages2.validateMessagesAndAssignOffsets(x$82, x$83, (CompressionCodec)x$84, (CompressionCodec)x$85, x$88, x$89, x$86, x$87).validatedMessages();
        this.checkOffsets(messageWithOffset, offset);
        this.checkOffsets(compressedMessages, 0L);
        kafka.common.LongRef x$90 = new kafka.common.LongRef((long)offset);
        long x$91 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$92 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$93 = DefaultCompressionCodec$.MODULE$;
        TimestampType x$94 = TimestampType.CREATE_TIME;
        long x$95 = 5000L;
        boolean x$96 = compressedMessages.validateMessagesAndAssignOffsets$default$5();
        byte x$97 = compressedMessages.validateMessagesAndAssignOffsets$default$6();
        ByteBufferMessageSet compressedMessagesWithOffset = compressedMessages.validateMessagesAndAssignOffsets(x$90, x$91, (CompressionCodec)x$92, (CompressionCodec)x$93, x$96, x$97, x$94, x$95).validatedMessages();
        this.checkOffsets(compressedMessagesWithOffset, offset);
    }

    @Test(expected=InvalidMessageException.class)
    public void testInvalidInnerMagicVersion() {
        int offset = 1234567;
        ByteBufferMessageSet messages2 = this.messageSetWithInvalidInnerMagic((CompressionCodec)SnappyCompressionCodec$.MODULE$, offset);
        kafka.common.LongRef x$98 = new kafka.common.LongRef((long)offset);
        long x$99 = System.currentTimeMillis();
        SnappyCompressionCodec$ x$100 = SnappyCompressionCodec$.MODULE$;
        SnappyCompressionCodec$ x$101 = SnappyCompressionCodec$.MODULE$;
        TimestampType x$102 = TimestampType.CREATE_TIME;
        long x$103 = 5000L;
        boolean x$104 = messages2.validateMessagesAndAssignOffsets$default$5();
        byte x$105 = messages2.validateMessagesAndAssignOffsets$default$6();
        messages2.validateMessagesAndAssignOffsets(x$98, x$99, (CompressionCodec)x$100, (CompressionCodec)x$101, x$104, x$105, x$102, x$103).validatedMessages();
    }

    @Test
    public void testOffsetAssignmentAfterMessageFormatConversion() {
        byte x$106 = Message$.MODULE$.MagicValue_V0();
        NoCompressionCodec$ x$107 = NoCompressionCodec$.MODULE$;
        long x$108 = this.getMessages$default$2();
        ByteBufferMessageSet messagesV0 = this.getMessages(x$106, x$108, (CompressionCodec)x$107);
        byte x$109 = Message$.MODULE$.MagicValue_V0();
        DefaultCompressionCodec$ x$110 = DefaultCompressionCodec$.MODULE$;
        long x$111 = this.getMessages$default$2();
        ByteBufferMessageSet compressedMessagesV0 = this.getMessages(x$109, x$111, (CompressionCodec)x$110);
        this.checkOffsets(messagesV0, 0L);
        int offset = 1234567;
        kafka.common.LongRef x$112 = new kafka.common.LongRef((long)offset);
        long x$113 = System.currentTimeMillis();
        NoCompressionCodec$ x$114 = NoCompressionCodec$.MODULE$;
        NoCompressionCodec$ x$115 = NoCompressionCodec$.MODULE$;
        byte x$116 = 1;
        TimestampType x$117 = TimestampType.LOG_APPEND_TIME;
        long x$118 = 1000L;
        boolean x$119 = messagesV0.validateMessagesAndAssignOffsets$default$5();
        this.checkOffsets(messagesV0.validateMessagesAndAssignOffsets(x$112, x$113, (CompressionCodec)x$114, (CompressionCodec)x$115, x$119, x$116, x$117, x$118).validatedMessages(), offset);
        this.checkOffsets(compressedMessagesV0, 0L);
        kafka.common.LongRef x$120 = new kafka.common.LongRef((long)offset);
        long x$121 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$122 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$123 = DefaultCompressionCodec$.MODULE$;
        byte x$124 = 1;
        TimestampType x$125 = TimestampType.LOG_APPEND_TIME;
        long x$126 = 1000L;
        boolean x$127 = compressedMessagesV0.validateMessagesAndAssignOffsets$default$5();
        this.checkOffsets(compressedMessagesV0.validateMessagesAndAssignOffsets(x$120, x$121, (CompressionCodec)x$122, (CompressionCodec)x$123, x$127, x$124, x$125, x$126).validatedMessages(), offset);
        long now = System.currentTimeMillis();
        ByteBufferMessageSet messagesV1 = this.getMessages(Message$.MODULE$.MagicValue_V1(), now, (CompressionCodec)NoCompressionCodec$.MODULE$);
        ByteBufferMessageSet compressedMessagesV1 = this.getMessages(Message$.MODULE$.MagicValue_V1(), now, (CompressionCodec)DefaultCompressionCodec$.MODULE$);
        this.checkOffsets(messagesV1, 0L);
        kafka.common.LongRef x$128 = new kafka.common.LongRef((long)offset);
        long x$129 = System.currentTimeMillis();
        NoCompressionCodec$ x$130 = NoCompressionCodec$.MODULE$;
        NoCompressionCodec$ x$131 = NoCompressionCodec$.MODULE$;
        byte x$132 = 0;
        TimestampType x$133 = TimestampType.CREATE_TIME;
        long x$134 = 5000L;
        boolean x$135 = messagesV1.validateMessagesAndAssignOffsets$default$5();
        this.checkOffsets(messagesV1.validateMessagesAndAssignOffsets(x$128, x$129, (CompressionCodec)x$130, (CompressionCodec)x$131, x$135, x$132, x$133, x$134).validatedMessages(), offset);
        this.checkOffsets(compressedMessagesV1, 0L);
        kafka.common.LongRef x$136 = new kafka.common.LongRef((long)offset);
        long x$137 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$138 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$139 = DefaultCompressionCodec$.MODULE$;
        byte x$140 = 0;
        TimestampType x$141 = TimestampType.CREATE_TIME;
        long x$142 = 5000L;
        boolean x$143 = compressedMessagesV1.validateMessagesAndAssignOffsets$default$5();
        this.checkOffsets(compressedMessagesV1.validateMessagesAndAssignOffsets(x$136, x$137, (CompressionCodec)x$138, (CompressionCodec)x$139, x$143, x$140, x$141, x$142).validatedMessages(), offset);
    }

    @Test
    public void testWriteFullyTo() {
        this.checkWriteFullyToWithMessageSet(this.createMessageSet((Seq<Message>)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Message.class)))));
        this.checkWriteFullyToWithMessageSet(this.createMessageSet((Seq<Message>)Predef$.MODULE$.wrapRefArray((Object[])this.messages())));
    }

    public void checkWriteFullyToWithMessageSet(ByteBufferMessageSet messageSet) {
        this.checkWriteWithMessageSet((MessageSet)messageSet, (Function1<GatheringByteChannel, Object>)new Serializable(this, messageSet){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet messageSet$1;

            public final long apply(GatheringByteChannel channel) {
                return this.messageSet$1.writeFullyTo(channel);
            }
            {
                this.messageSet$1 = messageSet$1;
            }
        });
    }

    public void checkOffsets(ByteBufferMessageSet messages2, long baseOffset) {
        Assert.assertTrue((String)"Message set should not be empty", (boolean)messages2.nonEmpty());
        LongRef offset = new LongRef(baseOffset);
        messages2.foreach((Function1)new Serializable(this, offset){
            public static final long serialVersionUID = 0L;
            private final LongRef offset$1;

            public final void apply(MessageAndOffset entry) {
                Assert.assertEquals((String)"Unexpected offset in message set iterator", (long)this.offset$1.elem, (long)entry.offset());
                ++this.offset$1.elem;
            }
            {
                this.offset$1 = offset$1;
            }
        });
    }

    public void verifyShallowIterator(ByteBufferMessageSet messageSet) {
        Set shallowOffsets = messageSet.shallowIterator().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(MessageAndOffset msgAndOff) {
                return msgAndOff.offset();
            }
        }).toSet();
        Set deepOffsets = messageSet.iterator().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(MessageAndOffset msgAndOff) {
                return msgAndOff.offset();
            }
        }).toSet();
        Assert.assertTrue((boolean)shallowOffsets.subsetOf((GenSet)deepOffsets));
    }

    private ByteBufferMessageSet getMessages(byte magicValue, long timestamp, CompressionCodec codec) {
        return magicValue == Message$.MODULE$.MagicValue_V0() ? new ByteBufferMessageSet(codec, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes(), Message$.MODULE$.NoTimestamp(), Message$.MODULE$.MagicValue_V0()), new Message("there".getBytes(), Message$.MODULE$.NoTimestamp(), Message$.MODULE$.MagicValue_V0()), new Message("beautiful".getBytes(), Message$.MODULE$.NoTimestamp(), Message$.MODULE$.MagicValue_V0())})) : new ByteBufferMessageSet(codec, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes(), timestamp, Message$.MODULE$.MagicValue_V1()), new Message("there".getBytes(), timestamp, Message$.MODULE$.MagicValue_V1()), new Message("beautiful".getBytes(), timestamp, Message$.MODULE$.MagicValue_V1())}));
    }

    private byte getMessages$default$1() {
        return Message$.MODULE$.CurrentMagicValue();
    }

    private long getMessages$default$2() {
        return Message$.MODULE$.NoTimestamp();
    }

    private CompressionCodec getMessages$default$3() {
        return NoCompressionCodec$.MODULE$;
    }

    private ByteBufferMessageSet messageSetWithInvalidInnerMagic(CompressionCodec codec, long initialOffset) {
        IndexedSeq messages2 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Message apply(int id) {
                byte[] x$144 = ((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes();
                byte[] x$145 = ((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes();
                long x$146 = Message$.MODULE$.NoTimestamp();
                byte x$147 = Message$.MODULE$.MagicValue_V0();
                return new Message(x$145, x$144, x$146, x$147);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        MessageWriter messageWriter = new MessageWriter(package$.MODULE$.min(package$.MODULE$.max(MessageSet$.MODULE$.messageSetSize((Iterable)messages2) / 2, 1024), 65536));
        LongRef lastOffset = new LongRef(initialOffset);
        CompressionCodec x$148 = codec;
        long x$149 = System.currentTimeMillis();
        TimestampType x$150 = TimestampType.CREATE_TIME;
        byte x$151 = Message$.MODULE$.MagicValue_V1();
        byte[] x$152 = messageWriter.write$default$1();
        Serializable x$153 = new Serializable(this, codec, initialOffset, messages2, lastOffset){
            public static final long serialVersionUID = 0L;
            private final CompressionCodec codec$1;
            public final long initialOffset$1;
            private final IndexedSeq messages$1;
            public final LongRef lastOffset$1;

            public final void apply(OutputStream outputStream) {
                try (DataOutputStream output = new DataOutputStream(CompressionFactory$.MODULE$.apply(this.codec$1, Message$.MODULE$.MagicValue_V1(), outputStream));){
                    this.messages$1.foreach((Function1)new Serializable(this, output){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$4 $outer;
                        private final DataOutputStream output$1;

                        public final void apply(Message message) {
                            long innerOffset = this.$outer.lastOffset$1.elem - this.$outer.initialOffset$1;
                            this.output$1.writeLong(innerOffset);
                            this.output$1.writeInt(message.size());
                            this.output$1.write(message.buffer().array(), message.buffer().arrayOffset(), message.buffer().limit());
                            ++this.$outer.lastOffset$1.elem;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.output$1 = output$1;
                        }
                    });
                    return;
                }
            }
            {
                this.codec$1 = codec$1;
                this.initialOffset$1 = initialOffset$1;
                this.messages$1 = messages$1;
                this.lastOffset$1 = lastOffset$1;
            }
        };
        messageWriter.write(x$152, x$148, x$149, x$150, x$151, (Function1)x$153);
        ByteBuffer buffer = ByteBuffer.allocate(messageWriter.size() + MessageSet$.MODULE$.LogOverhead());
        ByteBufferMessageSet$.MODULE$.writeMessage(buffer, messageWriter, lastOffset.elem - 1L);
        buffer.rewind();
        return new ByteBufferMessageSet(buffer);
    }

    public final void kafka$message$ByteBufferMessageSetTest$$validateLogAppendTime$1(Message message, long now$1) {
        message.ensureValid();
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timestamp of message ", " should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message, BoxesRunTime.boxToLong((long)now$1)})), (long)now$1, (long)message.timestamp());
        Assert.assertEquals((Object)TimestampType.LOG_APPEND_TIME, (Object)message.timestampType());
    }

    public ByteBufferMessageSetTest() {
        BaseMessageSetTestCases$class.$init$(this);
    }
}

