/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Properties;
import kafka.integration.KafkaServerTestHarness;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.network.SocketServer;
import kafka.server.BrokerShuttingDown$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.NotRunning$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Before;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005}e!B\u0001\u0003\u0003\u00039!a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u0013!\tI\u0001#D\u0001\u000b\u0015\tYA\"A\u0003kk:LGO\u0003\u0002\u000e\u001d\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002\u001f\u0005\u0019qN]4\n\u0005EQ!A\u0003&V]&$8+^5uKB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\fS:$Xm\u001a:bi&|g.\u0003\u0002\u0018)\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003\u001a\u0001\u0011\u0005!$\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011A\u0004A\u0007\u0002\u0005!9a\u0004\u0001a\u0001\n\u0013y\u0012!D2peJ,G.\u0019;j_:LE-F\u0001!!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\rIe\u000e\u001e\u0005\bO\u0001\u0001\r\u0011\"\u0003)\u0003E\u0019wN\u001d:fY\u0006$\u0018n\u001c8JI~#S-\u001d\u000b\u0003S1\u0002\"!\t\u0016\n\u0005-\u0012#\u0001B+oSRDq!\f\u0014\u0002\u0002\u0003\u0007\u0001%A\u0002yIEBaa\f\u0001!B\u0013\u0001\u0013AD2peJ,G.\u0019;j_:LE\r\t\u0005\u0006c\u0001!\tbH\u0001\u000b]Vl'I]8lKJ\u001c\b\"B\u001a\u0001\t#!\u0014!\u00059s_B,'\u000f^=Pm\u0016\u0014(/\u001b3fgR\u0011\u0011&\u000e\u0005\u0006mI\u0002\raN\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\bC\u0001\u001d>\u001b\u0005I$B\u0001\u001e<\u0003\u0011)H/\u001b7\u000b\u0003q\nAA[1wC&\u0011a(\u000f\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\b\"\u0002!\u0001\t\u0003\t\u0015aD4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ:\u0015\u0003\t\u00032aQ&O\u001d\t!\u0015J\u0004\u0002F\u00116\taI\u0003\u0002H\r\u00051AH]8pizJ\u0011aI\u0005\u0003\u0015\n\nq\u0001]1dW\u0006<W-\u0003\u0002M\u001b\n\u00191+Z9\u000b\u0005)\u0013\u0003C\u0001\u000fP\u0013\t\u0001&AA\u0006LC\u001a\\\u0017mQ8oM&<\u0007\"\u0002*\u0001\t\u0003\u0019\u0016aD1osN{7m[3u'\u0016\u0014h/\u001a:\u0016\u0003Q\u0003\"!\u0016-\u000e\u0003YS!a\u0016\u0003\u0002\u000f9,Go^8sW&\u0011\u0011L\u0016\u0002\r'>\u001c7.\u001a;TKJ4XM\u001d\u0005\u00067\u0002!\taU\u0001\u0017G>tGO]8mY\u0016\u00148k\\2lKR\u001cVM\u001d<fe\")Q\f\u0001C\u0001'\u0006Ibn\u001c;D_:$(o\u001c7mKJ\u001cvnY6fiN+'O^3s\u0011\u0015y\u0006\u0001\"\u0001a\u0003I\u0011'o\\6feN{7m[3u'\u0016\u0014h/\u001a:\u0015\u0005Q\u000b\u0007\"\u00022_\u0001\u0004\u0001\u0013\u0001\u00032s_.,'/\u00133\t\u000b\u0011\u0004A\u0011A3\u0002\u000f\r|gN\\3diR\u0019a\r\u001c8\u0011\u0005\u001dTW\"\u00015\u000b\u0005%\\\u0014a\u00018fi&\u00111\u000e\u001b\u0002\u0007'>\u001c7.\u001a;\t\u000f5\u001c\u0007\u0013!a\u0001)\u0006\t1\u000fC\u0004pGB\u0005\t\u0019\u00019\u0002\u0011A\u0014x\u000e^8d_2\u0004\"!\u001d=\u000e\u0003IT!a\\:\u000b\u0005Q,\u0018AB2p[6|gN\u0003\u0002\u0006m*\u0011qOD\u0001\u0007CB\f7\r[3\n\u0005e\u0014(\u0001E*fGV\u0014\u0018\u000e^=Qe>$xnY8m\u0011\u0015Y\b\u0001\"\u0003}\u0003-\u0019XM\u001c3SKF,Xm\u001d;\u0015\u0007%jx\u0010C\u0003\u007fu\u0002\u0007a-\u0001\u0004t_\u000e\\W\r\u001e\u0005\b\u0003\u0003Q\b\u0019AA\u0002\u0003\u001d\u0011X-];fgR\u0004R!IA\u0003\u0003\u0013I1!a\u0002#\u0005\u0015\t%O]1z!\r\t\u00131B\u0005\u0004\u0003\u001b\u0011#\u0001\u0002\"zi\u0016Dq!!\u0005\u0001\t\u0013\t\u0019\"A\bsK\u000e,\u0017N^3SKN\u0004xN\\:f)\u0011\t\u0019!!\u0006\t\ry\fy\u00011\u0001g\u0011\u001d\tI\u0002\u0001C\u0001\u00037\t\u0011C]3rk\u0016\u001cH/\u00118e%\u0016\u001cW-\u001b<f)\u0019\t\u0019!!\b\u0002 !1a0a\u0006A\u0002\u0019D\u0001\"!\u0001\u0002\u0018\u0001\u0007\u00111\u0001\u0005\b\u0003G\u0001A\u0011AA\u0013\u0003\u0011\u0019XM\u001c3\u0015\u0019\u0005\u001d\u00121GA!\u0003\u0017\nY&a\u0018\u0011\t\u0005%\u0012qF\u0007\u0003\u0003WQ1!!\f<\u0003\rq\u0017n\\\u0005\u0005\u0003c\tYC\u0001\u0006CsR,')\u001e4gKJD\u0001\"!\u0001\u0002\"\u0001\u0007\u0011Q\u0007\t\u0005\u0003o\ti$\u0004\u0002\u0002:)\u0019\u00111H:\u0002\u0011I,\u0017/^3tiNLA!a\u0010\u0002:\ty\u0011IY:ue\u0006\u001cGOU3rk\u0016\u001cH\u000f\u0003\u0005\u0002D\u0005\u0005\u0002\u0019AA#\u0003\u0019\t\u0007/[&fsB\u0019\u0011/a\u0012\n\u0007\u0005%#OA\u0004Ba&\\U-_:\t\u0015\u00055\u0013\u0011\u0005I\u0001\u0002\u0004\ty%A\u0004wKJ\u001c\u0018n\u001c8\u0011\u000b\u0005\n\t&!\u0016\n\u0007\u0005M#E\u0001\u0004PaRLwN\u001c\t\u0004C\u0005]\u0013bAA-E\t)1\u000b[8si\"I\u0011QLA\u0011!\u0003\u0005\r\u0001V\u0001\fI\u0016\u001cH/\u001b8bi&|g\u000e\u0003\u0005p\u0003C\u0001\n\u00111\u0001q\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003G\"\"\"a\n\u0002f\u0005\u001d\u0014\u0011NA6\u0011!\t\t!!\u0019A\u0002\u0005U\u0002\u0002CA\"\u0003C\u0002\r!!\u0012\t\u0011\u00055\u0013\u0011\ra\u0001\u0003+BaA`A1\u0001\u00041\u0007\"CA8\u0001E\u0005I\u0011AA9\u00039\u0019XM\u001c3%I\u00164\u0017-\u001e7uIM*\"!a\u001d+\t\u0005=\u0013QO\u0016\u0003\u0003o\u0002B!!\u001f\u0002\u00046\u0011\u00111\u0010\u0006\u0005\u0003{\ny(A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0011\u0012\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0006\u0006m$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011\u0011\u0012\u0001\u0012\u0002\u0013\u0005\u00111R\u0001\u000fg\u0016tG\r\n3fM\u0006,H\u000e\u001e\u00135+\t\tiIK\u0002U\u0003kB\u0011\"!%\u0001#\u0003%\t!a%\u0002\u001dM,g\u000e\u001a\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011Q\u0013\u0016\u0004a\u0006U\u0004\"CAM\u0001E\u0005I\u0011AAF\u0003E\u0019wN\u001c8fGR$C-\u001a4bk2$H%\r\u0005\n\u0003;\u0003\u0011\u0013!C\u0001\u0003'\u000b\u0011cY8o]\u0016\u001cG\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0001")
public abstract class BaseRequestTest
extends JUnitSuite
implements KafkaServerTestHarness {
    private int correlationId;
    private Seq<KafkaConfig> instanceConfigs;
    private Buffer<KafkaServer> servers;
    private String brokerList;
    private boolean[] alive;
    private final String kafkaPrincipalType;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public Seq<KafkaConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    @Override
    public void instanceConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.instanceConfigs = x$1;
    }

    @Override
    public Buffer<KafkaServer> servers() {
        return this.servers;
    }

    @Override
    public void servers_$eq(Buffer<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public String brokerList() {
        return this.brokerList;
    }

    @Override
    public void brokerList_$eq(String x$1) {
        this.brokerList = x$1;
    }

    @Override
    public boolean[] alive() {
        return this.alive;
    }

    @Override
    public void alive_$eq(boolean[] x$1) {
        this.alive = x$1;
    }

    @Override
    public String kafkaPrincipalType() {
        return this.kafkaPrincipalType;
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$_setter_$kafkaPrincipalType_$eq(String x$1) {
        this.kafkaPrincipalType = x$1;
    }

    @Override
    public void setAclsBeforeServersStart() {
        KafkaServerTestHarness$class.setAclsBeforeServersStart(this);
    }

    @Override
    public Seq<KafkaConfig> configs() {
        return KafkaServerTestHarness$class.configs(this);
    }

    @Override
    public Option<KafkaServer> serverForId(int id) {
        return KafkaServerTestHarness$class.serverForId(this, id);
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return KafkaServerTestHarness$class.securityProtocol(this);
    }

    @Override
    public Option<File> trustStoreFile() {
        return KafkaServerTestHarness$class.trustStoreFile(this);
    }

    @Override
    public Option<Properties> saslProperties() {
        return KafkaServerTestHarness$class.saslProperties(this);
    }

    @Override
    @Before
    public void setUp() {
        KafkaServerTestHarness$class.setUp(this);
    }

    @Override
    @After
    public void tearDown() {
        KafkaServerTestHarness$class.tearDown(this);
    }

    @Override
    public int killRandomBroker() {
        return KafkaServerTestHarness$class.killRandomBroker(this);
    }

    @Override
    public void restartDeadBrokers() {
        KafkaServerTestHarness$class.restartDeadBrokers(this);
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        BaseRequestTest baseRequestTest = this;
        synchronized (baseRequestTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    private int correlationId() {
        return this.correlationId;
    }

    private void correlationId_$eq(int x$1) {
        this.correlationId = x$1;
    }

    public int numBrokers() {
        return 3;
    }

    public void propertyOverrides(Properties properties) {
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        Seq<Properties> props = TestUtils$.MODULE$.createBrokerConfigs(this.numBrokers(), this.zkConnect(), false, true, (Option<SecurityProtocol>)new Some((Object)this.securityProtocol()), this.trustStoreFile(), this.saslProperties(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12());
        props.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseRequestTest $outer;

            public final void apply(Properties properties) {
                this.$outer.propertyOverrides(properties);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        return (Seq)props.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public SocketServer anySocketServer() {
        return (SocketServer)this.servers().find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KafkaServer server) {
                byte state = server.brokerState().currentState();
                return state != NotRunning$.MODULE$.state() && state != BrokerShuttingDown$.MODULE$.state();
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SocketServer apply(KafkaServer x$1) {
                return x$1.socketServer();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalStateException("No live broker is available");
            }
        });
    }

    public SocketServer controllerSocketServer() {
        return (SocketServer)this.servers().find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KafkaServer server) {
                return server.kafkaController().isActive();
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SocketServer apply(KafkaServer x$2) {
                return x$2.socketServer();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalStateException("No controller broker is available");
            }
        });
    }

    public SocketServer notControllerSocketServer() {
        return (SocketServer)this.servers().find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KafkaServer server) {
                return !server.kafkaController().isActive();
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SocketServer apply(KafkaServer x$3) {
                return x$3.socketServer();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalStateException("No non-controller broker is available");
            }
        });
    }

    public SocketServer brokerSocketServer(int brokerId) {
        return (SocketServer)this.servers().find((Function1)new Serializable(this, brokerId){
            public static final long serialVersionUID = 0L;
            private final int brokerId$1;

            public final boolean apply(KafkaServer server) {
                return server.config().brokerId() == this.brokerId$1;
            }
            {
                this.brokerId$1 = brokerId$1;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SocketServer apply(KafkaServer x$4) {
                return x$4.socketServer();
            }
        }).getOrElse((Function0)new Serializable(this, brokerId){
            public static final long serialVersionUID = 0L;
            private final int brokerId$1;

            public final Nothing$ apply() {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find broker with id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.brokerId$1)})));
            }
            {
                this.brokerId$1 = brokerId$1;
            }
        });
    }

    public Socket connect(SocketServer s, SecurityProtocol protocol) {
        return new Socket("localhost", s.boundPort(protocol));
    }

    public SocketServer connect$default$1() {
        return this.anySocketServer();
    }

    public SecurityProtocol connect$default$2() {
        return SecurityProtocol.PLAINTEXT;
    }

    private void sendRequest(Socket socket, byte[] request) {
        DataOutputStream outgoing = new DataOutputStream(socket.getOutputStream());
        outgoing.writeInt(request.length);
        outgoing.write(request);
        outgoing.flush();
    }

    private byte[] receiveResponse(Socket socket) {
        DataInputStream incoming = new DataInputStream(socket.getInputStream());
        int len = incoming.readInt();
        byte[] response = new byte[len];
        incoming.readFully(response);
        return response;
    }

    public byte[] requestAndReceive(Socket socket, byte[] request) {
        this.sendRequest(socket, request);
        return this.receiveResponse(socket);
    }

    public ByteBuffer send(AbstractRequest request, ApiKeys apiKey, Option<Object> version, SocketServer destination, SecurityProtocol protocol) {
        short requestVersion = BoxesRunTime.unboxToShort((Object)version.getOrElse((Function0)new Serializable(this, apiKey){
            public static final long serialVersionUID = 0L;
            private final ApiKeys apiKey$1;

            public final short apply() {
                return this.apply$mcS$sp();
            }

            public short apply$mcS$sp() {
                return ProtoUtils.latestVersion((int)this.apiKey$1.id);
            }
            {
                this.apiKey$1 = apiKey$1;
            }
        }));
        try (Socket socket = this.connect(destination, protocol);){
            return this.send(request, apiKey, requestVersion, socket);
        }
    }

    public ByteBuffer send(AbstractRequest request, ApiKeys apiKey, short version, Socket socket) {
        this.correlationId_$eq(this.correlationId() + 1);
        RequestHeader header = new RequestHeader(apiKey.id, version, "", this.correlationId());
        ByteBuffer byteBuffer = ByteBuffer.allocate(header.sizeOf() + request.sizeOf());
        header.writeTo(byteBuffer);
        request.writeTo(byteBuffer);
        byte[] serializedBytes = byteBuffer.array();
        byte[] response = this.requestAndReceive(socket, serializedBytes);
        ByteBuffer responseBuffer = ByteBuffer.wrap(response);
        ResponseHeader.parse((ByteBuffer)responseBuffer);
        return responseBuffer;
    }

    public Option<Object> send$default$3() {
        return None$.MODULE$;
    }

    public SocketServer send$default$4() {
        return this.anySocketServer();
    }

    public SecurityProtocol send$default$5() {
        return SecurityProtocol.PLAINTEXT;
    }

    public BaseRequestTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        KafkaServerTestHarness$class.$init$(this);
        this.correlationId = 0;
    }
}

