/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.nio.ByteBuffer;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001B\u0001\u0003\u0001\u001d\u0011qc\u0011:fCR,Gk\u001c9jGN\u0014V-];fgR$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%QQ\"\u0001\u0002\n\u0005-\u0011!a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\t\u000b5\u0001A\u0011\u0001\b\u0002\rqJg.\u001b;?)\u0005y\u0001CA\u0005\u0001\u0011\u0015\t\u0002\u0001\"\u0001\u0013\u0003u!Xm\u001d;WC2LGm\u0011:fCR,Gk\u001c9jGN\u0014V-];fgR\u001cH#A\n\u0011\u0005Q9R\"A\u000b\u000b\u0003Y\tQa]2bY\u0006L!\u0001G\u000b\u0003\tUs\u0017\u000e\u001e\u0015\u0003!i\u0001\"a\u0007\u0011\u000e\u0003qQ!!\b\u0010\u0002\u000b),h.\u001b;\u000b\u0003}\t1a\u001c:h\u0013\t\tCD\u0001\u0003UKN$\b\"B\u0012\u0001\t\u0013!\u0013!\t<bY&$\u0017\r^3WC2LGm\u0011:fCR,Gk\u001c9jGN\u0014V-];fgR\u001cHCA\n&\u0011\u00151#\u00051\u0001(\u0003\u001d\u0011X-];fgR\u0004\"\u0001\u000b\u0019\u000e\u0003%R!AK\u0016\u0002\u0011I,\u0017/^3tiNT!\u0001L\u0017\u0002\r\r|W.\\8o\u0015\t)aF\u0003\u00020=\u00051\u0011\r]1dQ\u0016L!!M\u0015\u0003'\r\u0013X-\u0019;f)>\u0004\u0018nY:SKF,Xm\u001d;\t\u000bM\u0002A\u0011\u0001\n\u0002;Q,7\u000f^#se>\u00148I]3bi\u0016$v\u000e]5dgJ+\u0017/^3tiND#A\r\u000e\t\u000bY\u0002A\u0011\u0001\n\u0002?Q,7\u000f^%om\u0006d\u0017\u000eZ\"sK\u0006$X\rV8qS\u000e\u001c(+Z9vKN$8\u000f\u000b\u000265!)\u0011\b\u0001C\u0005u\u0005\u0019B-\u001e9mS\u000e\fG/\u001a$jeN$Hk\u001c9jGR\u0011qe\u000f\u0005\u0006Ma\u0002\ra\n\u0005\u0006{\u0001!IAP\u0001.C\u0012$\u0007+\u0019:uSRLwN\\:B]\u0012\u0014V\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d+p\r&\u00148\u000f\u001e+pa&\u001cGCA\u0014@\u0011\u00151C\b1\u0001(\u0011\u0015\t\u0005\u0001\"\u0003C\u0003\u00052\u0018\r\\5eCR,WI\u001d:pe\u000e\u0013X-\u0019;f)>\u0004\u0018nY:SKF,Xm\u001d;t)\r\u00192\t\u0012\u0005\u0006M\u0001\u0003\ra\n\u0005\u0006\u000b\u0002\u0003\rAR\u0001\u0011Kb\u0004Xm\u0019;fIJ+7\u000f]8og\u0016\u0004Ba\u0012&N!:\u0011A\u0003S\u0005\u0003\u0013V\ta\u0001\u0015:fI\u00164\u0017BA&M\u0005\ri\u0015\r\u001d\u0006\u0003\u0013V\u0001\"a\u0012(\n\u0005=c%AB*ue&tw\r\u0005\u0002R)6\t!K\u0003\u0002TW\u0005A\u0001O]8u_\u000e|G.\u0003\u0002V%\n1QI\u001d:peNDQa\u0016\u0001\u0005\u0002I\t\u0011\u0003^3ti:{GoQ8oiJ|G\u000e\\3sQ\t1&\u0004C\u0003[\u0001\u0011%1,A\nwC2LG-\u0019;f)>\u0004\u0018nY#ySN$8\u000f\u0006\u0002\u00149\")Q,\u0017a\u0001\u001b\u0006)Ao\u001c9jG\")q\f\u0001C\u0005A\u00069\"/\u001a9mS\u000e\f\u0017i]:jO:lWM\u001c;U_*\u000bg/\u0019\u000b\u0003CF\u0004BAY4i]6\t1M\u0003\u0002eK\u0006!Q\u000f^5m\u0015\u00051\u0017\u0001\u00026bm\u0006L!aS2\u0011\u0005%dW\"\u00016\u000b\u0005-,\u0017\u0001\u00027b]\u001eL!!\u001c6\u0003\u000f%sG/Z4feB\u0019!m\u001c5\n\u0005A\u001c'\u0001\u0002'jgRDQA\u001d0A\u0002M\f1\"Y:tS\u001etW.\u001a8ugB!qI\u0013;x!\t!R/\u0003\u0002w+\t\u0019\u0011J\u001c;\u0011\ta\f\t\u0001\u001e\b\u0003szt!A_?\u000e\u0003mT!\u0001 \u0004\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0012BA@\u0016\u0003\u001d\u0001\u0018mY6bO\u0016L1\u0001]A\u0002\u0015\tyX\u0003C\u0004\u0002\b\u0001!I!!\u0003\u0002-M,g\u000eZ\"sK\u0006$X\rV8qS\u000e\u0014V-];fgR$\u0002\"a\u0003\u0002\u0012\u0005M\u0011Q\u0004\t\u0004Q\u00055\u0011bAA\bS\t!2I]3bi\u0016$v\u000e]5dgJ+7\u000f]8og\u0016DaAJA\u0003\u0001\u00049\u0003\u0002CA\u000b\u0003\u000b\u0001\r!a\u0006\u0002\u000fY,'o]5p]B\u0019A#!\u0007\n\u0007\u0005mQCA\u0003TQ>\u0014H\u000f\u0003\u0006\u0002 \u0005\u0015\u0001\u0013!a\u0001\u0003C\tAb]8dW\u0016$8+\u001a:wKJ\u0004B!a\t\u0002*5\u0011\u0011Q\u0005\u0006\u0004\u0003O!\u0011a\u00028fi^|'o[\u0005\u0005\u0003W\t)C\u0001\u0007T_\u000e\\W\r^*feZ,'\u000fC\u0004\u00020\u0001!I!!\r\u0002'M,g\u000eZ'fi\u0006$\u0017\r^1SKF,Xm\u001d;\u0015\r\u0005M\u0012\u0011HA!!\rA\u0013QG\u0005\u0004\u0003oI#\u0001E'fi\u0006$\u0017\r^1SKN\u0004xN\\:f\u0011\u001d1\u0013Q\u0006a\u0001\u0003w\u00012\u0001KA\u001f\u0013\r\ty$\u000b\u0002\u0010\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3ti\"Q\u00111IA\u0017!\u0003\u0005\r!!\t\u0002\u0017\u0011,7\u000f^5oCRLwN\u001c\u0005\n\u0003\u000f\u0002\u0011\u0013!C\u0005\u0003\u0013\n\u0001e]3oI\u000e\u0013X-\u0019;f)>\u0004\u0018n\u0019*fcV,7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\n\u0016\u0005\u0003C\tie\u000b\u0002\u0002PA!\u0011\u0011KA.\u001b\t\t\u0019F\u0003\u0003\u0002V\u0005]\u0013!C;oG\",7m[3e\u0015\r\tI&F\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA/\u0003'\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\t\t\u0007AI\u0001\n\u0013\tI%A\u000ftK:$W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0001")
public class CreateTopicsRequestTest
extends BaseRequestTest {
    @Test
    public void testValidCreateTopicsRequests() {
        int timeout = 10000;
        this.validateValidCreateTopicsRequests(new CreateTopicsRequest((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"topic1"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1))}))).asJava(), Predef$.MODULE$.int2Integer(timeout)));
        this.validateValidCreateTopicsRequests(new CreateTopicsRequest((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"topic2"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)3))}))).asJava(), Predef$.MODULE$.int2Integer(timeout)));
        java.util.Map config3 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"min.insync.replicas"), (Object)"2")}))).asJava();
        this.validateValidCreateTopicsRequests(new CreateTopicsRequest((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"topic3"), (Object)new CreateTopicsRequest.TopicDetails(5, (short)2, config3))}))).asJava(), Predef$.MODULE$.int2Integer(timeout)));
        java.util.Map<Integer, java.util.List<Integer>> assignments4 = this.replicaAssignmentToJava((scala.collection.immutable.Map<Object, List<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}))));
        this.validateValidCreateTopicsRequests(new CreateTopicsRequest((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"topic4"), (Object)new CreateTopicsRequest.TopicDetails(assignments4))}))).asJava(), Predef$.MODULE$.int2Integer(timeout)));
        java.util.Map<Integer, java.util.List<Integer>> assignments5 = this.replicaAssignmentToJava((scala.collection.immutable.Map<Object, List<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}))));
        java.util.Map config5 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"min.insync.replicas"), (Object)"2")}))).asJava();
        this.validateValidCreateTopicsRequests(new CreateTopicsRequest((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"topic5"), (Object)new CreateTopicsRequest.TopicDetails(assignments5, config5))}))).asJava(), Predef$.MODULE$.int2Integer(timeout)));
        java.util.Map<Integer, java.util.List<Integer>> assignments8 = this.replicaAssignmentToJava((scala.collection.immutable.Map<Object, List<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}))));
        this.validateValidCreateTopicsRequests(new CreateTopicsRequest((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"topic6"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"topic7"), (Object)new CreateTopicsRequest.TopicDetails(5, (short)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"topic8"), (Object)new CreateTopicsRequest.TopicDetails(assignments8))}))).asJava(), Predef$.MODULE$.int2Integer(timeout)));
    }

    private void validateValidCreateTopicsRequests(CreateTopicsRequest request) {
        CreateTopicsResponse response = this.sendCreateTopicRequest(request, (short)0, this.sendCreateTopicRequest$default$3());
        Option error = ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.errors().values()).asScala()).find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Errors x$1) {
                Errors errors = x$1;
                Errors errors2 = Errors.NONE;
                return errors != null ? !errors.equals(errors2) : errors2 != null;
            }
        });
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"There should be no errors, found ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.mapAsScalaMapConverter(response.errors()).asScala()})), (boolean)error.isEmpty());
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.topics()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CreateTopicsRequestTest $outer;

            public final void apply(Tuple2<String, CreateTopicsRequest.TopicDetails> x0$2) {
                Tuple2<String, CreateTopicsRequest.TopicDetails> tuple2 = x0$2;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    CreateTopicsRequest.TopicDetails details = (CreateTopicsRequest.TopicDetails)tuple2._2();
                    this.verifyMetadata$1(this.$outer.controllerSocketServer(), topic, details);
                    TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.$outer.servers(), topic, 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
                    this.verifyMetadata$1(this.$outer.notControllerSocketServer(), topic, details);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }

            private final void verifyMetadata$1(SocketServer socketServer, String topic$1, CreateTopicsRequest.TopicDetails details$1) {
                Iterable metadata = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.$outer.kafka$server$CreateTopicsRequestTest$$sendMetadataRequest(new MetadataRequest((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic$1}))).asJava()), this.$outer.kafka$server$CreateTopicsRequestTest$$sendMetadataRequest$default$2()).topicMetadata()).asScala();
                MetadataResponse.TopicMetadata metadataForTopic = (MetadataResponse.TopicMetadata)((IterableLike)metadata.filter((Function1)new Serializable(this, topic$1){
                    public static final long serialVersionUID = 0L;
                    private final String topic$1;

                    public final boolean apply(MetadataResponse.TopicMetadata p) {
                        return p.topic().equals(this.topic$1);
                    }
                    {
                        this.topic$1 = topic$1;
                    }
                })).head();
                int partitions = details$1.replicasAssignments.isEmpty() ? details$1.numPartitions : details$1.replicasAssignments.size();
                int replication = details$1.replicasAssignments.isEmpty() ? details$1.replicationFactor : ((java.util.List)((Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(details$1.replicasAssignments).asScala()).head())._2()).size();
                Assert.assertNotNull((String)"The topic should be created", (Object)metadataForTopic);
                Assert.assertEquals((String)"The topic should have the correct number of partitions", (long)partitions, (long)metadataForTopic.partitionMetadata().size());
                Assert.assertEquals((String)"The topic should have the correct replication factor", (long)replication, (long)((MetadataResponse.PartitionMetadata)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(metadataForTopic.partitionMetadata()).asScala()).head()).replicas().size());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testErrorCreateTopicsRequests() {
        int timeout = 10000;
        String existingTopic = "existing-topic";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), existingTopic, 1, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.validateErrorCreateTopicsRequests(new CreateTopicsRequest((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)existingTopic), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1))}))).asJava(), Predef$.MODULE$.int2Integer(timeout)), (scala.collection.immutable.Map<String, Errors>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)existingTopic), (Object)Errors.TOPIC_ALREADY_EXISTS)}))));
        this.validateErrorCreateTopicsRequests(new CreateTopicsRequest((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"error-partitions"), (Object)new CreateTopicsRequest.TopicDetails(-1, (short)1))}))).asJava(), Predef$.MODULE$.int2Integer(timeout)), (scala.collection.immutable.Map<String, Errors>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"error-partitions"), (Object)Errors.INVALID_PARTITIONS)}))));
        this.validateErrorCreateTopicsRequests(new CreateTopicsRequest((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"error-replication"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)(this.numBrokers() + 1)))}))).asJava(), Predef$.MODULE$.int2Integer(timeout)), (scala.collection.immutable.Map<String, Errors>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"error-replication"), (Object)Errors.INVALID_REPLICATION_FACTOR)}))));
        java.util.Map invalidConfig = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"not.a.property"), (Object)"error")}))).asJava();
        this.validateErrorCreateTopicsRequests(new CreateTopicsRequest((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"error-config"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1, invalidConfig))}))).asJava(), Predef$.MODULE$.int2Integer(timeout)), (scala.collection.immutable.Map<String, Errors>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"error-config"), (Object)Errors.INVALID_CONFIG)}))));
        java.util.Map<Integer, java.util.List<Integer>> invalidAssignments = this.replicaAssignmentToJava((scala.collection.immutable.Map<Object, List<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}))));
        this.validateErrorCreateTopicsRequests(new CreateTopicsRequest((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"error-assignment"), (Object)new CreateTopicsRequest.TopicDetails(invalidAssignments))}))).asJava(), Predef$.MODULE$.int2Integer(timeout)), (scala.collection.immutable.Map<String, Errors>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"error-assignment"), (Object)Errors.INVALID_REPLICA_ASSIGNMENT)}))));
        this.validateErrorCreateTopicsRequests(new CreateTopicsRequest((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)existingTopic), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"partial-partitions"), (Object)new CreateTopicsRequest.TopicDetails(-1, (short)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"partial-replication"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)(this.numBrokers() + 1))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"partial-assignment"), (Object)new CreateTopicsRequest.TopicDetails(invalidAssignments)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"partial-none"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1))}))).asJava(), Predef$.MODULE$.int2Integer(timeout)), (scala.collection.immutable.Map<String, Errors>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)existingTopic), (Object)Errors.TOPIC_ALREADY_EXISTS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"partial-partitions"), (Object)Errors.INVALID_PARTITIONS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"partial-replication"), (Object)Errors.INVALID_REPLICATION_FACTOR), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"partial-assignment"), (Object)Errors.INVALID_REPLICA_ASSIGNMENT), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"partial-none"), (Object)Errors.NONE)}))));
        this.kafka$server$CreateTopicsRequestTest$$validateTopicExists("partial-none");
        this.validateErrorCreateTopicsRequests(new CreateTopicsRequest((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"error-timeout"), (Object)new CreateTopicsRequest.TopicDetails(10, (short)3))}))).asJava(), Predef$.MODULE$.int2Integer(1)), (scala.collection.immutable.Map<String, Errors>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"error-timeout"), (Object)Errors.REQUEST_TIMED_OUT)}))));
        this.validateErrorCreateTopicsRequests(new CreateTopicsRequest((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"error-timeout-zero"), (Object)new CreateTopicsRequest.TopicDetails(10, (short)3))}))).asJava(), Predef$.MODULE$.int2Integer(0)), (scala.collection.immutable.Map<String, Errors>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"error-timeout-zero"), (Object)Errors.REQUEST_TIMED_OUT)}))));
        this.validateErrorCreateTopicsRequests(new CreateTopicsRequest((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"error-timeout-negative"), (Object)new CreateTopicsRequest.TopicDetails(10, (short)3))}))).asJava(), Predef$.MODULE$.int2Integer(-1)), (scala.collection.immutable.Map<String, Errors>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"error-timeout-negative"), (Object)Errors.REQUEST_TIMED_OUT)}))));
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), "error-timeout", 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), "error-timeout-zero", 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), "error-timeout-negative", 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        this.kafka$server$CreateTopicsRequestTest$$validateTopicExists("error-timeout");
        this.kafka$server$CreateTopicsRequestTest$$validateTopicExists("error-timeout-zero");
        this.kafka$server$CreateTopicsRequestTest$$validateTopicExists("error-timeout-negative");
    }

    @Test
    public void testInvalidCreateTopicsRequests() {
        CreateTopicsRequest singleRequest = new CreateTopicsRequest((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"duplicate-topic"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1))}))).asJava(), Predef$.MODULE$.int2Integer(1000));
        CreateTopicsRequest duplicateRequest = this.duplicateFirstTopic(singleRequest);
        Assert.assertFalse((String)"Request doesn't have duplicate topics", (boolean)duplicateRequest.duplicateTopics().isEmpty());
        this.validateErrorCreateTopicsRequests(duplicateRequest, (scala.collection.immutable.Map<String, Errors>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"duplicate-topic"), (Object)Errors.INVALID_REQUEST)}))));
        CreateTopicsRequest doubleRequest = new CreateTopicsRequest((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"duplicate-topic"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"other-topic"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1))}))).asJava(), Predef$.MODULE$.int2Integer(1000));
        CreateTopicsRequest duplicateDoubleRequest = this.duplicateFirstTopic(doubleRequest);
        Assert.assertFalse((String)"Request doesn't have duplicate topics", (boolean)duplicateDoubleRequest.duplicateTopics().isEmpty());
        this.validateErrorCreateTopicsRequests(duplicateDoubleRequest, (scala.collection.immutable.Map<String, Errors>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"duplicate-topic"), (Object)Errors.INVALID_REQUEST), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"other-topic"), (Object)Errors.NONE)}))));
        java.util.Map<Integer, java.util.List<Integer>> assignments = this.replicaAssignmentToJava((scala.collection.immutable.Map<Object, List<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}))));
        CreateTopicsRequest assignmentRequest = new CreateTopicsRequest((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"bad-args-topic"), (Object)new CreateTopicsRequest.TopicDetails(assignments))}))).asJava(), Predef$.MODULE$.int2Integer(1000));
        CreateTopicsRequest badArgumentsRequest = this.addPartitionsAndReplicationFactorToFirstTopic(assignmentRequest);
        this.validateErrorCreateTopicsRequests(badArgumentsRequest, (scala.collection.immutable.Map<String, Errors>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"bad-args-topic"), (Object)Errors.INVALID_REQUEST)}))));
    }

    private CreateTopicsRequest duplicateFirstTopic(CreateTopicsRequest request) {
        Struct firstTopic;
        Struct struct = request.toStruct();
        Object[] topics = struct.getArray("create_topic_requests");
        Struct struct2 = firstTopic = (Struct)topics[0];
        List newTopics = Predef$.MODULE$.refArrayOps(topics).toList().$colon$colon((Object)struct2);
        struct.set("create_topic_requests", newTopics.toArray(ClassTag$.MODULE$.Object()));
        return new CreateTopicsRequest(struct);
    }

    private CreateTopicsRequest addPartitionsAndReplicationFactorToFirstTopic(CreateTopicsRequest request) {
        Struct struct = request.toStruct();
        Object[] topics = struct.getArray("create_topic_requests");
        Struct firstTopic = (Struct)topics[0];
        firstTopic.set("num_partitions", (Object)BoxesRunTime.boxToInteger((int)1));
        firstTopic.set("replication_factor", (Object)BoxesRunTime.boxToShort((short)((short)1)));
        return new CreateTopicsRequest(struct);
    }

    private void validateErrorCreateTopicsRequests(CreateTopicsRequest request, scala.collection.immutable.Map<String, Errors> expectedResponse) {
        CreateTopicsResponse response = this.sendCreateTopicRequest(request, (short)0, this.sendCreateTopicRequest$default$3());
        scala.collection.mutable.Map errors = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(response.errors()).asScala();
        Assert.assertEquals((String)"The response size should match", (long)expectedResponse.size(), (long)response.errors().size());
        expectedResponse.foreach((Function1)new Serializable(this, expectedResponse, errors){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CreateTopicsRequestTest $outer;
            private final scala.collection.immutable.Map expectedResponse$1;
            private final scala.collection.mutable.Map errors$1;

            public final void apply(Tuple2<String, Errors> x0$3) {
                Tuple2<String, Errors> tuple2 = x0$3;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    String topic = (String)tuple2._1();
                    Errors expectedError = (Errors)tuple2._2();
                    Assert.assertEquals((String)"The response error should match", (Object)this.expectedResponse$1.apply((Object)topic), (Object)this.errors$1.apply((Object)topic));
                    Errors errors = expectedError;
                    Errors errors2 = Errors.NONE;
                    if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                        this.$outer.kafka$server$CreateTopicsRequestTest$$validateTopicExists(topic);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.expectedResponse$1 = expectedResponse$1;
                this.errors$1 = errors$1;
            }
        });
    }

    @Test
    public void testNotController() {
        CreateTopicsRequest request = new CreateTopicsRequest((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"topic1"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1))}))).asJava(), Predef$.MODULE$.int2Integer(1000));
        CreateTopicsResponse response = this.sendCreateTopicRequest(request, (short)0, this.notControllerSocketServer());
        Errors error = (Errors)((Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(response.errors()).asScala()).head())._2();
        Assert.assertEquals((String)"Expected controller error when routed incorrectly", (Object)Errors.NOT_CONTROLLER, (Object)error);
    }

    public void kafka$server$CreateTopicsRequestTest$$validateTopicExists(String topic) {
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), topic, 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        Iterable metadata = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.kafka$server$CreateTopicsRequestTest$$sendMetadataRequest(new MetadataRequest((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).asJava()), this.kafka$server$CreateTopicsRequestTest$$sendMetadataRequest$default$2()).topicMetadata()).asScala();
        Assert.assertTrue((String)"The topic should be created", (boolean)metadata.exists((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$2;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(MetadataResponse.TopicMetadata p) {
                if (!p.topic().equals(this.topic$2)) return false;
                Errors errors = p.error();
                Errors errors2 = Errors.NONE;
                if (errors != null) {
                    if (!errors.equals(errors2)) return false;
                    return true;
                }
                if (errors2 == null) return true;
                return false;
            }
            {
                this.topic$2 = topic$2;
            }
        }));
    }

    private java.util.Map<Integer, java.util.List<Integer>> replicaAssignmentToJava(scala.collection.immutable.Map<Object, List<Object>> assignments) {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)assignments.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Integer, java.util.List<Integer>> apply(Tuple2<Object, List<Object>> x0$1) {
                Tuple2<Object, List<Object>> tuple2 = x0$1;
                if (tuple2 != null) {
                    int k = tuple2._1$mcI$sp();
                    List v = (List)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)Predef$.MODULE$.int2Integer(k), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)v.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Integer apply(int i) {
                            return Predef$.MODULE$.int2Integer(i);
                        }
                    }, List$.MODULE$.canBuildFrom())).asJava());
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom())).asJava();
    }

    private CreateTopicsResponse sendCreateTopicRequest(CreateTopicsRequest request, short version, SocketServer socketServer) {
        ByteBuffer response = this.send((AbstractRequest)request, ApiKeys.CREATE_TOPICS, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)version)), socketServer, this.send$default$5());
        return CreateTopicsResponse.parse((ByteBuffer)response, (int)version);
    }

    private SocketServer sendCreateTopicRequest$default$3() {
        return this.controllerSocketServer();
    }

    public MetadataResponse kafka$server$CreateTopicsRequestTest$$sendMetadataRequest(MetadataRequest request, SocketServer destination) {
        short version = ProtoUtils.latestVersion((int)ApiKeys.METADATA.id);
        MetadataRequest x$3 = request;
        ApiKeys x$4 = ApiKeys.METADATA;
        SocketServer x$5 = destination;
        Option<Object> x$6 = this.send$default$3();
        SecurityProtocol x$7 = this.send$default$5();
        ByteBuffer response = this.send((AbstractRequest)x$3, x$4, x$6, x$5, x$7);
        return MetadataResponse.parse((ByteBuffer)response, (int)version);
    }

    public SocketServer kafka$server$CreateTopicsRequestTest$$sendMetadataRequest$default$2() {
        return this.anySocketServer();
    }
}

