/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.admin.AdminUtils$;
import kafka.server.DynamicConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.kafka.common.config.ConfigException;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000194A!\u0001\u0002\u0001\u000f\t\tB)\u001f8b[&\u001c7i\u001c8gS\u001e$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g\u0011\u0015y\u0001\u0001\"\u0001\u0011\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0003\u0005\u0002\u0013\u00015\t!\u0001C\u0004\u0015\u0001\t\u0007IQB\u000b\u0002#9|g.\u0012=jgR,g\u000e^\"p]\u001aLw-F\u0001\u0017!\t9\"D\u0004\u0002\n1%\u0011\u0011DC\u0001\u0007!J,G-\u001a4\n\u0005ma\"AB*ue&twM\u0003\u0002\u001a\u0015!1a\u0004\u0001Q\u0001\u000eY\t!C\\8o\u000bbL7\u000f^3oi\u000e{gNZ5hA!9\u0001\u0005\u0001b\u0001\n\u001b)\u0012!C:p[\u00164\u0016\r\\;f\u0011\u0019\u0011\u0003\u0001)A\u0007-\u0005Q1o\\7f-\u0006dW/\u001a\u0011\t\u0013\u0011\u0002\u0001\u0019!a\u0001\n\u0003)\u0013a\u0002>l+RLGn]\u000b\u0002MA\u0011qEK\u0007\u0002Q)\u0011\u0011\u0006B\u0001\u0006kRLGn]\u0005\u0003W!\u0012qAW6Vi&d7\u000fC\u0005.\u0001\u0001\u0007\t\u0019!C\u0001]\u0005Y!p[+uS2\u001cx\fJ3r)\ty#\u0007\u0005\u0002\na%\u0011\u0011G\u0003\u0002\u0005+:LG\u000fC\u00044Y\u0005\u0005\t\u0019\u0001\u0014\u0002\u0007a$\u0013\u0007\u0003\u00046\u0001\u0001\u0006KAJ\u0001\tu.,F/\u001b7tA!)q\u0007\u0001C\u0001q\u0005)1/\u001a;VaR\tq\u0006\u000b\u00027uA\u00111\bQ\u0007\u0002y)\u0011QHP\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u007f\u0005\u0019qN]4\n\u0005\u0005c$A\u0002\"fM>\u0014X\rC\u0003D\u0001\u0011\u0005\u0001(A\u0015tQ>,H\u000e\u001a$bS2<\u0006.\u001a8DQ\u0006tw-\u001b8h\u0005J|7.\u001a:V].twn\u001e8D_:4\u0017n\u001a\u0015\u0005\u0005\u0016C\u0015\n\u0005\u0002<\r&\u0011q\t\u0010\u0002\u0005)\u0016\u001cH/\u0001\u0005fqB,7\r^3eG\u0005Q\u0005CA&T\u001d\ta\u0015K\u0004\u0002N!6\taJ\u0003\u0002P\r\u00051AH]8pizJ\u0011aC\u0005\u0003%*\tq\u0001]1dW\u0006<W-\u0003\u0002U+\nA\u0012\n\u001c7fO\u0006d\u0017I]4v[\u0016tG/\u0012=dKB$\u0018n\u001c8\u000b\u0005IS\u0001\"B,\u0001\t\u0003A\u0014aK:i_VdGMR1jY^CWM\\\"iC:<\u0017N\\4DY&,g\u000e^%e+:\\gn\\<o\u0007>tg-[4)\tY+\u0005*\u0013\u0005\u00065\u0002!\t\u0001O\u0001(g\"|W\u000f\u001c3GC&dw\u000b[3o\u0007\"\fgnZ5oOV\u001bXM]+oW:|wO\\\"p]\u001aLw\r\u000b\u0003Z\u000b\"K\u0005\"B/\u0001\t\u0003A\u0014\u0001K:i_VdGMR1jY2+\u0017\rZ3s\u0007>tg-[4t/&$\b.\u00138wC2LGMV1mk\u0016\u001c\b\u0006\u0002/F\u0011~\u001b\u0013\u0001\u0019\t\u0003C&l\u0011A\u0019\u0006\u0003G\u0012\faaY8oM&<'BA3g\u0003\u0019\u0019w.\\7p]*\u0011Qa\u001a\u0006\u0003Qz\na!\u00199bG\",\u0017B\u00016c\u0005=\u0019uN\u001c4jO\u0016C8-\u001a9uS>t\u0007\"\u00027\u0001\t\u0003A\u0014AK:i_VdGMR1jY\u001a{G\u000e\\8xKJ\u001cuN\u001c4jON<\u0016\u000e\u001e5J]Z\fG.\u001b3WC2,Xm\u001d\u0015\u0005W\u0016Cu\f")
public class DynamicConfigTest {
    private final String nonExistentConfig;
    private final String someValue;
    private ZkUtils zkUtils;

    private final String nonExistentConfig() {
        return this.nonExistentConfig;
    }

    private final String someValue() {
        return this.someValue;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Before
    public void setUp() {
        ZkClient zkClient = (ZkClient)EasyMock.createMock(ZkClient.class);
        this.zkUtils_$eq(ZkUtils$.MODULE$.apply(zkClient, false));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailWhenChangingBrokerUnknownConfig() {
        AdminUtils$.MODULE$.changeBrokerConfig(this.zkUtils(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), CoreUtils$.MODULE$.propsWith(this.nonExistentConfig(), this.someValue()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailWhenChangingClientIdUnknownConfig() {
        AdminUtils$.MODULE$.changeClientIdConfig(this.zkUtils(), "ClientId", CoreUtils$.MODULE$.propsWith(this.nonExistentConfig(), this.someValue()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailWhenChangingUserUnknownConfig() {
        AdminUtils$.MODULE$.changeUserOrUserClientIdConfig(this.zkUtils(), "UserId", CoreUtils$.MODULE$.propsWith(this.nonExistentConfig(), this.someValue()));
    }

    @Test(expected=ConfigException.class)
    public void shouldFailLeaderConfigsWithInvalidValues() {
        AdminUtils$.MODULE$.changeBrokerConfig(this.zkUtils(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), CoreUtils$.MODULE$.propsWith(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), "-100"));
    }

    @Test(expected=ConfigException.class)
    public void shouldFailFollowerConfigsWithInvalidValues() {
        AdminUtils$.MODULE$.changeBrokerConfig(this.zkUtils(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), CoreUtils$.MODULE$.propsWith(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), "-100"));
    }

    public DynamicConfigTest() {
        this.nonExistentConfig = "some.config.that.does.not.exist";
        this.someValue = "some interesting value";
    }
}

