/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import java.util.List;
import javax.security.auth.login.Configuration;
import kafka.consumer.ConsumerConfig;
import kafka.utils.JaasTestUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZKCheckedEphemeral;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZKEphemeralTest$;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.ZkConnection;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005t!B\u0001\u0003\u0011\u00039\u0011a\u0004.L\u000bBDW-\\3sC2$Vm\u001d;\u000b\u0005\r!\u0011A\u0001>l\u0015\u0005)\u0011!B6bM.\f7\u0001\u0001\t\u0003\u0011%i\u0011A\u0001\u0004\u0006\u0015\tA\ta\u0003\u0002\u00105.+\u0005\u000f[3nKJ\fG\u000eV3tiN\u0019\u0011\u0002\u0004\n\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g!\ti1#\u0003\u0002\u0015\u001d\ta1+\u001a:jC2L'0\u00192mK\")a#\u0003C\u0001/\u00051A(\u001b8jiz\"\u0012a\u0002\u0005\u00063%!\tAG\u0001\u0016K:\f'\r\\3TK\u000e,(/\u001b;z\u001fB$\u0018n\u001c8t+\u0005Y\u0002c\u0001\u000f\"G5\tQD\u0003\u0002\u001f?\u0005!A.\u00198h\u0015\u0005\u0001\u0013\u0001\u00026bm\u0006L!AI\u000f\u0003\u0011%#XM]1cY\u0016\u00042!\u0004\u0013'\u0013\t)cBA\u0003BeJ\f\u0017\u0010\u0005\u0002\u001dO%\u0011\u0001&\b\u0002\b\u0005>|G.Z1oQ\tA\"\u0006\u0005\u0002,{9\u0011AF\u000f\b\u0003[]r!A\f\u001b\u000f\u0005=\u0012T\"\u0001\u0019\u000b\u0005E2\u0011A\u0002\u001fs_>$h(C\u00014\u0003\ry'oZ\u0005\u0003kY\nQA[;oSRT\u0011aM\u0005\u0003qe\nqA];o]\u0016\u00148O\u0003\u00026m%\u00111\bP\u0001\u000e!\u0006\u0014\u0018-\\3uKJL'0\u001a3\u000b\u0005aJ\u0014B\u0001 @\u0005)\u0001\u0016M]1nKR,'o\u001d\u0006\u0003wqBq!Q\u0005\u0002\u0002\u0013%!)A\u0006sK\u0006$'+Z:pYZ,G#A\"\u0011\u0005q!\u0015BA#\u001e\u0005\u0019y%M[3di\u001a!!B\u0001\u0001H'\r1\u0005j\u0014\t\u0003\u00136k\u0011A\u0013\u0006\u0003k-S!\u0001\u0014\u001c\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018B\u0001(K\u0005)QUK\\5u'VLG/\u001a\t\u0003\u0011AK!!\u0015\u0002\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0011!\u0019fI!b\u0001\n\u0003!\u0016AB:fGV\u0014X-F\u0001V!\tia+\u0003\u0002)\u001d!A\u0001L\u0012B\u0001B\u0003%Q+A\u0004tK\u000e,(/\u001a\u0011\t\u000bY1E\u0011\u0001.\u0015\u0005mc\u0006C\u0001\u0005G\u0011\u0015\u0019\u0016\f1\u0001V\u0011\u001dqfI1A\u0005\u0002}\u000b\u0001B[1bg\u001aKG.Z\u000b\u0002AB\u0011\u0011\r\u001a\b\u0003\u001b\tL!a\u0019\b\u0002\rA\u0013X\rZ3g\u0013\t)gM\u0001\u0004TiJLgn\u001a\u0006\u0003G:Aa\u0001\u001b$!\u0002\u0013\u0001\u0017!\u00036bCN4\u0015\u000e\\3!\u0011\u001dQgI1A\u0005\u0002-\fA\"Y;uQB\u0013xN^5eKJ,\u0012\u0001\u001c\t\u000395L!!Z\u000f\t\r=4\u0005\u0015!\u0003m\u00035\tW\u000f\u001e5Qe>4\u0018\u000eZ3sA!9\u0011O\u0012a\u0001\n\u0003\u0011\u0018A\u0005>l'\u0016\u001c8/[8o)&lWm\\;u\u001bN,\u0012a\u001d\t\u0003\u001bQL!!\u001e\b\u0003\u0007%sG\u000fC\u0004x\r\u0002\u0007I\u0011\u0001=\u0002-i\\7+Z:tS>tG+[7f_V$Xj]0%KF$\"!\u001f?\u0011\u00055Q\u0018BA>\u000f\u0005\u0011)f.\u001b;\t\u000fu4\u0018\u0011!a\u0001g\u0006\u0019\u0001\u0010J\u0019\t\r}4\u0005\u0015)\u0003t\u0003MQ8nU3tg&|g\u000eV5nK>,H/T:!\u0011\u001d\t\u0019A\u0012C!\u0003\u000b\tQa]3u+B$\u0012!\u001f\u0015\u0005\u0003\u0003\tI\u0001\u0005\u0003\u0002\f\u00055Q\"A\u001d\n\u0007\u0005=\u0011H\u0001\u0004CK\u001a|'/\u001a\u0005\b\u0003'1E\u0011IA\u0003\u0003!!X-\u0019:E_^t\u0007\u0006BA\t\u0003/\u0001B!a\u0003\u0002\u001a%\u0019\u00111D\u001d\u0003\u000b\u00053G/\u001a:\t\u000f\u0005}a\t\"\u0001\u0002\"\u0005AB/Z:u\u000bBDW-\\3sC2tu\u000eZ3DY\u0016\fg.\u001e9\u0016\u0003eDC!!\b\u0002&A!\u00111BA\u0014\u0013\r\tI#\u000f\u0002\u0005)\u0016\u001cH\u000fC\u0004\u0002.\u0019#\t!!\t\u0002-Q,7\u000f\u001e.l/\u0006$8\r[3e\u000bBDW-\\3sC2DC!a\u000b\u0002&!9\u00111\u0007$\u0005\n\u0005U\u0012\u0001\u0004;fgR\u001c%/Z1uS>tGcA=\u00028!9\u0011\u0011HA\u0019\u0001\u0004\u0001\u0017\u0001\u00029bi\"Dq!!\u0010G\t\u0003\t\t#A\fuKN$xJ^3sY\u0006\u0004\b/\u001b8h'\u0016\u001c8/[8og\"\"\u00111HA\u0013\u0011\u001d\t\u0019E\u0012C\u0001\u0003C\tq\u0002^3tiN\u000bW.Z*fgNLwN\u001c\u0015\u0005\u0003\u0003\n)\u0003K\u0004G\u0003\u0013\n)&a\u0016\u0011\t\u0005-\u0013\u0011K\u0007\u0003\u0003\u001bR1!a\u0014:\u0003\u0019\u0011XO\u001c8fe&!\u00111KA'\u0005\u001d\u0011VO\\,ji\"\fQA^1mk\u0016\u001c#!!\u0017\u0011\t\u0005m\u0013QL\u0007\u0002y%\u0019\u0011q\f\u001f\u0003\u001bA\u000b'/Y7fi\u0016\u0014\u0018N_3e\u0001")
public class ZKEphemeralTest
extends JUnitSuite
implements ZooKeeperTestHarness {
    private final boolean secure;
    private final String jaasFile;
    private final String authProvider;
    private int zkSessionTimeoutMs;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Parameterized.Parameters
    public static Iterable<Boolean[]> enableSecurityOptions() {
        return ZKEphemeralTest$.MODULE$.enableSecurityOptions();
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ZKEphemeralTest zKEphemeralTest = this;
        synchronized (zKEphemeralTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public boolean secure() {
        return this.secure;
    }

    public String jaasFile() {
        return this.jaasFile;
    }

    public String authProvider() {
        return this.authProvider;
    }

    public int zkSessionTimeoutMs() {
        return this.zkSessionTimeoutMs;
    }

    public void zkSessionTimeoutMs_$eq(int x$1) {
        this.zkSessionTimeoutMs = x$1;
    }

    @Override
    @Before
    public void setUp() {
        if (this.secure()) {
            Configuration.setConfiguration(null);
            System.setProperty("java.security.auth.login.config", this.jaasFile());
            System.setProperty(this.authProvider(), "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
            if (!JaasUtils.isZkSecurityEnabled()) {
                throw this.fail("Secure access not enabled");
            }
        }
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    @After
    public void tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
        System.clearProperty("java.security.auth.login.config");
        System.clearProperty(this.authProvider());
        Configuration.setConfiguration(null);
    }

    @Test
    public void testEphemeralNodeCleanup() {
        ConsumerConfig config = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), "test", "1", TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(this.zkConnect(), this.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), JaasUtils.isZkSecurityEnabled());
        try {
            ZkUtils qual$1 = zkUtils;
            String x$2 = "/tmp/zktest";
            String x$3 = "node created";
            List x$4 = qual$1.createEphemeralPathExpectConflict$default$3();
            qual$1.createEphemeralPathExpectConflict(x$2, x$3, x$4);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String testData = null;
        testData = (String)zkUtils.readData("/tmp/zktest")._1();
        Assert.assertNotNull((Object)testData);
        zkUtils.close();
        zkUtils = ZkUtils$.MODULE$.apply(this.zkConnect(), this.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), JaasUtils.isZkSecurityEnabled());
        boolean nodeExists = zkUtils.pathExists("/tmp/zktest");
        Assert.assertFalse((boolean)nodeExists);
        zkUtils.close();
    }

    @Test
    public void testZkWatchedEphemeral() {
        this.testCreation("/zwe-test");
        this.testCreation("/zwe-test-parent/zwe-test");
    }

    private void testCreation(String path) {
        ZooKeeper zk = this.zkUtils().zkConnection().getZookeeper();
        ZKCheckedEphemeral zwe = new ZKCheckedEphemeral(path, "", zk, JaasUtils.isZkSecurityEnabled());
        BooleanRef created = new BooleanRef(false);
        zk.exists(path, new Watcher(this, created){
            private final BooleanRef created$1;

            public void process(WatchedEvent event) {
                Watcher.Event.EventType eventType = event.getType();
                Watcher.Event.EventType eventType2 = Watcher.Event.EventType.NodeCreated;
                if (!(eventType != null ? !eventType.equals(eventType2) : eventType2 != null)) {
                    this.created$1.elem = true;
                }
            }
            {
                this.created$1 = created$1;
            }
        });
        zwe.create();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, path){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZKEphemeralTest $outer;
            private final String path$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkUtils().pathExists(this.path$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.path$1 = path$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Znode ", " wasn't created"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})), TestUtils$.MODULE$.waitUntilTrue$default$3());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testOverlappingSessions() {
        boolean bl;
        Tuple2 tuple22;
        String path = "/zwe-test";
        ZooKeeper zk1 = this.zkUtils().zkConnection().getZookeeper();
        Tuple2 tuple2 = ZkUtils$.MODULE$.createZkClientAndConnection(this.zkConnect(), this.zkSessionTimeoutMs(), this.zkConnectionTimeout());
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        ZkClient zkClient22 = (ZkClient)tuple2._1();
        ZkConnection zkConnection2 = (ZkConnection)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)zkClient22, (Object)zkConnection2);
        ZkClient zkClient2 = (ZkClient)tuple23._1();
        ZkConnection zkConnection22 = (ZkConnection)tuple23._2();
        ZooKeeper zk2 = zkConnection22.getZookeeper();
        ZKCheckedEphemeral zwe = new ZKCheckedEphemeral(path, "", zk2, JaasUtils.isZkSecurityEnabled());
        zk1.create(path, (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        try {
            zwe.create();
            bl = false;
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            bl = true;
        }
        boolean gotException = bl;
        Assert.assertTrue((boolean)gotException);
        zkClient2.close();
    }

    @Test
    public void testSameSession() {
        boolean bl;
        String path = "/zwe-test";
        ZooKeeper zk = this.zkUtils().zkConnection().getZookeeper();
        zk.create(path, (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        ZKCheckedEphemeral zwe = new ZKCheckedEphemeral(path, "", zk, JaasUtils.isZkSecurityEnabled());
        try {
            zwe.create();
            bl = false;
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            bl = true;
        }
        boolean gotException = bl;
        Assert.assertFalse((boolean)gotException);
    }

    public ZKEphemeralTest(boolean secure) {
        this.secure = secure;
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        this.jaasFile = JaasTestUtils$.MODULE$.writeZkFile();
        this.authProvider = "zookeeper.authProvider.1";
        this.zkSessionTimeoutMs = 1000;
    }
}

