/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import kafka.admin.AdminUtilities;
import kafka.admin.AdminUtils$;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReassignmentStatus;
import kafka.common.AdminCommandFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.ReassignedPartitionsContext;
import kafka.log.LogConfig$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tUt!B\u0001\u0003\u0011\u00039\u0011!\u0007*fCN\u001c\u0018n\u001a8QCJ$\u0018\u000e^5p]N\u001cu.\\7b]\u0012T!a\u0001\u0003\u0002\u000b\u0005$W.\u001b8\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002\t\u00135\t!AB\u0003\u000b\u0005!\u00051BA\rSK\u0006\u001c8/[4o!\u0006\u0014H/\u001b;j_:\u001c8i\\7nC:$7cA\u0005\r%A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005]!\"a\u0002'pO\u001eLgn\u001a\u0005\u00063%!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001dAQ\u0001H\u0005\u0005\u0002u\tA!\\1j]R\u0011a$\t\t\u0003\u001b}I!\u0001\t\b\u0003\tUs\u0017\u000e\u001e\u0005\u0006Em\u0001\raI\u0001\u0005CJ<7\u000fE\u0002\u000eI\u0019J!!\n\b\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u001dRcBA\u0007)\u0013\tIc\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003W1\u0012aa\u0015;sS:<'BA\u0015\u000f\u0011\u0015q\u0013\u0002\"\u00010\u0003A1XM]5gs\u0006\u001b8/[4o[\u0016tG\u000fF\u0002\u001faUBQ!M\u0017A\u0002I\nqA_6Vi&d7\u000f\u0005\u0002\u0014g%\u0011A\u0007\u0006\u0002\b5.,F/\u001b7t\u0011\u00151T\u00061\u00018\u0003\u0011y\u0007\u000f^:\u0011\u0005aJT\"A\u0005\u0007\tiJ\u0001a\u000f\u0002!%\u0016\f7o]5h]B\u000b'\u000f^5uS>t7oQ8n[\u0006tGm\u00149uS>t7o\u0005\u0002:\u0019!A!%\u000fB\u0001B\u0003%1\u0005C\u0003\u001as\u0011\u0005a\b\u0006\u00028\u007f!)!%\u0010a\u0001G!9\u0011)\u000fb\u0001\n\u0003\u0011\u0015A\u00029beN,'/F\u0001D!\t!u)D\u0001F\u0015\u00051\u0015A\u00036paR\u001c\u0018.\u001c9mK&\u0011\u0001*\u0012\u0002\r\u001fB$\u0018n\u001c8QCJ\u001cXM\u001d\u0005\u0007\u0015f\u0002\u000b\u0011B\"\u0002\u000fA\f'o]3sA!9A*\u000fb\u0001\n\u0003i\u0015\u0001\u0004>l\u0007>tg.Z2u\u001fB$X#\u0001(\u0011\u0007\u0011{e%\u0003\u0002Q\u000b\nY\u0012I]4v[\u0016tG/Q2dKB$\u0018N\\4PaRLwN\\*qK\u000eDaAU\u001d!\u0002\u0013q\u0015!\u0004>l\u0007>tg.Z2u\u001fB$\b\u0005C\u0004Us\t\u0007I\u0011A+\u0002\u0017\u001d,g.\u001a:bi\u0016|\u0005\u000f^\u000b\u0002-B\u0011AiV\u0005\u00031\u0016\u0013\u0011c\u00149uS>t7\u000b]3d\u0005VLG\u000eZ3s\u0011\u0019Q\u0016\b)A\u0005-\u0006aq-\u001a8fe\u0006$Xm\u00149uA!9A,\u000fb\u0001\n\u0003)\u0016AC3yK\u000e,H/Z(qi\"1a,\u000fQ\u0001\nY\u000b1\"\u001a=fGV$Xm\u00149uA!9\u0001-\u000fb\u0001\n\u0003)\u0016!\u0003<fe&4\u0017p\u00149u\u0011\u0019\u0011\u0017\b)A\u0005-\u0006Qa/\u001a:jMf|\u0005\u000f\u001e\u0011\t\u000f\u0011L$\u0019!C\u0001\u001b\u00069\"/Z1tg&<g.\\3oi*\u001bxN\u001c$jY\u0016|\u0005\u000f\u001e\u0005\u0007Mf\u0002\u000b\u0011\u0002(\u00021I,\u0017m]:jO:lWM\u001c;Kg>tg)\u001b7f\u001fB$\b\u0005C\u0004is\t\u0007I\u0011A'\u0002/Q|\u0007/[2t)>luN^3Kg>tg)\u001b7f\u001fB$\bB\u00026:A\u0003%a*\u0001\ru_BL7m\u001d+p\u001b>4XMS:p]\u001aKG.Z(qi\u0002Bq\u0001\\\u001dC\u0002\u0013\u0005Q*A\u0007ce>\\WM\u001d'jgR|\u0005\u000f\u001e\u0005\u0007]f\u0002\u000b\u0011\u0002(\u0002\u001d\t\u0014xn[3s\u0019&\u001cHo\u00149uA!9\u0001/\u000fb\u0001\n\u0003)\u0016\u0001\u00053jg\u0006\u0014G.\u001a*bG.\fu/\u0019:f\u0011\u0019\u0011\u0018\b)A\u0005-\u0006\tB-[:bE2,'+Y2l\u0003^\f'/\u001a\u0011\t\u000fQL$\u0019!C\u0001k\u0006YA\u000f\u001b:piRdWm\u00149u+\u00051\bc\u0001#PoB\u0011Q\u0002_\u0005\u0003s:\u0011A\u0001T8oO\"110\u000fQ\u0001\nY\fA\u0002\u001e5s_R$H.Z(qi\u0002Bq!`\u001dC\u0002\u0013\u0005a0A\u0004paRLwN\\:\u0016\u0003}\u00042\u0001RA\u0001\u0013\r\t\u0019!\u0012\u0002\n\u001fB$\u0018n\u001c8TKRDq!a\u0002:A\u0003%q0\u0001\u0005paRLwN\\:!\u0011\u0019q\u0013\u0002\"\u0001\u0002\fQ)a$!\u0004\u0002\u0010!1\u0011'!\u0003A\u0002IBq!!\u0005\u0002\n\u0001\u0007a%\u0001\u0006kg>t7\u000b\u001e:j]\u001eDq!!\u0006\n\t\u0013\t9\"\u0001\bsK6|g/\u001a+ie>$H\u000f\\3\u0015\u000fy\tI\"a\u0007\u0002D!1\u0011'a\u0005A\u0002IB\u0001\"!\b\u0002\u0014\u0001\u0007\u0011qD\u0001\u0019a\u0006\u0014H/\u001b;j_:\u001cHk\u001c\"f%\u0016\f7o]5h]\u0016$\u0007\u0003CA\u0011\u0003O\tY#a\u000e\u000e\u0005\u0005\r\"bAA\u0013\u001d\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005%\u00121\u0005\u0002\u0004\u001b\u0006\u0004\b\u0003BA\u0017\u0003gi!!a\f\u000b\u0007\u0005EB!\u0001\u0004d_6lwN\\\u0005\u0005\u0003k\tyCA\tU_BL7-\u00118e!\u0006\u0014H/\u001b;j_:\u0004b!!\t\u0002:\u0005u\u0012\u0002BA\u001e\u0003G\u00111aU3r!\ri\u0011qH\u0005\u0004\u0003\u0003r!aA%oi\"A\u0011QIA\n\u0001\u0004\t9%\u0001\u000esK\u0006\u001c8/[4oK\u0012\u0004\u0016M\u001d;ji&|gn]*uCR,8\u000f\u0005\u0005\u0002\"\u0005\u001d\u00121FA%!\rA\u00111J\u0005\u0004\u0003\u001b\u0012!A\u0005*fCN\u001c\u0018n\u001a8nK:$8\u000b^1ukNDq!!\u0015\n\t\u0003\t\u0019&\u0001\nhK:,'/\u0019;f\u0003N\u001c\u0018n\u001a8nK:$H#\u0002\u0010\u0002V\u0005]\u0003BB\u0019\u0002P\u0001\u0007!\u0007\u0003\u00047\u0003\u001f\u0002\ra\u000e\u0005\b\u0003#JA\u0011AA.))\ti&a\u0019\u0002f\u0005%\u0014Q\u000e\t\b\u001b\u0005}\u0013qDA\u0010\u0013\r\t\tG\u0004\u0002\u0007)V\u0004H.\u001a\u001a\t\rE\nI\u00061\u00013\u0011!\t9'!\u0017A\u0002\u0005]\u0012\u0001\u00062s_.,'\u000fT5tiR{'+Z1tg&<g\u000eC\u0004\u0002l\u0005e\u0003\u0019\u0001\u0014\u0002-Q|\u0007/[2t)>luN^3Kg>t7\u000b\u001e:j]\u001eDq\u0001]A-\u0001\u0004\ty\u0007E\u0002\u000e\u0003cJ1!a\u001d\u000f\u0005\u001d\u0011un\u001c7fC:Dq!a\u001e\n\t\u0003\tI(A\tfq\u0016\u001cW\u000f^3BgNLwM\\7f]R$RAHA>\u0003{Ba!MA;\u0001\u0004\u0011\u0004B\u0002\u001c\u0002v\u0001\u0007q\u0007C\u0004\u0002x%!\t!!!\u0015\u000fy\t\u0019)!\"\u0002\n\"1\u0011'a A\u0002IBq!a\"\u0002\u0000\u0001\u0007a%\u0001\fsK\u0006\u001c8/[4o[\u0016tGOS:p]N#(/\u001b8h\u0011%\tY)a \u0011\u0002\u0003\u0007q/\u0001\u0005uQJ|G\u000f\u001e7f\u0011\u001d\ty)\u0003C\u0001\u0003#\u000ba\u0003\u001d:j]R\u001cUO\u001d:f]R\f5o]5h]6,g\u000e\u001e\u000b\u0006=\u0005M\u0015Q\u0013\u0005\u0007c\u00055\u0005\u0019\u0001\u001a\t\u0011\u0005u\u0011Q\u0012a\u0001\u0003/\u0003b!!\t\u0002:\u0005e\u0005cB\u0007\u0002`\u0005-\u0012q\u0007\u0005\b\u0003;KA\u0011AAP\u0003A\u0001\u0018M]:f\u0003:$g+\u00197jI\u0006$X\r\u0006\u0004\u0002\u0018\u0006\u0005\u00161\u0015\u0005\u0007c\u0005m\u0005\u0019\u0001\u001a\t\u000f\u0005\u001d\u00151\u0014a\u0001M!9\u0011qU\u0005\u0005\n\u0005%\u0016\u0001H2iK\u000e\\\u0017J\u001a*fCN\u001c\u0018n\u001a8nK:$8+^2dK\u0016$W\r\u001a\u000b\u0007\u0003\u000f\nY+!,\t\rE\n)\u000b1\u00013\u0011!\ti\"!*A\u0002\u0005}\u0001bBAY\u0013\u0011\u0005\u00111W\u0001&G\",7m[%g!\u0006\u0014H/\u001b;j_:\u0014V-Y:tS\u001etW.\u001a8u'V\u001c7-Z3eK\u0012$\"\"!\u0013\u00026\u0006]\u00161XA_\u0011\u0019\t\u0014q\u0016a\u0001e!A\u0011\u0011XAX\u0001\u0004\tY#A\tu_BL7-\u00118e!\u0006\u0014H/\u001b;j_:D\u0001\"!\b\u00020\u0002\u0007\u0011q\u0004\u0005\t\u0003\u007f\u000by\u000b1\u0001\u0002 \u0005I\u0002/\u0019:uSRLwN\\:CK&twMU3bgNLwM\\3e\u0011\u001d\t\u0019-\u0003C\u0001\u0003\u000b\fAC^1mS\u0012\fG/Z!oIB\u000b'o]3Be\u001e\u001cHcA\u001c\u0002H\"1!%!1A\u0002\rB\u0011\"a3\n#\u0003%\t!!4\u00027\u0015DXmY;uK\u0006\u001b8/[4o[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\tyMK\u0002x\u0003#\\#!a5\u0011\t\u0005U\u0017q\\\u0007\u0003\u0003/TA!!7\u0002\\\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003;t\u0011AC1o]>$\u0018\r^5p]&!\u0011\u0011]Al\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0004\u0006\u0015\t\u0001\u0011Q]\n\u0005\u0003Gd!\u0003C\u00052\u0003G\u0014\t\u0011)A\u0005e!Y\u00111^Ar\u0005\u0003\u0005\u000b\u0011BA\u0010\u0003I\u0001(o\u001c9pg\u0016$\u0017i]:jO:lWM\u001c;\t\u000fe\t\u0019\u000f\"\u0001\u0002pR1\u0011\u0011_Az\u0003k\u00042\u0001CAr\u0011\u0019\t\u0014Q\u001ea\u0001e!A\u00111^Aw\u0001\u0004\ty\u0002\u0003\u0005\u0002z\u0006\rH\u0011AA~\u0003I)\u00070[:uS:<\u0017i]:jO:lWM\u001c;\u0015\u0005\u0005}\u0001\u0002CA\u0000\u0003G$IA!\u0001\u0002\u001b5\f\u0017PY3UQJ|G\u000f\u001e7f)\rq\"1\u0001\u0005\b\u0003\u0017\u000bi\u00101\u0001x\u0011!\u00119!a9\u0005\u0002\t%\u0011AC7bs\n,G*[7jiR\u0019aDa\u0003\t\u000f\u0005-%Q\u0001a\u0001o\"I!qBAr\t\u0003\u0011!\u0011C\u0001\u0018CN\u001c\u0018n\u001a8UQJ|G\u000f\u001e7fIJ+\u0007\u000f\\5dCN$rA\bB\n\u0005/\u0011Y\u0002\u0003\u0005\u0003\u0016\t5\u0001\u0019AA\u0010\u0003-\tG\u000e\\#ySN$\u0018N\\4\t\u0011\te!Q\u0002a\u0001\u0003?\t1\"\u00197m!J|\u0007o\\:fI\"I1A!\u0004\u0011\u0002\u0003\u0007!Q\u0004\t\u0004\u0011\t}\u0011b\u0001B\u0011\u0005\tq\u0011\tZ7j]V#\u0018\u000e\\5uS\u0016\u001c\b\u0002\u0003B\u0013\u0003G$IAa\n\u0002=A|7\u000f\u001e*fE\u0006d\u0017M\\2f%\u0016\u0004H.[2bgRC\u0017\r^'pm\u0016$GCBA\u0010\u0005S\u0011i\u0003\u0003\u0005\u0003,\t\r\u0002\u0019AA\u0010\u0003!)\u00070[:uS:<\u0007\u0002\u0003B\u0018\u0005G\u0001\r!a\b\u0002\u0011A\u0014x\u000e]8tK\u0012D\u0001Ba\r\u0002d\u0012%!QG\u0001'aJ,'+\u001a2bY\u0006t7-\u001a*fa2L7-\u0019$pe6{g/\u001b8h!\u0006\u0014H/\u001b;j_:\u001cHCBA\u0010\u0005o\u0011I\u0004\u0003\u0005\u0003,\tE\u0002\u0019AA\u0010\u0011!\u0011yC!\rA\u0002\u0005}\u0001\u0002\u0003B\u001f\u0003G$\tAa\u0010\u0002\r\u0019|'/\\1u)\r1#\u0011\t\u0005\t\u0005\u0007\u0012Y\u00041\u0001\u0002 \u0005)Qn\u001c<fg\"A!qIAr\t\u0003\u0011I%\u0001\u0005gS2$XM\u001d\"z)!\tiFa\u0013\u0003P\tE\u0003b\u0002B'\u0005\u000b\u0002\rAJ\u0001\u0006i>\u0004\u0018n\u0019\u0005\t\u0005+\u0011)\u00051\u0001\u0002 !A!\u0011\u0004B#\u0001\u0004\ty\u0002\u0003\u0005\u0003V\u0005\rH\u0011\u0001B,\u0003I\u0011X-Y:tS\u001et\u0007+\u0019:uSRLwN\\:\u0015\t\u0005=$\u0011\f\u0005\n\u0003\u0017\u0013\u0019\u0006%AA\u0002]D\u0001B!\u0018\u0002d\u0012\u0005!qL\u0001\u0012m\u0006d\u0017\u000eZ1uKB\u000b'\u000f^5uS>tG\u0003CA8\u0005C\u0012\u0019G!\u001a\t\rE\u0012Y\u00061\u00013\u0011\u001d\u0011iEa\u0017A\u0002\u0019B\u0001Ba\u001a\u0003\\\u0001\u0007\u0011QH\u0001\na\u0006\u0014H/\u001b;j_:D!Ba\u001b\u0002dF\u0005I\u0011AAg\u0003q\u0011X-Y:tS\u001et\u0007+\u0019:uSRLwN\\:%I\u00164\u0017-\u001e7uIEB!Ba\u001c\u0002dF\u0005I\u0011\u0001B9\u0003\u0005\n7o]5h]RC'o\u001c;uY\u0016$'+\u001a9mS\u000e\f7\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011\u0019H\u000b\u0003\u0003\u001e\u0005E\u0007")
public class ReassignPartitionsCommand
implements Logging {
    public final ZkUtils kafka$admin$ReassignPartitionsCommand$$zkUtils;
    private final Map<TopicAndPartition, Seq<Object>> proposedAssignment;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static long executeAssignment$default$3() {
        return ReassignPartitionsCommand$.MODULE$.executeAssignment$default$3();
    }

    public static ReassignPartitionsCommandOptions validateAndParseArgs(String[] stringArray) {
        return ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(stringArray);
    }

    public static ReassignmentStatus checkIfPartitionReassignmentSucceeded(ZkUtils zkUtils, TopicAndPartition topicAndPartition, Map<TopicAndPartition, Seq<Object>> map, Map<TopicAndPartition, Seq<Object>> map2) {
        return ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(zkUtils, topicAndPartition, map, map2);
    }

    public static Seq<Tuple2<TopicAndPartition, Seq<Object>>> parseAndValidate(ZkUtils zkUtils, String string) {
        return ReassignPartitionsCommand$.MODULE$.parseAndValidate(zkUtils, string);
    }

    public static void printCurrentAssignment(ZkUtils zkUtils, Seq<Tuple2<TopicAndPartition, Seq<Object>>> seq) {
        ReassignPartitionsCommand$.MODULE$.printCurrentAssignment(zkUtils, seq);
    }

    public static void executeAssignment(ZkUtils zkUtils, String string, long l) {
        ReassignPartitionsCommand$.MODULE$.executeAssignment(zkUtils, string, l);
    }

    public static void executeAssignment(ZkUtils zkUtils, ReassignPartitionsCommandOptions reassignPartitionsCommandOptions) {
        ReassignPartitionsCommand$.MODULE$.executeAssignment(zkUtils, reassignPartitionsCommandOptions);
    }

    public static Tuple2<Map<TopicAndPartition, Seq<Object>>, Map<TopicAndPartition, Seq<Object>>> generateAssignment(ZkUtils zkUtils, Seq<Object> seq, String string, boolean bl) {
        return ReassignPartitionsCommand$.MODULE$.generateAssignment(zkUtils, seq, string, bl);
    }

    public static void generateAssignment(ZkUtils zkUtils, ReassignPartitionsCommandOptions reassignPartitionsCommandOptions) {
        ReassignPartitionsCommand$.MODULE$.generateAssignment(zkUtils, reassignPartitionsCommandOptions);
    }

    public static void verifyAssignment(ZkUtils zkUtils, String string) {
        ReassignPartitionsCommand$.MODULE$.verifyAssignment(zkUtils, string);
    }

    public static void verifyAssignment(ZkUtils zkUtils, ReassignPartitionsCommandOptions reassignPartitionsCommandOptions) {
        ReassignPartitionsCommand$.MODULE$.verifyAssignment(zkUtils, reassignPartitionsCommandOptions);
    }

    public static void main(String[] stringArray) {
        ReassignPartitionsCommand$.MODULE$.main(stringArray);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ReassignPartitionsCommand reassignPartitionsCommand = this;
        synchronized (reassignPartitionsCommand) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public Map<TopicAndPartition, Seq<Object>> existingAssignment() {
        Seq proposedTopics = ((SetLike)this.proposedAssignment.keySet().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(TopicAndPartition x$6) {
                return x$6.topic();
            }
        }, Set$.MODULE$.canBuildFrom())).toSeq();
        return this.kafka$admin$ReassignPartitionsCommand$$zkUtils.getReplicaAssignmentForTopics((Seq<String>)proposedTopics);
    }

    private void maybeThrottle(long throttle) {
        if (throttle >= 0L) {
            this.maybeLimit(throttle);
            this.assignThrottledReplicas(this.existingAssignment(), this.proposedAssignment, this.assignThrottledReplicas$default$3());
        }
    }

    public void maybeLimit(long throttle) {
        if (throttle >= 0L) {
            Seq existingBrokers = ((TraversableOnce)this.existingAssignment().values().flatten((Function1)Predef$.MODULE$.conforms())).toSeq();
            Seq proposedBrokers = ((TraversableOnce)this.proposedAssignment.values().flatten((Function1)Predef$.MODULE$.conforms())).toSeq();
            Seq brokers = (Seq)((SeqLike)existingBrokers.$plus$plus((GenTraversableOnce)proposedBrokers, Seq$.MODULE$.canBuildFrom())).distinct();
            brokers.foreach((Function1)new Serializable(this, throttle){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReassignPartitionsCommand $outer;
                private final long throttle$1;

                public final void apply(int id) {
                    this.apply$mcVI$sp(id);
                }

                public void apply$mcVI$sp(int id) {
                    Properties configs = AdminUtils$.MODULE$.fetchEntityConfig(this.$outer.kafka$admin$ReassignPartitionsCommand$$zkUtils, ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger((int)id)).toString());
                    configs.put(DynamicConfig$Broker$.MODULE$.LeaderReplicationThrottledRateProp(), ((Object)BoxesRunTime.boxToLong((long)this.throttle$1)).toString());
                    configs.put(DynamicConfig$Broker$.MODULE$.FollowerReplicationThrottledRateProp(), ((Object)BoxesRunTime.boxToLong((long)this.throttle$1)).toString());
                    AdminUtils$.MODULE$.changeBrokerConfig(this.$outer.kafka$admin$ReassignPartitionsCommand$$zkUtils, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{id}))), configs);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.throttle$1 = throttle$1;
                }
            });
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The throttle limit was set to ", " B/s"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)throttle)})));
        }
    }

    public void assignThrottledReplicas(Map<TopicAndPartition, Seq<Object>> allExisting, Map<TopicAndPartition, Seq<Object>> allProposed, AdminUtilities admin) {
        ((SetLike)allProposed.keySet().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(TopicAndPartition x$7) {
                return x$7.topic();
            }
        }, Set$.MODULE$.canBuildFrom())).toSeq().foreach((Function1)new Serializable(this, allExisting, allProposed, admin){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReassignPartitionsCommand $outer;
            private final Map allExisting$1;
            private final Map allProposed$1;
            private final AdminUtilities admin$1;

            public final void apply(String topic) {
                Tuple2<Map<TopicAndPartition, Seq<Object>>, Map<TopicAndPartition, Seq<Object>>> tuple2 = this.$outer.filterBy(topic, (Map<TopicAndPartition, Seq<Object>>)this.allExisting$1, (Map<TopicAndPartition, Seq<Object>>)this.allProposed$1);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    Map existing = (Map)tuple2._1();
                    Map proposed = (Map)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)existing, (Object)proposed);
                    Map existing2 = (Map)tuple23._1();
                    Map proposed2 = (Map)tuple23._2();
                    String leader = this.$outer.format(this.$outer.kafka$admin$ReassignPartitionsCommand$$preRebalanceReplicaForMovingPartitions((Map<TopicAndPartition, Seq<Object>>)existing2, (Map<TopicAndPartition, Seq<Object>>)proposed2));
                    String follower = this.$outer.format(this.$outer.kafka$admin$ReassignPartitionsCommand$$postRebalanceReplicasThatMoved((Map<TopicAndPartition, Seq<Object>>)existing2, (Map<TopicAndPartition, Seq<Object>>)proposed2));
                    Properties configs = this.admin$1.fetchEntityConfig(this.$outer.kafka$admin$ReassignPartitionsCommand$$zkUtils, ConfigType$.MODULE$.Topic(), topic);
                    configs.put(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), leader);
                    configs.put(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), follower);
                    this.admin$1.changeTopicConfig(this.$outer.kafka$admin$ReassignPartitionsCommand$$zkUtils, topic, configs);
                    this.$outer.debug((Function0<String>)new Serializable(this, topic, leader){
                        public static final long serialVersionUID = 0L;
                        private final String topic$2;
                        private final String leader$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated leader-throttled replicas for topic ", " with: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$2, this.leader$1}));
                        }
                        {
                            this.topic$2 = topic$2;
                            this.leader$1 = leader$1;
                        }
                    });
                    this.$outer.debug((Function0<String>)new Serializable(this, topic, follower){
                        public static final long serialVersionUID = 0L;
                        private final String topic$2;
                        private final String follower$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated follower-throttled replicas for topic ", " with: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$2, this.follower$1}));
                        }
                        {
                            this.topic$2 = topic$2;
                            this.follower$1 = follower$1;
                        }
                    });
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.allExisting$1 = allExisting$1;
                this.allProposed$1 = allProposed$1;
                this.admin$1 = admin$1;
            }
        });
    }

    public AdminUtilities assignThrottledReplicas$default$3() {
        return AdminUtils$.MODULE$;
    }

    public Map<TopicAndPartition, Seq<Object>> kafka$admin$ReassignPartitionsCommand$$postRebalanceReplicasThatMoved(Map<TopicAndPartition, Seq<Object>> existing, Map<TopicAndPartition, Seq<Object>> proposed) {
        return (Map)existing.map((Function1)new Serializable(this, proposed){
            public static final long serialVersionUID = 0L;
            private final Map proposed$2;

            public final Tuple2<TopicAndPartition, Seq<Object>> apply(Tuple2<TopicAndPartition, Seq<Object>> x0$12) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2 = x0$12;
                if (tuple2 != null) {
                    TopicAndPartition tp = (TopicAndPartition)tuple2._1();
                    Seq current = (Seq)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)tp), (Object)((SetLike)((TraversableOnce)this.proposed$2.apply((Object)tp)).toSet().$minus$minus((GenTraversableOnce)current)).toSeq());
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.proposed$2 = proposed$2;
            }
        }, Map$.MODULE$.canBuildFrom());
    }

    public Map<TopicAndPartition, Seq<Object>> kafka$admin$ReassignPartitionsCommand$$preRebalanceReplicaForMovingPartitions(Map<TopicAndPartition, Seq<Object>> existing, Map<TopicAndPartition, Seq<Object>> proposed) {
        return (Map)existing.filter((Function1)new Serializable(this, proposed){
            public static final long serialVersionUID = 0L;
            private final Map proposed$1;

            public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> x0$13) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2 = x0$13;
                if (tuple2 != null) {
                    TopicAndPartition tp = (TopicAndPartition)tuple2._1();
                    Seq current = (Seq)tuple2._2();
                    boolean bl = ((TraversableOnce)((TraversableOnce)this.proposed$1.apply((Object)tp)).toSet().$minus$minus((GenTraversableOnce)current)).nonEmpty();
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.proposed$1 = proposed$1;
            }
        });
    }

    public String format(Map<TopicAndPartition, Seq<Object>> moves) {
        return ((TraversableOnce)moves.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(Tuple2<TopicAndPartition, Seq<Object>> x0$14) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2 = x0$14;
                if (tuple2 != null) {
                    TopicAndPartition tp = (TopicAndPartition)tuple2._1();
                    Seq moves = (Seq)tuple2._2();
                    Seq seq = (Seq)moves.map((Function1)new Serializable(this, tp){
                        public static final long serialVersionUID = 0L;
                        private final TopicAndPartition tp$1;

                        public final String apply(int replicaId) {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.tp$1.partition()), BoxesRunTime.boxToInteger((int)replicaId)}));
                        }
                        {
                            this.tp$1 = tp$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    return seq;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).mkString(",");
    }

    public Tuple2<Map<TopicAndPartition, Seq<Object>>, Map<TopicAndPartition, Seq<Object>>> filterBy(String topic, Map<TopicAndPartition, Seq<Object>> allExisting, Map<TopicAndPartition, Seq<Object>> allProposed) {
        return new Tuple2(allExisting.filter((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$3;

            public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> x0$15) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2 = x0$15;
                if (tuple2 != null) {
                    TopicAndPartition tp = (TopicAndPartition)tuple2._1();
                    String string = tp.topic();
                    String string2 = this.topic$3;
                    boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.topic$3 = topic$3;
            }
        }), allProposed.filter((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$3;

            public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> x0$16) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2 = x0$16;
                if (tuple2 != null) {
                    TopicAndPartition tp = (TopicAndPartition)tuple2._1();
                    String string = tp.topic();
                    String string2 = this.topic$3;
                    boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.topic$3 = topic$3;
            }
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean reassignPartitions(long throttle) {
        this.maybeThrottle(throttle);
        try {
            Map validPartitions = (Map)this.proposedAssignment.filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReassignPartitionsCommand $outer;

                public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> x0$17) {
                    Tuple2<TopicAndPartition, Seq<Object>> tuple2 = x0$17;
                    if (tuple2 != null) {
                        TopicAndPartition p = (TopicAndPartition)tuple2._1();
                        boolean bl = this.$outer.validatePartition(this.$outer.kafka$admin$ReassignPartitionsCommand$$zkUtils, p.topic(), p.partition());
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            if (validPartitions.isEmpty()) {
                return false;
            }
            String jsonReassignmentData = ZkUtils$.MODULE$.formatAsReassignmentJson((Map<TopicAndPartition, Seq<Object>>)validPartitions);
            this.kafka$admin$ReassignPartitionsCommand$$zkUtils.createPersistentPath(ZkUtils$.MODULE$.ReassignPartitionsPath(), jsonReassignmentData, this.kafka$admin$ReassignPartitionsCommand$$zkUtils.createPersistentPath$default$3());
            return true;
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Admin command failed";
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable e$1;

                public final Throwable apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            });
            return false;
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            Map<TopicAndPartition, ReassignedPartitionsContext> partitionsBeingReassigned = this.kafka$admin$ReassignPartitionsCommand$$zkUtils.getPartitionsBeingReassigned();
            throw new AdminCommandFailedException(new StringBuilder().append((Object)"Partition reassignment currently in ").append((Object)new StringOps(Predef$.MODULE$.augmentString("progress for %s. Aborting operation")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionsBeingReassigned}))).toString());
        }
    }

    public long reassignPartitions$default$1() {
        return -1L;
    }

    public boolean validatePartition(ZkUtils zkUtils, String topic, int partition) {
        Option option;
        block7: {
            boolean bl;
            block6: {
                block5: {
                    boolean bl2;
                    Option partitionsOpt = zkUtils.getPartitionsForTopics((Seq<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).get((Object)topic);
                    option = partitionsOpt;
                    if (!(option instanceof Some)) break block5;
                    Some some = (Some)option;
                    Seq partitions = (Seq)some.x();
                    if (partitions.contains((Object)BoxesRunTime.boxToInteger((int)partition))) {
                        bl2 = true;
                    } else {
                        this.error((Function0<String>)new Serializable(this, topic, partition){
                            public static final long serialVersionUID = 0L;
                            private final String topic$4;
                            private final int partition$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Skipping reassignment of partition [%s,%d] ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$4, BoxesRunTime.boxToInteger((int)this.partition$1)}))).append((Object)"since it doesn't exist").toString();
                            }
                            {
                                this.topic$4 = topic$4;
                                this.partition$1 = partition$1;
                            }
                        });
                        bl2 = false;
                    }
                    bl = bl2;
                    break block6;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block7;
                this.error((Function0<String>)new Serializable(this, topic, partition){
                    public static final long serialVersionUID = 0L;
                    private final String topic$4;
                    private final int partition$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Skipping reassignment of partition ").append((Object)new StringOps(Predef$.MODULE$.augmentString("[%s,%d] since topic %s doesn't exist")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$4, BoxesRunTime.boxToInteger((int)this.partition$1), this.topic$4}))).toString();
                    }
                    {
                        this.topic$4 = topic$4;
                        this.partition$1 = partition$1;
                    }
                });
                bl = false;
            }
            return bl;
        }
        throw new MatchError((Object)option);
    }

    public ReassignPartitionsCommand(ZkUtils zkUtils, Map<TopicAndPartition, Seq<Object>> proposedAssignment) {
        this.kafka$admin$ReassignPartitionsCommand$$zkUtils = zkUtils;
        this.proposedAssignment = proposedAssignment;
        Logging$class.$init$(this);
    }

    public static class ReassignPartitionsCommandOptions {
        private final OptionParser parser = new OptionParser();
        private final ArgumentAcceptingOptionSpec<String> zkConnectOpt = this.parser().accepts("zookeeper", "REQUIRED: The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over.").withRequiredArg().describedAs("urls").ofType(String.class);
        private final OptionSpecBuilder generateOpt = this.parser().accepts("generate", "Generate a candidate partition reassignment configuration. Note that this only generates a candidate assignment, it does not execute it.");
        private final OptionSpecBuilder executeOpt = this.parser().accepts("execute", "Kick off the reassignment as specified by the --reassignment-json-file option.");
        private final OptionSpecBuilder verifyOpt = this.parser().accepts("verify", "Verify if the reassignment completed as specified by the --reassignment-json-file option. If there is a throttle engaged for the replicas specified, and the rebalance has completed, the throttle will be removed");
        private final ArgumentAcceptingOptionSpec<String> reassignmentJsonFileOpt = this.parser().accepts("reassignment-json-file", "The JSON file with the partition reassignment configurationThe format to use is - \n{\"partitions\":\n\t[{\"topic\": \"foo\",\n\t  \"partition\": 1,\n\t  \"replicas\": [1,2,3] }],\n\"version\":1\n}").withRequiredArg().describedAs("manual assignment json file path").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> topicsToMoveJsonFileOpt = this.parser().accepts("topics-to-move-json-file", "Generate a reassignment configuration to move the partitions of the specified topics to the list of brokers specified by the --broker-list option. The format to use is - \n{\"topics\":\n\t[{\"topic\": \"foo\"},{\"topic\": \"foo1\"}],\n\"version\":1\n}").withRequiredArg().describedAs("topics to reassign json file path").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> brokerListOpt = this.parser().accepts("broker-list", "The list of brokers to which the partitions need to be reassigned in the form \"0,1,2\". This is required if --topics-to-move-json-file is used to generate reassignment configuration").withRequiredArg().describedAs("brokerlist").ofType(String.class);
        private final OptionSpecBuilder disableRackAware = this.parser().accepts("disable-rack-aware", "Disable rack aware replica assignment");
        private final ArgumentAcceptingOptionSpec<Object> throttleOpt = this.parser().accepts("throttle", "The movement of partitions will be throttled to this value (bytes/sec). Rerunning with this option, whilst a rebalance is in progress, will alter the throttle value. The throttle rate should be at least 1 KB/s.").withRequiredArg().describedAs("throttle").defaultsTo((Object)"-1", (Object[])new String[0]).ofType(Long.TYPE);
        private final OptionSet options;

        public OptionParser parser() {
            return this.parser;
        }

        public ArgumentAcceptingOptionSpec<String> zkConnectOpt() {
            return this.zkConnectOpt;
        }

        public OptionSpecBuilder generateOpt() {
            return this.generateOpt;
        }

        public OptionSpecBuilder executeOpt() {
            return this.executeOpt;
        }

        public OptionSpecBuilder verifyOpt() {
            return this.verifyOpt;
        }

        public ArgumentAcceptingOptionSpec<String> reassignmentJsonFileOpt() {
            return this.reassignmentJsonFileOpt;
        }

        public ArgumentAcceptingOptionSpec<String> topicsToMoveJsonFileOpt() {
            return this.topicsToMoveJsonFileOpt;
        }

        public ArgumentAcceptingOptionSpec<String> brokerListOpt() {
            return this.brokerListOpt;
        }

        public OptionSpecBuilder disableRackAware() {
            return this.disableRackAware;
        }

        public ArgumentAcceptingOptionSpec<Object> throttleOpt() {
            return this.throttleOpt;
        }

        public OptionSet options() {
            return this.options;
        }

        public ReassignPartitionsCommandOptions(String[] args) {
            this.options = this.parser().parse(args);
        }
    }
}

