/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.nio.ByteBuffer;
import java.util.List;
import kafka.log.LogValidator;
import kafka.message.CompressionCodec;
import kafka.message.InvalidMessageException;
import kafka.message.NoCompressionCodec$;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.record.BufferSupplier;
import org.apache.kafka.common.record.ByteBufferLogInputStream;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.LogEntry;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.TimestampType;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

public final class LogValidator$ {
    public static final LogValidator$ MODULE$;

    static {
        new LogValidator$();
    }

    /*
     * Enabled aggressive block sorting
     */
    public LogValidator.ValidationAndOffsetAssignResult validateMessagesAndAssignOffsets(MemoryRecords records, kafka.common.LongRef offsetCounter, long now, CompressionCodec sourceCodec, CompressionCodec targetCodec, boolean compactedTopic, byte messageFormatVersion, TimestampType messageTimestampType, long messageTimestampDiffMaxMs) {
        LogValidator.ValidationAndOffsetAssignResult validationAndOffsetAssignResult;
        CompressionCodec compressionCodec = sourceCodec;
        NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
        if (!(compressionCodec != null ? !compressionCodec.equals(noCompressionCodec$) : noCompressionCodec$ != null)) {
            CompressionCodec compressionCodec2 = targetCodec;
            NoCompressionCodec$ noCompressionCodec$2 = NoCompressionCodec$.MODULE$;
            if (!(compressionCodec2 != null ? !compressionCodec2.equals(noCompressionCodec$2) : noCompressionCodec$2 != null)) {
                if (records.hasMatchingShallowMagic(messageFormatVersion)) {
                    validationAndOffsetAssignResult = this.assignOffsetsNonCompressed(records, offsetCounter, now, compactedTopic, messageTimestampType, messageTimestampDiffMaxMs);
                    return validationAndOffsetAssignResult;
                }
                validationAndOffsetAssignResult = this.convertAndAssignOffsetsNonCompressed(records, offsetCounter, compactedTopic, now, messageTimestampType, messageTimestampDiffMaxMs, messageFormatVersion);
                return validationAndOffsetAssignResult;
            }
        }
        validationAndOffsetAssignResult = this.validateMessagesAndAssignOffsetsCompressed(records, offsetCounter, now, sourceCodec, targetCodec, compactedTopic, messageFormatVersion, messageTimestampType, messageTimestampDiffMaxMs);
        return validationAndOffsetAssignResult;
    }

    public boolean validateMessagesAndAssignOffsets$default$6() {
        return false;
    }

    public byte validateMessagesAndAssignOffsets$default$7() {
        return 1;
    }

    private LogValidator.ValidationAndOffsetAssignResult convertAndAssignOffsetsNonCompressed(MemoryRecords records, kafka.common.LongRef offsetCounter, boolean compactedTopic, long now, TimestampType timestampType2, long messageTimestampDiffMaxMs, byte toMagicValue) {
        int sizeInBytesAfterConversion = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.shallowEntries()).asScala()).map((Function1)new Serializable(toMagicValue){
            public static final long serialVersionUID = 0L;
            private final byte toMagicValue$1;

            public final int apply(ByteBufferLogInputStream.ByteBufferLogEntry logEntry) {
                return logEntry.record().convertedSize(this.toMagicValue$1);
            }
            {
                this.toMagicValue$1 = toMagicValue$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        ByteBuffer newBuffer = ByteBuffer.allocate(sizeInBytesAfterConversion);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)newBuffer, (byte)toMagicValue, (CompressionType)CompressionType.NONE, (TimestampType)timestampType2, (long)offsetCounter.value(), (long)now);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.shallowEntries()).asScala()).foreach((Function1)new Serializable(offsetCounter, compactedTopic, now, timestampType2, messageTimestampDiffMaxMs, builder){
            public static final long serialVersionUID = 0L;
            private final kafka.common.LongRef offsetCounter$1;
            private final boolean compactedTopic$1;
            private final long now$1;
            private final TimestampType timestampType$1;
            private final long messageTimestampDiffMaxMs$1;
            private final MemoryRecordsBuilder builder$1;

            public final void apply(ByteBufferLogInputStream.ByteBufferLogEntry logEntry) {
                Record record2 = logEntry.record();
                LogValidator$.MODULE$.kafka$log$LogValidator$$validateKey(record2, this.compactedTopic$1);
                LogValidator$.MODULE$.kafka$log$LogValidator$$validateTimestamp(record2, this.now$1, this.timestampType$1, this.messageTimestampDiffMaxMs$1);
                this.builder$1.convertAndAppendWithOffset(this.offsetCounter$1.getAndIncrement(), record2);
            }
            {
                this.offsetCounter$1 = offsetCounter$1;
                this.compactedTopic$1 = compactedTopic$1;
                this.now$1 = now$1;
                this.timestampType$1 = timestampType$1;
                this.messageTimestampDiffMaxMs$1 = messageTimestampDiffMaxMs$1;
                this.builder$1 = builder$1;
            }
        });
        MemoryRecords convertedRecords = builder.build();
        MemoryRecordsBuilder.RecordsInfo info = builder.info();
        return new LogValidator.ValidationAndOffsetAssignResult(convertedRecords, info.maxTimestamp, info.shallowOffsetOfMaxTimestamp, true);
    }

    private LogValidator.ValidationAndOffsetAssignResult assignOffsetsNonCompressed(MemoryRecords records, kafka.common.LongRef offsetCounter, long now, boolean compactedTopic, TimestampType timestampType2, long timestampDiffMaxMs) {
        LongRef maxTimestamp = new LongRef(-1L);
        LongRef offsetOfMaxTimestamp = new LongRef(-1L);
        long firstOffset = offsetCounter.value();
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.shallowEntries()).asScala()).foreach((Function1)new Serializable(offsetCounter, now, compactedTopic, timestampType2, timestampDiffMaxMs, maxTimestamp, offsetOfMaxTimestamp){
            public static final long serialVersionUID = 0L;
            private final kafka.common.LongRef offsetCounter$2;
            private final long now$2;
            private final boolean compactedTopic$2;
            private final TimestampType timestampType$2;
            private final long timestampDiffMaxMs$1;
            private final LongRef maxTimestamp$1;
            private final LongRef offsetOfMaxTimestamp$1;

            public final void apply(ByteBufferLogInputStream.ByteBufferLogEntry entry2) {
                Record record2 = entry2.record();
                LogValidator$.MODULE$.kafka$log$LogValidator$$validateKey(record2, this.compactedTopic$2);
                long offset = this.offsetCounter$2.getAndIncrement();
                entry2.setOffset(offset);
                if (record2.magic() > 0) {
                    LogValidator$.MODULE$.kafka$log$LogValidator$$validateTimestamp(record2, this.now$2, this.timestampType$2, this.timestampDiffMaxMs$1);
                    TimestampType timestampType2 = this.timestampType$2;
                    TimestampType timestampType3 = TimestampType.LOG_APPEND_TIME;
                    if (!(timestampType2 != null ? !timestampType2.equals(timestampType3) : timestampType3 != null)) {
                        entry2.setLogAppendTime(this.now$2);
                    } else if (record2.timestamp() > this.maxTimestamp$1.elem) {
                        this.maxTimestamp$1.elem = record2.timestamp();
                        this.offsetOfMaxTimestamp$1.elem = offset;
                    }
                }
            }
            {
                this.offsetCounter$2 = offsetCounter$2;
                this.now$2 = now$2;
                this.compactedTopic$2 = compactedTopic$2;
                this.timestampType$2 = timestampType$2;
                this.timestampDiffMaxMs$1 = timestampDiffMaxMs$1;
                this.maxTimestamp$1 = maxTimestamp$1;
                this.offsetOfMaxTimestamp$1 = offsetOfMaxTimestamp$1;
            }
        });
        TimestampType timestampType3 = timestampType2;
        TimestampType timestampType4 = TimestampType.LOG_APPEND_TIME;
        if (!(timestampType3 != null ? !timestampType3.equals(timestampType4) : timestampType4 != null)) {
            maxTimestamp.elem = now;
            offsetOfMaxTimestamp.elem = firstOffset;
        }
        return new LogValidator.ValidationAndOffsetAssignResult(records, maxTimestamp.elem, offsetOfMaxTimestamp.elem, false);
    }

    public LogValidator.ValidationAndOffsetAssignResult validateMessagesAndAssignOffsetsCompressed(MemoryRecords records, kafka.common.LongRef offsetCounter, long now, CompressionCodec sourceCodec, CompressionCodec targetCodec, boolean compactedTopic, byte messageFormatVersion, TimestampType messageTimestampType, long messageTimestampDiffMaxMs) {
        LogValidator.ValidationAndOffsetAssignResult validationAndOffsetAssignResult;
        CompressionCodec compressionCodec = sourceCodec;
        CompressionCodec compressionCodec2 = targetCodec;
        BooleanRef inPlaceAssignment = new BooleanRef(!(compressionCodec != null ? !compressionCodec.equals(compressionCodec2) : compressionCodec2 != null) && messageFormatVersion > 0);
        LongRef maxTimestamp = new LongRef(-1L);
        kafka.common.LongRef expectedInnerOffset = new kafka.common.LongRef(0L);
        ArrayBuffer validatedRecords = new ArrayBuffer();
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.deepEntries(true, BufferSupplier.NO_CACHING)).asScala()).foreach((Function1)new Serializable(now, sourceCodec, compactedTopic, messageFormatVersion, messageTimestampType, messageTimestampDiffMaxMs, inPlaceAssignment, maxTimestamp, expectedInnerOffset, validatedRecords){
            public static final long serialVersionUID = 0L;
            private final long now$3;
            private final CompressionCodec sourceCodec$1;
            private final boolean compactedTopic$3;
            private final byte messageFormatVersion$1;
            private final TimestampType messageTimestampType$1;
            private final long messageTimestampDiffMaxMs$2;
            private final BooleanRef inPlaceAssignment$1;
            private final LongRef maxTimestamp$2;
            private final kafka.common.LongRef expectedInnerOffset$1;
            private final ArrayBuffer validatedRecords$1;

            public final ArrayBuffer<Record> apply(LogEntry logEntry) {
                Record record2 = logEntry.record();
                LogValidator$.MODULE$.kafka$log$LogValidator$$validateKey(record2, this.compactedTopic$3);
                if (record2.magic() > 0 && this.messageFormatVersion$1 > 0) {
                    LogValidator$.MODULE$.kafka$log$LogValidator$$validateTimestamp(record2, this.now$3, this.messageTimestampType$1, this.messageTimestampDiffMaxMs$2);
                    if (logEntry.offset() != this.expectedInnerOffset$1.getAndIncrement()) {
                        this.inPlaceAssignment$1.elem = false;
                    }
                    if (record2.timestamp() > this.maxTimestamp$2.elem) {
                        this.maxTimestamp$2.elem = record2.timestamp();
                    }
                }
                CompressionCodec compressionCodec = this.sourceCodec$1;
                NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                if ((compressionCodec == null ? noCompressionCodec$ != null : !compressionCodec.equals(noCompressionCodec$)) && logEntry.isCompressed()) {
                    throw new InvalidMessageException(new StringBuilder().append((Object)"Compressed outer record should not have an inner record with a ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"compression attribute set: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{record2}))).toString());
                }
                if (record2.magic() != this.messageFormatVersion$1) {
                    this.inPlaceAssignment$1.elem = false;
                }
                return this.validatedRecords$1.$plus$eq((Object)record2.convert(this.messageFormatVersion$1));
            }
            {
                this.now$3 = now$3;
                this.sourceCodec$1 = sourceCodec$1;
                this.compactedTopic$3 = compactedTopic$3;
                this.messageFormatVersion$1 = messageFormatVersion$1;
                this.messageTimestampType$1 = messageTimestampType$1;
                this.messageTimestampDiffMaxMs$2 = messageTimestampDiffMaxMs$2;
                this.inPlaceAssignment$1 = inPlaceAssignment$1;
                this.maxTimestamp$2 = maxTimestamp$2;
                this.expectedInnerOffset$1 = expectedInnerOffset$1;
                this.validatedRecords$1 = validatedRecords$1;
            }
        });
        if (inPlaceAssignment.elem) {
            validatedRecords.foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Record x$1) {
                    x$1.ensureValid();
                }
            });
            ByteBufferLogInputStream.ByteBufferLogEntry entry2 = (ByteBufferLogInputStream.ByteBufferLogEntry)records.shallowEntries().iterator().next();
            long offset = offsetCounter.addAndGet(validatedRecords.size()) - 1L;
            entry2.setOffset(offset);
            TimestampType timestampType2 = messageTimestampType;
            TimestampType timestampType3 = TimestampType.LOG_APPEND_TIME;
            long shallowTimestamp = !(timestampType2 != null ? !timestampType2.equals(timestampType3) : timestampType3 != null) ? now : maxTimestamp.elem;
            TimestampType timestampType4 = messageTimestampType;
            TimestampType timestampType5 = TimestampType.LOG_APPEND_TIME;
            if (!(timestampType4 != null ? !timestampType4.equals(timestampType5) : timestampType5 != null)) {
                entry2.setLogAppendTime(shallowTimestamp);
            } else {
                TimestampType timestampType6 = messageTimestampType;
                TimestampType timestampType7 = TimestampType.CREATE_TIME;
                if (!(timestampType6 != null ? !timestampType6.equals(timestampType7) : timestampType7 != null)) {
                    entry2.setCreateTime(shallowTimestamp);
                }
            }
            validationAndOffsetAssignResult = new LogValidator.ValidationAndOffsetAssignResult(records, shallowTimestamp, offset, false);
        } else {
            ArrayBuffer entries = (ArrayBuffer)validatedRecords.map((Function1)new Serializable(offsetCounter){
                public static final long serialVersionUID = 0L;
                private final kafka.common.LongRef offsetCounter$3;

                public final LogEntry apply(Record record2) {
                    return LogEntry.create((long)this.offsetCounter$3.getAndIncrement(), (Record)record2);
                }
                {
                    this.offsetCounter$3 = offsetCounter$3;
                }
            }, ArrayBuffer$.MODULE$.canBuildFrom());
            MemoryRecordsBuilder builder = MemoryRecords.builderWithEntries((TimestampType)messageTimestampType, (CompressionType)CompressionType.forId((int)targetCodec.codec()), (long)now, (List)((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)entries).asJava()));
            MemoryRecords updatedRecords = builder.build();
            MemoryRecordsBuilder.RecordsInfo info = builder.info();
            validationAndOffsetAssignResult = new LogValidator.ValidationAndOffsetAssignResult(updatedRecords, info.maxTimestamp, info.shallowOffsetOfMaxTimestamp, true);
        }
        return validationAndOffsetAssignResult;
    }

    public boolean validateMessagesAndAssignOffsetsCompressed$default$6() {
        return false;
    }

    public byte validateMessagesAndAssignOffsetsCompressed$default$7() {
        return 1;
    }

    public void kafka$log$LogValidator$$validateKey(Record record2, boolean compactedTopic) {
        if (compactedTopic && !record2.hasKey()) {
            throw new InvalidMessageException("Compacted topic cannot accept message without key.");
        }
    }

    public void kafka$log$LogValidator$$validateTimestamp(Record record2, long now, TimestampType timestampType2, long timestampDiffMaxMs) {
        TimestampType timestampType3 = timestampType2;
        TimestampType timestampType4 = TimestampType.CREATE_TIME;
        if (!(timestampType3 != null ? !timestampType3.equals(timestampType4) : timestampType4 != null) && package$.MODULE$.abs(record2.timestamp() - now) > timestampDiffMaxMs) {
            throw new InvalidTimestampException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timestamp ", " of message is out of range. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)record2.timestamp())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The timestamp should be within [", ", ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(now - timestampDiffMaxMs)), BoxesRunTime.boxToLong((long)(now + timestampDiffMaxMs))}))).toString());
        }
        TimestampType timestampType5 = record2.timestampType();
        TimestampType timestampType6 = TimestampType.LOG_APPEND_TIME;
        if (!(timestampType5 != null ? !timestampType5.equals(timestampType6) : timestampType6 != null)) {
            throw new InvalidTimestampException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid timestamp type in message ", ". Producer should not set "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{record2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp type to LogAppendTime."})).s((Seq)Nil$.MODULE$)).toString());
        }
    }

    private LogValidator$() {
        MODULE$ = this;
    }
}

