/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Properties;
import junit.framework.Assert;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.api.PartitionMetadata;
import kafka.api.TopicMetadata;
import kafka.client.ClientUtils$;
import kafka.cluster.Broker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.utils.Utils$;
import kafka.utils.ZkUtils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.I0Itec.zkclient.ZkClient;
import org.scalatest.junit.JUnit3Suite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001B\u0001\u0003\u0001\u001d\u0011\u0011#\u00113e!\u0006\u0014H/\u001b;j_:\u001cH+Z:u\u0015\t\u0019A!A\u0003bI6LgNC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u0013!\tI\u0001#D\u0001\u000b\u0015\tYA\"A\u0003kk:LGO\u0003\u0002\u000e\u001d\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002\u001f\u0005\u0019qN]4\n\u0005EQ!a\u0003&V]&$8gU;ji\u0016\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\u0005i\\\u0017BA\f\u0015\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tg\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011A\u0001\u0005\b=\u0001\u0011\r\u0011\"\u0001 \u0003%\u0011'o\\6fe&#\u0017'F\u0001!!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\rIe\u000e\u001e\u0005\u0007O\u0001\u0001\u000b\u0011\u0002\u0011\u0002\u0015\t\u0014xn[3s\u0013\u0012\f\u0004\u0005C\u0004*\u0001\t\u0007I\u0011A\u0010\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0014\u0004BB\u0016\u0001A\u0003%\u0001%\u0001\u0006ce>\\WM]%ee\u0001Bq!\f\u0001C\u0002\u0013\u0005q$A\u0005ce>\\WM]%eg!1q\u0006\u0001Q\u0001\n\u0001\n!B\u0019:pW\u0016\u0014\u0018\nZ\u001a!\u0011\u001d\t\u0004A1A\u0005\u0002}\t\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u001b\t\rM\u0002\u0001\u0015!\u0003!\u0003)\u0011'o\\6fe&#G\u0007\t\u0005\bk\u0001\u0011\r\u0011\"\u0001 \u0003\u0015\u0001xN\u001d;2\u0011\u00199\u0004\u0001)A\u0005A\u00051\u0001o\u001c:uc\u0001Bq!\u000f\u0001C\u0002\u0013\u0005q$A\u0003q_J$(\u0007\u0003\u0004<\u0001\u0001\u0006I\u0001I\u0001\u0007a>\u0014HO\r\u0011\t\u000fu\u0002!\u0019!C\u0001?\u0005)\u0001o\u001c:ug!1q\b\u0001Q\u0001\n\u0001\na\u0001]8siN\u0002\u0003bB!\u0001\u0005\u0004%\taH\u0001\u0006a>\u0014H\u000f\u000e\u0005\u0007\u0007\u0002\u0001\u000b\u0011\u0002\u0011\u0002\rA|'\u000f\u001e\u001b!\u0011\u001d)\u0005A1A\u0005\u0002\u0019\u000bAbY8oM&<\u0007K]8qgF*\u0012a\u0012\t\u0003\u00116k\u0011!\u0013\u0006\u0003\u0015.\u000bA!\u001e;jY*\tA*\u0001\u0003kCZ\f\u0017B\u0001(J\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\u0007!\u0002\u0001\u000b\u0011B$\u0002\u001b\r|gNZ5h!J|\u0007o]\u0019!\u0011\u001d\u0011\u0006A1A\u0005\u0002\u0019\u000bAbY8oM&<\u0007K]8qgJBa\u0001\u0016\u0001!\u0002\u00139\u0015!D2p]\u001aLw\r\u0015:paN\u0014\u0004\u0005C\u0004W\u0001\t\u0007I\u0011\u0001$\u0002\u0019\r|gNZ5h!J|\u0007o]\u001a\t\ra\u0003\u0001\u0015!\u0003H\u00035\u0019wN\u001c4jOB\u0013x\u000e]:4A!9!\f\u0001b\u0001\n\u00031\u0015\u0001D2p]\u001aLw\r\u0015:paN$\u0004B\u0002/\u0001A\u0003%q)A\u0007d_:4\u0017n\u001a)s_B\u001cH\u0007\t\u0005\b=\u0002\u0001\r\u0011\"\u0001`\u0003\u001d\u0019XM\u001d<feN,\u0012\u0001\u0019\t\u0004C&dgB\u00012h\u001d\t\u0019g-D\u0001e\u0015\t)g!\u0001\u0004=e>|GOP\u0005\u0002G%\u0011\u0001NI\u0001\ba\u0006\u001c7.Y4f\u0013\tQ7NA\u0002TKFT!\u0001\u001b\u0012\u0011\u00055\u0004X\"\u00018\u000b\u0005=$\u0011AB:feZ,'/\u0003\u0002r]\nY1*\u00194lCN+'O^3s\u0011\u001d\u0019\b\u00011A\u0005\u0002Q\f1b]3sm\u0016\u00148o\u0018\u0013fcR\u0011Q\u000f\u001f\t\u0003CYL!a\u001e\u0012\u0003\tUs\u0017\u000e\u001e\u0005\bsJ\f\t\u00111\u0001a\u0003\rAH%\r\u0005\u0007w\u0002\u0001\u000b\u0015\u00021\u0002\u0011M,'O^3sg\u0002Bq! \u0001A\u0002\u0013\u0005a0A\u0004ce>\\WM]:\u0016\u0003}\u0004B!Y5\u0002\u0002A!\u00111AA\u0005\u001b\t\t)AC\u0002\u0002\b\u0011\tqa\u00197vgR,'/\u0003\u0003\u0002\f\u0005\u0015!A\u0002\"s_.,'\u000fC\u0005\u0002\u0010\u0001\u0001\r\u0011\"\u0001\u0002\u0012\u0005Y!M]8lKJ\u001cx\fJ3r)\r)\u00181\u0003\u0005\ts\u00065\u0011\u0011!a\u0001\u007f\"9\u0011q\u0003\u0001!B\u0013y\u0018\u0001\u00032s_.,'o\u001d\u0011\t\u0011\u0005m\u0001A1A\u0005\u0002}\t1\u0002]1si&$\u0018n\u001c8JI\"9\u0011q\u0004\u0001!\u0002\u0013\u0001\u0013\u0001\u00049beRLG/[8o\u0013\u0012\u0004\u0003\"CA\u0012\u0001\t\u0007I\u0011AA\u0013\u0003\u0019!x\u000e]5dcU\u0011\u0011q\u0005\t\u0005\u0003S\ty#\u0004\u0002\u0002,)\u0019\u0011QF&\u0002\t1\fgnZ\u0005\u0005\u0003c\tYC\u0001\u0004TiJLgn\u001a\u0005\t\u0003k\u0001\u0001\u0015!\u0003\u0002(\u00059Ao\u001c9jGF\u0002\u0003\"CA\u001d\u0001\t\u0007I\u0011AA\u0013\u0003\u0019!x\u000e]5de!A\u0011Q\b\u0001!\u0002\u0013\t9#A\u0004u_BL7M\r\u0011\t\u0013\u0005\u0005\u0003A1A\u0005\u0002\u0005\u0015\u0012A\u0002;pa&\u001c7\u0007\u0003\u0005\u0002F\u0001\u0001\u000b\u0011BA\u0014\u0003\u001d!x\u000e]5dg\u0001B\u0011\"!\u0013\u0001\u0005\u0004%\t!!\n\u0002\rQ|\u0007/[25\u0011!\ti\u0005\u0001Q\u0001\n\u0005\u001d\u0012a\u0002;pa&\u001cG\u0007\t\u0005\b\u0003#\u0002A\u0011IA*\u0003\u0015\u0019X\r^+q)\u0005)\bbBA,\u0001\u0011\u0005\u00131K\u0001\ti\u0016\f'\u000fR8x]\"9\u00111\f\u0001\u0005\u0002\u0005u\u0013!\u0006;fgR$v\u000e]5d\t>,7OT8u\u000bbL7\u000f^\u000b\u0002k\"9\u0011\u0011\r\u0001\u0005\u0002\u0005u\u0013!\u0006;fgR<&o\u001c8h%\u0016\u0004H.[2b\u0007>,h\u000e\u001e\u0005\b\u0003K\u0002A\u0011AA/\u0003]!Xm\u001d;J]\u000e\u0014X-\\3oiB\u000b'\u000f^5uS>t7\u000fC\u0004\u0002j\u0001!\t!!\u0018\u0002=Q,7\u000f^'b]V\fG.Q:tS\u001etW.\u001a8u\u001f\u001a\u0014V\r\u001d7jG\u0006\u001c\bbBA7\u0001\u0011\u0005\u0011QL\u0001\u0015i\u0016\u001cHOU3qY&\u001c\u0017\r\u00157bG\u0016lWM\u001c;")
public class AddPartitionsTest
extends JUnit3Suite
implements ZooKeeperTestHarness {
    private final int brokerId1;
    private final int brokerId2;
    private final int brokerId3;
    private final int brokerId4;
    private final int port1;
    private final int port2;
    private final int port3;
    private final int port4;
    private final Properties configProps1;
    private final Properties configProps2;
    private final Properties configProps3;
    private final Properties configProps4;
    private Seq<KafkaServer> servers;
    private Seq<Broker> brokers;
    private final int partitionId;
    private final String topic1;
    private final String topic2;
    private final String topic3;
    private final String topic4;
    private final String zkConnect;
    private EmbeddedZookeeper zookeeper;
    private ZkClient zkClient;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;

    @Override
    public String zkConnect() {
        return this.zkConnect;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public ZkClient zkClient() {
        return this.zkClient;
    }

    @Override
    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$setUp() {
        super.setUp();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$tearDown() {
        super.tearDown();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnect_$eq(String x$1) {
        this.zkConnect = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    public int brokerId1() {
        return this.brokerId1;
    }

    public int brokerId2() {
        return this.brokerId2;
    }

    public int brokerId3() {
        return this.brokerId3;
    }

    public int brokerId4() {
        return this.brokerId4;
    }

    public int port1() {
        return this.port1;
    }

    public int port2() {
        return this.port2;
    }

    public int port3() {
        return this.port3;
    }

    public int port4() {
        return this.port4;
    }

    public Properties configProps1() {
        return this.configProps1;
    }

    public Properties configProps2() {
        return this.configProps2;
    }

    public Properties configProps3() {
        return this.configProps3;
    }

    public Properties configProps4() {
        return this.configProps4;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public Seq<Broker> brokers() {
        return this.brokers;
    }

    public void brokers_$eq(Seq<Broker> x$1) {
        this.brokers = x$1;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    public String topic3() {
        return this.topic3;
    }

    public String topic4() {
        return this.topic4;
    }

    @Override
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
        KafkaServer server1 = TestUtils$.MODULE$.createServer(new KafkaConfig(this.configProps1()), TestUtils$.MODULE$.createServer$default$2());
        KafkaServer server2 = TestUtils$.MODULE$.createServer(new KafkaConfig(this.configProps2()), TestUtils$.MODULE$.createServer$default$2());
        KafkaServer server3 = TestUtils$.MODULE$.createServer(new KafkaConfig(this.configProps3()), TestUtils$.MODULE$.createServer$default$2());
        KafkaServer server4 = TestUtils$.MODULE$.createServer(new KafkaConfig(this.configProps4()), TestUtils$.MODULE$.createServer$default$2());
        this.servers_$eq((Seq<KafkaServer>)((Seq)this.servers().$plus$plus((GenTraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server1, server2, server3, server4})), Seq$.MODULE$.canBuildFrom())));
        this.brokers_$eq((Seq<Broker>)((Seq)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Broker apply(KafkaServer s) {
                return new Broker(s.config().brokerId(), s.config().hostName(), s.config().port());
            }
        }, Seq$.MODULE$.canBuildFrom())));
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkClient(), this.topic1(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))})), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkClient(), this.topic2(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))})), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkClient(), this.topic3(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1})))})), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkClient(), this.topic4(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3})))})), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        ObjectRef leader1 = new ObjectRef(TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic1(), this.partitionId(), 500L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5()));
        Option<Object> leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic2(), this.partitionId(), 500L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5());
        Option<Object> leader3 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic3(), this.partitionId(), 500L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5());
        Option<Object> leader4 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic4(), this.partitionId(), 500L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5());
        TestUtils$.MODULE$.debug((Function0)new Serializable(this, leader1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AddPartitionsTest $outer;
            private final ObjectRef leader1$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Leader for ").append((Object)this.$outer.topic1()).append((Object)new StringOps(Predef$.MODULE$.augmentString(" is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Option)this.leader1$1.elem).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return -1;
                    }
                })}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.leader1$1 = leader1$1;
            }
        });
        TestUtils$.MODULE$.debug((Function0)new Serializable(this, leader1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AddPartitionsTest $outer;
            private final ObjectRef leader1$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Leader for ").append((Object)this.$outer.topic2()).append((Object)new StringOps(Predef$.MODULE$.augmentString(" is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Option)this.leader1$1.elem).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return -1;
                    }
                })}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.leader1$1 = leader1$1;
            }
        });
        TestUtils$.MODULE$.debug((Function0)new Serializable(this, leader1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AddPartitionsTest $outer;
            private final ObjectRef leader1$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Leader for ").append((Object)this.$outer.topic3()).append((Object)new StringOps(Predef$.MODULE$.augmentString("is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Option)this.leader1$1.elem).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return -1;
                    }
                })}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.leader1$1 = leader1$1;
            }
        });
        TestUtils$.MODULE$.debug((Function0)new Serializable(this, leader1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AddPartitionsTest $outer;
            private final ObjectRef leader1$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Leader for ").append((Object)this.$outer.topic4()).append((Object)new StringOps(Predef$.MODULE$.augmentString("is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Option)this.leader1$1.elem).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return -1;
                    }
                })}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.leader1$1 = leader1$1;
            }
        });
        Assert.assertTrue((String)"Leader should get elected", (boolean)((Option)leader1.elem).isDefined());
        Assert.assertTrue((String)"Leader should get elected", (boolean)leader2.isDefined());
        Assert.assertTrue((String)"Leader should get elected", (boolean)leader3.isDefined());
        Assert.assertTrue((String)"Leader should get elected", (boolean)leader4.isDefined());
        Assert.assertTrue((String)new StringBuilder().append((Object)"Leader could be broker 0 or broker 1 for ").append((Object)this.topic1()).toString(), (BoxesRunTime.unboxToInt((Object)((Option)leader1.elem).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })) == 0 || BoxesRunTime.unboxToInt((Object)((Option)leader1.elem).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringBuilder().append((Object)"Leader could be broker 1 or broker 2 for ").append((Object)this.topic2()).toString(), (BoxesRunTime.unboxToInt((Object)leader2.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })) == 1 || BoxesRunTime.unboxToInt((Object)((Option)leader1.elem).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })) == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringBuilder().append((Object)"Leader could be broker 2 or broker 3 for ").append((Object)this.topic3()).toString(), (BoxesRunTime.unboxToInt((Object)leader3.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })) == 2 || BoxesRunTime.unboxToInt((Object)((Option)leader1.elem).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })) == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringBuilder().append((Object)"Leader could be broker 3 or broker 4 for ").append((Object)this.topic4()).toString(), (BoxesRunTime.unboxToInt((Object)leader4.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })) == 0 || BoxesRunTime.unboxToInt((Object)((Option)leader1.elem).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })) == 3 ? 1 : 0) != 0);
    }

    @Override
    public void tearDown() {
        this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                server.shutdown();
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                Utils$.MODULE$.rm(server.config().logDirs());
            }
        }, Seq$.MODULE$.canBuildFrom());
        ZooKeeperTestHarness$class.tearDown(this);
    }

    public void testTopicDoesNotExist() {
        try {
            AdminUtils$.MODULE$.addPartitions(this.zkClient(), "Blah", 1, AdminUtils$.MODULE$.addPartitions$default$4());
            throw this.fail("Topic should not exist");
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (AdminOperationException adminOperationException) {
            return;
        }
    }

    public void testWrongReplicaCount() {
        try {
            AdminUtils$.MODULE$.addPartitions(this.zkClient(), this.topic1(), 2, "0:1,0:1:2");
            throw this.fail("Add partitions should fail");
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (AdminOperationException adminOperationException) {
            return;
        }
    }

    public void testIncrementPartitions() {
        AdminUtils$.MODULE$.addPartitions(this.zkClient(), this.topic1(), 3, AdminUtils$.MODULE$.addPartitions$default$4());
        Option<Object> leader1 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic1(), 1, 500L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5());
        Option<Object> leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic1(), 2, 500L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5());
        int leader1FromZk = BoxesRunTime.unboxToInt((Object)ZkUtils$.MODULE$.getLeaderForPartition(this.zkClient(), this.topic1(), 1).get());
        int leader2FromZk = BoxesRunTime.unboxToInt((Object)ZkUtils$.MODULE$.getLeaderForPartition(this.zkClient(), this.topic1(), 2).get());
        Assert.assertEquals((int)BoxesRunTime.unboxToInt((Object)leader1.get()), (int)leader1FromZk);
        Assert.assertEquals((int)BoxesRunTime.unboxToInt((Object)leader2.get()), (int)leader2FromZk);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic1(), 1, 1000L);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic1(), 2, 1000L);
        Seq metadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()})), this.brokers(), "AddPartitionsTest-testIncrementPartitions", 2000, 0).topicsMetadata();
        Seq metaDataForTopic1 = (Seq)metadata.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AddPartitionsTest $outer;

            public final boolean apply(TopicMetadata p) {
                return p.topic().equals(this.$outer.topic1());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Seq partitionDataForTopic1 = ((TopicMetadata)metaDataForTopic1.head()).partitionsMetadata();
        Assert.assertEquals((int)partitionDataForTopic1.size(), (int)3);
        Assert.assertEquals((int)((PartitionMetadata)partitionDataForTopic1.apply(1)).partitionId(), (int)1);
        Assert.assertEquals((int)((PartitionMetadata)partitionDataForTopic1.apply(2)).partitionId(), (int)2);
        Seq replicas = ((PartitionMetadata)partitionDataForTopic1.apply(1)).replicas();
        Assert.assertEquals((int)replicas.size(), (int)2);
        this.assert(replicas.contains(((PartitionMetadata)partitionDataForTopic1.apply(1)).leader().get()));
    }

    public void testManualAssignmentOfReplicas() {
        AdminUtils$.MODULE$.addPartitions(this.zkClient(), this.topic2(), 3, "1:2,0:1,2:3");
        Option<Object> leader1 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic2(), 1, 500L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5());
        Option<Object> leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic2(), 2, 500L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5());
        int leader1FromZk = BoxesRunTime.unboxToInt((Object)ZkUtils$.MODULE$.getLeaderForPartition(this.zkClient(), this.topic2(), 1).get());
        int leader2FromZk = BoxesRunTime.unboxToInt((Object)ZkUtils$.MODULE$.getLeaderForPartition(this.zkClient(), this.topic2(), 2).get());
        Assert.assertEquals((int)BoxesRunTime.unboxToInt((Object)leader1.get()), (int)leader1FromZk);
        Assert.assertEquals((int)BoxesRunTime.unboxToInt((Object)leader2.get()), (int)leader2FromZk);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic2(), 1, 1000L);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic2(), 2, 1000L);
        Seq metadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic2()})), this.brokers(), "AddPartitionsTest-testManualAssignmentOfReplicas", 2000, 0).topicsMetadata();
        Seq metaDataForTopic2 = (Seq)metadata.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AddPartitionsTest $outer;

            public final boolean apply(TopicMetadata p) {
                return p.topic().equals(this.$outer.topic2());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Seq partitionDataForTopic2 = ((TopicMetadata)metaDataForTopic2.head()).partitionsMetadata();
        Assert.assertEquals((int)partitionDataForTopic2.size(), (int)3);
        Assert.assertEquals((int)((PartitionMetadata)partitionDataForTopic2.apply(1)).partitionId(), (int)1);
        Assert.assertEquals((int)((PartitionMetadata)partitionDataForTopic2.apply(2)).partitionId(), (int)2);
        Seq replicas = ((PartitionMetadata)partitionDataForTopic2.apply(1)).replicas();
        Assert.assertEquals((int)replicas.size(), (int)2);
        this.assert(((Broker)replicas.apply(0)).id() == 0 || ((Broker)replicas.apply(0)).id() == 1);
        this.assert(((Broker)replicas.apply(1)).id() == 0 || ((Broker)replicas.apply(1)).id() == 1);
    }

    public void testReplicaPlacement() {
        AdminUtils$.MODULE$.addPartitions(this.zkClient(), this.topic3(), 7, AdminUtils$.MODULE$.addPartitions$default$4());
        Option<Object> leader1 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic3(), 1, 500L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5());
        Option<Object> leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic3(), 2, 500L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5());
        Option<Object> leader3 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic3(), 3, 500L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5());
        Option<Object> leader4 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic3(), 4, 500L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5());
        Option<Object> leader5 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic3(), 5, 500L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5());
        Option<Object> leader6 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic3(), 6, 500L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5());
        int leader1FromZk = BoxesRunTime.unboxToInt((Object)ZkUtils$.MODULE$.getLeaderForPartition(this.zkClient(), this.topic3(), 1).get());
        int leader2FromZk = BoxesRunTime.unboxToInt((Object)ZkUtils$.MODULE$.getLeaderForPartition(this.zkClient(), this.topic3(), 2).get());
        int leader3FromZk = BoxesRunTime.unboxToInt((Object)ZkUtils$.MODULE$.getLeaderForPartition(this.zkClient(), this.topic3(), 3).get());
        int leader4FromZk = BoxesRunTime.unboxToInt((Object)ZkUtils$.MODULE$.getLeaderForPartition(this.zkClient(), this.topic3(), 4).get());
        int leader5FromZk = BoxesRunTime.unboxToInt((Object)ZkUtils$.MODULE$.getLeaderForPartition(this.zkClient(), this.topic3(), 5).get());
        int leader6FromZk = BoxesRunTime.unboxToInt((Object)ZkUtils$.MODULE$.getLeaderForPartition(this.zkClient(), this.topic3(), 6).get());
        Assert.assertEquals((int)BoxesRunTime.unboxToInt((Object)leader1.get()), (int)leader1FromZk);
        Assert.assertEquals((int)BoxesRunTime.unboxToInt((Object)leader2.get()), (int)leader2FromZk);
        Assert.assertEquals((int)BoxesRunTime.unboxToInt((Object)leader3.get()), (int)leader3FromZk);
        Assert.assertEquals((int)BoxesRunTime.unboxToInt((Object)leader4.get()), (int)leader4FromZk);
        Assert.assertEquals((int)BoxesRunTime.unboxToInt((Object)leader5.get()), (int)leader5FromZk);
        Assert.assertEquals((int)BoxesRunTime.unboxToInt((Object)leader6.get()), (int)leader6FromZk);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic3(), 1, 1000L);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic3(), 2, 1000L);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic3(), 3, 1000L);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic3(), 4, 1000L);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic3(), 5, 1000L);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic3(), 6, 1000L);
        Seq metadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic3()})), this.brokers(), "AddPartitionsTest-testReplicaPlacement", 2000, 0).topicsMetadata();
        TopicMetadata metaDataForTopic3 = (TopicMetadata)((IterableLike)metadata.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AddPartitionsTest $outer;

            public final boolean apply(TopicMetadata p) {
                return p.topic().equals(this.$outer.topic3());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        })).head();
        PartitionMetadata partition1DataForTopic3 = (PartitionMetadata)metaDataForTopic3.partitionsMetadata().apply(1);
        PartitionMetadata partition2DataForTopic3 = (PartitionMetadata)metaDataForTopic3.partitionsMetadata().apply(2);
        PartitionMetadata partition3DataForTopic3 = (PartitionMetadata)metaDataForTopic3.partitionsMetadata().apply(3);
        PartitionMetadata partition4DataForTopic3 = (PartitionMetadata)metaDataForTopic3.partitionsMetadata().apply(4);
        PartitionMetadata partition5DataForTopic3 = (PartitionMetadata)metaDataForTopic3.partitionsMetadata().apply(5);
        PartitionMetadata partition6DataForTopic3 = (PartitionMetadata)metaDataForTopic3.partitionsMetadata().apply(6);
        Assert.assertEquals((int)partition1DataForTopic3.replicas().size(), (int)4);
        Assert.assertEquals((int)((Broker)partition1DataForTopic3.replicas().apply(0)).id(), (int)3);
        Assert.assertEquals((int)((Broker)partition1DataForTopic3.replicas().apply(1)).id(), (int)2);
        Assert.assertEquals((int)((Broker)partition1DataForTopic3.replicas().apply(2)).id(), (int)0);
        Assert.assertEquals((int)((Broker)partition1DataForTopic3.replicas().apply(3)).id(), (int)1);
        Assert.assertEquals((int)partition2DataForTopic3.replicas().size(), (int)4);
        Assert.assertEquals((int)((Broker)partition2DataForTopic3.replicas().apply(0)).id(), (int)0);
        Assert.assertEquals((int)((Broker)partition2DataForTopic3.replicas().apply(1)).id(), (int)3);
        Assert.assertEquals((int)((Broker)partition2DataForTopic3.replicas().apply(2)).id(), (int)1);
        Assert.assertEquals((int)((Broker)partition2DataForTopic3.replicas().apply(3)).id(), (int)2);
        Assert.assertEquals((int)partition3DataForTopic3.replicas().size(), (int)4);
        Assert.assertEquals((int)((Broker)partition3DataForTopic3.replicas().apply(0)).id(), (int)1);
        Assert.assertEquals((int)((Broker)partition3DataForTopic3.replicas().apply(1)).id(), (int)0);
        Assert.assertEquals((int)((Broker)partition3DataForTopic3.replicas().apply(2)).id(), (int)2);
        Assert.assertEquals((int)((Broker)partition3DataForTopic3.replicas().apply(3)).id(), (int)3);
        Assert.assertEquals((int)partition4DataForTopic3.replicas().size(), (int)4);
        Assert.assertEquals((int)((Broker)partition4DataForTopic3.replicas().apply(0)).id(), (int)2);
        Assert.assertEquals((int)((Broker)partition4DataForTopic3.replicas().apply(1)).id(), (int)3);
        Assert.assertEquals((int)((Broker)partition4DataForTopic3.replicas().apply(2)).id(), (int)0);
        Assert.assertEquals((int)((Broker)partition4DataForTopic3.replicas().apply(3)).id(), (int)1);
        Assert.assertEquals((int)partition5DataForTopic3.replicas().size(), (int)4);
        Assert.assertEquals((int)((Broker)partition5DataForTopic3.replicas().apply(0)).id(), (int)3);
        Assert.assertEquals((int)((Broker)partition5DataForTopic3.replicas().apply(1)).id(), (int)0);
        Assert.assertEquals((int)((Broker)partition5DataForTopic3.replicas().apply(2)).id(), (int)1);
        Assert.assertEquals((int)((Broker)partition5DataForTopic3.replicas().apply(3)).id(), (int)2);
        Assert.assertEquals((int)partition6DataForTopic3.replicas().size(), (int)4);
        Assert.assertEquals((int)((Broker)partition6DataForTopic3.replicas().apply(0)).id(), (int)0);
        Assert.assertEquals((int)((Broker)partition6DataForTopic3.replicas().apply(1)).id(), (int)1);
        Assert.assertEquals((int)((Broker)partition6DataForTopic3.replicas().apply(2)).id(), (int)2);
        Assert.assertEquals((int)((Broker)partition6DataForTopic3.replicas().apply(3)).id(), (int)3);
    }

    public AddPartitionsTest() {
        ZooKeeperTestHarness$class.$init$(this);
        this.brokerId1 = 0;
        this.brokerId2 = 1;
        this.brokerId3 = 2;
        this.brokerId4 = 3;
        this.port1 = TestUtils$.MODULE$.choosePort();
        this.port2 = TestUtils$.MODULE$.choosePort();
        this.port3 = TestUtils$.MODULE$.choosePort();
        this.port4 = TestUtils$.MODULE$.choosePort();
        this.configProps1 = TestUtils$.MODULE$.createBrokerConfig(this.brokerId1(), this.port1());
        this.configProps2 = TestUtils$.MODULE$.createBrokerConfig(this.brokerId2(), this.port2());
        this.configProps3 = TestUtils$.MODULE$.createBrokerConfig(this.brokerId3(), this.port3());
        this.configProps4 = TestUtils$.MODULE$.createBrokerConfig(this.brokerId4(), this.port4());
        this.servers = (Seq)Seq$.MODULE$.empty();
        this.brokers = (Seq)Seq$.MODULE$.empty();
        this.partitionId = 0;
        this.topic1 = "new-topic1";
        this.topic2 = "new-topic2";
        this.topic3 = "new-topic3";
        this.topic4 = "new-topic4";
    }
}

