/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Hashtable;
import java.util.Properties;
import junit.framework.Assert;
import kafka.admin.AdminUtils$;
import kafka.api.FetchRequest;
import kafka.api.FetchRequest$;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponse;
import kafka.api.FetchResponsePartitionData;
import kafka.cluster.Replica;
import kafka.common.ErrorMapping$;
import kafka.common.OffsetOutOfRangeException;
import kafka.common.TopicAndPartition;
import kafka.common.UnknownTopicOrPartitionException;
import kafka.consumer.SimpleConsumer;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.integration.ProducerConsumerTestHarness;
import kafka.integration.ProducerConsumerTestHarness$class;
import kafka.log.Log;
import kafka.message.ByteBufferMessageSet;
import kafka.message.MessageAndOffset;
import kafka.producer.KeyedMessage;
import kafka.producer.Producer;
import kafka.producer.ProducerConfig;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRequestHandler;
import kafka.server.KafkaServer;
import kafka.server.ReplicaManager;
import kafka.utils.TestUtils$;
import kafka.utils.Utils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness$class;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.scalatest.junit.JUnit3Suite;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005\rb\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0003\u0015:j[&$\u0018N^3Ba&$Vm\u001d;\u000b\u0005\r!\u0011aC5oi\u0016<'/\u0019;j_:T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0001B\u0005\f\u0011\u0005%\u0001R\"\u0001\u0006\u000b\u0005-a\u0011!\u00026v]&$(BA\u0007\u000f\u0003%\u00198-\u00197bi\u0016\u001cHOC\u0001\u0010\u0003\ry'oZ\u0005\u0003#)\u00111BS+oSR\u001c4+^5uKB\u00111\u0003F\u0007\u0002\u0005%\u0011QC\u0001\u0002\u001c!J|G-^2fe\u000e{gn];nKJ$Vm\u001d;ICJtWm]:\u0011\u0005]QR\"\u0001\r\u000b\u0005e!\u0011A\u0001>l\u0013\tY\u0002D\u0001\u000b[_>\\U-\u001a9feR+7\u000f\u001e%be:,7o\u001d\u0005\u0006;\u0001!\tAH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0001\"a\u0005\u0001\t\u000f\u0005\u0002!\u0019!C\u0001E\u0005!\u0001o\u001c:u+\u0005\u0019\u0003C\u0001\u0013(\u001b\u0005)#\"\u0001\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!*#aA%oi\"1!\u0006\u0001Q\u0001\n\r\nQ\u0001]8si\u0002Bq\u0001\f\u0001C\u0002\u0013\u0005Q&A\u0003qe>\u00048/F\u0001/!\tyC'D\u00011\u0015\t\t$'\u0001\u0003vi&d'\"A\u001a\u0002\t)\fg/Y\u0005\u0003kA\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u00199\u0004\u0001)A\u0005]\u00051\u0001O]8qg\u0002Bq!\u000f\u0001C\u0002\u0013\u0005!(\u0001\u0004d_:4\u0017nZ\u000b\u0002wA\u0011AhP\u0007\u0002{)\u0011a\bB\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\u0001k$aC&bM.\f7i\u001c8gS\u001eDaA\u0011\u0001!\u0002\u0013Y\u0014aB2p]\u001aLw\r\t\u0005\b\t\u0002\u0011\r\u0011\"\u0001F\u0003\u001d\u0019wN\u001c4jON,\u0012A\u0012\t\u0004\u000f2[T\"\u0001%\u000b\u0005%S\u0015!C5n[V$\u0018M\u00197f\u0015\tYU%\u0001\u0006d_2dWm\u0019;j_:L!!\u0014%\u0003\t1K7\u000f\u001e\u0005\u0007\u001f\u0002\u0001\u000b\u0011\u0002$\u0002\u0011\r|gNZ5hg\u0002Bq!\u0015\u0001C\u0002\u0013\u0005!+\u0001\u000bsKF,Xm\u001d;IC:$G.\u001a:M_\u001e<WM]\u000b\u0002'B\u0011A+W\u0007\u0002+*\u0011akV\u0001\u0006Y><GG\u001b\u0006\u00031:\ta!\u00199bG\",\u0017B\u0001.V\u0005\u0019aunZ4fe\"1A\f\u0001Q\u0001\nM\u000bQC]3rk\u0016\u001cH\u000fS1oI2,'\u000fT8hO\u0016\u0014\b\u0005C\u0003_\u0001\u0011\u0005q,\u0001\u0013uKN$h)\u001a;dQJ+\u0017/^3ti\u000e\u000bg\u000e\u0015:pa\u0016\u0014H._*fe&\fG.\u001b>f)\u0005\u0001\u0007C\u0001\u0013b\u0013\t\u0011WE\u0001\u0003V]&$\b\"\u00023\u0001\t\u0003y\u0016!\u0006;fgR,U\u000e\u001d;z\r\u0016$8\r\u001b*fcV,7\u000f\u001e\u0005\u0006M\u0002!\taX\u0001#i\u0016\u001cH\u000fR3gCVdG/\u00128d_\u0012,'\u000f\u0015:pIV\u001cWM]!oI\u001a+Go\u00195\t\u000b!\u0004A\u0011A0\u0002cQ,7\u000f\u001e#fM\u0006,H\u000e^#oG>$WM\u001d)s_\u0012,8-\u001a:B]\u00124U\r^2i/&$\bnQ8naJ,7o]5p]\")!\u000e\u0001C\u0001?\u0006AB/Z:u!J|G-^2f\u0003:$W*\u001e7uS\u001a+Go\u00195\t\u000b1\u0004A\u0011A0\u0002OQ,7\u000f\u001e)s_\u0012,8-Z!oI6+H\u000e^5GKR\u001c\u0007nV5uQ\u000e{W\u000e\u001d:fgNLwN\u001c\u0005\u0006]\u0002!\taX\u0001\u0011i\u0016\u001cH/T;mi&\u0004&o\u001c3vG\u0016DQ\u0001\u001d\u0001\u0005\u0002}\u000bq\u0004^3ti6+H\u000e^5Qe>$WoY3XSRD7i\\7qe\u0016\u001c8/[8o\u0011\u0015\u0011\b\u0001\"\u0001`\u0003Y!Xm\u001d;D_:\u001cX/\\3s\u000b6\u0004H/\u001f+pa&\u001c\u0007\"\u0002;\u0001\t\u0003y\u0016\u0001\b;fgR\u0004\u0016\u000e]3mS:,G\r\u0015:pIV\u001cWMU3rk\u0016\u001cHo\u001d\u0005\u0006m\u0002!\ta^\u0001!GJ,\u0017\r^3TS6\u0004H.\u001a+pa&\u001c7/\u00118e\u0003^\f\u0017\u000e\u001e'fC\u0012,'\u000f\u0006\u0004aq\u0006\u0015\u0011q\u0004\u0005\u0006sV\u0004\rA_\u0001\tu.\u001cE.[3oiB\u001910!\u0001\u000e\u0003qT!! @\u0002\u0011i\\7\r\\5f]RT!a \b\u0002\r%\u0003\u0014\n^3d\u0013\r\t\u0019\u0001 \u0002\t5.\u001cE.[3oi\"9\u0011qA;A\u0002\u0005%\u0011A\u0002;pa&\u001c7\u000f\u0005\u0004\u0002\f\u00055\u0011\u0011C\u0007\u0002\u0015&\u0019\u0011q\u0002&\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002\u0014\u0005eab\u0001\u0013\u0002\u0016%\u0019\u0011qC\u0013\u0002\rA\u0013X\rZ3g\u0013\u0011\tY\"!\b\u0003\rM#(/\u001b8h\u0015\r\t9\"\n\u0005\u0007\u0003C)\b\u0019A\u0012\u0002\u0011\t\u0014xn[3s\u0013\u0012\u0004")
public class PrimitiveApiTest
extends JUnit3Suite
implements ProducerConsumerTestHarness {
    private final int port;
    private final Properties props;
    private final KafkaConfig config;
    private final List<KafkaConfig> configs;
    private final Logger requestHandlerLogger;
    private final String host;
    private Producer<String, String> producer;
    private SimpleConsumer consumer;
    private List<KafkaServer> servers;
    private final String zkConnect;
    private EmbeddedZookeeper zookeeper;
    private ZkClient zkClient;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public Producer<String, String> producer() {
        return this.producer;
    }

    @Override
    public void producer_$eq(Producer<String, String> x$1) {
        this.producer = x$1;
    }

    @Override
    public SimpleConsumer consumer() {
        return this.consumer;
    }

    @Override
    public void consumer_$eq(SimpleConsumer x$1) {
        this.consumer = x$1;
    }

    @Override
    public void kafka$integration$ProducerConsumerTestHarness$$super$setUp() {
        KafkaServerTestHarness$class.setUp(this);
    }

    @Override
    public void kafka$integration$ProducerConsumerTestHarness$$super$tearDown() {
        KafkaServerTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$integration$ProducerConsumerTestHarness$_setter_$host_$eq(String x$1) {
        this.host = x$1;
    }

    @Override
    public void setUp() {
        ProducerConsumerTestHarness$class.setUp(this);
    }

    @Override
    public void tearDown() {
        ProducerConsumerTestHarness$class.tearDown(this);
    }

    @Override
    public List<KafkaServer> servers() {
        return this.servers;
    }

    @Override
    @TraitSetter
    public void servers_$eq(List<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Override
    public String zkConnect() {
        return this.zkConnect;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public ZkClient zkClient() {
        return this.zkClient;
    }

    @Override
    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$setUp() {
        super.setUp();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$tearDown() {
        super.tearDown();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnect_$eq(String x$1) {
        this.zkConnect = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int port() {
        return this.port;
    }

    public Properties props() {
        return this.props;
    }

    public KafkaConfig config() {
        return this.config;
    }

    @Override
    public List<KafkaConfig> configs() {
        return this.configs;
    }

    public Logger requestHandlerLogger() {
        return this.requestHandlerLogger;
    }

    public void testFetchRequestCanProperlySerialize() {
        FetchRequest request = new FetchRequestBuilder().clientId("test-client").maxWait(10001).minBytes(4444).addFetch("topic1", 0, 0L, 10000).addFetch("topic2", 1, 1024L, 9999).addFetch("topic1", 1, 256L, 444).build();
        ByteBuffer serializedBuffer = ByteBuffer.allocate(request.sizeInBytes());
        request.writeTo(serializedBuffer);
        ((Buffer)serializedBuffer).rewind();
        FetchRequest deserializedRequest = FetchRequest$.MODULE$.readFrom(serializedBuffer);
        Assert.assertEquals((Object)request, (Object)deserializedRequest);
    }

    public void testEmptyFetchRequest() {
        Map partitionRequests;
        Map x$20 = partitionRequests = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        short x$21 = FetchRequest$.MODULE$.$lessinit$greater$default$1();
        int x$22 = FetchRequest$.MODULE$.$lessinit$greater$default$2();
        String x$23 = FetchRequest$.MODULE$.$lessinit$greater$default$3();
        int x$24 = FetchRequest$.MODULE$.$lessinit$greater$default$4();
        int x$25 = FetchRequest$.MODULE$.$lessinit$greater$default$5();
        int x$26 = FetchRequest$.MODULE$.$lessinit$greater$default$6();
        FetchRequest request = new FetchRequest(x$21, x$22, x$23, x$24, x$25, x$26, x$20);
        FetchResponse fetched = this.consumer().fetch(request);
        Assert.assertTrue((!fetched.hasError() && fetched.data().size() == 0 ? 1 : 0) != 0);
    }

    public void testDefaultEncoderProducerAndFetch() {
        String topic = "test-topic";
        Properties props = this.producer().config().props().props();
        ProducerConfig config = new ProducerConfig(props);
        Producer stringProducer1 = new Producer(config);
        stringProducer1.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(topic, (Object)"test-message")}));
        ReplicaManager qual$1 = ((KafkaServer)this.servers().head()).replicaManager();
        String x$27 = topic;
        int x$28 = 0;
        int x$29 = qual$1.getReplica$default$3();
        Replica replica = (Replica)qual$1.getReplica(x$27, x$28, x$29).get();
        Assert.assertTrue((String)"HighWatermark should equal logEndOffset with just 1 replica", (replica.logEndOffset() > 0L && replica.logEndOffset() == replica.highWatermark() ? 1 : 0) != 0);
        FetchRequest request = new FetchRequestBuilder().clientId("test-client").addFetch(topic, 0, 0L, 10000).build();
        FetchResponse fetched = this.consumer().fetch(request);
        Assert.assertEquals((String)"Returned correlationId doesn't match that in request.", (int)0, (int)fetched.correlationId());
        ByteBufferMessageSet messageSet = fetched.messageSet(topic, 0);
        Assert.assertTrue((boolean)messageSet.iterator().hasNext());
        MessageAndOffset fetchedMessageAndOffset = (MessageAndOffset)messageSet.head();
        Assert.assertEquals((String)"test-message", (String)Utils$.MODULE$.readString(fetchedMessageAndOffset.message().payload(), "UTF-8"));
    }

    public void testDefaultEncoderProducerAndFetchWithCompression() {
        String topic = "test-topic";
        Properties props = this.producer().config().props().props();
        ((Hashtable)props).put("compression", "true");
        ProducerConfig config = new ProducerConfig(props);
        Producer stringProducer1 = new Producer(config);
        stringProducer1.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(topic, (Object)"test-message")}));
        FetchResponse fetched = this.consumer().fetch(new FetchRequestBuilder().addFetch(topic, 0, 0L, 10000).build());
        ByteBufferMessageSet messageSet = fetched.messageSet(topic, 0);
        Assert.assertTrue((boolean)messageSet.iterator().hasNext());
        MessageAndOffset fetchedMessageAndOffset = (MessageAndOffset)messageSet.head();
        Assert.assertEquals((String)"test-message", (String)Utils$.MODULE$.readString(fetchedMessageAndOffset.message().payload(), "UTF-8"));
    }

    public void testProduceAndMultiFetch() {
        this.createSimpleTopicsAndAwaitLeader(this.zkClient(), (Seq<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2", "test3", "test4"})), this.config().brokerId());
        List topics = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"test4", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"test1", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"test2", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"test3", (Object)BoxesRunTime.boxToInteger((int)0))}));
        HashMap messages2 = new HashMap();
        FetchRequestBuilder builder = new FetchRequestBuilder();
        topics.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$1) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, messages2, builder){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;
            private final HashMap messages$1;
            private final FetchRequestBuilder builder$1;

            public final FetchRequestBuilder apply(Tuple2<String, Object> x$2) {
                Tuple2<String, Object> tuple2 = x$2;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    int partition = tuple2._2$mcI$sp();
                    List messageList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)"a_").append((Object)topic).toString(), new StringBuilder().append((Object)"b_").append((Object)topic).toString()}));
                    List producerData = (List)messageList.map((Function1)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$1;

                        public final KeyedMessage<String, String> apply(String x$1) {
                            return new KeyedMessage(this.topic$1, (Object)this.topic$1, (Object)x$1);
                        }
                        {
                            this.topic$1 = topic$1;
                        }
                    }, List$.MODULE$.canBuildFrom());
                    this.messages$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topic), (Object)messageList));
                    this.$outer.producer().send((Seq)producerData);
                    FetchRequestBuilder fetchRequestBuilder = this.builder$1.addFetch(topic, partition, 0L, 10000);
                    return fetchRequestBuilder;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.messages$1 = messages$1;
                this.builder$1 = builder$1;
            }
        });
        FetchRequest request = builder.build();
        FetchResponse response = this.consumer().fetch(request);
        topics.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$2) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, messages2, response){
            public static final long serialVersionUID = 0L;
            private final HashMap messages$1;
            private final FetchResponse response$1;

            public final void apply(Tuple2<String, Object> x$3) {
                Tuple2<String, Object> tuple2 = x$3;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    int partition = tuple2._2$mcI$sp();
                    ByteBufferMessageSet fetched = this.response$1.messageSet(topic, partition);
                    Assert.assertEquals((Object)this.messages$1.apply((Object)topic), (Object)fetched.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(MessageAndOffset messageAndOffset) {
                            return Utils$.MODULE$.readString(messageAndOffset.message().payload(), Utils$.MODULE$.readString$default$2());
                        }
                    }, Iterable$.MODULE$.canBuildFrom()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.messages$1 = messages$1;
                this.response$1 = response$1;
            }
        });
        this.requestHandlerLogger().setLevel(Level.FATAL);
        FetchRequestBuilder builder2 = new FetchRequestBuilder();
        topics.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$3) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$3;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, builder2){
            public static final long serialVersionUID = 0L;
            private final FetchRequestBuilder builder$2;

            public final FetchRequestBuilder apply(Tuple2<String, Object> x$4) {
                Tuple2<String, Object> tuple2 = x$4;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    int partition = tuple2._2$mcI$sp();
                    FetchRequestBuilder fetchRequestBuilder = this.builder$2.addFetch(topic, partition, -1L, 10000);
                    return fetchRequestBuilder;
                }
                throw new MatchError(tuple2);
            }
            {
                this.builder$2 = builder$2;
            }
        });
        try {
            FetchRequest request2 = builder2.build();
            FetchResponse response2 = this.consumer().fetch(request2);
            response2.data().values().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(FetchResponsePartitionData pdata) {
                    ErrorMapping$.MODULE$.maybeThrowException(pdata.error());
                }
            });
            throw this.fail("Expected exception when fetching message with invalid offset");
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {
            FetchRequestBuilder builder3 = new FetchRequestBuilder();
            topics.withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, Object> check$ifrefutable$4) {
                    Tuple2<String, Object> tuple2 = check$ifrefutable$4;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this, builder3){
                public static final long serialVersionUID = 0L;
                private final FetchRequestBuilder builder$3;

                public final FetchRequestBuilder apply(Tuple2<String, Object> x$5) {
                    Tuple2<String, Object> tuple2 = x$5;
                    if (tuple2 != null) {
                        String topic = (String)tuple2._1();
                        FetchRequestBuilder fetchRequestBuilder = this.builder$3.addFetch(topic, -1, 0L, 10000);
                        return fetchRequestBuilder;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.builder$3 = builder$3;
                }
            });
            try {
                FetchRequest request3 = builder3.build();
                FetchResponse response3 = this.consumer().fetch(request3);
                response3.data().values().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(FetchResponsePartitionData pdata) {
                        ErrorMapping$.MODULE$.maybeThrowException(pdata.error());
                    }
                });
                throw this.fail("Expected exception when fetching message with invalid partition");
            }
            catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
                this.requestHandlerLogger().setLevel(Level.ERROR);
                return;
            }
        }
    }

    public void testProduceAndMultiFetchWithCompression() {
        this.createSimpleTopicsAndAwaitLeader(this.zkClient(), (Seq<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2", "test3", "test4"})), this.config().brokerId());
        List topics = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"test4", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"test1", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"test2", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"test3", (Object)BoxesRunTime.boxToInteger((int)0))}));
        HashMap messages2 = new HashMap();
        FetchRequestBuilder builder = new FetchRequestBuilder();
        topics.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$5) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$5;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, messages2, builder){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;
            private final HashMap messages$2;
            private final FetchRequestBuilder builder$4;

            public final FetchRequestBuilder apply(Tuple2<String, Object> x$7) {
                Tuple2<String, Object> tuple2 = x$7;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    int partition = tuple2._2$mcI$sp();
                    List messageList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)"a_").append((Object)topic).toString(), new StringBuilder().append((Object)"b_").append((Object)topic).toString()}));
                    List producerData = (List)messageList.map((Function1)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$2;

                        public final KeyedMessage<String, String> apply(String x$6) {
                            return new KeyedMessage(this.topic$2, (Object)this.topic$2, (Object)x$6);
                        }
                        {
                            this.topic$2 = topic$2;
                        }
                    }, List$.MODULE$.canBuildFrom());
                    this.messages$2.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topic), (Object)messageList));
                    this.$outer.producer().send((Seq)producerData);
                    FetchRequestBuilder fetchRequestBuilder = this.builder$4.addFetch(topic, partition, 0L, 10000);
                    return fetchRequestBuilder;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.messages$2 = messages$2;
                this.builder$4 = builder$4;
            }
        });
        FetchRequest request = builder.build();
        FetchResponse response = this.consumer().fetch(request);
        topics.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$6) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$6;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, messages2, response){
            public static final long serialVersionUID = 0L;
            private final HashMap messages$2;
            private final FetchResponse response$2;

            public final void apply(Tuple2<String, Object> x$8) {
                Tuple2<String, Object> tuple2 = x$8;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    int partition = tuple2._2$mcI$sp();
                    ByteBufferMessageSet fetched = this.response$2.messageSet(topic, partition);
                    Assert.assertEquals((Object)this.messages$2.apply((Object)topic), (Object)fetched.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(MessageAndOffset messageAndOffset) {
                            return Utils$.MODULE$.readString(messageAndOffset.message().payload(), Utils$.MODULE$.readString$default$2());
                        }
                    }, Iterable$.MODULE$.canBuildFrom()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.messages$2 = messages$2;
                this.response$2 = response$2;
            }
        });
        this.requestHandlerLogger().setLevel(Level.FATAL);
        FetchRequestBuilder builder2 = new FetchRequestBuilder();
        topics.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$7) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$7;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, builder2){
            public static final long serialVersionUID = 0L;
            private final FetchRequestBuilder builder$5;

            public final FetchRequestBuilder apply(Tuple2<String, Object> x$9) {
                Tuple2<String, Object> tuple2 = x$9;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    int partition = tuple2._2$mcI$sp();
                    FetchRequestBuilder fetchRequestBuilder = this.builder$5.addFetch(topic, partition, -1L, 10000);
                    return fetchRequestBuilder;
                }
                throw new MatchError(tuple2);
            }
            {
                this.builder$5 = builder$5;
            }
        });
        try {
            FetchRequest request2 = builder2.build();
            FetchResponse response2 = this.consumer().fetch(request2);
            response2.data().values().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(FetchResponsePartitionData pdata) {
                    ErrorMapping$.MODULE$.maybeThrowException(pdata.error());
                }
            });
            throw this.fail("Expected exception when fetching message with invalid offset");
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {
            FetchRequestBuilder builder3 = new FetchRequestBuilder();
            topics.withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, Object> check$ifrefutable$8) {
                    Tuple2<String, Object> tuple2 = check$ifrefutable$8;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this, builder3){
                public static final long serialVersionUID = 0L;
                private final FetchRequestBuilder builder$6;

                public final FetchRequestBuilder apply(Tuple2<String, Object> x$10) {
                    Tuple2<String, Object> tuple2 = x$10;
                    if (tuple2 != null) {
                        String topic = (String)tuple2._1();
                        FetchRequestBuilder fetchRequestBuilder = this.builder$6.addFetch(topic, -1, 0L, 10000);
                        return fetchRequestBuilder;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.builder$6 = builder$6;
                }
            });
            try {
                FetchRequest request3 = builder3.build();
                FetchResponse response3 = this.consumer().fetch(request3);
                response3.data().values().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(FetchResponsePartitionData pdata) {
                        ErrorMapping$.MODULE$.maybeThrowException(pdata.error());
                    }
                });
                throw this.fail("Expected exception when fetching message with invalid partition");
            }
            catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
                this.requestHandlerLogger().setLevel(Level.ERROR);
                return;
            }
        }
    }

    public void testMultiProduce() {
        this.createSimpleTopicsAndAwaitLeader(this.zkClient(), (Seq<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2", "test3", "test4"})), this.config().brokerId());
        List topics = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"test4", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"test1", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"test2", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"test3", (Object)BoxesRunTime.boxToInteger((int)0))}));
        HashMap messages2 = new HashMap();
        FetchRequestBuilder builder = new FetchRequestBuilder();
        Nil$ produceList = Nil$.MODULE$;
        topics.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$9) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$9;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, messages2, builder){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;
            private final HashMap messages$3;
            private final FetchRequestBuilder builder$7;

            public final FetchRequestBuilder apply(Tuple2<String, Object> x$12) {
                Tuple2<String, Object> tuple2 = x$12;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    int partition = tuple2._2$mcI$sp();
                    List messageList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)"a_").append((Object)topic).toString(), new StringBuilder().append((Object)"b_").append((Object)topic).toString()}));
                    List producerData = (List)messageList.map((Function1)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$3;

                        public final KeyedMessage<String, String> apply(String x$11) {
                            return new KeyedMessage(this.topic$3, (Object)this.topic$3, (Object)x$11);
                        }
                        {
                            this.topic$3 = topic$3;
                        }
                    }, List$.MODULE$.canBuildFrom());
                    this.messages$3.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topic), (Object)messageList));
                    this.$outer.producer().send((Seq)producerData);
                    FetchRequestBuilder fetchRequestBuilder = this.builder$7.addFetch(topic, partition, 0L, 10000);
                    return fetchRequestBuilder;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.messages$3 = messages$3;
                this.builder$7 = builder$7;
            }
        });
        this.producer().send((Seq)produceList);
        FetchRequest request = builder.build();
        FetchResponse response = this.consumer().fetch(request);
        topics.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$10) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$10;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, messages2, response){
            public static final long serialVersionUID = 0L;
            private final HashMap messages$3;
            private final FetchResponse response$3;

            public final void apply(Tuple2<String, Object> x$13) {
                Tuple2<String, Object> tuple2 = x$13;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    int partition = tuple2._2$mcI$sp();
                    ByteBufferMessageSet fetched = this.response$3.messageSet(topic, partition);
                    Assert.assertEquals((Object)this.messages$3.apply((Object)topic), (Object)fetched.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(MessageAndOffset messageAndOffset) {
                            return Utils$.MODULE$.readString(messageAndOffset.message().payload(), Utils$.MODULE$.readString$default$2());
                        }
                    }, Iterable$.MODULE$.canBuildFrom()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.messages$3 = messages$3;
                this.response$3 = response$3;
            }
        });
    }

    public void testMultiProduceWithCompression() {
        List topics = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"test4", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"test1", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"test2", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"test3", (Object)BoxesRunTime.boxToInteger((int)0))}));
        HashMap messages2 = new HashMap();
        FetchRequestBuilder builder = new FetchRequestBuilder();
        Nil$ produceList = Nil$.MODULE$;
        topics.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$11) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$11;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, messages2, builder){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;
            private final HashMap messages$4;
            private final FetchRequestBuilder builder$8;

            public final FetchRequestBuilder apply(Tuple2<String, Object> x$15) {
                Tuple2<String, Object> tuple2 = x$15;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    int partition = tuple2._2$mcI$sp();
                    List messageList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)"a_").append((Object)topic).toString(), new StringBuilder().append((Object)"b_").append((Object)topic).toString()}));
                    List producerData = (List)messageList.map((Function1)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$4;

                        public final KeyedMessage<String, String> apply(String x$14) {
                            return new KeyedMessage(this.topic$4, (Object)this.topic$4, (Object)x$14);
                        }
                        {
                            this.topic$4 = topic$4;
                        }
                    }, List$.MODULE$.canBuildFrom());
                    this.messages$4.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topic), (Object)messageList));
                    this.$outer.producer().send((Seq)producerData);
                    FetchRequestBuilder fetchRequestBuilder = this.builder$8.addFetch(topic, partition, 0L, 10000);
                    return fetchRequestBuilder;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.messages$4 = messages$4;
                this.builder$8 = builder$8;
            }
        });
        this.producer().send((Seq)produceList);
        FetchRequest request = builder.build();
        FetchResponse response = this.consumer().fetch(request);
        topics.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$12) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$12;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, messages2, response){
            public static final long serialVersionUID = 0L;
            private final HashMap messages$4;
            private final FetchResponse response$4;

            public final void apply(Tuple2<String, Object> x$16) {
                Tuple2<String, Object> tuple2 = x$16;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    ByteBufferMessageSet fetched = this.response$4.messageSet(topic, 0);
                    Assert.assertEquals((Object)this.messages$4.apply((Object)topic), (Object)fetched.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(MessageAndOffset messageAndOffset) {
                            return Utils$.MODULE$.readString(messageAndOffset.message().payload(), Utils$.MODULE$.readString$default$2());
                        }
                    }, Iterable$.MODULE$.canBuildFrom()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.messages$4 = messages$4;
                this.response$4 = response$4;
            }
        });
    }

    public void testConsumerEmptyTopic() {
        String newTopic = "new-topic";
        AdminUtils$.MODULE$.createTopic(this.zkClient(), newTopic, 1, 1, AdminUtils$.MODULE$.createTopic$default$5());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), newTopic, 0, 1000L);
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), newTopic, 0, 500L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5());
        FetchResponse fetchResponse = this.consumer().fetch(new FetchRequestBuilder().addFetch(newTopic, 0, 0L, 10000).build());
        Assert.assertFalse((boolean)fetchResponse.messageSet(newTopic, 0).iterator().hasNext());
    }

    public void testPipelinedProduceRequests() {
        this.createSimpleTopicsAndAwaitLeader(this.zkClient(), (Seq<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2", "test3", "test4"})), this.config().brokerId());
        Properties props = this.producer().config().props().props();
        ((Hashtable)props).put("request.required.acks", "0");
        Producer pipelinedProducer = new Producer(new ProducerConfig(props));
        List topics = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"test4", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"test1", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"test2", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"test3", (Object)BoxesRunTime.boxToInteger((int)0))}));
        HashMap messages2 = new HashMap();
        FetchRequestBuilder builder = new FetchRequestBuilder();
        Nil$ produceList = Nil$.MODULE$;
        topics.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$13) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$13;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, pipelinedProducer, messages2, builder){
            public static final long serialVersionUID = 0L;
            private final Producer pipelinedProducer$1;
            private final HashMap messages$5;
            private final FetchRequestBuilder builder$9;

            public final FetchRequestBuilder apply(Tuple2<String, Object> x$18) {
                Tuple2<String, Object> tuple2 = x$18;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    int partition = tuple2._2$mcI$sp();
                    List messageList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)"a_").append((Object)topic).toString(), new StringBuilder().append((Object)"b_").append((Object)topic).toString()}));
                    List producerData = (List)messageList.map((Function1)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$5;

                        public final KeyedMessage<String, String> apply(String x$17) {
                            return new KeyedMessage(this.topic$5, (Object)this.topic$5, (Object)x$17);
                        }
                        {
                            this.topic$5 = topic$5;
                        }
                    }, List$.MODULE$.canBuildFrom());
                    this.messages$5.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topic), (Object)messageList));
                    this.pipelinedProducer$1.send((Seq)producerData);
                    FetchRequestBuilder fetchRequestBuilder = this.builder$9.addFetch(topic, partition, 0L, 10000);
                    return fetchRequestBuilder;
                }
                throw new MatchError(tuple2);
            }
            {
                this.pipelinedProducer$1 = pipelinedProducer$1;
                this.messages$5 = messages$5;
                this.builder$9 = builder$9;
            }
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Log)((KafkaServer)this.$outer.servers().head()).logManager().getLog(new TopicAndPartition("test1", 0)).get()).logEndOffset() == 2L;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, 1000L);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Log)((KafkaServer)this.$outer.servers().head()).logManager().getLog(new TopicAndPartition("test2", 0)).get()).logEndOffset() == 2L;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, 1000L);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Log)((KafkaServer)this.$outer.servers().head()).logManager().getLog(new TopicAndPartition("test3", 0)).get()).logEndOffset() == 2L;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, 1000L);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Log)((KafkaServer)this.$outer.servers().head()).logManager().getLog(new TopicAndPartition("test4", 0)).get()).logEndOffset() == 2L;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, 1000L);
        int replicaId = ((KafkaServer)this.servers().head()).config().brokerId();
        long hwWaitMs = this.config().replicaHighWatermarkCheckpointIntervalMs();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, replicaId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;
            private final int replicaId$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Replica)((KafkaServer)this.$outer.servers().head()).replicaManager().getReplica("test1", 0, this.replicaId$1).get()).highWatermark() == 2L;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.replicaId$1 = replicaId$1;
            }
        }, hwWaitMs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, replicaId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;
            private final int replicaId$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Replica)((KafkaServer)this.$outer.servers().head()).replicaManager().getReplica("test2", 0, this.replicaId$1).get()).highWatermark() == 2L;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.replicaId$1 = replicaId$1;
            }
        }, hwWaitMs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, replicaId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;
            private final int replicaId$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Replica)((KafkaServer)this.$outer.servers().head()).replicaManager().getReplica("test3", 0, this.replicaId$1).get()).highWatermark() == 2L;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.replicaId$1 = replicaId$1;
            }
        }, hwWaitMs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, replicaId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;
            private final int replicaId$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Replica)((KafkaServer)this.$outer.servers().head()).replicaManager().getReplica("test4", 0, this.replicaId$1).get()).highWatermark() == 2L;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.replicaId$1 = replicaId$1;
            }
        }, hwWaitMs);
        FetchRequest request = builder.build();
        FetchResponse response = this.consumer().fetch(request);
        topics.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$14) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$14;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, messages2, response){
            public static final long serialVersionUID = 0L;
            private final HashMap messages$5;
            private final FetchResponse response$5;

            public final void apply(Tuple2<String, Object> x$19) {
                Tuple2<String, Object> tuple2 = x$19;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    int partition = tuple2._2$mcI$sp();
                    ByteBufferMessageSet fetched = this.response$5.messageSet(topic, partition);
                    Assert.assertEquals((Object)this.messages$5.apply((Object)topic), (Object)fetched.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(MessageAndOffset messageAndOffset) {
                            return Utils$.MODULE$.readString(messageAndOffset.message().payload(), Utils$.MODULE$.readString$default$2());
                        }
                    }, Iterable$.MODULE$.canBuildFrom()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.messages$5 = messages$5;
                this.response$5 = response$5;
            }
        });
    }

    public void createSimpleTopicsAndAwaitLeader(ZkClient zkClient, Seq<String> topics, int brokerId) {
        topics.foreach((Function1)new Serializable(this, zkClient){
            public static final long serialVersionUID = 0L;
            private final ZkClient zkClient$1;

            public final Option<Object> apply(String topic) {
                AdminUtils$.MODULE$.createTopic(this.zkClient$1, topic, 1, 1, AdminUtils$.MODULE$.createTopic$default$5());
                return TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient$1, topic, 0, 500L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5());
            }
            {
                this.zkClient$1 = zkClient$1;
            }
        });
    }

    public PrimitiveApiTest() {
        ZooKeeperTestHarness$class.$init$(this);
        KafkaServerTestHarness$class.$init$(this);
        ProducerConsumerTestHarness$class.$init$(this);
        this.port = TestUtils$.MODULE$.choosePort();
        this.props = TestUtils$.MODULE$.createBrokerConfig(0, this.port());
        this.config = new KafkaConfig(this.props());
        this.configs = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{this.config()}));
        this.requestHandlerLogger = Logger.getLogger(KafkaRequestHandler.class);
    }
}

