/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.lang.reflect.Method;
import junit.framework.Assert;
import kafka.common.TopicAndPartition;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerIntegrationTest$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.message.CompressionCodec;
import kafka.message.MessageAndOffset;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.Time;
import kafka.utils.Utils$;
import org.junit.After;
import org.junit.Test;
import org.scalatest.Assertions;
import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.PendingNothing;
import org.scalatest.Reporter;
import org.scalatest.Rerunner;
import org.scalatest.Stopper;
import org.scalatest.Suite;
import org.scalatest.TestRerunner;
import org.scalatest.Tracker;
import org.scalatest.junit.AssertionsForJUnit;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple5;
import scala.Tuple6;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0004T8h\u00072,\u0017M\\3s\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\t\u0011\u0005%qQ\"\u0001\u0006\u000b\u0005-a\u0011\u0001\u00027b]\u001eT\u0011!D\u0001\u0005U\u00064\u0018-\u0003\u0002\u0010\u0015\t1qJ\u00196fGR\u0004\"!\u0005\r\u000e\u0003IQ!a\u0005\u000b\u0002\u000b),h.\u001b;\u000b\u0005U1\u0012!C:dC2\fG/Z:u\u0015\u00059\u0012aA8sO&\u0011\u0011D\u0005\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u0003\u0011\u001d\u0001\u0003A1A\u0005\u0002\u0005\nA\u0001^5nKV\t!\u0005\u0005\u0002$M5\tAE\u0003\u0002&\t\u0005)Q\u000f^5mg&\u0011q\u0005\n\u0002\t\u001b>\u001c7\u000eV5nK\"1\u0011\u0006\u0001Q\u0001\n\t\nQ\u0001^5nK\u0002Bqa\u000b\u0001C\u0002\u0013\u0005A&A\u0006tK\u001elWM\u001c;TSj,W#A\u0017\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\u0007%sG\u000f\u0003\u00045\u0001\u0001\u0006I!L\u0001\rg\u0016<W.\u001a8u'&TX\r\t\u0005\bm\u0001\u0011\r\u0011\"\u0001-\u0003-!W\r\\3uK\u0012+G.Y=\t\ra\u0002\u0001\u0015!\u0003.\u00031!W\r\\3uK\u0012+G.Y=!\u0011\u001dQ\u0004A1A\u0005\u0002m\nq\u0001\\8h\u001d\u0006lW-F\u0001=!\tIQ(\u0003\u0002?\u0015\t11\u000b\u001e:j]\u001eDa\u0001\u0011\u0001!\u0002\u0013a\u0014\u0001\u00037pO:\u000bW.\u001a\u0011\t\u000f\t\u0003!\u0019!C\u0001\u0007\u00061An\\4ESJ,\u0012\u0001\u0012\t\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000f2\t!![8\n\u0005%3%\u0001\u0002$jY\u0016Daa\u0013\u0001!\u0002\u0013!\u0015a\u00027pO\u0012K'\u000f\t\u0005\b\u001b\u0002\u0001\r\u0011\"\u0001-\u0003\u001d\u0019w.\u001e8uKJDqa\u0014\u0001A\u0002\u0013\u0005\u0001+A\u0006d_VtG/\u001a:`I\u0015\fHCA)U!\tq#+\u0003\u0002T_\t!QK\\5u\u0011\u001d)f*!AA\u00025\n1\u0001\u001f\u00132\u0011\u00199\u0006\u0001)Q\u0005[\u0005A1m\\;oi\u0016\u0014\b\u0005C\u0004Z\u0001\t\u0007I\u0011\u0001.\u0002\rQ|\u0007/[2t+\u0005Y\u0006c\u0001\u0018]=&\u0011Ql\f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003?\nl\u0011\u0001\u0019\u0006\u0003C\u0012\taaY8n[>t\u0017BA2a\u0005E!v\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\u001c\u0005\u0007K\u0002\u0001\u000b\u0011B.\u0002\u000fQ|\u0007/[2tA!)q\r\u0001C\u0001Q\u0006Y1\r\\3b]\u0016\u0014H+Z:u)\u0005\t\u0006F\u00014k!\tYW.D\u0001m\u0015\t\u0019b#\u0003\u0002oY\n!A+Z:u\u0011\u0015\u0001\b\u0001\"\u0001r\u0003-\u0011X-\u00193Ge>lGj\\4\u0015\u0005I\\\bcA:wq6\tAO\u0003\u0002v_\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005]$(\u0001C%uKJ\f'\r\\3\u0011\t9JX&L\u0005\u0003u>\u0012a\u0001V;qY\u0016\u0014\u0004\"B\u0002p\u0001\u0004a\bC\u0001\u0010~\u0013\tq(AA\u0002M_\u001eDq!!\u0001\u0001\t\u0003\t\u0019!A\u0005xe&$X\rR;qgRA\u0011QAA\u0006\u0003\u001f\t\u0019\u0002\u0005\u0003t\u0003\u000fA\u0018bAA\u0005i\n\u00191+Z9\t\r\u00055q\u00101\u0001.\u0003\u001dqW/\\&fsNDa!!\u0005\u0000\u0001\u0004i\u0013a\u00028v[\u0012+\bo\u001d\u0005\u0006\u0007}\u0004\r\u0001 \u0005\u0007\u0003/\u0001A\u0011\u00015\u0002\u0011Q,\u0017M\u001d3po:DC!!\u0006\u0002\u001cA\u00191.!\b\n\u0007\u0005}ANA\u0003BMR,'\u000fC\u0004\u0002$\u0001!\t!!\n\u0002\u00175\f7.Z\"mK\u0006tWM\u001d\u000b\r\u0003O\ti#!\r\u00026\u0005e\u0012\u0011\n\t\u0004=\u0005%\u0012bAA\u0016\u0005\tQAj\\4DY\u0016\fg.\u001a:\t\u000f\u0005=\u0012\u0011\u0005a\u0001[\u0005)\u0001/\u0019:ug\"I\u00111GA\u0011!\u0003\u0005\r!L\u0001\u0011[&tG)\u001b:us6+7o]1hKND\u0011\"a\u000e\u0002\"A\u0005\t\u0019A\u0017\u0002\u00159,X\u000e\u00165sK\u0006$7\u000f\u0003\u0006\u0002<\u0005\u0005\u0002\u0013!a\u0001\u0003{\tQ\u0002Z3gCVdG\u000fU8mS\u000eL\b\u0003BA \u0003\u000br1ALA!\u0013\r\t\u0019eL\u0001\u0007!J,G-\u001a4\n\u0007y\n9EC\u0002\u0002D=B!\"a\u0013\u0002\"A\u0005\t\u0019AA'\u0003=\u0001x\u000e\\5ds>3XM\u001d:jI\u0016\u001c\bcB:\u0002P\u0005u\u0012QH\u0005\u0004\u0003#\"(aA'ba\"I\u0011Q\u000b\u0001\u0012\u0002\u0013\u0005\u0011qK\u0001\u0016[\u0006\\Wm\u00117fC:,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tIFK\u0002.\u00037Z#!!\u0018\u0011\t\u0005}\u0013\u0011N\u0007\u0003\u0003CRA!a\u0019\u0002f\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003Oz\u0013AC1o]>$\u0018\r^5p]&!\u00111NA1\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003_\u0002\u0011\u0013!C\u0001\u0003/\nQ#\\1lK\u000ecW-\u00198fe\u0012\"WMZ1vYR$3\u0007C\u0005\u0002t\u0001\t\n\u0011\"\u0001\u0002v\u0005)R.Y6f\u00072,\u0017M\\3sI\u0011,g-Y;mi\u0012\"TCAA<U\u0011\ti$a\u0017\t\u0013\u0005m\u0004!%A\u0005\u0002\u0005u\u0014!F7bW\u0016\u001cE.Z1oKJ$C-\u001a4bk2$H%N\u000b\u0003\u0003\u007fRC!!\u0014\u0002\\\u0001")
public class LogCleanerIntegrationTest
implements JUnitSuite {
    private final MockTime time;
    private final int segmentSize;
    private final int deleteDelay;
    private final String logName;
    private final File logDir;
    private int counter;
    private final TopicAndPartition[] topics;
    private volatile Tracker org$scalatest$junit$JUnitSuite$$theTracker;
    private final String styleName;

    public Tracker org$scalatest$junit$JUnitSuite$$theTracker() {
        return this.org$scalatest$junit$JUnitSuite$$theTracker;
    }

    public void org$scalatest$junit$JUnitSuite$$theTracker_$eq(Tracker x$1) {
        this.org$scalatest$junit$JUnitSuite$$theTracker = x$1;
    }

    public final String styleName() {
        return this.styleName;
    }

    public final void org$scalatest$junit$JUnitSuite$_setter_$styleName_$eq(String x$1) {
        this.styleName = x$1;
    }

    public final void withFixture(Suite.NoArgTest test) {
        JUnitSuite.class.withFixture((JUnitSuite)this, (Suite.NoArgTest)test);
    }

    public final void runNestedSuites(Reporter reporter, Stopper stopper, Filter filter, scala.collection.immutable.Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        JUnitSuite.class.runNestedSuites((JUnitSuite)this, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public final void runTests(Option<String> testName, Reporter reporter, Stopper stopper, Filter filter, scala.collection.immutable.Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        JUnitSuite.class.runTests((JUnitSuite)this, testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public final void runTest(String testName, Reporter reporter, Stopper stopper, scala.collection.immutable.Map<String, Object> configMap, Tracker tracker) {
        JUnitSuite.class.runTest((JUnitSuite)this, (String)testName, (Reporter)reporter, (Stopper)stopper, configMap, (Tracker)tracker);
    }

    public Set<String> testNames() {
        return JUnitSuite.class.testNames((JUnitSuite)this);
    }

    public int expectedTestCount(Filter filter) {
        return JUnitSuite.class.expectedTestCount((JUnitSuite)this, (Filter)filter);
    }

    public scala.collection.immutable.Map<String, Set<String>> tags() {
        return JUnitSuite.class.tags((JUnitSuite)this);
    }

    public void run(Option<String> testName, Reporter report, Stopper stopper, Filter filter, scala.collection.immutable.Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        JUnitSuite.class.run((JUnitSuite)this, testName, (Reporter)report, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public Throwable newAssertionFailedException(Option<Object> optionalMessage, Option<Throwable> optionalCause, int stackDepth) {
        return AssertionsForJUnit.class.newAssertionFailedException((AssertionsForJUnit)this, optionalMessage, optionalCause, (int)stackDepth);
    }

    public void org$scalatest$Suite$_setter_$styleName_$eq(String x$1) {
    }

    public List<Suite> nestedSuites() {
        return Suite.class.nestedSuites((Suite)this);
    }

    public final void execute(String testName, scala.collection.immutable.Map<String, Object> configMap, boolean color, boolean durations, boolean shortstacks, boolean fullstacks, boolean stats) {
        Suite.class.execute((Suite)this, (String)testName, configMap, (boolean)color, (boolean)durations, (boolean)shortstacks, (boolean)fullstacks, (boolean)stats);
    }

    public Method getMethodForTestName(String testName) {
        return Suite.class.getMethodForTestName((Suite)this, (String)testName);
    }

    public Tuple6<Stopper, Reporter, Method, Object, Option<TestRerunner>, Object> getSuiteRunTestGoodies(Stopper stopper, Reporter reporter, String testName) {
        return Suite.class.getSuiteRunTestGoodies((Suite)this, (Stopper)stopper, (Reporter)reporter, (String)testName);
    }

    public Tuple5<Stopper, Reporter, Object, Option<TestRerunner>, Object> getRunTestGoodies(Stopper stopper, Reporter reporter, String testName) {
        return Suite.class.getRunTestGoodies((Suite)this, (Stopper)stopper, (Reporter)reporter, (String)testName);
    }

    public void handleFailedTest(Throwable throwable, boolean hasPublicNoArgConstructor, String testName, Option<Rerunner> rerunnable, Reporter report, Tracker tracker, long duration) {
        Suite.class.handleFailedTest((Suite)this, (Throwable)throwable, (boolean)hasPublicNoArgConstructor, (String)testName, rerunnable, (Reporter)report, (Tracker)tracker, (long)duration);
    }

    public String suiteName() {
        return Suite.class.suiteName((Suite)this);
    }

    public PendingNothing pending() {
        return Suite.class.pending((Suite)this);
    }

    public void pendingUntilFixed(Function0<BoxedUnit> f) {
        Suite.class.pendingUntilFixed((Suite)this, f);
    }

    public Reporter wrapReporterIfNecessary(Reporter reporter) {
        return Suite.class.wrapReporterIfNecessary((Suite)this, (Reporter)reporter);
    }

    public final String execute$default$1() {
        return Suite.class.execute$default$1((Suite)this);
    }

    public final scala.collection.immutable.Map<String, Object> execute$default$2() {
        return Suite.class.execute$default$2((Suite)this);
    }

    public final boolean execute$default$3() {
        return Suite.class.execute$default$3((Suite)this);
    }

    public final boolean execute$default$4() {
        return Suite.class.execute$default$4((Suite)this);
    }

    public final boolean execute$default$5() {
        return Suite.class.execute$default$5((Suite)this);
    }

    public final boolean execute$default$6() {
        return Suite.class.execute$default$6((Suite)this);
    }

    public final boolean execute$default$7() {
        return Suite.class.execute$default$7((Suite)this);
    }

    public void assert(boolean condition) {
        Assertions.class.assert((Assertions)this, (boolean)condition);
    }

    public void assert(boolean condition, Object clue) {
        Assertions.class.assert((Assertions)this, (boolean)condition, (Object)clue);
    }

    public void assert(Option<String> o, Object clue) {
        Assertions.class.assert((Assertions)this, o, (Object)clue);
    }

    public void assert(Option<String> o) {
        Assertions.class.assert((Assertions)this, o);
    }

    public Assertions.Equalizer convertToEqualizer(Object left) {
        return Assertions.class.convertToEqualizer((Assertions)this, (Object)left);
    }

    public <T> T intercept(Function0<Object> f, Manifest<T> manifest) {
        return (T)Assertions.class.intercept((Assertions)this, f, manifest);
    }

    public void expectResult(Object expected, Object clue, Object actual) {
        Assertions.class.expectResult((Assertions)this, (Object)expected, (Object)clue, (Object)actual);
    }

    public void expect(Object expected, Object clue, Object actual) {
        Assertions.class.expect((Assertions)this, (Object)expected, (Object)clue, (Object)actual);
    }

    public void expectResult(Object expected, Object actual) {
        Assertions.class.expectResult((Assertions)this, (Object)expected, (Object)actual);
    }

    public void expect(Object expected, Object actual) {
        Assertions.class.expect((Assertions)this, (Object)expected, (Object)actual);
    }

    public Nothing$ fail() {
        return Assertions.class.fail((Assertions)this);
    }

    public Nothing$ fail(String message) {
        return Assertions.class.fail((Assertions)this, (String)message);
    }

    public Nothing$ fail(String message, Throwable cause) {
        return Assertions.class.fail((Assertions)this, (String)message, (Throwable)cause);
    }

    public Nothing$ fail(Throwable cause) {
        return Assertions.class.fail((Assertions)this, (Throwable)cause);
    }

    public <T> T withClue(Object clue, Function0<T> fun) {
        return (T)Assertions.class.withClue((Assertions)this, (Object)clue, fun);
    }

    public MockTime time() {
        return this.time;
    }

    public int segmentSize() {
        return this.segmentSize;
    }

    public int deleteDelay() {
        return this.deleteDelay;
    }

    public String logName() {
        return this.logName;
    }

    public File logDir() {
        return this.logDir;
    }

    public int counter() {
        return this.counter;
    }

    public void counter_$eq(int x$1) {
        this.counter = x$1;
    }

    public TopicAndPartition[] topics() {
        return this.topics;
    }

    @Test
    public void cleanerTest() {
        LogCleaner cleaner = this.makeCleaner(3, this.makeCleaner$default$2(), this.makeCleaner$default$3(), this.makeCleaner$default$4(), this.makeCleaner$default$5());
        Log log = (Log)cleaner.logs().get((Object)this.topics()[0]);
        Seq<Tuple2<Object, Object>> appends = this.writeDups(100, 3, log);
        long startSize = log.size();
        cleaner.startup();
        long lastCleaned = log.activeSegment().baseOffset();
        cleaner.awaitCleaned("log", 0, lastCleaned, cleaner.awaitCleaned$default$4());
        Iterable<Tuple2<Object, Object>> read = this.readFromLog(log);
        Assert.assertEquals((String)"Contents of the map shouldn't change.", (Object)appends.toMap(Predef$.MODULE$.conforms()), (Object)read.toMap(Predef$.MODULE$.conforms()));
        Assert.assertTrue((startSize > log.size() ? 1 : 0) != 0);
        Seq appends2 = (Seq)appends.$plus$plus(this.writeDups(100, 3, log), Seq$.MODULE$.canBuildFrom());
        long lastCleaned2 = log.activeSegment().baseOffset();
        cleaner.awaitCleaned("log", 0, lastCleaned2, cleaner.awaitCleaned$default$4());
        Iterable<Tuple2<Object, Object>> read2 = this.readFromLog(log);
        Assert.assertEquals((String)"Contents of the map shouldn't change.", (Object)appends2.toMap(Predef$.MODULE$.conforms()), (Object)read2.toMap(Predef$.MODULE$.conforms()));
        cleaner.shutdown();
    }

    public Iterable<Tuple2<Object, Object>> readFromLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Tuple2<Object, Object>> apply(LogSegment segment) {
                return (Iterable)segment.log().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(MessageAndOffset message) {
                        int key = new StringOps(Predef$.MODULE$.augmentString(Utils$.MODULE$.readString(message.message().key(), Utils$.MODULE$.readString$default$2()))).toInt();
                        int value = new StringOps(Predef$.MODULE$.augmentString(Utils$.MODULE$.readString(message.message().payload(), Utils$.MODULE$.readString$default$2()))).toInt();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)BoxesRunTime.boxToInteger((int)value));
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public Seq<Tuple2<Object, Object>> writeDups(int numKeys, int numDups, Log log) {
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1)new Serializable(this, numKeys, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerIntegrationTest $outer;
            private final int numKeys$1;
            public final Log log$1;

            public final IndexedSeq<Tuple2<Object, Object>> apply(int dup) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numKeys$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$writeDups$1 $outer;

                    public final Tuple2<Object, Object> apply(int key) {
                        int count = this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter();
                        byte[] x$1 = ((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter())).toString().getBytes();
                        byte[] x$2 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
                        CompressionCodec x$3 = TestUtils$.MODULE$.singleMessageSet$default$2();
                        this.$outer.log$1.append(TestUtils$.MODULE$.singleMessageSet(x$1, x$3, x$2), true);
                        this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter_$eq(this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter() + 1);
                        return new Tuple2.mcII.sp(key, count);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ LogCleanerIntegrationTest kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.numKeys$1 = numKeys$1;
                this.log$1 = log$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    @After
    public void teardown() {
        Utils$.MODULE$.rm(this.logDir());
    }

    public LogCleaner makeCleaner(int parts, int minDirtyMessages, int numThreads, String defaultPolicy, Map<String, String> policyOverrides) {
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), parts).foreach((Function1)new Serializable(this, logs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerIntegrationTest $outer;
            private final Pool logs$1;

            public final Log apply(int i) {
                File dir = new File(this.$outer.logDir(), new StringBuilder().append((Object)"log-").append((Object)BoxesRunTime.boxToInteger((int)i)).toString());
                dir.mkdirs();
                int x$4 = this.$outer.segmentSize();
                int x$5 = 102400;
                long x$6 = this.$outer.deleteDelay();
                boolean x$7 = true;
                long x$8 = LogConfig$.MODULE$.apply$default$2();
                long x$9 = LogConfig$.MODULE$.apply$default$3();
                long x$10 = LogConfig$.MODULE$.apply$default$4();
                long x$11 = LogConfig$.MODULE$.apply$default$5();
                long x$12 = LogConfig$.MODULE$.apply$default$6();
                int x$13 = LogConfig$.MODULE$.apply$default$7();
                int x$14 = LogConfig$.MODULE$.apply$default$9();
                long x$15 = LogConfig$.MODULE$.apply$default$11();
                double x$16 = LogConfig$.MODULE$.apply$default$12();
                Log log = new Log(dir, new LogConfig(x$4, x$8, x$9, x$10, x$11, x$12, x$13, x$5, x$14, x$6, x$15, x$16, x$7), 0L, (Scheduler)this.$outer.time().scheduler(), (Time)this.$outer.time());
                return (Log)this.logs$1.put((Object)new TopicAndPartition("log", i), (Object)log);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.logs$1 = logs$1;
            }
        });
        return new LogCleaner(new CleanerConfig(numThreads, CleanerConfig$.MODULE$.apply$default$2(), CleanerConfig$.MODULE$.apply$default$3(), CleanerConfig$.MODULE$.apply$default$4(), CleanerConfig$.MODULE$.apply$default$5(), CleanerConfig$.MODULE$.apply$default$6(), CleanerConfig$.MODULE$.apply$default$7(), CleanerConfig$.MODULE$.apply$default$8(), CleanerConfig$.MODULE$.apply$default$9()), (File[])((Object[])new File[]{this.logDir()}), logs, (Time)this.time());
    }

    public int makeCleaner$default$2() {
        return 0;
    }

    public int makeCleaner$default$3() {
        return 1;
    }

    public String makeCleaner$default$4() {
        return "compact";
    }

    public Map<String, String> makeCleaner$default$5() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public LogCleanerIntegrationTest() {
        Assertions.class.$init$((Assertions)this);
        Suite.class.$init$((Suite)this);
        AssertionsForJUnit.class.$init$((AssertionsForJUnit)this);
        JUnitSuite.class.$init$((JUnitSuite)this);
        this.time = new MockTime();
        this.segmentSize = 100;
        this.deleteDelay = 1000;
        this.logName = "log";
        this.logDir = TestUtils$.MODULE$.tempDir();
        this.counter = 0;
        this.topics = (TopicAndPartition[])((Object[])new TopicAndPartition[]{new TopicAndPartition("log", 0), new TopicAndPartition("log", 1), new TopicAndPartition("log", 2)});
    }
}

