/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.concurrent.atomic.AtomicLong;
import junit.framework.Assert;
import kafka.log.FileMessageSet;
import kafka.log.LogSegment;
import kafka.log.LogSegmentTest$;
import kafka.log.OffsetIndex;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.NoCompressionCodec$;
import kafka.utils.SystemTime$;
import kafka.utils.TestUtils$;
import kafka.utils.Time;
import org.junit.After;
import org.junit.Test;
import org.scalatest.junit.JUnit3Suite;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001]4A!\u0001\u0002\u0001\u000f\tqAj\\4TK\u001elWM\u001c;UKN$(BA\u0002\u0005\u0003\rawn\u001a\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tI\u0001#D\u0001\u000b\u0015\tYA\"A\u0003kk:LGO\u0003\u0002\u000e\u001d\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002\u001f\u0005\u0019qN]4\n\u0005EQ!a\u0003&V]&$8gU;ji\u0016DQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"\u0001\u0002\t\u000fa\u0001!\u0019!C\u00013\u0005A1/Z4nK:$8/F\u0001\u001b!\rY\"\u0005J\u0007\u00029)\u0011QDH\u0001\b[V$\u0018M\u00197f\u0015\ty\u0002%\u0001\u0006d_2dWm\u0019;j_:T\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003Gq\u00111\"\u0011:sCf\u0014UO\u001a4feB\u0011a#J\u0005\u0003M\t\u0011!\u0002T8h'\u0016<W.\u001a8u\u0011\u0019A\u0003\u0001)A\u00055\u0005I1/Z4nK:$8\u000f\t\u0005\u0006U\u0001!\taK\u0001\u000eGJ,\u0017\r^3TK\u001elWM\u001c;\u0015\u0005\u0011b\u0003\"B\u0017*\u0001\u0004q\u0013AB8gMN,G\u000f\u0005\u00020a5\t\u0001%\u0003\u00022A\t!Aj\u001c8h\u0011\u0015\u0019\u0004\u0001\"\u00015\u0003!iWm]:bO\u0016\u001cHcA\u001b<yA\u0011a'O\u0007\u0002o)\u0011\u0001\bB\u0001\b[\u0016\u001c8/Y4f\u0013\tQtG\u0001\u000bCsR,')\u001e4gKJlUm]:bO\u0016\u001cV\r\u001e\u0005\u0006[I\u0002\rA\f\u0005\u0006gI\u0002\r!\u0010\t\u0004_y\u0002\u0015BA !\u0005)a$/\u001a9fCR,GM\u0010\t\u0003\u0003\u0012s!a\f\"\n\u0005\r\u0003\u0013A\u0002)sK\u0012,g-\u0003\u0002F\r\n11\u000b\u001e:j]\u001eT!a\u0011\u0011\t\u000b!\u0003A\u0011A%\u0002\u0011Q,\u0017M\u001d3po:$\u0012A\u0013\t\u0003_-K!\u0001\u0014\u0011\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u000f:\u0003\"aT)\u000e\u0003AS!a\u0003\b\n\u0005I\u0003&!B!gi\u0016\u0014\b\"\u0002+\u0001\t\u0003I\u0015A\u0006;fgR\u0014V-\u00193P]\u0016k\u0007\u000f^=TK\u001elWM\u001c;)\u0005M3\u0006CA(X\u0013\tA\u0006K\u0001\u0003UKN$\b\"\u0002.\u0001\t\u0003I\u0015!\u0007;fgR\u0014V-\u00193CK\u001a|'/\u001a$jeN$xJ\u001a4tKRD#!\u0017,\t\u000bu\u0003A\u0011A%\u0002\u001bQ,7\u000f^'bq>3gm]3uQ\taf\u000bC\u0003a\u0001\u0011\u0005\u0011*A\tuKN$(+Z1e\u0003\u001a$XM\u001d'bgRD#a\u0018,\t\u000b\r\u0004A\u0011A%\u0002\u001fQ,7\u000f\u001e*fC\u00124%o\\7HCBD#A\u0019,\t\u000b\u0019\u0004A\u0011A%\u0002\u0019Q,7\u000f\u001e+sk:\u001c\u0017\r^3)\u0005\u00154\u0006\"B5\u0001\t\u0003I\u0015\u0001\u0005;fgR$&/\u001e8dCR,g)\u001e7mQ\tAg\u000bC\u0003m\u0001\u0011\u0005\u0011*A\ruKN$h*\u001a=u\u001f\u001a47/\u001a;DC2\u001cW\u000f\\1uS>t\u0007FA6W\u0011\u0015y\u0007\u0001\"\u0001J\u0003Y!Xm\u001d;DQ\u0006tw-\u001a$jY\u0016\u001cVO\u001a4jq\u0016\u001c\bF\u00018W\u0011\u0015\u0011\b\u0001\"\u0001J\u0003u!Xm\u001d;SK\u000e|g/\u001a:z\r&DXm]\"peJ,\b\u000f^%oI\u0016D\bFA9W\u0011\u0015)\b\u0001\"\u0001J\u0003y!Xm\u001d;SK\u000e|g/\u001a:z/&$\bnQ8seV\u0004H/T3tg\u0006<W\r\u000b\u0002u-\u0002")
public class LogSegmentTest
extends JUnit3Suite {
    private final ArrayBuffer<LogSegment> segments = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);

    public ArrayBuffer<LogSegment> segments() {
        return this.segments;
    }

    public LogSegment createSegment(long offset) {
        File msFile = TestUtils$.MODULE$.tempFile();
        FileMessageSet ms = new FileMessageSet(msFile);
        File idxFile = TestUtils$.MODULE$.tempFile();
        idxFile.delete();
        OffsetIndex idx = new OffsetIndex(idxFile, offset, 1000);
        LogSegment seg = new LogSegment(ms, idx, offset, 10, (Time)SystemTime$.MODULE$);
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    public ByteBufferMessageSet messages(long offset, Seq<String> messages2) {
        return new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, new AtomicLong(offset), (Seq)messages2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Message apply(String s) {
                return new Message(s.getBytes());
            }
        }, Seq$.MODULE$.canBuildFrom()));
    }

    @After
    public void teardown() {
        this.segments().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LogSegment seg) {
                seg.index().delete();
                return seg.log().delete();
            }
        });
    }

    @Test
    public void testReadOnEmptySegment() {
        LogSegment seg = this.createSegment(40L);
        long x$3 = 40L;
        int x$4 = 300;
        None$ x$5 = None$.MODULE$;
        MessageSet read = seg.read(x$3, (Option)x$5, x$4);
        Assert.assertNull((String)"Read beyond the last offset in the segment should be null", (Object)read);
    }

    @Test
    public void testReadBeforeFirstOffset() {
        LogSegment seg = this.createSegment(40L);
        ByteBufferMessageSet ms = this.messages(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "little", "bee"}));
        seg.append(50L, ms);
        long x$6 = 41L;
        int x$7 = 300;
        None$ x$8 = None$.MODULE$;
        MessageSet read = seg.read(x$6, (Option)x$8, x$7);
        Assert.assertEquals((Object)ms.toList(), (Object)read.toList());
    }

    @Test
    public void testMaxOffset() {
        int baseOffset = 50;
        LogSegment seg = this.createSegment(baseOffset);
        ByteBufferMessageSet ms = this.messages(baseOffset, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "beautiful"}));
        seg.append((long)baseOffset, ms);
        this.validate$1(50L, seg, ms);
        this.validate$1(51L, seg, ms);
        this.validate$1(52L, seg, ms);
    }

    @Test
    public void testReadAfterLast() {
        LogSegment seg = this.createSegment(40L);
        ByteBufferMessageSet ms = this.messages(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(50L, ms);
        long x$12 = 52L;
        int x$13 = 200;
        None$ x$14 = None$.MODULE$;
        MessageSet read = seg.read(x$12, (Option)x$14, x$13);
        Assert.assertNull((String)"Read beyond the last offset in the segment should give null", null);
    }

    @Test
    public void testReadFromGap() {
        LogSegment seg = this.createSegment(40L);
        ByteBufferMessageSet ms = this.messages(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(50L, ms);
        ByteBufferMessageSet ms2 = this.messages(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(60L, ms2);
        long x$15 = 55L;
        int x$16 = 200;
        None$ x$17 = None$.MODULE$;
        MessageSet read = seg.read(x$15, (Option)x$17, x$16);
        Assert.assertEquals((Object)ms2.toList(), (Object)read.toList());
    }

    @Test
    public void testTruncate() {
        LogSegment seg = this.createSegment(40L);
        IntRef offset = new IntRef(40);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 30).foreach$mVc$sp((Function1)new Serializable(this, seg, offset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegmentTest $outer;
            private final LogSegment seg$2;
            private final IntRef offset$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                ByteBufferMessageSet ms1 = this.$outer.messages(this.offset$2.elem, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
                this.seg$2.append((long)this.offset$2.elem, ms1);
                ByteBufferMessageSet ms2 = this.$outer.messages(this.offset$2.elem + 1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
                this.seg$2.append((long)(this.offset$2.elem + 1), ms2);
                MessageSet read = this.seg$2.read((long)this.offset$2.elem, (Option)None$.MODULE$, 10000);
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MessageAndOffset[]{(MessageAndOffset)ms1.head(), (MessageAndOffset)ms2.head()})), (Object)read.toList());
                this.seg$2.truncateTo((long)(this.offset$2.elem + 1));
                MessageSet read2 = this.seg$2.read((long)this.offset$2.elem, (Option)None$.MODULE$, 10000);
                Assert.assertEquals((int)1, (int)read2.size());
                Assert.assertEquals((Object)ms1.head(), (Object)read2.head());
                ++this.offset$2.elem;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.seg$2 = seg$2;
                this.offset$2 = offset$2;
            }
        });
    }

    @Test
    public void testTruncateFull() {
        LogSegment seg = this.createSegment(40L);
        seg.append(40L, this.messages(40L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
        seg.truncateTo(0L);
        Assert.assertNull((String)"Segment should be empty.", (Object)seg.read(0L, (Option)None$.MODULE$, 1024));
        seg.append(40L, this.messages(40L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
    }

    @Test
    public void testNextOffsetCalculation() {
        LogSegment seg = this.createSegment(40L);
        Assert.assertEquals((long)40L, (long)seg.nextOffset());
        seg.append(50L, this.messages(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "you"})));
        Assert.assertEquals((long)53L, (long)seg.nextOffset());
    }

    @Test
    public void testChangeFileSuffixes() {
        LogSegment seg = this.createSegment(40L);
        File logFile = seg.log().file();
        File indexFile = seg.index().file();
        seg.changeFileSuffixes("", ".deleted");
        Assert.assertEquals((String)new StringBuilder().append((Object)logFile.getAbsolutePath()).append((Object)".deleted").toString(), (String)seg.log().file().getAbsolutePath());
        Assert.assertEquals((String)new StringBuilder().append((Object)indexFile.getAbsolutePath()).append((Object)".deleted").toString(), (String)seg.index().file().getAbsolutePath());
        Assert.assertTrue((boolean)seg.log().file().exists());
        Assert.assertTrue((boolean)seg.index().file().exists());
    }

    @Test
    public void testRecoveryFixesCorruptIndex() {
        LogSegment seg = this.createSegment(0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)new Serializable(this, seg){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegmentTest $outer;
            private final LogSegment seg$3;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.seg$3.append((long)i, this.$outer.messages(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)i)).toString()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.seg$3 = seg$3;
            }
        });
        File indexFile = seg.index().file();
        TestUtils$.MODULE$.writeNonsenseToFile(indexFile, 5L, (int)indexFile.length());
        seg.recover(65536);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)new Serializable(this, seg){
            public static final long serialVersionUID = 0L;
            private final LogSegment seg$3;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((long)i, (long)((MessageAndOffset)this.seg$3.read((long)i, (Option)new Some((Object)BoxesRunTime.boxToLong((long)(i + 1))), 1024).head()).offset());
            }
            {
                this.seg$3 = seg$3;
            }
        });
    }

    @Test
    public void testRecoveryWithCorruptMessage() {
        int messagesAppended = 20;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, messagesAppended){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegmentTest $outer;
            private final int messagesAppended$1;

            public final void apply(int iteration) {
                this.apply$mcVI$sp(iteration);
            }

            public void apply$mcVI$sp(int iteration) {
                LogSegment seg = this.$outer.createSegment(0L);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.messagesAppended$1).foreach$mVc$sp((Function1)new Serializable(this, seg){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testRecoveryWithCorruptMessage$1 $outer;
                    private final LogSegment seg$4;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.seg$4.append((long)i, this.$outer.kafka$log$LogSegmentTest$$anonfun$$$outer().messages(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)i)).toString()})));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.seg$4 = seg$4;
                    }
                });
                int offsetToBeginCorruption = TestUtils$.MODULE$.random().nextInt(this.messagesAppended$1);
                int position = seg.log().searchFor((long)offsetToBeginCorruption, 0).position() + TestUtils$.MODULE$.random().nextInt(15);
                TestUtils$.MODULE$.writeNonsenseToFile(seg.log().file(), position, (int)seg.log().file().length() - position);
                seg.recover(65536);
                Assert.assertEquals((String)"Should have truncated off bad messages.", (Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), offsetToBeginCorruption).toList(), (Object)((TraversableOnce)seg.log().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(MessageAndOffset x$2) {
                        return x$2.offset();
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toList());
                seg.delete();
            }

            public /* synthetic */ LogSegmentTest kafka$log$LogSegmentTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.messagesAppended$1 = messagesAppended$1;
            }
        });
    }

    private final void validate$1(long offset, LogSegment seg$1, ByteBufferMessageSet ms$1) {
        long x$9 = offset;
        int x$10 = 1024;
        Some x$11 = new Some((Object)BoxesRunTime.boxToLong((long)(offset + 1L)));
        Assert.assertEquals((Object)((TraversableOnce)ms$1.filter((Function1)new Serializable(this, offset){
            public static final long serialVersionUID = 0L;
            private final long offset$1;

            public final boolean apply(MessageAndOffset x$1) {
                return x$1.offset() == this.offset$1;
            }
            {
                this.offset$1 = offset$1;
            }
        })).toList(), (Object)seg$1.read(x$9, (Option)x$11, x$10).toList());
    }
}

