/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import junit.framework.Assert;
import kafka.message.BaseMessageSetTestCases;
import kafka.message.BaseMessageSetTestCases$class;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.message.NoCompressionCodec$;
import kafka.utils.TestUtils$;
import org.junit.Test;
import org.scalatest.Assertions;
import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.PendingNothing;
import org.scalatest.Reporter;
import org.scalatest.Rerunner;
import org.scalatest.Stopper;
import org.scalatest.Suite;
import org.scalatest.TestRerunner;
import org.scalatest.Tracker;
import org.scalatest.junit.AssertionsForJUnit;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple5;
import scala.Tuple6;
import scala.collection.GenSet;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u0001m3A!\u0001\u0002\u0001\u000f\tA\")\u001f;f\u0005V4g-\u001a:NKN\u001c\u0018mZ3TKR$Vm\u001d;\u000b\u0005\r!\u0011aB7fgN\fw-\u001a\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t!A\u0011\u0011BD\u0007\u0002\u0015)\u00111\u0002D\u0001\u0005Y\u0006twMC\u0001\u000e\u0003\u0011Q\u0017M^1\n\u0005=Q!AB(cU\u0016\u001cG\u000f\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\t9\")Y:f\u001b\u0016\u001c8/Y4f'\u0016$H+Z:u\u0007\u0006\u001cXm\u001d\u0005\u0006+\u0001!\tAF\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"!\u0005\u0001\t\u000be\u0001A\u0011\t\u000e\u0002!\r\u0014X-\u0019;f\u001b\u0016\u001c8/Y4f'\u0016$HCA\u000e\u001f!\t\tB$\u0003\u0002\u001e\u0005\t!\")\u001f;f\u0005V4g-\u001a:NKN\u001c\u0018mZ3TKRDQa\b\rA\u0002\u0001\n\u0001\"\\3tg\u0006<Wm\u001d\t\u0004C-rcB\u0001\u0012)\u001d\t\u0019c%D\u0001%\u0015\t)c!\u0001\u0004=e>|GOP\u0005\u0002O\u0005)1oY1mC&\u0011\u0011FK\u0001\ba\u0006\u001c7.Y4f\u0015\u00059\u0013B\u0001\u0017.\u0005\r\u0019V-\u001d\u0006\u0003S)\u0002\"!E\u0018\n\u0005A\u0012!aB'fgN\fw-\u001a\u0005\u0006e\u0001!\taM\u0001\u000fi\u0016\u001cHOV1mS\u0012\u0014\u0015\u0010^3t)\u0005!\u0004CA\u001b7\u001b\u0005Q\u0013BA\u001c+\u0005\u0011)f.\u001b;)\u0005EJ\u0004C\u0001\u001e@\u001b\u0005Y$B\u0001\u001f>\u0003\u0015QWO\\5u\u0015\u0005q\u0014aA8sO&\u0011\u0001i\u000f\u0002\u0005)\u0016\u001cH\u000fC\u0003C\u0001\u0011\u00051'A\u000fuKN$h+\u00197jI\nKH/Z:XSRD7i\\7qe\u0016\u001c8/[8oQ\t\t\u0015\bC\u0003F\u0001\u0011\u00051'\u0001\u0006uKN$X)];bYND#\u0001R\u001d\t\u000b!\u0003A\u0011A\u001a\u0002\u0019Q,7\u000f^%uKJ\fGo\u001c:)\u0005\u001dK\u0004\"B&\u0001\t\u0003\u0019\u0014\u0001\u0006;fgR|eMZ:fi\u0006\u001b8/[4o[\u0016tG\u000f\u000b\u0002Ks!)a\n\u0001C\u0001\u001f\u0006a1\r[3dW>3gm]3ugR\u0019A\u0007U)\t\u000b}i\u0005\u0019A\u000e\t\u000bIk\u0005\u0019A*\u0002\u0015\t\f7/Z(gMN,G\u000f\u0005\u00026)&\u0011QK\u000b\u0002\u0005\u0019>tw\rC\u0003X\u0001\u0011\u0005\u0001,A\u000bwKJLg-_*iC2dwn^%uKJ\fGo\u001c:\u0015\u0005QJ\u0006\"\u0002.W\u0001\u0004Y\u0012AC7fgN\fw-Z*fi\u0002")
public class ByteBufferMessageSetTest
implements BaseMessageSetTestCases {
    private final Message[] messages;
    private volatile Tracker org$scalatest$junit$JUnitSuite$$theTracker;
    private final String styleName;

    @Override
    public Message[] messages() {
        return this.messages;
    }

    @Override
    public void kafka$message$BaseMessageSetTestCases$_setter_$messages_$eq(Message[] x$1) {
        this.messages = x$1;
    }

    @Override
    @Test
    public void testWrittenEqualsRead() {
        BaseMessageSetTestCases$class.testWrittenEqualsRead(this);
    }

    @Override
    @Test
    public void testIteratorIsConsistent() {
        BaseMessageSetTestCases$class.testIteratorIsConsistent(this);
    }

    @Override
    @Test
    public void testSizeInBytes() {
        BaseMessageSetTestCases$class.testSizeInBytes(this);
    }

    @Override
    @Test
    public void testWriteTo() {
        BaseMessageSetTestCases$class.testWriteTo(this);
    }

    @Override
    public void testWriteToWithMessageSet(MessageSet set) {
        BaseMessageSetTestCases$class.testWriteToWithMessageSet(this, set);
    }

    public Tracker org$scalatest$junit$JUnitSuite$$theTracker() {
        return this.org$scalatest$junit$JUnitSuite$$theTracker;
    }

    public void org$scalatest$junit$JUnitSuite$$theTracker_$eq(Tracker x$1) {
        this.org$scalatest$junit$JUnitSuite$$theTracker = x$1;
    }

    public final String styleName() {
        return this.styleName;
    }

    public final void org$scalatest$junit$JUnitSuite$_setter_$styleName_$eq(String x$1) {
        this.styleName = x$1;
    }

    public final void withFixture(Suite.NoArgTest test) {
        JUnitSuite.class.withFixture((JUnitSuite)this, (Suite.NoArgTest)test);
    }

    public final void runNestedSuites(Reporter reporter, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        JUnitSuite.class.runNestedSuites((JUnitSuite)this, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public final void runTests(Option<String> testName, Reporter reporter, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        JUnitSuite.class.runTests((JUnitSuite)this, testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public final void runTest(String testName, Reporter reporter, Stopper stopper, Map<String, Object> configMap, Tracker tracker) {
        JUnitSuite.class.runTest((JUnitSuite)this, (String)testName, (Reporter)reporter, (Stopper)stopper, configMap, (Tracker)tracker);
    }

    public Set<String> testNames() {
        return JUnitSuite.class.testNames((JUnitSuite)this);
    }

    public int expectedTestCount(Filter filter) {
        return JUnitSuite.class.expectedTestCount((JUnitSuite)this, (Filter)filter);
    }

    public Map<String, Set<String>> tags() {
        return JUnitSuite.class.tags((JUnitSuite)this);
    }

    public void run(Option<String> testName, Reporter report, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        JUnitSuite.class.run((JUnitSuite)this, testName, (Reporter)report, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public Throwable newAssertionFailedException(Option<Object> optionalMessage, Option<Throwable> optionalCause, int stackDepth) {
        return AssertionsForJUnit.class.newAssertionFailedException((AssertionsForJUnit)this, optionalMessage, optionalCause, (int)stackDepth);
    }

    public void org$scalatest$Suite$_setter_$styleName_$eq(String x$1) {
    }

    public List<Suite> nestedSuites() {
        return Suite.class.nestedSuites((Suite)this);
    }

    public final void execute(String testName, Map<String, Object> configMap, boolean color, boolean durations, boolean shortstacks, boolean fullstacks, boolean stats) {
        Suite.class.execute((Suite)this, (String)testName, configMap, (boolean)color, (boolean)durations, (boolean)shortstacks, (boolean)fullstacks, (boolean)stats);
    }

    public Method getMethodForTestName(String testName) {
        return Suite.class.getMethodForTestName((Suite)this, (String)testName);
    }

    public Tuple6<Stopper, Reporter, Method, Object, Option<TestRerunner>, Object> getSuiteRunTestGoodies(Stopper stopper, Reporter reporter, String testName) {
        return Suite.class.getSuiteRunTestGoodies((Suite)this, (Stopper)stopper, (Reporter)reporter, (String)testName);
    }

    public Tuple5<Stopper, Reporter, Object, Option<TestRerunner>, Object> getRunTestGoodies(Stopper stopper, Reporter reporter, String testName) {
        return Suite.class.getRunTestGoodies((Suite)this, (Stopper)stopper, (Reporter)reporter, (String)testName);
    }

    public void handleFailedTest(Throwable throwable, boolean hasPublicNoArgConstructor, String testName, Option<Rerunner> rerunnable, Reporter report, Tracker tracker, long duration) {
        Suite.class.handleFailedTest((Suite)this, (Throwable)throwable, (boolean)hasPublicNoArgConstructor, (String)testName, rerunnable, (Reporter)report, (Tracker)tracker, (long)duration);
    }

    public String suiteName() {
        return Suite.class.suiteName((Suite)this);
    }

    public PendingNothing pending() {
        return Suite.class.pending((Suite)this);
    }

    public void pendingUntilFixed(Function0<BoxedUnit> f) {
        Suite.class.pendingUntilFixed((Suite)this, f);
    }

    public Reporter wrapReporterIfNecessary(Reporter reporter) {
        return Suite.class.wrapReporterIfNecessary((Suite)this, (Reporter)reporter);
    }

    public final String execute$default$1() {
        return Suite.class.execute$default$1((Suite)this);
    }

    public final Map<String, Object> execute$default$2() {
        return Suite.class.execute$default$2((Suite)this);
    }

    public final boolean execute$default$3() {
        return Suite.class.execute$default$3((Suite)this);
    }

    public final boolean execute$default$4() {
        return Suite.class.execute$default$4((Suite)this);
    }

    public final boolean execute$default$5() {
        return Suite.class.execute$default$5((Suite)this);
    }

    public final boolean execute$default$6() {
        return Suite.class.execute$default$6((Suite)this);
    }

    public final boolean execute$default$7() {
        return Suite.class.execute$default$7((Suite)this);
    }

    public void assert(boolean condition) {
        Assertions.class.assert((Assertions)this, (boolean)condition);
    }

    public void assert(boolean condition, Object clue) {
        Assertions.class.assert((Assertions)this, (boolean)condition, (Object)clue);
    }

    public void assert(Option<String> o, Object clue) {
        Assertions.class.assert((Assertions)this, o, (Object)clue);
    }

    public void assert(Option<String> o) {
        Assertions.class.assert((Assertions)this, o);
    }

    public Assertions.Equalizer convertToEqualizer(Object left) {
        return Assertions.class.convertToEqualizer((Assertions)this, (Object)left);
    }

    public <T> T intercept(Function0<Object> f, Manifest<T> manifest) {
        return (T)Assertions.class.intercept((Assertions)this, f, manifest);
    }

    public void expectResult(Object expected, Object clue, Object actual) {
        Assertions.class.expectResult((Assertions)this, (Object)expected, (Object)clue, (Object)actual);
    }

    public void expect(Object expected, Object clue, Object actual) {
        Assertions.class.expect((Assertions)this, (Object)expected, (Object)clue, (Object)actual);
    }

    public void expectResult(Object expected, Object actual) {
        Assertions.class.expectResult((Assertions)this, (Object)expected, (Object)actual);
    }

    public void expect(Object expected, Object actual) {
        Assertions.class.expect((Assertions)this, (Object)expected, (Object)actual);
    }

    public Nothing$ fail() {
        return Assertions.class.fail((Assertions)this);
    }

    public Nothing$ fail(String message) {
        return Assertions.class.fail((Assertions)this, (String)message);
    }

    public Nothing$ fail(String message, Throwable cause) {
        return Assertions.class.fail((Assertions)this, (String)message, (Throwable)cause);
    }

    public Nothing$ fail(Throwable cause) {
        return Assertions.class.fail((Assertions)this, (Throwable)cause);
    }

    public <T> T withClue(Object clue, Function0<T> fun) {
        return (T)Assertions.class.withClue((Assertions)this, (Object)clue, fun);
    }

    public ByteBufferMessageSet createMessageSet(Seq<Message> messages2) {
        return new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, messages2);
    }

    @Test
    public void testValidBytes() {
        ByteBufferMessageSet messages2 = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes()), new Message("there".getBytes())}));
        ByteBuffer buffer = ByteBuffer.allocate(messages2.sizeInBytes() + 2);
        buffer.put(messages2.buffer());
        buffer.putShort((short)4);
        ByteBufferMessageSet messagesPlus = new ByteBufferMessageSet(buffer);
        Assert.assertEquals((String)"Adding invalid bytes shouldn't change byte count", (int)messages2.validBytes(), (int)messagesPlus.validBytes());
        Assert.assertEquals((String)"Valid bytes on an empty ByteBufferMessageSet should return 0", (int)0, (int)MessageSet$.MODULE$.Empty().validBytes());
    }

    @Test
    public void testValidBytesWithCompression() {
        ByteBufferMessageSet messages2 = new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes()), new Message("there".getBytes())}));
        ByteBuffer buffer = ByteBuffer.allocate(messages2.sizeInBytes() + 2);
        buffer.put(messages2.buffer());
        buffer.putShort((short)4);
        ByteBufferMessageSet messagesPlus = new ByteBufferMessageSet(buffer);
        Assert.assertEquals((String)"Adding invalid bytes shouldn't change byte count", (int)messages2.validBytes(), (int)messagesPlus.validBytes());
    }

    @Test
    public void testEquals() {
        ByteBufferMessageSet messages2 = new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes()), new Message("there".getBytes())}));
        ByteBufferMessageSet moreMessages = new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes()), new Message("there".getBytes())}));
        Assert.assertTrue((boolean)messages2.equals((Object)moreMessages));
        messages2 = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes()), new Message("there".getBytes())}));
        moreMessages = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes()), new Message("there".getBytes())}));
        Assert.assertTrue((boolean)messages2.equals((Object)moreMessages));
    }

    @Test
    public void testIterator() {
        List messageList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("msg1".getBytes()), new Message("msg2".getBytes()), new Message("msg3".getBytes())}));
        ByteBufferMessageSet messageSet = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)messageList);
        TestUtils$.MODULE$.checkEquals(messageList.iterator(), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)messageSet.iterator()));
        TestUtils$.MODULE$.checkEquals(messageList.iterator(), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)messageSet.iterator()));
        TestUtils$.MODULE$.checkEquals(TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)messageSet.shallowIterator()), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)messageSet.iterator()));
        ByteBufferMessageSet messageSet2 = new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)messageList);
        TestUtils$.MODULE$.checkEquals(messageList.iterator(), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)messageSet2.iterator()));
        TestUtils$.MODULE$.checkEquals(messageList.iterator(), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)messageSet2.iterator()));
        this.verifyShallowIterator(messageSet2);
        Nil$ emptyMessageList = Nil$.MODULE$;
        ByteBufferMessageSet emptyMessageSet = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)emptyMessageList);
        ByteBufferMessageSet regularMessgeSet = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)messageList);
        ByteBuffer buffer = ByteBuffer.allocate(emptyMessageSet.buffer().limit() + regularMessgeSet.buffer().limit());
        buffer.put(emptyMessageSet.buffer());
        buffer.put(regularMessgeSet.buffer());
        ((Buffer)buffer).rewind();
        ByteBufferMessageSet mixedMessageSet = new ByteBufferMessageSet(buffer);
        TestUtils$.MODULE$.checkEquals(messageList.iterator(), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)mixedMessageSet.iterator()));
        TestUtils$.MODULE$.checkEquals(messageList.iterator(), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)mixedMessageSet.iterator()));
        TestUtils$.MODULE$.checkEquals(TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)mixedMessageSet.shallowIterator()), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)mixedMessageSet.iterator()));
        Nil$ emptyMessageList2 = Nil$.MODULE$;
        ByteBufferMessageSet emptyMessageSet2 = new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)emptyMessageList2);
        ByteBufferMessageSet regularMessgeSet2 = new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)messageList);
        ByteBuffer buffer2 = ByteBuffer.allocate(emptyMessageSet2.buffer().limit() + regularMessgeSet2.buffer().limit());
        buffer2.put(emptyMessageSet2.buffer());
        buffer2.put(regularMessgeSet2.buffer());
        ((Buffer)buffer2).rewind();
        ByteBufferMessageSet mixedMessageSet2 = new ByteBufferMessageSet(buffer2);
        TestUtils$.MODULE$.checkEquals(messageList.iterator(), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)mixedMessageSet2.iterator()));
        TestUtils$.MODULE$.checkEquals(messageList.iterator(), TestUtils$.MODULE$.getMessageIterator((Iterator<MessageAndOffset>)mixedMessageSet2.iterator()));
        this.verifyShallowIterator(mixedMessageSet2);
    }

    @Test
    public void testOffsetAssignment() {
        ByteBufferMessageSet messages2 = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes()), new Message("there".getBytes()), new Message("beautiful".getBytes())}));
        ByteBufferMessageSet compressedMessages = new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)((TraversableOnce)messages2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Message apply(MessageAndOffset x$1) {
                return x$1.message();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toBuffer());
        this.checkOffsets(messages2, 0L);
        int offset = 1234567;
        this.checkOffsets(messages2.assignOffsets(new AtomicLong(offset), (CompressionCodec)NoCompressionCodec$.MODULE$), offset);
        this.checkOffsets(compressedMessages, 0L);
        this.checkOffsets(compressedMessages.assignOffsets(new AtomicLong(offset), (CompressionCodec)DefaultCompressionCodec$.MODULE$), offset);
    }

    public void checkOffsets(ByteBufferMessageSet messages2, long baseOffset) {
        LongRef offset = new LongRef(baseOffset);
        messages2.foreach((Function1)new Serializable(this, offset){
            public static final long serialVersionUID = 0L;
            private final LongRef offset$1;

            public final void apply(MessageAndOffset entry) {
                Assert.assertEquals((String)"Unexpected offset in message set iterator", (long)this.offset$1.elem, (long)entry.offset());
                ++this.offset$1.elem;
            }
            {
                this.offset$1 = offset$1;
            }
        });
    }

    public void verifyShallowIterator(ByteBufferMessageSet messageSet) {
        Set shallowOffsets = messageSet.shallowIterator().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(MessageAndOffset msgAndOff) {
                return msgAndOff.offset();
            }
        }).toSet();
        Set deepOffsets = messageSet.iterator().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(MessageAndOffset msgAndOff) {
                return msgAndOff.offset();
            }
        }).toSet();
        Assert.assertTrue((boolean)shallowOffsets.subsetOf((GenSet)deepOffsets));
    }

    public ByteBufferMessageSetTest() {
        Assertions.class.$init$((Assertions)this);
        Suite.class.$init$((Suite)this);
        AssertionsForJUnit.class.$init$((AssertionsForJUnit)this);
        JUnitSuite.class.$init$((JUnitSuite)this);
        BaseMessageSetTestCases$class.$init$(this);
    }
}

