/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.nio.ByteBuffer;
import kafka.api.FetchRequest;
import kafka.api.FetchRequestBuilder;
import kafka.api.PartitionStateInfo;
import kafka.api.Request$;
import kafka.api.RequestOrResponse;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.common.TopicAndPartition;
import kafka.controller.KafkaController;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.message.ByteBufferMessageSet;
import kafka.message.Message;
import kafka.network.RequestChannel;
import kafka.server.KafkaApis;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaFetcherManager;
import kafka.server.ReplicaManager;
import kafka.server.SimpleFetchTest$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import kafka.utils.Time;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.easymock.EasyMock;
import org.scalatest.junit.JUnit3Suite;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001B\u0001\u0003\u0001\u001d\u0011qbU5na2,g)\u001a;dQR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u0013Ai\u0011A\u0003\u0006\u0003\u00171\tQA[;oSRT!!\u0004\b\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\b\u0002\u0007=\u0014x-\u0003\u0002\u0012\u0015\tY!*\u00168jiN\u001aV/\u001b;f\u0011\u0015\u0019\u0002\u0001\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0017\u00015\t!\u0001C\u0004\u0019\u0001\t\u0007I\u0011A\r\u0002\u000f\r|gNZ5hgV\t!\u0004E\u0002\u001cE\u0011j\u0011\u0001\b\u0006\u0003;y\t\u0011\"[7nkR\f'\r\\3\u000b\u0005}\u0001\u0013AC2pY2,7\r^5p]*\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$9\t!A*[:u!\t1R%\u0003\u0002'\u0005\tY1*\u00194lC\u000e{gNZ5h\u0011\u0019A\u0003\u0001)A\u00055\u0005A1m\u001c8gS\u001e\u001c\b\u0005C\u0004+\u0001\t\u0007I\u0011A\u0016\u0002\u000bQ|\u0007/[2\u0016\u00031\u0002\"!\f\u001a\u000e\u00039R!a\f\u0019\u0002\t1\fgn\u001a\u0006\u0002c\u0005!!.\u0019<b\u0013\t\u0019dF\u0001\u0004TiJLgn\u001a\u0005\u0007k\u0001\u0001\u000b\u0011\u0002\u0017\u0002\rQ|\u0007/[2!\u0011\u001d9\u0004A1A\u0005\u0002a\n1\u0002]1si&$\u0018n\u001c8JIV\t\u0011\b\u0005\u0002;w5\t\u0001%\u0003\u0002=A\t\u0019\u0011J\u001c;\t\ry\u0002\u0001\u0015!\u0003:\u00031\u0001\u0018M\u001d;ji&|g.\u00133!\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0003\u0001\"Xm\u001d;O_:\u0014V\r\u001d7jG\u0006\u001cV-Z:Io^CWM\u001c$fi\u000eD\u0017N\\4\u0015\u0003\t\u0003\"AO\"\n\u0005\u0011\u0003#\u0001B+oSRDQA\u0012\u0001\u0005\u0002\u0005\u000ba\u0004^3tiJ+\u0007\u000f\\5dCN+Wm\u001d'f_^CWM\u001c$fi\u000eD\u0017N\\4\t\u000b!\u0003A\u0011B%\u0002A\u001d,G\u000fU1si&$\u0018n\u001c8XSRD\u0017\t\u001c7SKBd\u0017nY1t\u0013:L5K\u0015\u000b\t\u0015B;\u0006\f\u00192k_B\u00111JT\u0007\u0002\u0019*\u0011Q\nB\u0001\bG2,8\u000f^3s\u0013\tyEJA\u0005QCJ$\u0018\u000e^5p]\")!f\u0012a\u0001#B\u0011!+\u0016\b\u0003uMK!\u0001\u0016\u0011\u0002\rA\u0013X\rZ3g\u0013\t\u0019dK\u0003\u0002UA!)qg\u0012a\u0001s!)\u0011l\u0012a\u00015\u0006!A/[7f!\tYf,D\u0001]\u0015\tiF!A\u0003vi&d7/\u0003\u0002`9\n!A+[7f\u0011\u0015\tw\t1\u0001:\u0003!aW-\u00193fe&#\u0007\"B2H\u0001\u0004!\u0017\u0001\u00037pG\u0006dGj\\4\u0011\u0005\u0015DW\"\u00014\u000b\u0005\u001d$\u0011a\u00017pO&\u0011\u0011N\u001a\u0002\u0004\u0019><\u0007\"B6H\u0001\u0004a\u0017\u0001\u00037fC\u0012,'\u000fS,\u0011\u0005ij\u0017B\u00018!\u0005\u0011auN\\4\t\u000bA<\u0005\u0019A9\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feB\u0011aC]\u0005\u0003g\n\u0011aBU3qY&\u001c\u0017-T1oC\u001e,'\u000fC\u0003v\u0001\u0011%a/A\nhKR4u\u000e\u001c7po\u0016\u0014(+\u001a9mS\u000e\f7\u000fF\u0004x\u0003\u001b\t\t\"a\u0005\u0011\u000ba\f\t!a\u0002\u000f\u0005ethB\u0001>~\u001b\u0005Y(B\u0001?\u0007\u0003\u0019a$o\\8u}%\t\u0011%\u0003\u0002\u0000A\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0002\u0003\u000b\u00111aU3r\u0015\ty\b\u0005E\u0002L\u0003\u0013I1!a\u0003M\u0005\u001d\u0011V\r\u001d7jG\u0006Da!a\u0004u\u0001\u0004Q\u0015!\u00039beRLG/[8o\u0011\u0015\tG\u000f1\u0001:\u0011\u0015IF\u000f1\u0001[\u0001")
public class SimpleFetchTest
extends JUnit3Suite {
    private final List<KafkaConfig> configs = (List)TestUtils$.MODULE$.createBrokerConfigs(2).map((Function1)new $anonfun$1(this), List$.MODULE$.canBuildFrom());
    private final String topic;
    private final int partitionId;

    public List<KafkaConfig> configs() {
        return this.configs;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public void testNonReplicaSeesHwWhenFetching() {
        MockTime time = new MockTime();
        int leo = 20;
        int hw = 5;
        int fetchSize = 100;
        Message messages2 = new Message("test-message".getBytes());
        ZkClient zkClient = (ZkClient)EasyMock.createNiceMock(ZkClient.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)zkClient.exists(ZkUtils$.MODULE$.ControllerEpochPath()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        EasyMock.replay((Object[])new Object[]{zkClient});
        Log log = (Log)EasyMock.createMock(Log.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)leo)).anyTimes();
        EasyMock.expect((Object)log);
        EasyMock.expect((Object)log.read(0L, fetchSize, (Option)new Some((Object)BoxesRunTime.boxToLong((long)hw)))).andReturn((Object)new ByteBufferMessageSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{messages2})));
        EasyMock.replay((Object[])new Object[]{log});
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        EasyMock.expect((Object)logManager.getLog(new TopicAndPartition(this.topic(), this.partitionId()))).andReturn((Object)new Some((Object)log)).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        EasyMock.expect((Object)replicaManager.config()).andReturn(this.configs().head());
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager);
        EasyMock.expect((Object)replicaManager.replicaFetcherManager()).andReturn(EasyMock.createMock(ReplicaFetcherManager.class));
        EasyMock.expect((Object)replicaManager.zkClient()).andReturn((Object)zkClient);
        EasyMock.replay((Object[])new Object[]{replicaManager});
        Partition partition = this.getPartitionWithAllReplicasInISR(this.topic(), this.partitionId(), time, ((KafkaConfig)this.configs().head()).brokerId(), log, hw, replicaManager);
        ((Replica)partition.getReplica(((KafkaConfig)this.configs().apply(1)).brokerId()).get()).logEndOffset_$eq((long)leo - 5L);
        EasyMock.reset((Object[])new Object[]{replicaManager});
        EasyMock.expect((Object)replicaManager.config()).andReturn(this.configs().head()).anyTimes();
        EasyMock.expect((Object)replicaManager.getLeaderReplicaIfLocal(this.topic(), this.partitionId())).andReturn(partition.leaderReplicaIfLocal().get()).anyTimes();
        EasyMock.replay((Object[])new Object[]{replicaManager});
        KafkaController controller = (KafkaController)EasyMock.createMock(KafkaController.class);
        RequestChannel requestChannel = new RequestChannel(2, 5);
        KafkaApis apis = new KafkaApis(requestChannel, replicaManager, zkClient, ((KafkaConfig)this.configs().head()).brokerId(), (KafkaConfig)this.configs().head(), controller);
        PartitionStateInfo partitionStateInfo = (PartitionStateInfo)EasyMock.createNiceMock(PartitionStateInfo.class);
        apis.metadataCache().addPartitionInfo(this.topic(), this.partitionId(), partitionStateInfo);
        EasyMock.replay((Object[])new Object[]{partitionStateInfo});
        FetchRequest goodFetch = new FetchRequestBuilder().replicaId(Request$.MODULE$.OrdinaryConsumerId()).addFetch(this.topic(), this.partitionId(), 0L, fetchSize).build();
        ByteBuffer goodFetchBB = TestUtils$.MODULE$.createRequestByteBuffer((RequestOrResponse)goodFetch);
        apis.handleFetchRequest(new RequestChannel.Request(1, (Object)BoxesRunTime.boxToInteger((int)5), goodFetchBB, 1L, RequestChannel.Request$.MODULE$.$lessinit$greater$default$5()));
        EasyMock.verify((Object[])new Object[]{log});
    }

    public void testReplicaSeesLeoWhenFetching() {
        MockTime time = new MockTime();
        int leo = 20;
        int hw = 5;
        Message messages2 = new Message("test-message".getBytes());
        int followerReplicaId = ((KafkaConfig)this.configs().apply(1)).brokerId();
        int followerLEO = 15;
        ZkClient zkClient = (ZkClient)EasyMock.createNiceMock(ZkClient.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)zkClient.exists(ZkUtils$.MODULE$.ControllerEpochPath()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        EasyMock.replay((Object[])new Object[]{zkClient});
        Log log = (Log)EasyMock.createMock(Log.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)leo)).anyTimes();
        EasyMock.expect((Object)log.read((long)followerLEO, Integer.MAX_VALUE, (Option)None$.MODULE$)).andReturn((Object)new ByteBufferMessageSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{messages2})));
        EasyMock.replay((Object[])new Object[]{log});
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        EasyMock.expect((Object)logManager.getLog(new TopicAndPartition(this.topic(), 0))).andReturn((Object)new Some((Object)log)).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        EasyMock.expect((Object)replicaManager.config()).andReturn(this.configs().head());
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager);
        EasyMock.expect((Object)replicaManager.replicaFetcherManager()).andReturn(EasyMock.createMock(ReplicaFetcherManager.class));
        EasyMock.expect((Object)replicaManager.zkClient()).andReturn((Object)zkClient);
        EasyMock.replay((Object[])new Object[]{replicaManager});
        Partition partition = this.getPartitionWithAllReplicasInISR(this.topic(), this.partitionId(), time, ((KafkaConfig)this.configs().head()).brokerId(), log, hw, replicaManager);
        ((Replica)partition.getReplica(followerReplicaId).get()).logEndOffset_$eq((long)followerLEO);
        EasyMock.reset((Object[])new Object[]{replicaManager});
        EasyMock.expect((Object)replicaManager.config()).andReturn(this.configs().head()).anyTimes();
        replicaManager.recordFollowerPosition(this.topic(), this.partitionId(), followerReplicaId, (long)followerLEO);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)replicaManager.getReplica(this.topic(), this.partitionId(), followerReplicaId)).andReturn((Object)partition.inSyncReplicas().find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SimpleFetchTest $outer;

            public final boolean apply(Replica x$2) {
                return x$2.brokerId() == ((KafkaConfig)this.$outer.configs().apply(1)).brokerId();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        EasyMock.expect((Object)replicaManager.getLeaderReplicaIfLocal(this.topic(), this.partitionId())).andReturn(partition.leaderReplicaIfLocal().get()).anyTimes();
        EasyMock.replay((Object[])new Object[]{replicaManager});
        KafkaController controller = (KafkaController)EasyMock.createMock(KafkaController.class);
        RequestChannel requestChannel = new RequestChannel(2, 5);
        KafkaApis apis = new KafkaApis(requestChannel, replicaManager, zkClient, ((KafkaConfig)this.configs().head()).brokerId(), (KafkaConfig)this.configs().head(), controller);
        PartitionStateInfo partitionStateInfo = (PartitionStateInfo)EasyMock.createNiceMock(PartitionStateInfo.class);
        apis.metadataCache().addPartitionInfo(this.topic(), this.partitionId(), partitionStateInfo);
        EasyMock.replay((Object[])new Object[]{partitionStateInfo});
        FetchRequest bigFetch = new FetchRequestBuilder().replicaId(followerReplicaId).addFetch(this.topic(), this.partitionId(), (long)followerLEO, Integer.MAX_VALUE).build();
        ByteBuffer fetchRequestBB = TestUtils$.MODULE$.createRequestByteBuffer((RequestOrResponse)bigFetch);
        apis.handleFetchRequest(new RequestChannel.Request(0, (Object)BoxesRunTime.boxToInteger((int)5), fetchRequestBB, 1L, RequestChannel.Request$.MODULE$.$lessinit$greater$default$5()));
        EasyMock.verify((Object[])new Object[]{log});
    }

    private Partition getPartitionWithAllReplicasInISR(String topic, int partitionId, Time time, int leaderId, Log localLog, long leaderHW, ReplicaManager replicaManager) {
        Partition partition = new Partition(topic, partitionId, 2, time, replicaManager);
        Replica leaderReplica = new Replica(leaderId, partition, time, 0L, (Option)new Some((Object)localLog));
        Seq allReplicas = (Seq)this.getFollowerReplicas(partition, leaderId, time).$colon$plus((Object)leaderReplica, Seq$.MODULE$.canBuildFrom());
        allReplicas.foreach((Function1)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final Partition partition$1;

            public final Replica apply(Replica x$3) {
                return this.partition$1.addReplicaIfNotExists(x$3);
            }
            {
                this.partition$1 = partition$1;
            }
        });
        partition.inSyncReplicas_$eq((Set)allReplicas.toSet());
        partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)leaderId)));
        leaderReplica.highWatermark_$eq(leaderHW);
        return partition;
    }

    private Seq<Replica> getFollowerReplicas(Partition partition, int leaderId, Time time) {
        return (Seq)((TraversableLike)this.configs().filter((Function1)new Serializable(this, leaderId){
            public static final long serialVersionUID = 0L;
            private final int leaderId$1;

            public final boolean apply(KafkaConfig x$4) {
                return x$4.brokerId() != this.leaderId$1;
            }
            {
                this.leaderId$1 = leaderId$1;
            }
        })).map((Function1)new Serializable(this, partition, time){
            public static final long serialVersionUID = 0L;
            private final Partition partition$2;
            private final Time time$1;

            public final Replica apply(KafkaConfig config) {
                return new Replica(config.brokerId(), this.partition$2, this.time$1, Replica$.MODULE$.$lessinit$greater$default$4(), Replica$.MODULE$.$lessinit$greater$default$5());
            }
            {
                this.partition$2 = partition$2;
                this.time$1 = time$1;
            }
        }, List$.MODULE$.canBuildFrom());
    }

    public SimpleFetchTest() {
        this.topic = "foo";
        this.partitionId = 0;
    }
}

