/*
 * Decompiled with CFR 0.152.
 */
package kafka.javaapi;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import kafka.api.RequestKeys$;
import kafka.api.RequestOrResponse;
import kafka.api.TopicMetadataRequest$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000154A!\u0001\u0002\u0001\u000f\t!Bk\u001c9jG6+G/\u00193bi\u0006\u0014V-];fgRT!a\u0001\u0003\u0002\u000f)\fg/Y1qS*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\r\u001b\u0005Q!BA\u0006\u0005\u0003\r\t\u0007/[\u0005\u0003\u001b)\u0011\u0011CU3rk\u0016\u001cHo\u0014:SKN\u0004xN\\:f\u0011!y\u0001A!b\u0001\n\u0003\u0001\u0012!\u0003<feNLwN\\%e+\u0005\t\u0002C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"!B*i_J$\b\u0002\u0003\r\u0001\u0005\u0003\u0005\u000b\u0011B\t\u0002\u0015Y,'o]5p]&#\u0007\u0005\u0003\u0005\u001b\u0001\t\u0015\r\u0011\"\u0011\u001c\u00035\u0019wN\u001d:fY\u0006$\u0018n\u001c8JIV\tA\u0004\u0005\u0002\u0013;%\u0011ad\u0005\u0002\u0004\u0013:$\b\"\u0003\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\"\u00039\u0019wN\u001d:fY\u0006$\u0018n\u001c8JI\u0002J!A\u0007\u0007\t\u0011\r\u0002!Q1A\u0005\u0002\u0011\n\u0001b\u00197jK:$\u0018\nZ\u000b\u0002KA\u0011a%\u000b\b\u0003%\u001dJ!\u0001K\n\u0002\rA\u0013X\rZ3g\u0013\tQ3F\u0001\u0004TiJLgn\u001a\u0006\u0003QMA\u0001\"\f\u0001\u0003\u0002\u0003\u0006I!J\u0001\nG2LWM\u001c;JI\u0002B\u0001b\f\u0001\u0003\u0006\u0004%\t\u0001M\u0001\u0007i>\u0004\u0018nY:\u0016\u0003E\u00022AM\u001c&\u001b\u0005\u0019$B\u0001\u001b6\u0003\u0011)H/\u001b7\u000b\u0003Y\nAA[1wC&\u0011\u0001h\r\u0002\u0005\u0019&\u001cH\u000f\u0003\u0005;\u0001\t\u0005\t\u0015!\u00032\u0003\u001d!x\u000e]5dg\u0002BQ\u0001\u0010\u0001\u0005\u0002u\na\u0001P5oSRtD#\u0002 A\u0003\n\u001b\u0005CA \u0001\u001b\u0005\u0011\u0001\"B\b<\u0001\u0004\t\u0002\"\u0002\u000e<\u0001\u0004a\u0002\"B\u0012<\u0001\u0004)\u0003\"B\u0018<\u0001\u0004\t\u0004bB#\u0001\u0005\u0004%\tAR\u0001\u000bk:$WM\u001d7zS:<W#A$\u0011\u0005%A\u0015BA\u0001\u000b\u0011\u0019Q\u0005\u0001)A\u0005\u000f\u0006YQO\u001c3fe2L\u0018N\\4!\u0011\u0015a\u0004\u0001\"\u0001M)\tqT\nC\u00030\u0017\u0002\u0007\u0011\u0007C\u0003=\u0001\u0011\u0005q\nF\u0002?!FCQa\f(A\u0002EBQA\u0007(A\u0002qAQa\u0015\u0001\u0005\u0002Q\u000bqa\u001e:ji\u0016$v\u000e\u0006\u0002V1B\u0011!CV\u0005\u0003/N\u0011A!\u00168ji\")\u0011L\u0015a\u00015\u00061!-\u001e4gKJ\u0004\"a\u00170\u000e\u0003qS!!X\u001b\u0002\u00079Lw.\u0003\u0002`9\nQ!)\u001f;f\u0005V4g-\u001a:\t\u000b\u0005\u0004A\u0011A\u000e\u0002\u0017ML'0Z%o\u0005f$Xm\u001d\u0005\u0006G\u0002!\t\u0005Z\u0001\ti>\u001cFO]5oOR\tQ\u0005C\u0003g\u0001\u0011\u0005s-\u0001\u0005eKN\u001c'/\u001b2f)\t)\u0003\u000eC\u0003jK\u0002\u0007!.A\u0004eKR\f\u0017\u000e\\:\u0011\u0005IY\u0017B\u00017\u0014\u0005\u001d\u0011un\u001c7fC:\u0004")
public class TopicMetadataRequest
extends RequestOrResponse {
    private final short versionId;
    private final String clientId;
    private final List<String> topics;
    private final kafka.api.TopicMetadataRequest underlying;

    public short versionId() {
        return this.versionId;
    }

    @Override
    public int correlationId() {
        return super.correlationId();
    }

    public String clientId() {
        return this.clientId;
    }

    public List<String> topics() {
        return this.topics;
    }

    public kafka.api.TopicMetadataRequest underlying() {
        return this.underlying;
    }

    @Override
    public void writeTo(ByteBuffer buffer) {
        this.underlying().writeTo(buffer);
    }

    @Override
    public int sizeInBytes() {
        return this.underlying().sizeInBytes();
    }

    public String toString() {
        return this.describe(true);
    }

    @Override
    public String describe(boolean details) {
        StringBuilder topicMetadataRequest = new StringBuilder();
        topicMetadataRequest.append(new StringBuilder().append((Object)"Name: ").append((Object)this.getClass().getSimpleName()).toString());
        topicMetadataRequest.append(new StringBuilder().append((Object)"; Version: ").append((Object)BoxesRunTime.boxToShort((short)this.versionId())).toString());
        topicMetadataRequest.append(new StringBuilder().append((Object)"; CorrelationId: ").append((Object)BoxesRunTime.boxToInteger((int)this.correlationId())).toString());
        topicMetadataRequest.append(new StringBuilder().append((Object)"; ClientId: ").append((Object)this.clientId()).toString());
        if (details) {
            topicMetadataRequest.append("; Topics: ");
            Iterator<String> topicIterator = this.topics().iterator();
            while (topicIterator.hasNext()) {
                String topic = topicIterator.next();
                topicMetadataRequest.append(new StringOps(Predef$.MODULE$.augmentString("%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
                Object object = topicIterator.hasNext() ? topicMetadataRequest.append(",") : BoxedUnit.UNIT;
            }
        }
        return topicMetadataRequest.toString();
    }

    public TopicMetadataRequest(short versionId, int correlationId, String clientId, List<String> topics) {
        this.versionId = versionId;
        this.clientId = clientId;
        this.topics = topics;
        super((Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)RequestKeys$.MODULE$.MetadataKey())), correlationId);
        this.underlying = new kafka.api.TopicMetadataRequest(versionId, correlationId, clientId, (Seq<String>)JavaConversions$.MODULE$.asScalaBuffer(topics));
    }

    public TopicMetadataRequest(List<String> topics) {
        this(TopicMetadataRequest$.MODULE$.CurrentVersion(), 0, TopicMetadataRequest$.MODULE$.DefaultClientId(), topics);
    }

    public TopicMetadataRequest(List<String> topics, int correlationId) {
        this(TopicMetadataRequest$.MODULE$.CurrentVersion(), correlationId, TopicMetadataRequest$.MODULE$.DefaultClientId(), topics);
    }
}

