/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.util.Random;
import junit.framework.Assert;
import kafka.api.ProducerRequest;
import kafka.network.BoundedByteBufferSend;
import kafka.network.RequestChannel;
import kafka.network.Send;
import kafka.network.SocketServer;
import kafka.producer.SyncProducerConfig$;
import kafka.utils.TestUtils$;
import org.junit.After;
import org.junit.Test;
import org.scalatest.Assertions;
import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.PendingNothing;
import org.scalatest.Reporter;
import org.scalatest.Rerunner;
import org.scalatest.Stopper;
import org.scalatest.Suite;
import org.scalatest.TestRerunner;
import org.scalatest.Tracker;
import org.scalatest.junit.AssertionsForJUnit;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple5;
import scala.Tuple6;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map$;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001B\u0001\u0003\u0001\u001d\u0011\u0001cU8dW\u0016$8+\u001a:wKJ$Vm\u001d;\u000b\u0005\r!\u0011a\u00028fi^|'o\u001b\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t!A\u0011\u0011BD\u0007\u0002\u0015)\u00111\u0002D\u0001\u0005Y\u0006twMC\u0001\u000e\u0003\u0011Q\u0017M^1\n\u0005=Q!AB(cU\u0016\u001cG\u000f\u0005\u0002\u001215\t!C\u0003\u0002\u0014)\u0005)!.\u001e8ji*\u0011QCF\u0001\ng\u000e\fG.\u0019;fgRT\u0011aF\u0001\u0004_J<\u0017BA\r\u0013\u0005)QUK\\5u'VLG/\u001a\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u0003\tAq\u0001\t\u0001C\u0002\u0013\u0005\u0011%\u0001\u0004tKJ4XM]\u000b\u0002EA\u0011adI\u0005\u0003I\t\u0011AbU8dW\u0016$8+\u001a:wKJDaA\n\u0001!\u0002\u0013\u0011\u0013aB:feZ,'\u000f\t\u0005\u0006Q\u0001!\t!K\u0001\fg\u0016tGMU3rk\u0016\u001cH\u000f\u0006\u0003+aaj\u0004CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#\u0001B+oSRDQ!M\u0014A\u0002I\naa]8dW\u0016$\bCA\u001a7\u001b\u0005!$BA\u001b\r\u0003\rqW\r^\u0005\u0003oQ\u0012aaU8dW\u0016$\b\"B\u001d(\u0001\u0004Q\u0014AA5e!\tY3(\u0003\u0002=Y\t)1\u000b[8si\")ah\na\u0001\u007f\u00059!/Z9vKN$\bcA\u0016A\u0005&\u0011\u0011\t\f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003W\rK!\u0001\u0012\u0017\u0003\t\tKH/\u001a\u0005\u0006\r\u0002!\taR\u0001\u0010e\u0016\u001cW-\u001b<f%\u0016\u001c\bo\u001c8tKR\u0011q\b\u0013\u0005\u0006c\u0015\u0003\rA\r\u0005\u0006\u0015\u0002!\taS\u0001\u000faJ|7-Z:t%\u0016\fX/Z:u)\tQC\nC\u0003N\u0013\u0002\u0007a*A\u0004dQ\u0006tg.\u001a7\u0011\u0005yy\u0015B\u0001)\u0003\u00059\u0011V-];fgR\u001c\u0005.\u00198oK2DQA\u0015\u0001\u0005\u0002M\u000bqaY8o]\u0016\u001cG\u000f\u0006\u00023)\"9Q+\u0015I\u0001\u0002\u0004\u0011\u0013!A:\t\u000b]\u0003A\u0011\u0001-\u0002\u000f\rdW-\u00198vaR\t!\u0006\u000b\u0002W5B\u00111,X\u0007\u00029*\u00111CF\u0005\u0003=r\u0013Q!\u00114uKJDQ\u0001\u0019\u0001\u0005\u0002a\u000bQb]5na2,'+Z9vKN$\bFA0c!\tY6-\u0003\u0002e9\n!A+Z:u\u0011\u00151\u0007\u0001\"\u0001Y\u0003]!xn\u001c\"jOJ+\u0017/^3ti&\u001b(+\u001a6fGR,G\r\u000b\u0003fE\"L\u0017\u0001C3ya\u0016\u001cG/\u001a3$\u0003)\u0004\"a\u001b8\u000e\u00031T!!\u001c\u0007\u0002\u0005%|\u0017BA8m\u0005-Iu*\u0012=dKB$\u0018n\u001c8\t\u000bE\u0004A\u0011\u0001-\u0002!Q,7\u000f\u001e(vY2\u0014Vm\u001d9p]N,\u0007F\u00019c\u0011\u0015!\b\u0001\"\u0001Y\u0003i!Xm\u001d;T_\u000e\\W\r^:DY>\u001cXm\u00148TQV$Hm\\<oQ\u0011\u0019(\r[5\t\u000b]\u0004A\u0011\u0001-\u0002/Q,7\u000f^'bq\u000e{gN\\3di&|gn\u001d)fe&\u0003\bF\u0001<c\u0011\u0015Q\b\u0001\"\u0001Y\u0003\u0001\"Xm\u001d;NCb\u001cuN\u001c8fGRLwN\\:QKJL\u0005k\u0014<feJLG-Z:)\u0005e\u0014\u0007bB?\u0001#\u0003%\tA`\u0001\u0012G>tg.Z2uI\u0011,g-Y;mi\u0012\nT#A@+\u0007\t\n\ta\u000b\u0002\u0002\u0004A!\u0011QAA\b\u001b\t\t9A\u0003\u0003\u0002\n\u0005-\u0011!C;oG\",7m[3e\u0015\r\ti\u0001L\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\t\u0003\u000f\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class SocketServerTest
implements JUnitSuite {
    private final SocketServer server;
    private volatile Tracker org$scalatest$junit$JUnitSuite$$theTracker;
    private final String styleName;

    public Tracker org$scalatest$junit$JUnitSuite$$theTracker() {
        return this.org$scalatest$junit$JUnitSuite$$theTracker;
    }

    public void org$scalatest$junit$JUnitSuite$$theTracker_$eq(Tracker x$1) {
        this.org$scalatest$junit$JUnitSuite$$theTracker = x$1;
    }

    public final String styleName() {
        return this.styleName;
    }

    public final void org$scalatest$junit$JUnitSuite$_setter_$styleName_$eq(String x$1) {
        this.styleName = x$1;
    }

    public final void withFixture(Suite.NoArgTest test) {
        JUnitSuite.class.withFixture((JUnitSuite)this, (Suite.NoArgTest)test);
    }

    public final void runNestedSuites(Reporter reporter, Stopper stopper, Filter filter, scala.collection.immutable.Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        JUnitSuite.class.runNestedSuites((JUnitSuite)this, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public final void runTests(Option<String> testName, Reporter reporter, Stopper stopper, Filter filter, scala.collection.immutable.Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        JUnitSuite.class.runTests((JUnitSuite)this, testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public final void runTest(String testName, Reporter reporter, Stopper stopper, scala.collection.immutable.Map<String, Object> configMap, Tracker tracker) {
        JUnitSuite.class.runTest((JUnitSuite)this, (String)testName, (Reporter)reporter, (Stopper)stopper, configMap, (Tracker)tracker);
    }

    public Set<String> testNames() {
        return JUnitSuite.class.testNames((JUnitSuite)this);
    }

    public int expectedTestCount(Filter filter) {
        return JUnitSuite.class.expectedTestCount((JUnitSuite)this, (Filter)filter);
    }

    public scala.collection.immutable.Map<String, Set<String>> tags() {
        return JUnitSuite.class.tags((JUnitSuite)this);
    }

    public void run(Option<String> testName, Reporter report, Stopper stopper, Filter filter, scala.collection.immutable.Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        JUnitSuite.class.run((JUnitSuite)this, testName, (Reporter)report, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public Throwable newAssertionFailedException(Option<Object> optionalMessage, Option<Throwable> optionalCause, int stackDepth) {
        return AssertionsForJUnit.class.newAssertionFailedException((AssertionsForJUnit)this, optionalMessage, optionalCause, (int)stackDepth);
    }

    public void org$scalatest$Suite$_setter_$styleName_$eq(String x$1) {
    }

    public List<Suite> nestedSuites() {
        return Suite.class.nestedSuites((Suite)this);
    }

    public final void execute(String testName, scala.collection.immutable.Map<String, Object> configMap, boolean color, boolean durations, boolean shortstacks, boolean fullstacks, boolean stats) {
        Suite.class.execute((Suite)this, (String)testName, configMap, (boolean)color, (boolean)durations, (boolean)shortstacks, (boolean)fullstacks, (boolean)stats);
    }

    public Method getMethodForTestName(String testName) {
        return Suite.class.getMethodForTestName((Suite)this, (String)testName);
    }

    public Tuple6<Stopper, Reporter, Method, Object, Option<TestRerunner>, Object> getSuiteRunTestGoodies(Stopper stopper, Reporter reporter, String testName) {
        return Suite.class.getSuiteRunTestGoodies((Suite)this, (Stopper)stopper, (Reporter)reporter, (String)testName);
    }

    public Tuple5<Stopper, Reporter, Object, Option<TestRerunner>, Object> getRunTestGoodies(Stopper stopper, Reporter reporter, String testName) {
        return Suite.class.getRunTestGoodies((Suite)this, (Stopper)stopper, (Reporter)reporter, (String)testName);
    }

    public void handleFailedTest(Throwable throwable, boolean hasPublicNoArgConstructor, String testName, Option<Rerunner> rerunnable, Reporter report, Tracker tracker, long duration) {
        Suite.class.handleFailedTest((Suite)this, (Throwable)throwable, (boolean)hasPublicNoArgConstructor, (String)testName, rerunnable, (Reporter)report, (Tracker)tracker, (long)duration);
    }

    public String suiteName() {
        return Suite.class.suiteName((Suite)this);
    }

    public PendingNothing pending() {
        return Suite.class.pending((Suite)this);
    }

    public void pendingUntilFixed(Function0<BoxedUnit> f) {
        Suite.class.pendingUntilFixed((Suite)this, f);
    }

    public Reporter wrapReporterIfNecessary(Reporter reporter) {
        return Suite.class.wrapReporterIfNecessary((Suite)this, (Reporter)reporter);
    }

    public final String execute$default$1() {
        return Suite.class.execute$default$1((Suite)this);
    }

    public final scala.collection.immutable.Map<String, Object> execute$default$2() {
        return Suite.class.execute$default$2((Suite)this);
    }

    public final boolean execute$default$3() {
        return Suite.class.execute$default$3((Suite)this);
    }

    public final boolean execute$default$4() {
        return Suite.class.execute$default$4((Suite)this);
    }

    public final boolean execute$default$5() {
        return Suite.class.execute$default$5((Suite)this);
    }

    public final boolean execute$default$6() {
        return Suite.class.execute$default$6((Suite)this);
    }

    public final boolean execute$default$7() {
        return Suite.class.execute$default$7((Suite)this);
    }

    public void assert(boolean condition) {
        Assertions.class.assert((Assertions)this, (boolean)condition);
    }

    public void assert(boolean condition, Object clue) {
        Assertions.class.assert((Assertions)this, (boolean)condition, (Object)clue);
    }

    public void assert(Option<String> o, Object clue) {
        Assertions.class.assert((Assertions)this, o, (Object)clue);
    }

    public void assert(Option<String> o) {
        Assertions.class.assert((Assertions)this, o);
    }

    public Assertions.Equalizer convertToEqualizer(Object left) {
        return Assertions.class.convertToEqualizer((Assertions)this, (Object)left);
    }

    public <T> T intercept(Function0<Object> f, Manifest<T> manifest) {
        return (T)Assertions.class.intercept((Assertions)this, f, manifest);
    }

    public void expectResult(Object expected, Object clue, Object actual) {
        Assertions.class.expectResult((Assertions)this, (Object)expected, (Object)clue, (Object)actual);
    }

    public void expect(Object expected, Object clue, Object actual) {
        Assertions.class.expect((Assertions)this, (Object)expected, (Object)clue, (Object)actual);
    }

    public void expectResult(Object expected, Object actual) {
        Assertions.class.expectResult((Assertions)this, (Object)expected, (Object)actual);
    }

    public void expect(Object expected, Object actual) {
        Assertions.class.expect((Assertions)this, (Object)expected, (Object)actual);
    }

    public Nothing$ fail() {
        return Assertions.class.fail((Assertions)this);
    }

    public Nothing$ fail(String message) {
        return Assertions.class.fail((Assertions)this, (String)message);
    }

    public Nothing$ fail(String message, Throwable cause) {
        return Assertions.class.fail((Assertions)this, (String)message, (Throwable)cause);
    }

    public Nothing$ fail(Throwable cause) {
        return Assertions.class.fail((Assertions)this, (Throwable)cause);
    }

    public <T> T withClue(Object clue, Function0<T> fun) {
        return (T)Assertions.class.withClue((Assertions)this, (Object)clue, fun);
    }

    public SocketServer server() {
        return this.server;
    }

    public void sendRequest(Socket socket, short id, byte[] request) {
        DataOutputStream outgoing = new DataOutputStream(socket.getOutputStream());
        outgoing.writeInt(request.length + 2);
        outgoing.writeShort(id);
        outgoing.write(request);
        outgoing.flush();
    }

    public byte[] receiveResponse(Socket socket) {
        DataInputStream incoming = new DataInputStream(socket.getInputStream());
        int len = incoming.readInt();
        byte[] response = new byte[len];
        incoming.readFully(response);
        return response;
    }

    public void processRequest(RequestChannel channel) {
        RequestChannel.Request request = channel.receiveRequest();
        ByteBuffer byteBuffer = ByteBuffer.allocate(request.requestObj().sizeInBytes());
        request.requestObj().writeTo(byteBuffer);
        byteBuffer.rewind();
        BoundedByteBufferSend send = new BoundedByteBufferSend(byteBuffer);
        channel.sendResponse(new RequestChannel.Response(request.processor(), request, (Send)send));
    }

    public Socket connect(SocketServer s) {
        return new Socket("localhost", s.port());
    }

    public SocketServer connect$default$1() {
        return this.server();
    }

    @After
    public void cleanup() {
        this.server().shutdown();
    }

    @Test
    public void simpleRequest() {
        Socket socket = this.connect(this.connect$default$1());
        int correlationId = -1;
        String clientId = SyncProducerConfig$.MODULE$.DefaultClientId();
        int ackTimeoutMs = SyncProducerConfig$.MODULE$.DefaultAckTimeoutMs();
        short ack = SyncProducerConfig$.MODULE$.DefaultRequiredAcks();
        ProducerRequest emptyRequest = new ProducerRequest(correlationId, clientId, ack, ackTimeoutMs, (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$));
        ByteBuffer byteBuffer = ByteBuffer.allocate(emptyRequest.sizeInBytes());
        emptyRequest.writeTo(byteBuffer);
        byteBuffer.rewind();
        byte[] serializedBytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(serializedBytes);
        this.sendRequest(socket, (short)0, serializedBytes);
        this.processRequest(this.server().requestChannel());
        Assert.assertEquals((Object)Predef$.MODULE$.byteArrayOps(serializedBytes).toSeq(), (Object)Predef$.MODULE$.byteArrayOps(this.receiveResponse(socket)).toSeq());
    }

    @Test(expected=IOException.class)
    public void tooBigRequestIsRejected() {
        byte[] tooManyBytes = new byte[this.server().maxRequestSize() + 1];
        new Random().nextBytes(tooManyBytes);
        Socket socket = this.connect(this.connect$default$1());
        this.sendRequest(socket, (short)0, tooManyBytes);
        this.receiveResponse(socket);
    }

    @Test
    public void testNullResponse() {
        Socket socket = this.connect(this.connect$default$1());
        byte[] bytes = new byte[40];
        this.sendRequest(socket, (short)0, bytes);
        RequestChannel.Request request = this.server().requestChannel().receiveRequest();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, request){
            public static final long serialVersionUID = 0L;
            private final RequestChannel.Request request$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return (((SelectionKey)this.request$1.requestKey()).interestOps() & 1) != 1;
            }
            {
                this.request$1 = request$1;
            }
        }, "Socket key shouldn't be available for read", TestUtils$.MODULE$.waitUntilTrue$default$3());
        this.server().requestChannel().sendResponse(new RequestChannel.Response(0, request, null));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, request){
            public static final long serialVersionUID = 0L;
            private final RequestChannel.Request request$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return (((SelectionKey)this.request$1.requestKey()).interestOps() & 1) == 1;
            }
            {
                this.request$1 = request$1;
            }
        }, "Socket key should be available for reads", TestUtils$.MODULE$.waitUntilTrue$default$3());
    }

    @Test(expected=IOException.class)
    public void testSocketsCloseOnShutdown() {
        Socket socket = this.connect(this.connect$default$1());
        byte[] bytes = new byte[40];
        this.sendRequest(socket, (short)0, bytes);
        this.processRequest(this.server().requestChannel());
        this.server().shutdown();
        this.sendRequest(socket, (short)0, bytes);
    }

    @Test
    public void testMaxConnectionsPerIp() {
        IndexedSeq conns = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.server().maxConnectionsPerIp()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SocketServerTest $outer;

            public final Socket apply(int i) {
                return this.$outer.connect(this.$outer.connect$default$1());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Socket conn = this.connect(this.connect$default$1());
        conn.setSoTimeout(3000);
        Assert.assertEquals((int)-1, (int)conn.getInputStream().read());
    }

    @Test
    public void testMaxConnectionsPerIPOverrides() {
        int overrideNum = 6;
        Map overrides = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"localhost"), (Object)BoxesRunTime.boxToInteger((int)overrideNum))}));
        SocketServer overrideServer = new SocketServer(0, null, TestUtils$.MODULE$.choosePort(), 1, 50, 300000, 300000, 50, 5, 60000L, overrides);
        overrideServer.startup();
        IndexedSeq conns = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), overrideNum).map((Function1)new Serializable(this, overrideServer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SocketServerTest $outer;
            private final SocketServer overrideServer$1;

            public final Socket apply(int i) {
                return this.$outer.connect(this.overrideServer$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.overrideServer$1 = overrideServer$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Socket conn = this.connect(overrideServer);
        conn.setSoTimeout(3000);
        Assert.assertEquals((int)-1, (int)conn.getInputStream().read());
        overrideServer.shutdown();
    }

    public SocketServerTest() {
        Assertions.class.$init$((Assertions)this);
        Suite.class.$init$((Suite)this);
        AssertionsForJUnit.class.$init$((AssertionsForJUnit)this);
        JUnitSuite.class.$init$((JUnitSuite)this);
        this.server = new SocketServer(0, null, TestUtils$.MODULE$.choosePort(), 1, 50, 300000, 300000, 50, 5, 60000L, (Map)scala.collection.Map$.MODULE$.empty());
        this.server().startup();
    }
}

