/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import junit.framework.Assert;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.utils.Utils$;
import kafka.utils.ZkUtils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.I0Itec.zkclient.ZkClient;
import org.scalatest.junit.JUnit3Suite;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.StringAdd$;

@ScalaSignature(bytes="\u0006\u000113A!\u0001\u0002\u0001\u000f\t\t2+\u001a:wKJ\u001cF/\u0019:ukB$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u0013!\tI\u0001#D\u0001\u000b\u0015\tYA\"A\u0003kk:LGO\u0003\u0002\u000e\u001d\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002\u001f\u0005\u0019qN]4\n\u0005EQ!a\u0003&V]&$8gU;ji\u0016\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\u0005i\\\u0017BA\f\u0015\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tg\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011A\u0001\u0005\b\u0007\u0001\u0001\r\u0011\"\u0001\u001f+\u0005y\u0002C\u0001\u000f!\u0013\t\t#AA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\bbB\u0012\u0001\u0001\u0004%\t\u0001J\u0001\u000bg\u0016\u0014h/\u001a:`I\u0015\fHCA\u0013,!\t1\u0013&D\u0001(\u0015\u0005A\u0013!B:dC2\f\u0017B\u0001\u0016(\u0005\u0011)f.\u001b;\t\u000f1\u0012\u0013\u0011!a\u0001?\u0005\u0019\u0001\u0010J\u0019\t\r9\u0002\u0001\u0015)\u0003 \u0003\u001d\u0019XM\u001d<fe\u0002Bq\u0001\r\u0001C\u0002\u0013\u0005\u0011'\u0001\u0005ce>\\WM]%e+\u0005\u0011\u0004C\u0001\u00144\u0013\t!tEA\u0002J]RDaA\u000e\u0001!\u0002\u0013\u0011\u0014!\u00032s_.,'/\u00133!\u0011\u001dA\u0004A1A\u0005\u0002e\nqB_8pW\u0016,\u0007/\u001a:DQJ|w\u000e^\u000b\u0002uA\u00111\bQ\u0007\u0002y)\u0011QHP\u0001\u0005Y\u0006twMC\u0001@\u0003\u0011Q\u0017M^1\n\u0005\u0005c$AB*ue&tw\r\u0003\u0004D\u0001\u0001\u0006IAO\u0001\u0011u>|7.Z3qKJ\u001c\u0005N]8pi\u0002BQ!\u0012\u0001\u0005B\u0019\u000bQa]3u+B$\u0012!\n\u0005\u0006\u0011\u0002!\tER\u0001\ti\u0016\f'\u000fR8x]\")!\n\u0001C\u0001\u0017\u0006IB/Z:u\u0005J|7.\u001a:De\u0016\fG/Z:[\u0017\u000eC'o\\8u+\u0005)\u0003")
public class ServerStartupTest
extends JUnit3Suite
implements ZooKeeperTestHarness {
    private KafkaServer server;
    private final int brokerId;
    private final String zookeeperChroot;
    private final String zkConnect;
    private EmbeddedZookeeper zookeeper;
    private ZkClient zkClient;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;

    @Override
    public String zkConnect() {
        return this.zkConnect;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public ZkClient zkClient() {
        return this.zkClient;
    }

    @Override
    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$setUp() {
        super.setUp();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$tearDown() {
        super.tearDown();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnect_$eq(String x$1) {
        this.zkConnect = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    public KafkaServer server() {
        return this.server;
    }

    public void server_$eq(KafkaServer x$1) {
        this.server = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public String zookeeperChroot() {
        return this.zookeeperChroot;
    }

    @Override
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), TestUtils$.MODULE$.choosePort(), TestUtils$.MODULE$.createBrokerConfig$default$3());
        Object zooKeeperConnect = props.get("zookeeper.connect");
        props.put("zookeeper.connect", StringAdd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(zooKeeperConnect), this.zookeeperChroot()));
        this.server_$eq(TestUtils$.MODULE$.createServer(new KafkaConfig(props), TestUtils$.MODULE$.createServer$default$2()));
    }

    @Override
    public void tearDown() {
        this.server().shutdown();
        Utils$.MODULE$.rm(this.server().config().logDirs());
        ZooKeeperTestHarness$class.tearDown(this);
    }

    public void testBrokerCreatesZKChroot() {
        boolean pathExists = ZkUtils$.MODULE$.pathExists(this.zkClient(), this.zookeeperChroot());
        Assert.assertTrue((boolean)pathExists);
    }

    public ServerStartupTest() {
        ZooKeeperTestHarness$class.$init$(this);
        this.server = null;
        this.brokerId = 0;
        this.zookeeperChroot = "/kafka-chroot-for-unittest";
    }
}

